/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.hash;

import gnu.crypto.hash.IMessageDigest;

public abstract class BaseHash
implements IMessageDigest {
    protected String name;
    protected int hashSize;
    protected int blockSize;
    protected long count;
    protected byte[] buffer;
    private static int a;

    protected BaseHash(String name, int hashSize, int blockSize) {
        this.name = name;
        this.hashSize = hashSize;
        this.blockSize = blockSize;
        this.buffer = new byte[blockSize];
        this.resetContext();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int hashSize() {
        return this.hashSize;
    }

    @Override
    public int blockSize() {
        return this.blockSize;
    }

    @Override
    public void update(byte b2) {
        int n = (int)(this.count % (long)this.blockSize);
        ++this.count;
        this.buffer[n] = b2;
        if (n == this.blockSize - 1) {
            this.transform(this.buffer, 0);
        }
    }

    @Override
    public void update(byte[] b2, int offset, int len) {
        int n = (int)(this.count % (long)this.blockSize);
        this.count += (long)len;
        int n2 = this.blockSize - n;
        int n3 = 0;
        int n4 = BaseHash.b();
        if (len >= n2) {
            System.arraycopy(b2, offset, this.buffer, n, n2);
            this.transform(this.buffer, 0);
            n3 = n2;
            while (n3 + this.blockSize - 1 < len) {
                this.transform(b2, offset + n3);
                n3 += this.blockSize;
                if (n4 != 0) continue;
            }
            n = 0;
        }
        if (n3 < len) {
            System.arraycopy(b2, offset + n3, this.buffer, n, len - n3);
        }
    }

    @Override
    public byte[] digest() {
        byte[] byArray = this.padBuffer();
        this.update(byArray, 0, byArray.length);
        byte[] byArray2 = this.getResult();
        this.reset();
        return byArray2;
    }

    @Override
    public void reset() {
        this.count = 0L;
        int n = BaseHash.b();
        int n2 = 0;
        while (n2 < this.blockSize) {
            this.buffer[n2++] = 0;
            if (n != 0) continue;
        }
        this.resetContext();
    }

    @Override
    public abstract Object clone();

    @Override
    public abstract boolean selfTest();

    protected abstract byte[] padBuffer();

    protected abstract byte[] getResult();

    protected abstract void resetContext();

    protected abstract void transform(byte[] var1, int var2);

    public static void b(int n) {
        a = n;
    }

    public static int b() {
        return a;
    }

    public static int c() {
        int n = BaseHash.b();
        if (n == 0) {
            return 14;
        }
        return 0;
    }

    static {
        if (BaseHash.c() != 0) {
            BaseHash.b(45);
        }
    }
}

