/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.ecdsa.ecmath.curve;

import gnu.crypto.sig.ecdsa.ecmath.field.Field;
import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.EllipticCurve;

public abstract class Curve
extends EllipticCurve {
    protected final Field mField;
    protected final BigInteger mA;
    protected final BigInteger mB;
    protected final byte[] mSeed;

    public Curve(Field aField, BigInteger aA, BigInteger aB) {
        super(aField, aA, aB);
        this.mA = aA;
        this.mB = aB;
        this.mField = aField;
        this.mSeed = null;
    }

    public Curve(Field aField, BigInteger aA, BigInteger aB, byte[] aSeed) {
        super(aField, aA, aB);
        this.mA = aA;
        this.mB = aB;
        this.mField = aField;
        this.mSeed = aSeed;
    }

    public Field getMField() {
        return this.mField;
    }

    @Override
    public ECField getField() {
        return this.mField;
    }

    public BigInteger getMA() {
        return this.mA;
    }

    @Override
    public BigInteger getA() {
        return this.mA;
    }

    public BigInteger getMB() {
        return this.mB;
    }

    @Override
    public BigInteger getB() {
        return this.mB;
    }

    @Override
    public byte[] getSeed() {
        return this.mSeed;
    }

    public abstract boolean onCurve(BigInteger var1, BigInteger var2);

    @Override
    public boolean equals(Object aObject) {
        if (aObject == null) {
            return false;
        }
        if (this.getClass().isInstance(aObject)) {
            Curve curve = (Curve)aObject;
            if (!curve.mField.equals(this.mField)) {
                return false;
            }
            if (!curve.mA.equals(this.mA)) {
                return false;
            }
            return curve.mB.equals(this.mB);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.mField.hashCode() ^ this.mA.hashCode() ^ this.mB.hashCode();
    }
}

