/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.ecdsa.ecmath.curve;

import gnu.crypto.sig.ecdsa.ecmath.curve.Curve;
import gnu.crypto.sig.ecdsa.ecmath.exceptions.EllipticCurveException;
import gnu.crypto.sig.ecdsa.ecmath.field.Field;
import gnu.crypto.sig.ecdsa.ecmath.field.FieldFp;
import java.math.BigInteger;

public class CurveFp
extends Curve {
    private static final String c;

    public CurveFp(Field aField, BigInteger aA, BigInteger aB) throws EllipticCurveException {
        super(aField, aA, aB);
        if (!(this.mField instanceof FieldFp)) {
            throw new EllipticCurveException(c);
        }
    }

    @Override
    public boolean onCurve(BigInteger aAffineX, BigInteger aAffineY) {
        BigInteger bigInteger = this.mField.getMSize();
        return aAffineY.pow(2).mod(bigInteger).compareTo(aAffineX.pow(3).add(this.mA.multiply(aAffineX)).add(this.mB).mod(bigInteger)) == 0;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block12: {
            int n;
            char[] cArray2;
            int n2;
            int n3;
            block11: {
                char[] cArray3 = "i0?ng\u000b*U6&+&M3B3/ncG?J:%:".toCharArray();
                int n4 = cArray3.length;
                n3 = 0;
                n2 = 73;
                cArray2 = cArray3;
                n = n4;
                if (n4 <= 1) break block11;
                cArray = cArray2;
                n = n;
                if (n <= n3) break block12;
            }
            do {
                int n5 = n2;
                cArray2 = cArray2;
                char[] cArray4 = cArray2;
                int n6 = n2;
                int n7 = n3;
                while (true) {
                    int n8;
                    switch (n3 % 7) {
                        case 0: {
                            n8 = 110;
                            break;
                        }
                        case 1: {
                            n8 = 22;
                            break;
                        }
                        case 2: {
                            n8 = 2;
                            break;
                        }
                        case 3: {
                            n8 = 7;
                            break;
                        }
                        case 4: {
                            n8 = 79;
                            break;
                        }
                        case 5: {
                            n8 = 98;
                            break;
                        }
                        default: {
                            n8 = 19;
                        }
                    }
                    cArray4[n7] = (char)(cArray4[n7] ^ (n6 ^ n8));
                    ++n3;
                    n2 = n5;
                    if (n5 != 0) break;
                    n5 = n2;
                    cArray2 = cArray2;
                    n7 = n2;
                    cArray4 = cArray2;
                    n6 = n2;
                }
                cArray = cArray2;
                n = n;
            } while (n > n3);
        }
        c = new String(cArray).intern();
    }
}

