/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.crypto.alg;

import java.util.HashMap;
import java.util.Map;
import tr.gov.tubitak.uekae.esya.api.common.OID;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.AgreementAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.Algorithm;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DerivationFunctionAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DerivationFunctionType;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;

public class KeyAgreementAlg
implements Algorithm {
    private static Map<OID, KeyAgreementAlg> a = new HashMap<OID, KeyAgreementAlg>();
    public static final KeyAgreementAlg ECDH_SHA1KDF = new KeyAgreementAlg(new int[]{1, 3, 133, 16, 840, 63, 0, 2}, AgreementAlg.ECDH, new DerivationFunctionAlg(DerivationFunctionType.ECDHKEK, DigestAlg.SHA1));
    public static final KeyAgreementAlg ECDH_SHA224KDF = new KeyAgreementAlg(new int[]{1, 3, 132, 1, 11, 0}, AgreementAlg.ECDH, new DerivationFunctionAlg(DerivationFunctionType.ECDHKEK, DigestAlg.SHA224));
    public static final KeyAgreementAlg ECDH_SHA256KDF = new KeyAgreementAlg(new int[]{1, 3, 132, 1, 11, 1}, AgreementAlg.ECDH, new DerivationFunctionAlg(DerivationFunctionType.ECDHKEK, DigestAlg.SHA256));
    public static final KeyAgreementAlg ECDH_SHA384KDF = new KeyAgreementAlg(new int[]{1, 3, 132, 1, 11, 2}, AgreementAlg.ECDH, new DerivationFunctionAlg(DerivationFunctionType.ECDHKEK, DigestAlg.SHA384));
    public static final KeyAgreementAlg ECDH_SHA512KDF = new KeyAgreementAlg(new int[]{1, 3, 132, 1, 11, 3}, AgreementAlg.ECDH, new DerivationFunctionAlg(DerivationFunctionType.ECDHKEK, DigestAlg.SHA512));
    public static final KeyAgreementAlg ECCDH_SHA1KDF = new KeyAgreementAlg(new int[]{1, 3, 133, 16, 840, 63, 0, 3}, AgreementAlg.ECCDH, new DerivationFunctionAlg(DerivationFunctionType.ECDHKEK, DigestAlg.SHA1));
    public static final KeyAgreementAlg ECCDH_SHA224KDF = new KeyAgreementAlg(new int[]{1, 3, 132, 1, 14, 0}, AgreementAlg.ECCDH, new DerivationFunctionAlg(DerivationFunctionType.ECDHKEK, DigestAlg.SHA224));
    public static final KeyAgreementAlg ECCDH_SHA256KDF = new KeyAgreementAlg(new int[]{1, 3, 132, 1, 14, 1}, AgreementAlg.ECCDH, new DerivationFunctionAlg(DerivationFunctionType.ECDHKEK, DigestAlg.SHA256));
    public static final KeyAgreementAlg ECCDH_SHA384KDF = new KeyAgreementAlg(new int[]{1, 3, 132, 1, 14, 2}, AgreementAlg.ECCDH, new DerivationFunctionAlg(DerivationFunctionType.ECDHKEK, DigestAlg.SHA384));
    public static final KeyAgreementAlg ECCDH_SHA512KDF = new KeyAgreementAlg(new int[]{1, 3, 132, 1, 14, 3}, AgreementAlg.ECCDH, new DerivationFunctionAlg(DerivationFunctionType.ECDHKEK, DigestAlg.SHA512));
    private int[] b;
    private AgreementAlg c;
    private DerivationFunctionAlg d;

    public KeyAgreementAlg(int[] aOID, AgreementAlg aAgreementAlg, DerivationFunctionAlg aDerivationFunction) {
        this.b = aOID;
        this.c = aAgreementAlg;
        this.d = aDerivationFunction;
        if (aOID != null) {
            OID oID = new OID(aOID);
            a.put(oID, this);
        }
    }

    @Override
    public int[] getOID() {
        return this.b;
    }

    public AgreementAlg getAgreementAlg() {
        return this.c;
    }

    public DerivationFunctionAlg getDerivationFunctionAlg() {
        return this.d;
    }

    public static KeyAgreementAlg fromOID(int[] aOID) {
        OID oID = new OID(aOID);
        return a.get(oID);
    }

    @Override
    public String getName() {
        return this.c.name();
    }
}

