/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.certstore.ops;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EBasicOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.ESingleResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.ItemSource;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStore;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVEN;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVTKatmani;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.JDBCUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.NotFoundException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzetTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzneTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoOCSP;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoOCSPToWrite;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoOzet;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoSertifika;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.ops.CertStoreRootCertificateOps;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.template.OCSPSearchTemplate;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.util.RsItemSource;

public class CertStoreOCSPOps {
    private static Logger a;
    private final CertStore b;
    private static final String[] c;
    private static final String[] d;

    public CertStoreOCSPOps(CertStore aDepo) {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            a.error(CertStoreOCSPOps.a(30230, 24938));
            throw new ESYARuntimeException(CertStoreOCSPOps.a(30224, 8875) + lE.getMessage());
        }
        this.b = aDepo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DepoOCSP readStoreOCSPResponse(long aOCSPNo) throws CertStoreException {
        DepoOCSP depoOCSP;
        try {
            DepoOCSP depoOCSP2;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoOCSP = depoOCSP2 = depoVEN.ocspCevabiOku(aOCSPNo);
        }
        catch (NotFoundException notFoundException) {
            try {
                throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(30218, 30195), notFoundException);
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(30219, -3915), certStoreException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(30219, -3915), certStoreException);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return depoOCSP;
            JDBCUtil.commit(this.b.getConn());
            return depoOCSP;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(30234, -7489), certStoreException);
        }
    }

    public void writeOCSPResponseAndCertificate(EOCSPResponse aResponse, ECertificate aCertificate) throws CertStoreException {
        EBasicOCSPResponse eBasicOCSPResponse = aResponse.getBasicOCSPResponse();
        boolean bl = CertStoreRootCertificateOps.c;
        ESingleResponse eSingleResponse = CertStoreUtil.getOCSPResponseForCertificate(eBasicOCSPResponse, aCertificate);
        if (eSingleResponse == null) {
            throw new CertStoreException(CertStoreOCSPOps.a(30223, -687));
        }
        DepoSertifika depoSertifika = CertStoreUtil.eSYASertifikaTODepoSertifika(aCertificate);
        DepoOCSPToWrite depoOCSPToWrite = CertStoreUtil.asnOCSPResponseTODepoOCSP(aResponse);
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            List<DepoOzet> list = CertStoreUtil.convertToDepoOzet(depoOCSPToWrite.getBasicOCSPResponse(), OzneTipi.OCSP_BASIC_RESPONSE);
            List<DepoOzet> list2 = CertStoreUtil.convertToDepoOzet(depoOCSPToWrite.getOCSPResponse(), OzneTipi.OCSP_RESPONSE);
            ArrayList<DepoOzet> arrayList = new ArrayList<DepoOzet>(list);
            arrayList.addAll(list2);
            List<DepoOzet> list3 = CertStoreUtil.convertToDepoOzet(depoSertifika.getValue(), OzneTipi.SERTIFIKA);
            depoVEN.ocspCevabiVeSertifikaYaz(depoOCSPToWrite, arrayList, depoSertifika, list3, eSingleResponse);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(CertStoreOCSPOps.a(30213, 14206), certStoreException);
        }
        if (bl) {
            int n = CertStoreException.b;
            CertStoreException.b = ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DepoOzet> listOCSPResponseHashes(long aOCSPNo) throws CertStoreException {
        List<DepoOzet> list2;
        try {
            List<DepoOzet> list;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            ItemSource<DepoOzet> itemSource = depoVEN.ocspOzetleriniListele(aOCSPNo);
            list2 = list = ((RsItemSource)itemSource).toList();
        }
        catch (Exception exception) {
            try {
                throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(30238, -4203), exception);
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(30238, -4203), certStoreException);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return list2;
            JDBCUtil.commit(this.b.getConn());
            return list2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(30229, -11794), certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemSource<DepoOCSP> listStoreOCSPResponses(OCSPSearchTemplate aSablon) throws CertStoreException {
        ItemSource<DepoOCSP> itemSource2;
        try {
            ItemSource<DepoOCSP> itemSource;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            Pair<String, List<Object>> pair = this.a(aSablon);
            String string = (String)pair.first();
            List list = (List)pair.second();
            itemSource2 = itemSource = depoVEN.ocspCevabiListele(string, list.toArray());
        }
        catch (CertStoreException certStoreException) {
            try {
                throw new CertStoreException(CertStoreOCSPOps.a(30232, 26499), certStoreException);
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException2) {
                    throw new CertStoreException(CertStoreOCSPOps.a(30232, 26499), certStoreException2);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return itemSource2;
            JDBCUtil.commit(this.b.getConn());
            return itemSource2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(CertStoreOCSPOps.a(30231, -17980), certStoreException);
        }
    }

    public EBasicOCSPResponse listOCSPResponses(OCSPSearchTemplate aSablon) throws CertStoreException {
        ItemSource<DepoOCSP> itemSource = this.listStoreOCSPResponses(aSablon);
        if (itemSource == null) {
            return null;
        }
        DepoOCSP depoOCSP = null;
        try {
            depoOCSP = (DepoOCSP)itemSource.nextItem();
            itemSource.close();
            if (depoOCSP == null) {
                return null;
            }
            return new EBasicOCSPResponse(depoOCSP.getBasicOCSPResponse());
        }
        catch (Exception exception) {
            throw new CertStoreException(depoOCSP.getOCSPNo() + CertStoreOCSPOps.a(30225, -23068), exception);
        }
    }

    public int deleteOCSPResponse(long aOCSPNo) throws CertStoreException {
        try {
            if (aOCSPNo <= 0L) {
                throw new CertStoreException(CertStoreOCSPOps.a(30235, 29727));
            }
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            int n = depoVEN.ocspCevabiSil(aOCSPNo);
            JDBCUtil.commit(this.b.getConn());
            return n;
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(aOCSPNo + CertStoreOCSPOps.a(30221, -8629), certStoreException);
        }
    }

    private Pair<String, List<Object>> a(OCSPSearchTemplate oCSPSearchTemplate) {
        ArrayList<Object> arrayList;
        StringBuffer stringBuffer;
        block30: {
            OzetTipi ozetTipi;
            block28: {
                boolean bl;
                block29: {
                    stringBuffer = new StringBuffer("");
                    arrayList = new ArrayList<Object>();
                    stringBuffer.append(CertStoreOCSPOps.a(30233, -17659));
                    byte[] byArray = oCSPSearchTemplate.getHash();
                    bl = CertStoreRootCertificateOps.c;
                    ozetTipi = oCSPSearchTemplate.getHashType();
                    if (byArray == null) break block28;
                    stringBuffer.append(CertStoreOCSPOps.a(30226, -13619));
                    arrayList.add(OzneTipi.OCSP_RESPONSE.getIntValue());
                    arrayList.add(OzneTipi.OCSP_BASIC_RESPONSE.getIntValue());
                    arrayList.add(byArray);
                    if (ozetTipi == null) break block29;
                    stringBuffer.append(CertStoreOCSPOps.a(30228, 14997));
                    arrayList.add(ozetTipi.getIntValue());
                    if (!bl) break block30;
                }
                stringBuffer.append(CertStoreOCSPOps.a(30216, 6929));
                if (!bl) break block30;
            }
            if (ozetTipi == null) break block30;
            stringBuffer.append(CertStoreOCSPOps.a(30220, 17846));
            arrayList.add(OzneTipi.OCSP_RESPONSE.getIntValue());
            arrayList.add(OzneTipi.OCSP_BASIC_RESPONSE.getIntValue());
            arrayList.add(ozetTipi.getIntValue());
        }
        byte[] byArray = oCSPSearchTemplate.getOCSPResponderID();
        if (byArray != null) {
            stringBuffer.append(CertStoreOCSPOps.a(30217, -30048));
            arrayList.add(byArray);
        }
        byte[] byArray2 = oCSPSearchTemplate.getOCSPValue();
        if (byArray2 != null) {
            stringBuffer.append(CertStoreOCSPOps.a(30237, -26682));
            arrayList.add(byArray2);
        }
        Date date = oCSPSearchTemplate.getProducedAtAfter();
        if (date != null) {
            stringBuffer.append(CertStoreOCSPOps.a(30236, -9820));
            arrayList.add(date);
        }
        Date date2 = oCSPSearchTemplate.getProducedAt();
        if (date2 != null) {
            stringBuffer.append(CertStoreOCSPOps.a(30239, -14320));
            arrayList.add(date2);
        }
        Date date3 = oCSPSearchTemplate.getProducedAtBefore();
        if (date3 != null) {
            stringBuffer.append(CertStoreOCSPOps.a(30222, -24088));
            arrayList.add(date3);
        }
        byte[] byArray3 = oCSPSearchTemplate.getCertSerialNumber();
        if (byArray3 != null) {
            stringBuffer.append(CertStoreOCSPOps.a(30227, -31344));
            arrayList.add(byArray3);
        }
        return new Pair((Object)stringBuffer.toString(), arrayList);
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[25];
                var3_1 = 0;
                var2_2 = ".P{u\u00a7(z#\u00a5\u00df\u00ddd\u0086\u00e1\u00f8Y\u00cf\u00dc\u0092]\u00ad\u00a9\u000bJ\u00a9\u00cf\u00bb\u00df\u009dX\u00d4\u00c3T\u00fb\u0019A\u0080\u0012\n\u00ef.\u0097_\u00b7\u00del\u00a5\u0013RTZ\u00ae\u00e5\u0085\u00d3\u00d4\u008a%\u00ba\u009a\u00ca\u0093O\u00c2P \u0090z\u0091\u00e6\u00cdd\u0013\u00f0\u00cf\u00cf\u0093$\u0011\u00c0\\p\u00f9\u00c22\u00a4\u00ce\f\u00c5\u00b1\u00ce\u00a3\u009aP\u00deR\u00acT^#\u00b3-?\u00fb\"\u00ff\u00fd6\u00cf_8\u00e2v[\u009a\u001d\u00ed\u00dcu\u001d \u0085\u00ee\u0013\u00ba\u00aa\u00ed\u00b8\u00dc\u00f1'\u0019#\u00a04\u00cc\u0086*wQ\u009c\u00f6\u00e7\u008b^\u00e2\u00f1\u00df`I\u00f6D\u00dd\u007f\u0097\u00c3\u0000\u0084\u00fe7\u00cb\u0089\u00ea\u008c\u00a0\u00bdUp\u0097^m\u00edo\u00fe\u00efA\u000bg\u00d8\u00e2\u00bd7\u0017\u000b\u00a6\u0086\u00e2\u00df\u00ad3\u0006\u00c8{\u00ebq\u00a5=L\u0019\u0083\u00e8\u00beZ\bB9v\u00ccQ\u0004\u00b2D\u000b\u001c\u0001(Ow\u00ad~\u00ce\u0084)\u0082g\u0098a\f\u00e3\u00b2o\u009cw\u00e9\u009d\u00b0L\u000b\u0011\fe\u0083\u008d\u00fd\u008b9\u0081\u00be_\u00f0z]\f'L\n3\u00dd\u00c3F\u00d2I]\u0003]5Y:\u009a\u009a\u00dc \u00b5\u008e\u00bc\u0081,\u00af.}\u00dc\u00c0/|J\u00c4\u001f\u00dcs\u00e0%\u00ec\u00f8\u00d7L?\u000bZU'\u0088\u008e\u00ddM\u000e\u000e\u00b3l\u00bb\u007f\u00d4\u00c2\u00f8Oa\u00c0L\u00ef%\u0002\u00be\u00d8@]\u00b3\u00ee*`\u0010,\u00f7\u0092x;\u00bc\u00b6\u00e3\u00c5\u0080\u001d\u00e5\u0004)\u00062).\rGg\u0092\u0083\u00c6\u001cy\u00bf>\u0088\u00f8\u0002Q\u00ee\u000e\u001e\u00aaS\u00b6K\u00a5-\u00e6eC1\u00f0\u00e2C\u00c8\b\u00b2n$\u0089\u0014J\u00c9\u00b9es\u00e6pg1\u00e9\u00c4\u000b\u00f5a\u0098\u00cd{]E\u00bfm\u00ad\u0018\\z\u00ac\u00bd\u00ee\u00cb$y9VUU72\"\u001b\u00d0\u0003\u00b1\u000fD\u00a5\u0018\u00cfH\t\u001bc\u00ab\u00e1j\u00f3~m\u00057\u00da\u0095\u00d6M\u00c71\u0095a\u00b0\r\u009b\u009b\u00f5\u0083'\u001f\u00c3r;\r\u00ebl\u00937\u00eeC \u00c2\u0085_\u0014v\\p\u00f4\u00c6\u001ft\u0002:\u00dd\tz\u0017\u00f8\u00c5\u008a\u00c9\u0007\u00a7\u00e8:Cb\u00e7?\u00d2mP\u00fd\u00b1 \u009d\u008c\u00aa\u00fe\u00e1\u00bb\u0093<$\u00c3\u0014\u0003\u00c9\u0090eX\u00ff\u00ce}d\u009b\u00e0Qv\u00e6Ri\u00ed_\u0010&\u00f0g3\u008eq\u00af\u0007\u0095\u0017\u001e\u001d\u00d9;\u00ac!.a\u001a\u00e5\u00e7\u00de\u008b\u00c7J\u0092\u00ec\u0088!\u00b5\u009a&\u00ea\u00e0\rq\u00b6\u001c\u00ff\u0005\b~\u00f8\u00fa\u001a@\u00a7\u0004k\u001d\u00f5g\u00e3x\u001c\u00a4\u00ec\u00e4\u00cfV\u0017\u009as\\%\u00f0F\u00a1\u008c\u009f\u008c\u0087\u00ff\u00a0^\u0095\u00ee&\u008f|U\u00d6\u0016\u001e\u00b1/\u0099M\u0099\u00836r\u0084\u00d8V\u00913\u000f\u00ff\u00cb\u00eb\u00bct$\u0012!\u00bf\u008ev\u00d6\u001b\u00eav?\u00b9\u00fb\f\u0015$x8\u00ab\u00b9\u00e5\u008e\u0098\u0081~'\u00fd\u00cd9N\u00f90\n\u0003Q\u0086\u00cb\u008b\u00c7\u000e0G\u0088\u00ce\u00fbz\u0018\u0087\u00cds*P\u00e60\u00c6\u00ab\u00b7\u001fl\u00a6\u00b8NiW\u00cb\u00dci\u00bf\u0083\u00a7\u001f\u0090\u0013\u00ad\u0089\u008b\u00ac\u00b1\u0083\u0086\u00c9\u00a8\u00a3k\u00f7\u00c4\u0001 \u008ax\u00fc\u00de\u00f2\u000b\u00c1\u008e\u0002H\u0084\u001b$\u00ff\u00f47Pe\u0099\u0092\u0090h\b\u00a0n~W\u0096\u00f9\u00f6\u0087b\u00bf\u00f0\u00e2i{\n!V\u00c3\u00df\u007f\u0012]\u00ca\u0013q\u00e7\u00e4\u00ba\\\u009fZ\\\u00f3!\u0002\u0089\u0091'\u00a7N\u00e7\u00edY\t\u00d0\u00b3Z\u00ce\u009dy\u0006\u0015Pr\u00fd%K@\u009fh\u00b5\u00f9\b@\u00c9\u008e\u00b7\u00f7\u001c]\u00e4cR\u00ef\u00d9\u00c3\u0098B\t\u00e5N\u00d6S\u009f~P\u0081\u00a7^$\u008aq\u00fa]w-\u00f9\u00dd\b\u00c6%(a\u00f8\u0000^\u00c7\u00f6\u00d4\t\u000e\u009e\u00dcp\u00d5\u00a3\u00d4\u00be\u00cd+\u00e5>\u00a1\u0010\u0000\u00d2\u00c5C;\u00d6\u00f2\u0087\u00c1\u00e6\u00ea\u00827-D/.\u008ee<\u008e\u0012HzK\u00ed\u0004+#\u0094}\u00f9Z\u00ee\u001c\u00b7\u00a3\u00a0\u00be\u0015Oyt\u00b0\u0013\u008e\u00a6\u008c@\u00f1\u00a3Q\u0006nP\u00b6A&t\u009c\u00c6\u000b&\u007f=l\u00e7\u00d1}\u0000\u00cb\u00a4\u0097M\u00b2Q\u00a92\u00c5)\u00fch\u0081L\u000e5GKg\u0082\u001b\u00d3\u0092\u00a7P\u0004\u0093\u00efT~\u00f0\u00d8\u0097W\u0084\u00e8\u00e4S\u00d0.\n\u00b6\u00cc'\u0083\u00af\u00fa<F\u00d0iT\u00884nNKGO\u0002J'\u0081*\u00b3\u00d6Hy35\u00cb\u00c9\u0013\u00a3'`GBE&x\u0085\u00fa\u001b,K\u0003~\u0018\u00f8~;?\u00a2\u001ax\u0002\u00c8}5x2\u00b0[\u00b5%\u001b\u00ca\u00a9\u000e\u00c9\u009db\u00ae\u009b\u00e1\u00a3\u00f9m\u00bc\u0013\u0002?\u00df\u00f1)`OqK\u00a4\u00cf\u00ffY\u0012\t\u00d7\u00b8\u00c2U\u00fa\u00c7\u00c9[\u00c8pj\u00a5\u00979\u0097\u00f7\u0005\u0095TV!\u0086\u00f0\u00f17+\u00dc\u00d1\u00e0q\u00ecr\u00c5\n>/\u0003\u00ad\u001f\u001b\u00c3\u00f5\u008fY\b>O\u00bf\u00a4q\u00bc\u00d1\u00e1\u00f9]\u0011\u0099\u009cL[\u000f\u00e5\u00c7V[\u00ad\u00a3{\u00f7\u00fc\u00c0<\"\u009d\u00e9\u00dcW\u0001\u00af\u0015o\u00dcs}X\u00bf/Y\u00b5D\u00d2x\u00e5\u00e4\u0082\u0001\u00906\u00a2\u007f,u\u00fb-\u00d6Zb\u00e10\u0091\u00d7X'h\u00a0s|\u001cC\u008e\u0094Y\b7s\u0090\u00fbQ[\u00a73\u0083x\u00bb\u00a6\u000f\u009d\u00a8\u00ed\u00d0=\u00a3n\u0004TA\u0083Y\u0019WrT1B\u00a0\u00c622\u00f9+;\u00d9\u00fc\u00f8\u00e8\r\u00d5N\u00c7`\u00da\u0099*e\u0003\u00f2\u00df\u0087-M\u00e06\u0081^\u00f4\u0096\n\u00b2\u00ea9/cu\u0017\u00e5\u0012\u00e0\u0006V\u00deq\u00e4+~S\u00a2jr\u00ac&q\u00ee:\u0018\u001d\u00b6J\u00afn\u0007\u00b6\u009c/\u0093";
                var4_3 = ".P{u\u00a7(z#\u00a5\u00df\u00ddd\u0086\u00e1\u00f8Y\u00cf\u00dc\u0092]\u00ad\u00a9\u000bJ\u00a9\u00cf\u00bb\u00df\u009dX\u00d4\u00c3T\u00fb\u0019A\u0080\u0012\n\u00ef.\u0097_\u00b7\u00del\u00a5\u0013RTZ\u00ae\u00e5\u0085\u00d3\u00d4\u008a%\u00ba\u009a\u00ca\u0093O\u00c2P \u0090z\u0091\u00e6\u00cdd\u0013\u00f0\u00cf\u00cf\u0093$\u0011\u00c0\\p\u00f9\u00c22\u00a4\u00ce\f\u00c5\u00b1\u00ce\u00a3\u009aP\u00deR\u00acT^#\u00b3-?\u00fb\"\u00ff\u00fd6\u00cf_8\u00e2v[\u009a\u001d\u00ed\u00dcu\u001d \u0085\u00ee\u0013\u00ba\u00aa\u00ed\u00b8\u00dc\u00f1'\u0019#\u00a04\u00cc\u0086*wQ\u009c\u00f6\u00e7\u008b^\u00e2\u00f1\u00df`I\u00f6D\u00dd\u007f\u0097\u00c3\u0000\u0084\u00fe7\u00cb\u0089\u00ea\u008c\u00a0\u00bdUp\u0097^m\u00edo\u00fe\u00efA\u000bg\u00d8\u00e2\u00bd7\u0017\u000b\u00a6\u0086\u00e2\u00df\u00ad3\u0006\u00c8{\u00ebq\u00a5=L\u0019\u0083\u00e8\u00beZ\bB9v\u00ccQ\u0004\u00b2D\u000b\u001c\u0001(Ow\u00ad~\u00ce\u0084)\u0082g\u0098a\f\u00e3\u00b2o\u009cw\u00e9\u009d\u00b0L\u000b\u0011\fe\u0083\u008d\u00fd\u008b9\u0081\u00be_\u00f0z]\f'L\n3\u00dd\u00c3F\u00d2I]\u0003]5Y:\u009a\u009a\u00dc \u00b5\u008e\u00bc\u0081,\u00af.}\u00dc\u00c0/|J\u00c4\u001f\u00dcs\u00e0%\u00ec\u00f8\u00d7L?\u000bZU'\u0088\u008e\u00ddM\u000e\u000e\u00b3l\u00bb\u007f\u00d4\u00c2\u00f8Oa\u00c0L\u00ef%\u0002\u00be\u00d8@]\u00b3\u00ee*`\u0010,\u00f7\u0092x;\u00bc\u00b6\u00e3\u00c5\u0080\u001d\u00e5\u0004)\u00062).\rGg\u0092\u0083\u00c6\u001cy\u00bf>\u0088\u00f8\u0002Q\u00ee\u000e\u001e\u00aaS\u00b6K\u00a5-\u00e6eC1\u00f0\u00e2C\u00c8\b\u00b2n$\u0089\u0014J\u00c9\u00b9es\u00e6pg1\u00e9\u00c4\u000b\u00f5a\u0098\u00cd{]E\u00bfm\u00ad\u0018\\z\u00ac\u00bd\u00ee\u00cb$y9VUU72\"\u001b\u00d0\u0003\u00b1\u000fD\u00a5\u0018\u00cfH\t\u001bc\u00ab\u00e1j\u00f3~m\u00057\u00da\u0095\u00d6M\u00c71\u0095a\u00b0\r\u009b\u009b\u00f5\u0083'\u001f\u00c3r;\r\u00ebl\u00937\u00eeC \u00c2\u0085_\u0014v\\p\u00f4\u00c6\u001ft\u0002:\u00dd\tz\u0017\u00f8\u00c5\u008a\u00c9\u0007\u00a7\u00e8:Cb\u00e7?\u00d2mP\u00fd\u00b1 \u009d\u008c\u00aa\u00fe\u00e1\u00bb\u0093<$\u00c3\u0014\u0003\u00c9\u0090eX\u00ff\u00ce}d\u009b\u00e0Qv\u00e6Ri\u00ed_\u0010&\u00f0g3\u008eq\u00af\u0007\u0095\u0017\u001e\u001d\u00d9;\u00ac!.a\u001a\u00e5\u00e7\u00de\u008b\u00c7J\u0092\u00ec\u0088!\u00b5\u009a&\u00ea\u00e0\rq\u00b6\u001c\u00ff\u0005\b~\u00f8\u00fa\u001a@\u00a7\u0004k\u001d\u00f5g\u00e3x\u001c\u00a4\u00ec\u00e4\u00cfV\u0017\u009as\\%\u00f0F\u00a1\u008c\u009f\u008c\u0087\u00ff\u00a0^\u0095\u00ee&\u008f|U\u00d6\u0016\u001e\u00b1/\u0099M\u0099\u00836r\u0084\u00d8V\u00913\u000f\u00ff\u00cb\u00eb\u00bct$\u0012!\u00bf\u008ev\u00d6\u001b\u00eav?\u00b9\u00fb\f\u0015$x8\u00ab\u00b9\u00e5\u008e\u0098\u0081~'\u00fd\u00cd9N\u00f90\n\u0003Q\u0086\u00cb\u008b\u00c7\u000e0G\u0088\u00ce\u00fbz\u0018\u0087\u00cds*P\u00e60\u00c6\u00ab\u00b7\u001fl\u00a6\u00b8NiW\u00cb\u00dci\u00bf\u0083\u00a7\u001f\u0090\u0013\u00ad\u0089\u008b\u00ac\u00b1\u0083\u0086\u00c9\u00a8\u00a3k\u00f7\u00c4\u0001 \u008ax\u00fc\u00de\u00f2\u000b\u00c1\u008e\u0002H\u0084\u001b$\u00ff\u00f47Pe\u0099\u0092\u0090h\b\u00a0n~W\u0096\u00f9\u00f6\u0087b\u00bf\u00f0\u00e2i{\n!V\u00c3\u00df\u007f\u0012]\u00ca\u0013q\u00e7\u00e4\u00ba\\\u009fZ\\\u00f3!\u0002\u0089\u0091'\u00a7N\u00e7\u00edY\t\u00d0\u00b3Z\u00ce\u009dy\u0006\u0015Pr\u00fd%K@\u009fh\u00b5\u00f9\b@\u00c9\u008e\u00b7\u00f7\u001c]\u00e4cR\u00ef\u00d9\u00c3\u0098B\t\u00e5N\u00d6S\u009f~P\u0081\u00a7^$\u008aq\u00fa]w-\u00f9\u00dd\b\u00c6%(a\u00f8\u0000^\u00c7\u00f6\u00d4\t\u000e\u009e\u00dcp\u00d5\u00a3\u00d4\u00be\u00cd+\u00e5>\u00a1\u0010\u0000\u00d2\u00c5C;\u00d6\u00f2\u0087\u00c1\u00e6\u00ea\u00827-D/.\u008ee<\u008e\u0012HzK\u00ed\u0004+#\u0094}\u00f9Z\u00ee\u001c\u00b7\u00a3\u00a0\u00be\u0015Oyt\u00b0\u0013\u008e\u00a6\u008c@\u00f1\u00a3Q\u0006nP\u00b6A&t\u009c\u00c6\u000b&\u007f=l\u00e7\u00d1}\u0000\u00cb\u00a4\u0097M\u00b2Q\u00a92\u00c5)\u00fch\u0081L\u000e5GKg\u0082\u001b\u00d3\u0092\u00a7P\u0004\u0093\u00efT~\u00f0\u00d8\u0097W\u0084\u00e8\u00e4S\u00d0.\n\u00b6\u00cc'\u0083\u00af\u00fa<F\u00d0iT\u00884nNKGO\u0002J'\u0081*\u00b3\u00d6Hy35\u00cb\u00c9\u0013\u00a3'`GBE&x\u0085\u00fa\u001b,K\u0003~\u0018\u00f8~;?\u00a2\u001ax\u0002\u00c8}5x2\u00b0[\u00b5%\u001b\u00ca\u00a9\u000e\u00c9\u009db\u00ae\u009b\u00e1\u00a3\u00f9m\u00bc\u0013\u0002?\u00df\u00f1)`OqK\u00a4\u00cf\u00ffY\u0012\t\u00d7\u00b8\u00c2U\u00fa\u00c7\u00c9[\u00c8pj\u00a5\u00979\u0097\u00f7\u0005\u0095TV!\u0086\u00f0\u00f17+\u00dc\u00d1\u00e0q\u00ecr\u00c5\n>/\u0003\u00ad\u001f\u001b\u00c3\u00f5\u008fY\b>O\u00bf\u00a4q\u00bc\u00d1\u00e1\u00f9]\u0011\u0099\u009cL[\u000f\u00e5\u00c7V[\u00ad\u00a3{\u00f7\u00fc\u00c0<\"\u009d\u00e9\u00dcW\u0001\u00af\u0015o\u00dcs}X\u00bf/Y\u00b5D\u00d2x\u00e5\u00e4\u0082\u0001\u00906\u00a2\u007f,u\u00fb-\u00d6Zb\u00e10\u0091\u00d7X'h\u00a0s|\u001cC\u008e\u0094Y\b7s\u0090\u00fbQ[\u00a73\u0083x\u00bb\u00a6\u000f\u009d\u00a8\u00ed\u00d0=\u00a3n\u0004TA\u0083Y\u0019WrT1B\u00a0\u00c622\u00f9+;\u00d9\u00fc\u00f8\u00e8\r\u00d5N\u00c7`\u00da\u0099*e\u0003\u00f2\u00df\u0087-M\u00e06\u0081^\u00f4\u0096\n\u00b2\u00ea9/cu\u0017\u00e5\u0012\u00e0\u0006V\u00deq\u00e4+~S\u00a2jr\u00ac&q\u00ee:\u0018\u001d\u00b6J\u00afn\u0007\u00b6\u009c/\u0093".length();
                var1_4 = 19;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "e\u00833\u00ed\u00fey\u0082\u00bb0\u00dci\u00e9i\u00adV\u00fe:\u0083\u001a4`\u00f5\u00d5Op\u00aaK\u0098w\u00a2\u00f8\u00ce_\u008d@\u00cc\u0016\u00f7^\u00bdjzX=+pd#\u00de|s%W\u00aa\u009c4\u00a4.\u00df\u00een\u00e0\u001fL\u0096w\u0082\u001f$\u00b7\u00c0\u00d5kc\u009c\u00a6\u00d0\u0091\u00d7,N\u00d2\u00afp\u00dc\u00c3\u0011\u00c4e\u00e5\u009a\u00d1S\"\u00be\u0081\u00a9\u0085\u0012\u0011f!\u00b7\u001eM";
                    var4_3 = "e\u00833\u00ed\u00fey\u0082\u00bb0\u00dci\u00e9i\u00adV\u00fe:\u0083\u001a4`\u00f5\u00d5Op\u00aaK\u0098w\u00a2\u00f8\u00ce_\u008d@\u00cc\u0016\u00f7^\u00bdjzX=+pd#\u00de|s%W\u00aa\u009c4\u00a4.\u00df\u00een\u00e0\u001fL\u0096w\u0082\u001f$\u00b7\u00c0\u00d5kc\u009c\u00a6\u00d0\u0091\u00d7,N\u00d2\u00afp\u00dc\u00c3\u0011\u00c4e\u00e5\u009a\u00d1S\"\u00be\u0081\u00a9\u0085\u0012\u0011f!\u00b7\u001eM".length();
                    var1_4 = 43;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 54;
                            break;
                        }
                        case 1: {
                            v13 = 24;
                            break;
                        }
                        case 2: {
                            v13 = 18;
                            break;
                        }
                        case 3: {
                            v13 = 81;
                            break;
                        }
                        case 4: {
                            v13 = 45;
                            break;
                        }
                        case 5: {
                            v13 = 47;
                            break;
                        }
                        default: {
                            v13 = 76;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        CertStoreOCSPOps.c = var5;
        CertStoreOCSPOps.d = new String[25];
        CertStoreOCSPOps.a = LoggerFactory.getLogger(CertStoreOCSPOps.class);
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0x761D) & 0xFFFF;
        if (d[n3] == null) {
            int n4;
            int n5;
            char[] cArray = c[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 134;
                    break;
                }
                case 1: {
                    n5 = 64;
                    break;
                }
                case 2: {
                    n5 = 97;
                    break;
                }
                case 3: {
                    n5 = 12;
                    break;
                }
                case 4: {
                    n5 = 197;
                    break;
                }
                case 5: {
                    n5 = 244;
                    break;
                }
                case 6: {
                    n5 = 76;
                    break;
                }
                case 7: {
                    n5 = 29;
                    break;
                }
                case 8: {
                    n5 = 161;
                    break;
                }
                case 9: {
                    n5 = 156;
                    break;
                }
                case 10: {
                    n5 = 4;
                    break;
                }
                case 11: {
                    n5 = 9;
                    break;
                }
                case 12: {
                    n5 = 31;
                    break;
                }
                case 13: {
                    n5 = 117;
                    break;
                }
                case 14: {
                    n5 = 214;
                    break;
                }
                case 15: {
                    n5 = 201;
                    break;
                }
                case 16: {
                    n5 = 71;
                    break;
                }
                case 17: {
                    n5 = 105;
                    break;
                }
                case 18: {
                    n5 = 152;
                    break;
                }
                case 19: {
                    n5 = 87;
                    break;
                }
                case 20: {
                    n5 = 25;
                    break;
                }
                case 21: {
                    n5 = 21;
                    break;
                }
                case 22: {
                    n5 = 189;
                    break;
                }
                case 23: {
                    n5 = 106;
                    break;
                }
                case 24: {
                    n5 = 142;
                    break;
                }
                case 25: {
                    n5 = 57;
                    break;
                }
                case 26: {
                    n5 = 16;
                    break;
                }
                case 27: {
                    n5 = 83;
                    break;
                }
                case 28: {
                    n5 = 176;
                    break;
                }
                case 29: {
                    n5 = 44;
                    break;
                }
                case 30: {
                    n5 = 177;
                    break;
                }
                case 31: {
                    n5 = 141;
                    break;
                }
                case 32: {
                    n5 = 32;
                    break;
                }
                case 33: {
                    n5 = 229;
                    break;
                }
                case 34: {
                    n5 = 153;
                    break;
                }
                case 35: {
                    n5 = 52;
                    break;
                }
                case 36: {
                    n5 = 19;
                    break;
                }
                case 37: {
                    n5 = 103;
                    break;
                }
                case 38: {
                    n5 = 86;
                    break;
                }
                case 39: {
                    n5 = 225;
                    break;
                }
                case 40: {
                    n5 = 96;
                    break;
                }
                case 41: {
                    n5 = 252;
                    break;
                }
                case 42: {
                    n5 = 58;
                    break;
                }
                case 43: {
                    n5 = 164;
                    break;
                }
                case 44: {
                    n5 = 113;
                    break;
                }
                case 45: {
                    n5 = 157;
                    break;
                }
                case 46: {
                    n5 = 240;
                    break;
                }
                case 47: {
                    n5 = 185;
                    break;
                }
                case 48: {
                    n5 = 248;
                    break;
                }
                case 49: {
                    n5 = 148;
                    break;
                }
                case 50: {
                    n5 = 210;
                    break;
                }
                case 51: {
                    n5 = 206;
                    break;
                }
                case 52: {
                    n5 = 13;
                    break;
                }
                case 53: {
                    n5 = 110;
                    break;
                }
                case 54: {
                    n5 = 138;
                    break;
                }
                case 55: {
                    n5 = 205;
                    break;
                }
                case 56: {
                    n5 = 14;
                    break;
                }
                case 57: {
                    n5 = 169;
                    break;
                }
                case 58: {
                    n5 = 228;
                    break;
                }
                case 59: {
                    n5 = 33;
                    break;
                }
                case 60: {
                    n5 = 59;
                    break;
                }
                case 61: {
                    n5 = 88;
                    break;
                }
                case 62: {
                    n5 = 167;
                    break;
                }
                case 63: {
                    n5 = 63;
                    break;
                }
                case 64: {
                    n5 = 53;
                    break;
                }
                case 65: {
                    n5 = 54;
                    break;
                }
                case 66: {
                    n5 = 131;
                    break;
                }
                case 67: {
                    n5 = 3;
                    break;
                }
                case 68: {
                    n5 = 108;
                    break;
                }
                case 69: {
                    n5 = 242;
                    break;
                }
                case 70: {
                    n5 = 93;
                    break;
                }
                case 71: {
                    n5 = 250;
                    break;
                }
                case 72: {
                    n5 = 193;
                    break;
                }
                case 73: {
                    n5 = 78;
                    break;
                }
                case 74: {
                    n5 = 127;
                    break;
                }
                case 75: {
                    n5 = 230;
                    break;
                }
                case 76: {
                    n5 = 115;
                    break;
                }
                case 77: {
                    n5 = 162;
                    break;
                }
                case 78: {
                    n5 = 222;
                    break;
                }
                case 79: {
                    n5 = 220;
                    break;
                }
                case 80: {
                    n5 = 72;
                    break;
                }
                case 81: {
                    n5 = 249;
                    break;
                }
                case 82: {
                    n5 = 151;
                    break;
                }
                case 83: {
                    n5 = 128;
                    break;
                }
                case 84: {
                    n5 = 62;
                    break;
                }
                case 85: {
                    n5 = 119;
                    break;
                }
                case 86: {
                    n5 = 7;
                    break;
                }
                case 87: {
                    n5 = 187;
                    break;
                }
                case 88: {
                    n5 = 30;
                    break;
                }
                case 89: {
                    n5 = 36;
                    break;
                }
                case 90: {
                    n5 = 43;
                    break;
                }
                case 91: {
                    n5 = 120;
                    break;
                }
                case 92: {
                    n5 = 238;
                    break;
                }
                case 93: {
                    n5 = 18;
                    break;
                }
                case 94: {
                    n5 = 154;
                    break;
                }
                case 95: {
                    n5 = 146;
                    break;
                }
                case 96: {
                    n5 = 174;
                    break;
                }
                case 97: {
                    n5 = 95;
                    break;
                }
                case 98: {
                    n5 = 116;
                    break;
                }
                case 99: {
                    n5 = 94;
                    break;
                }
                case 100: {
                    n5 = 254;
                    break;
                }
                case 101: {
                    n5 = 111;
                    break;
                }
                case 102: {
                    n5 = 6;
                    break;
                }
                case 103: {
                    n5 = 100;
                    break;
                }
                case 104: {
                    n5 = 121;
                    break;
                }
                case 105: {
                    n5 = 149;
                    break;
                }
                case 106: {
                    n5 = 245;
                    break;
                }
                case 107: {
                    n5 = 171;
                    break;
                }
                case 108: {
                    n5 = 55;
                    break;
                }
                case 109: {
                    n5 = 181;
                    break;
                }
                case 110: {
                    n5 = 60;
                    break;
                }
                case 111: {
                    n5 = 75;
                    break;
                }
                case 112: {
                    n5 = 39;
                    break;
                }
                case 113: {
                    n5 = 79;
                    break;
                }
                case 114: {
                    n5 = 37;
                    break;
                }
                case 115: {
                    n5 = 226;
                    break;
                }
                case 116: {
                    n5 = 107;
                    break;
                }
                case 117: {
                    n5 = 158;
                    break;
                }
                case 118: {
                    n5 = 253;
                    break;
                }
                case 119: {
                    n5 = 68;
                    break;
                }
                case 120: {
                    n5 = 47;
                    break;
                }
                case 121: {
                    n5 = 22;
                    break;
                }
                case 122: {
                    n5 = 130;
                    break;
                }
                case 123: {
                    n5 = 90;
                    break;
                }
                case 124: {
                    n5 = 114;
                    break;
                }
                case 125: {
                    n5 = 40;
                    break;
                }
                case 126: {
                    n5 = 243;
                    break;
                }
                case 127: {
                    n5 = 143;
                    break;
                }
                case 128: {
                    n5 = 126;
                    break;
                }
                case 129: {
                    n5 = 186;
                    break;
                }
                case 130: {
                    n5 = 175;
                    break;
                }
                case 131: {
                    n5 = 42;
                    break;
                }
                case 132: {
                    n5 = 102;
                    break;
                }
                case 133: {
                    n5 = 92;
                    break;
                }
                case 134: {
                    n5 = 26;
                    break;
                }
                case 135: {
                    n5 = 227;
                    break;
                }
                case 136: {
                    n5 = 112;
                    break;
                }
                case 137: {
                    n5 = 213;
                    break;
                }
                case 138: {
                    n5 = 65;
                    break;
                }
                case 139: {
                    n5 = 124;
                    break;
                }
                case 140: {
                    n5 = 11;
                    break;
                }
                case 141: {
                    n5 = 200;
                    break;
                }
                case 142: {
                    n5 = 24;
                    break;
                }
                case 143: {
                    n5 = 246;
                    break;
                }
                case 144: {
                    n5 = 99;
                    break;
                }
                case 145: {
                    n5 = 51;
                    break;
                }
                case 146: {
                    n5 = 232;
                    break;
                }
                case 147: {
                    n5 = 66;
                    break;
                }
                case 148: {
                    n5 = 122;
                    break;
                }
                case 149: {
                    n5 = 1;
                    break;
                }
                case 150: {
                    n5 = 195;
                    break;
                }
                case 151: {
                    n5 = 199;
                    break;
                }
                case 152: {
                    n5 = 209;
                    break;
                }
                case 153: {
                    n5 = 41;
                    break;
                }
                case 154: {
                    n5 = 49;
                    break;
                }
                case 155: {
                    n5 = 233;
                    break;
                }
                case 156: {
                    n5 = 144;
                    break;
                }
                case 157: {
                    n5 = 204;
                    break;
                }
                case 158: {
                    n5 = 139;
                    break;
                }
                case 159: {
                    n5 = 235;
                    break;
                }
                case 160: {
                    n5 = 208;
                    break;
                }
                case 161: {
                    n5 = 133;
                    break;
                }
                case 162: {
                    n5 = 89;
                    break;
                }
                case 163: {
                    n5 = 236;
                    break;
                }
                case 164: {
                    n5 = 50;
                    break;
                }
                case 165: {
                    n5 = 239;
                    break;
                }
                case 166: {
                    n5 = 192;
                    break;
                }
                case 167: {
                    n5 = 28;
                    break;
                }
                case 168: {
                    n5 = 198;
                    break;
                }
                case 169: {
                    n5 = 215;
                    break;
                }
                case 170: {
                    n5 = 20;
                    break;
                }
                case 171: {
                    n5 = 15;
                    break;
                }
                case 172: {
                    n5 = 132;
                    break;
                }
                case 173: {
                    n5 = 150;
                    break;
                }
                case 174: {
                    n5 = 219;
                    break;
                }
                case 175: {
                    n5 = 184;
                    break;
                }
                case 176: {
                    n5 = 82;
                    break;
                }
                case 177: {
                    n5 = 237;
                    break;
                }
                case 178: {
                    n5 = 223;
                    break;
                }
                case 179: {
                    n5 = 10;
                    break;
                }
                case 180: {
                    n5 = 5;
                    break;
                }
                case 181: {
                    n5 = 70;
                    break;
                }
                case 182: {
                    n5 = 136;
                    break;
                }
                case 183: {
                    n5 = 224;
                    break;
                }
                case 184: {
                    n5 = 202;
                    break;
                }
                case 185: {
                    n5 = 190;
                    break;
                }
                case 186: {
                    n5 = 216;
                    break;
                }
                case 187: {
                    n5 = 194;
                    break;
                }
                case 188: {
                    n5 = 2;
                    break;
                }
                case 189: {
                    n5 = 8;
                    break;
                }
                case 190: {
                    n5 = 255;
                    break;
                }
                case 191: {
                    n5 = 211;
                    break;
                }
                case 192: {
                    n5 = 145;
                    break;
                }
                case 193: {
                    n5 = 247;
                    break;
                }
                case 194: {
                    n5 = 173;
                    break;
                }
                case 195: {
                    n5 = 23;
                    break;
                }
                case 196: {
                    n5 = 45;
                    break;
                }
                case 197: {
                    n5 = 81;
                    break;
                }
                case 198: {
                    n5 = 74;
                    break;
                }
                case 199: {
                    n5 = 231;
                    break;
                }
                case 200: {
                    n5 = 125;
                    break;
                }
                case 201: {
                    n5 = 85;
                    break;
                }
                case 202: {
                    n5 = 234;
                    break;
                }
                case 203: {
                    n5 = 170;
                    break;
                }
                case 204: {
                    n5 = 109;
                    break;
                }
                case 205: {
                    n5 = 38;
                    break;
                }
                case 206: {
                    n5 = 140;
                    break;
                }
                case 207: {
                    n5 = 172;
                    break;
                }
                case 208: {
                    n5 = 207;
                    break;
                }
                case 209: {
                    n5 = 61;
                    break;
                }
                case 210: {
                    n5 = 168;
                    break;
                }
                case 211: {
                    n5 = 203;
                    break;
                }
                case 212: {
                    n5 = 155;
                    break;
                }
                case 213: {
                    n5 = 118;
                    break;
                }
                case 214: {
                    n5 = 77;
                    break;
                }
                case 215: {
                    n5 = 166;
                    break;
                }
                case 216: {
                    n5 = 251;
                    break;
                }
                case 217: {
                    n5 = 48;
                    break;
                }
                case 218: {
                    n5 = 73;
                    break;
                }
                case 219: {
                    n5 = 56;
                    break;
                }
                case 220: {
                    n5 = 27;
                    break;
                }
                case 221: {
                    n5 = 217;
                    break;
                }
                case 222: {
                    n5 = 34;
                    break;
                }
                case 223: {
                    n5 = 0;
                    break;
                }
                case 224: {
                    n5 = 196;
                    break;
                }
                case 225: {
                    n5 = 241;
                    break;
                }
                case 226: {
                    n5 = 188;
                    break;
                }
                case 227: {
                    n5 = 69;
                    break;
                }
                case 228: {
                    n5 = 218;
                    break;
                }
                case 229: {
                    n5 = 178;
                    break;
                }
                case 230: {
                    n5 = 147;
                    break;
                }
                case 231: {
                    n5 = 165;
                    break;
                }
                case 232: {
                    n5 = 80;
                    break;
                }
                case 233: {
                    n5 = 159;
                    break;
                }
                case 234: {
                    n5 = 67;
                    break;
                }
                case 235: {
                    n5 = 182;
                    break;
                }
                case 236: {
                    n5 = 191;
                    break;
                }
                case 237: {
                    n5 = 17;
                    break;
                }
                case 238: {
                    n5 = 212;
                    break;
                }
                case 239: {
                    n5 = 123;
                    break;
                }
                case 240: {
                    n5 = 104;
                    break;
                }
                case 241: {
                    n5 = 84;
                    break;
                }
                case 242: {
                    n5 = 129;
                    break;
                }
                case 243: {
                    n5 = 160;
                    break;
                }
                case 244: {
                    n5 = 135;
                    break;
                }
                case 245: {
                    n5 = 101;
                    break;
                }
                case 246: {
                    n5 = 98;
                    break;
                }
                case 247: {
                    n5 = 35;
                    break;
                }
                case 248: {
                    n5 = 91;
                    break;
                }
                case 249: {
                    n5 = 163;
                    break;
                }
                case 250: {
                    n5 = 46;
                    break;
                }
                case 251: {
                    n5 = 137;
                    break;
                }
                case 252: {
                    n5 = 180;
                    break;
                }
                case 253: {
                    n5 = 179;
                    break;
                }
                case 254: {
                    n5 = 221;
                    break;
                }
                default: {
                    n5 = 183;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            CertStoreOCSPOps.d[n3] = new String(cArray).intern();
        }
        return d[n3];
    }
}

