/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.ECertID;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EResponseData;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.CertificateStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.MatchSystem;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.StatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.ValidationSystem;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.Checker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateController;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.issuer.IssuerCheckParameters;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.CRLController;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.CRLStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.CRLStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.deltacrl.DeltaCRLController;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.Find;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.certificate.CertificateFinder;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.certificate.cross.CrossCertificateFinder;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.certificate.trusted.TrustedCertificateFinder;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.crl.CRLFinder;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.crl.delta.DeltaCRLFinder;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.ocsp.OCSPResponseFinder;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;

public class FindSystem {
    private static Logger a;
    private static final List<ECertificate> b;
    private static final List<ECRL> c;
    private List<ECertificate> d = new ArrayList<ECertificate>(0);
    private boolean e;
    private List<CertificateFinder> f = new ArrayList<CertificateFinder>(0);
    private List<CRLFinder> g = new ArrayList<CRLFinder>(0);
    private List<OCSPResponseFinder> h = new ArrayList<OCSPResponseFinder>(0);
    private List<TrustedCertificateFinder> i = new ArrayList<TrustedCertificateFinder>();
    private List<CrossCertificateFinder> j = new ArrayList<CrossCertificateFinder>(0);
    private List<DeltaCRLFinder> k = new ArrayList<DeltaCRLFinder>(0);
    private static final String[] l;
    private static final String[] m;

    public FindSystem() {
        try {
            LV.getInstance().checkLD(LV.Urunler.SERTIFIKADOGRULAMA);
        }
        catch (LE lE) {
            throw new ESYARuntimeException(FindSystem.a(-3392, -17563) + lE.getMessage());
        }
    }

    public List<ECertificate> getTrustedCertificates() {
        return this.d;
    }

    public void findTrustedCertificates() {
        int n = StatusInfo.c;
        if (!this.e) {
            for (TrustedCertificateFinder trustedCertificateFinder : this.i) {
                this.d.addAll(trustedCertificateFinder.findTrustedCertificate());
                if (n == 0) continue;
            }
            this.e = true;
        }
    }

    public void addTrustedCertificate(ECertificate aCertificate) {
        if (this.d.indexOf(aCertificate) < 0) {
            this.d.add(aCertificate);
        }
    }

    public boolean isTrustedCertificate(ECertificate aCertificate) {
        Iterator<ECertificate> iterator = this.d.iterator();
        int n = StatusInfo.c;
        while (iterator.hasNext()) {
            ECertificate eCertificate = iterator.next();
            if (aCertificate.equals((Object)eCertificate)) {
                return true;
            }
            if (n == 0) continue;
        }
        return false;
    }

    public List<CertificateFinder> getCertificateFinders() {
        return this.f;
    }

    public void setCertificateFinders(List<CertificateFinder> aCertificateFinders) {
        this.f = aCertificateFinders;
    }

    public void addCertificateFinder(CertificateFinder aCertificateFinder) {
        this.f.add(aCertificateFinder);
    }

    public List<TrustedCertificateFinder> getTrustedCertificateFinders() {
        return this.i;
    }

    public void setTrustedCertificateFinders(List<TrustedCertificateFinder> aTrustedCertificateFinders) {
        this.i = aTrustedCertificateFinders;
    }

    public void addTrustedCertificateFinder(TrustedCertificateFinder aTrustedCertificateFinder) {
        this.i.add(aTrustedCertificateFinder);
    }

    public List<CrossCertificateFinder> getCrossCertificateFinders() {
        return this.j;
    }

    public void setCrossCertificateFinders(List<CrossCertificateFinder> aCrossCertificateFinders) {
        this.j = aCrossCertificateFinders;
    }

    public void addCrossCertificateFinder(CrossCertificateFinder aCrossCertificateFinder) {
        this.j.add(aCrossCertificateFinder);
    }

    public List<CRLFinder> getCRLFinders() {
        return this.g;
    }

    public void setCRLFinders(List<CRLFinder> aCRLFinders) {
        this.g = aCRLFinders;
    }

    public void addCRLFinder(CRLFinder aCRLFinder) {
        this.g.add(aCRLFinder);
    }

    public List<OCSPResponseFinder> getOCSPResponseFinders() {
        return this.h;
    }

    public void setOCSPResponseFinders(List<OCSPResponseFinder> aOCSPResponseFinders) {
        this.h = aOCSPResponseFinders;
    }

    public void addOCSPResponseFinder(OCSPResponseFinder aOCSPResponseFinder) {
        this.h.add(aOCSPResponseFinder);
    }

    public List<DeltaCRLFinder> getDeltaCRLFinders() {
        return this.k;
    }

    public void setDeltaCRLFinders(List<DeltaCRLFinder> aDeltaCRLFinders) {
        this.k = aDeltaCRLFinders;
    }

    public void addDeltaCRLFinder(DeltaCRLFinder aDeltaCRLFinder) {
        this.k.add(aDeltaCRLFinder);
    }

    public List<ECertificate> findTrustedCertificates(ValidationSystem aValidationSystem) {
        int n = StatusInfo.c;
        if (this.i.isEmpty()) {
            return b;
        }
        ArrayList<ECertificate> arrayList = new ArrayList<ECertificate>(0);
        for (TrustedCertificateFinder trustedCertificateFinder : this.i) {
            arrayList.addAll(trustedCertificateFinder.findTrustedCertificate());
            if (n == 0) continue;
        }
        return arrayList;
    }

    public ECertificate findIssuerCertificate(ValidationSystem aValidationSystem, CertificateStatusInfo aCertStatusInfo) throws ESYAException {
        ECertificate eCertificate = aCertStatusInfo.getCertificate();
        MatchSystem matchSystem = aValidationSystem.getMatchSystem();
        String string = eCertificate.getSubject().stringValue();
        if (a.isDebugEnabled()) {
            a.debug(string + FindSystem.a(-3387, 1111));
        }
        ECertificate eCertificate2 = null;
        List<ECertificate> list = aValidationSystem.getCertificateValidationCache().getCheckedCertificates();
        eCertificate2 = Find.fromList(matchSystem, list, eCertificate);
        if (eCertificate2 != null) {
            CertificateStatusInfo certificateStatusInfo = aValidationSystem.getCertificateValidationCache().getCheckResult(eCertificate2);
            aCertStatusInfo.setSigningCertficateInfo(certificateStatusInfo.clone());
            if (certificateStatusInfo.getCertificateStatus() == CertificateStatus.VALID) {
                return eCertificate2;
            }
            return null;
        }
        List<ECertificate> list2 = this.getTrustedCertificates();
        eCertificate2 = Find.fromList(matchSystem, list2, eCertificate);
        if (eCertificate2 != null) {
            CertificateController certificateController = new CertificateController();
            CertificateStatusInfo certificateStatusInfo = certificateController.check(aValidationSystem, eCertificate2);
            aCertStatusInfo.setSigningCertficateInfo(certificateStatusInfo);
            if (certificateStatusInfo.getCertificateStatus() == CertificateStatus.VALID) {
                return eCertificate2;
            }
            return null;
        }
        for (CertificateFinder certificateFinder : this.f) {
            block20: {
                block19: {
                    list = certificateFinder.findCertificate(aCertStatusInfo.getCertificate());
                    eCertificate2 = Find.fromList(matchSystem, list, eCertificate);
                    if (eCertificate2 == null) break block19;
                    if (!certificateFinder.isToBeChecked()) break block20;
                    if (this.a(aValidationSystem, aCertStatusInfo, eCertificate2)) break block20;
                }
                eCertificate2 = null;
                continue;
            }
            if (certificateFinder.isToBeChecked()) {
                Find.saveCertificate(aValidationSystem.getSaveSystem(), eCertificate2);
            }
            return eCertificate2;
        }
        return eCertificate2;
    }

    public ECertificate findCRLIssuerCertificate(ValidationSystem aValidationSystem, CRLStatusInfo aCRLStatusInfo) throws ESYAException {
        List<ECertificate> list;
        ECRL eCRL;
        MatchSystem matchSystem;
        ECertificate eCertificate;
        block24: {
            block23: {
                eCertificate = null;
                matchSystem = aValidationSystem.getMatchSystem();
                FindSystem findSystem = aValidationSystem.getFindSystem();
                eCRL = aCRLStatusInfo.getCRL();
                list = aValidationSystem.getCertificateValidationCache().getCheckedCertificates();
                eCertificate = Find.issuerCertificateFromList(matchSystem, list, eCRL);
                if (eCertificate != null) {
                    CertificateStatusInfo certificateStatusInfo = aValidationSystem.getCertificateValidationCache().getCheckResult(eCertificate);
                    aCRLStatusInfo.setSigningCertficateInfo(certificateStatusInfo.clone());
                    if (certificateStatusInfo.getCertificateStatus() == CertificateStatus.VALID) {
                        return eCertificate;
                    }
                    return null;
                }
                List<ECertificate> list2 = findSystem.getTrustedCertificates();
                eCertificate = Find.issuerCertificateFromList(matchSystem, list2, eCRL);
                if (eCertificate != null) {
                    CertificateController certificateController = new CertificateController();
                    CertificateStatusInfo certificateStatusInfo = certificateController.check(aValidationSystem, eCertificate);
                    aCRLStatusInfo.setSigningCertficateInfo(certificateStatusInfo);
                    if (certificateStatusInfo.getCertificateStatus() == CertificateStatus.VALID) {
                        return eCertificate;
                    }
                    return null;
                }
                List<ECertificate> list3 = aValidationSystem.getUserInitialCertificateSet();
                if (list3 != null) {
                    eCertificate = Find.issuerCertificateFromList(matchSystem, list3, eCRL);
                }
                if (eCertificate == null || !this.a(aValidationSystem, aCRLStatusInfo, eCertificate)) break block23;
                return eCertificate;
            }
            eCertificate = null;
            List<ECertificate> list4 = aValidationSystem.getCachedCACertificates(eCRL.getIssuer().stringValue());
            eCertificate = Find.issuerCertificateFromList(matchSystem, list4, eCRL);
            if (eCertificate == null || !this.a(aValidationSystem, aCRLStatusInfo, eCertificate)) break block24;
            return eCertificate;
        }
        eCertificate = null;
        for (CertificateFinder certificateFinder : this.f) {
            list = certificateFinder.findCertificate();
            eCertificate = Find.issuerCertificateFromList(matchSystem, list, eCRL);
            if (eCertificate != null && this.a(aValidationSystem, aCRLStatusInfo, eCertificate)) break;
            eCertificate = null;
        }
        if (eCertificate != null) {
            Find.saveCertificate(aValidationSystem.getSaveSystem(), eCertificate);
        }
        return eCertificate;
    }

    public EOCSPResponse findOCSPResponseFromInitial(ValidationSystem aValidationSystem, ECertificate aIssuerCertificate, CertificateStatusInfo aCertStatusInfo) {
        block6: {
            ECertificate eCertificate = aCertStatusInfo.getCertificate();
            int n = StatusInfo.c;
            List<EOCSPResponse> list = aValidationSystem.getUserInitialOCSPResponseSet();
            if (list == null || list.size() <= 0) break block6;
            a.debug(FindSystem.a(-3388, 8998) + list.size());
            for (int i = 0; i < list.size(); ++i) {
                EOCSPResponse eOCSPResponse = list.get(i);
                EResponseData eResponseData = eOCSPResponse.getBasicOCSPResponse().getTbsResponseData();
                for (int j = 0; j < eResponseData.getSingleResponseCount(); ++j) {
                    ECertID eCertID = eResponseData.getSingleResponse(j).getCertID();
                    if (!this.a(aValidationSystem, eCertID, eCertificate)) continue;
                    return eOCSPResponse;
                }
                if (n == 0) continue;
            }
        }
        return null;
    }

    public EOCSPResponse findOCSPResponse(ValidationSystem aValidationSystem, ECertificate aIssuerCertificate, CertificateStatusInfo aCertStatusInfo) {
        ECertificate eCertificate = aCertStatusInfo.getCertificate();
        int n = StatusInfo.c;
        for (OCSPResponseFinder oCSPResponseFinder : this.h) {
            a.debug(FindSystem.a(-3390, -18748) + oCSPResponseFinder);
            EOCSPResponse eOCSPResponse = oCSPResponseFinder.findOCSPResponse(aCertStatusInfo.getCertificate(), aIssuerCertificate);
            if (eOCSPResponse != null) {
                return eOCSPResponse;
            }
            if (n == 0) continue;
        }
        return null;
    }

    private boolean a(ValidationSystem validationSystem, ECertID eCertID, ECertificate eCertificate) {
        if (!eCertID.getSerialNumber().equals(eCertificate.getSerialNumber())) {
            return false;
        }
        try {
            DigestAlg digestAlg = DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eCertID.getHashAlgorithm());
            byte[] byArray = eCertificate.getIssuer().getEncoded();
            byte[] byArray2 = DigestUtil.digest((DigestAlg)digestAlg, (byte[])byArray);
            if (!Arrays.equals(eCertID.getIssuerNameHash(), byArray2)) {
                return false;
            }
            List<ECertificate> list = this.findIssuerCertificate(validationSystem, eCertificate, true);
            ECertificate eCertificate2 = list.get(0);
            byte[] byArray3 = eCertificate2.getSubjectPublicKeyInfo().getSubjectPublicKey();
            byte[] byArray4 = DigestUtil.digest((DigestAlg)digestAlg, (byte[])byArray3);
            if (!Arrays.equals(eCertID.getIssuerKeyHash(), byArray4)) {
                return false;
            }
        }
        catch (Exception exception) {
            a.error(FindSystem.a(-3391, 7696), (Throwable)exception);
            return false;
        }
        return true;
    }

    public List<ECRL> findCRL(ValidationSystem aValidationSystem, CertificateStatusInfo aCertStatusInfo) throws ESYAException {
        ArrayList<ECRL> arrayList = new ArrayList<ECRL>();
        MatchSystem matchSystem = aValidationSystem.getMatchSystem();
        int n = StatusInfo.c;
        ECertificate eCertificate = aCertStatusInfo.getCertificate();
        Object var7_7 = null;
        String string = eCertificate.getSubject().stringValue();
        if (a.isDebugEnabled()) {
            a.debug(string + FindSystem.a(-3386, -29105));
        }
        List<ECRL> list = new ArrayList<ECRL>();
        a.debug(FindSystem.a(-3385, -20678) + aValidationSystem.getUserInitialCRLSet().size());
        list = Find.crlsFromList(matchSystem, aValidationSystem.getUserInitialCRLSet(), list, eCertificate);
        a.debug(FindSystem.a(-3378, -31466) + list.size());
        for (CRLFinder cRLFinder : this.g) {
            List<ECRL> list2 = cRLFinder.findCRL(eCertificate);
            list = Find.crlsFromList(matchSystem, list2, list, eCertificate);
            if (n == 0) continue;
            boolean bl = !Checker.c;
            Checker.c = bl;
            break;
        }
        for (int i = 0; i < list.size(); ++i) {
            CRLFinder cRLFinder;
            cRLFinder = list.get(i);
            if (!this.checkCRL(aValidationSystem, aCertStatusInfo, (ECRL)cRLFinder)) continue;
            arrayList.add((ECRL)cRLFinder);
            continue;
        }
        return arrayList;
    }

    public ECRL findDeltaCRL(ValidationSystem aValidationSystem, ECRL aBaseCRL, CertificateStatusInfo aCertStatusInfo) throws ESYAException {
        ECRL eCRL;
        block7: {
            eCRL = null;
            MatchSystem matchSystem = aValidationSystem.getMatchSystem();
            List<ECRL> list = aValidationSystem.getUserInitialCRLSet();
            eCRL = Find.deltaCRLFromList(matchSystem, list, aBaseCRL);
            if (eCRL != null && this.a(aValidationSystem, eCRL, aCertStatusInfo)) break block7;
            eCRL = null;
            for (DeltaCRLFinder deltaCRLFinder : this.k) {
                block9: {
                    block8: {
                        List<ECRL> list2 = deltaCRLFinder.findDeltaCRL(aBaseCRL);
                        eCRL = Find.deltaCRLFromList(matchSystem, list2, aBaseCRL);
                        if (eCRL == null) break block8;
                        if (!deltaCRLFinder.isToBeChecked()) break block9;
                        if (this.a(aValidationSystem, eCRL, aCertStatusInfo)) break block9;
                    }
                    eCRL = null;
                    continue;
                }
                return eCRL;
            }
        }
        return eCRL;
    }

    public ECRL findDeltaCRL(ValidationSystem aValidationSystem, ECertificate aCertificate, CertificateStatusInfo aCertStatusInfo) throws ESYAException {
        ECRL eCRL;
        block7: {
            eCRL = null;
            MatchSystem matchSystem = aValidationSystem.getMatchSystem();
            List<ECRL> list = aValidationSystem.getUserInitialCRLSet();
            eCRL = Find.deltaCRLFromList(matchSystem, list, aCertificate);
            if (eCRL != null && this.a(aValidationSystem, eCRL, aCertStatusInfo)) break block7;
            eCRL = null;
            for (DeltaCRLFinder deltaCRLFinder : this.k) {
                block9: {
                    block8: {
                        List<ECRL> list2 = deltaCRLFinder.findDeltaCRL(aCertificate);
                        eCRL = Find.deltaCRLFromList(matchSystem, list2, aCertificate);
                        if (eCRL == null) break block8;
                        if (!deltaCRLFinder.isToBeChecked()) break block9;
                        if (this.a(aValidationSystem, eCRL, aCertStatusInfo)) break block9;
                    }
                    eCRL = null;
                    continue;
                }
                return eCRL;
            }
        }
        return eCRL;
    }

    public ECertificate findCrossCertificate(ValidationSystem aValidationSystem, ECertificate aCertificate) throws ESYAException {
        ECertificate eCertificate;
        block9: {
            eCertificate = null;
            MatchSystem matchSystem = aValidationSystem.getMatchSystem();
            List<ECertificate> list = aValidationSystem.getValidCertificateSet();
            eCertificate = Find.crossCertificateFromList(matchSystem, list, aCertificate);
            if (eCertificate != null) {
                return eCertificate;
            }
            List<ECertificate> list2 = aValidationSystem.getUserInitialCertificateSet();
            eCertificate = Find.crossCertificateFromList(matchSystem, list2, aCertificate);
            if (eCertificate == null) {
                List<ECertificate> list3 = this.getTrustedCertificates();
                eCertificate = Find.crossCertificateFromList(matchSystem, list3, aCertificate);
            }
            if (eCertificate != null && this.a(aValidationSystem, eCertificate)) break block9;
            eCertificate = null;
            for (CrossCertificateFinder crossCertificateFinder : this.j) {
                block10: {
                    List<ECertificate> list4 = crossCertificateFinder.findCrossCertificate();
                    eCertificate = Find.crossCertificateFromList(matchSystem, list4, aCertificate);
                    if (eCertificate != null && this.a(aValidationSystem, eCertificate)) break block10;
                    eCertificate = null;
                    continue;
                }
                return eCertificate;
            }
        }
        return eCertificate;
    }

    boolean a(ValidationSystem validationSystem, StatusInfo statusInfo, ECertificate eCertificate) throws ESYAException {
        boolean bl;
        block5: {
            block4: {
                IssuerCheckParameters issuerCheckParameters = validationSystem.getCheckSystem().getConstraintCheckParam();
                issuerCheckParameters.increaseCertificateOrder();
                CertificateController certificateController = new CertificateController();
                CertificateStatusInfo certificateStatusInfo = certificateController.check(validationSystem, eCertificate);
                statusInfo.setSigningCertficateInfo(certificateStatusInfo);
                issuerCheckParameters.decreaseCertificateOrder();
                if (certificateStatusInfo.getCertificateStatus() != CertificateStatus.VALID && certificateStatusInfo.getCertificateStatus() != CertificateStatus.NOT_CHECKED) break block4;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    public boolean checkCRL(ValidationSystem aValidationSystem, CertificateStatusInfo aCertStatusInfo, ECRL aCRL) throws ESYAException {
        CRLStatusInfo cRLStatusInfo;
        block5: {
            block4: {
                CRLController cRLController = new CRLController();
                cRLStatusInfo = cRLController.check(aValidationSystem, aCRL);
                if (cRLStatusInfo.getCRLStatus() != CRLStatus.VALID) break block4;
                if (aCertStatusInfo.getTrustCertificate().equals((Object)cRLStatusInfo.getTrustCertificate())) break block5;
                return false;
            }
            return false;
        }
        aCertStatusInfo.addCRLInfo(cRLStatusInfo);
        return true;
    }

    boolean a(ValidationSystem validationSystem, ECRL eCRL, CertificateStatusInfo certificateStatusInfo) throws ESYAException {
        DeltaCRLController deltaCRLController = new DeltaCRLController();
        CRLStatusInfo cRLStatusInfo = deltaCRLController.check(validationSystem, eCRL);
        certificateStatusInfo.addDeltaCRLInfo(cRLStatusInfo);
        boolean bl = cRLStatusInfo.getCRLStatus() == CRLStatus.VALID;
        return bl;
    }

    boolean a(ValidationSystem validationSystem, ECertificate eCertificate) throws ESYAException {
        CertificateController certificateController = new CertificateController();
        CertificateStatusInfo certificateStatusInfo = certificateController.check(validationSystem, eCertificate);
        boolean bl = certificateStatusInfo.getCertificateStatus() == CertificateStatus.VALID;
        return bl;
    }

    public List<ECertificate> findIssuerCertificate(ValidationSystem aValidationSystem, ECertificate aCertificate, boolean aRemoteSearch) {
        MatchSystem matchSystem = aValidationSystem.getMatchSystem();
        String string = aCertificate.getSubject().stringValue();
        int n = StatusInfo.c;
        if (a.isDebugEnabled()) {
            a.debug(string + FindSystem.a(-3389, -31352));
        }
        List<ECertificate> list = new ArrayList<ECertificate>();
        List<ECertificate> list2 = aValidationSystem.getCertificateValidationCache().getCheckedCertificates();
        list = Find.issuerCertificatesFromList(matchSystem, list2, aCertificate, list);
        List<ECertificate> list3 = this.getTrustedCertificates();
        list = Find.issuerCertificatesFromList(matchSystem, list3, aCertificate, list);
        List<ECertificate> list4 = aValidationSystem.getUserInitialCertificateSet();
        list = Find.issuerCertificatesFromList(matchSystem, list4, aCertificate, list);
        for (CertificateFinder certificateFinder : this.f) {
            block8: {
                if (aRemoteSearch || !certificateFinder.isRemote()) break block8;
                if (n == 0) continue;
            }
            list2 = certificateFinder.findCertificate(aCertificate);
            list = Find.issuerCertificatesFromList(matchSystem, list2, aCertificate, list);
            if (n == 0) continue;
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[9];
                var3_1 = 0;
                var2_2 = "\u001d\u00e6\u009a\u00dc5L\u00ef\u00ad\u00da\u00e8\u0012\u00f8\u008d\u00bb\u0095P\u00ec4\u0004\u00aa\u00da\u00e6}\u0088\u00a4\u000b\u0002\u00cd_\u00ee\u00b6\u0014]g\u00e2\r\u00e9\u0017\u001dV\u00d2r\u00acWh\u008ee\u00ee2y\u00f9\u00f7wq\u007f\u00c8y\u00fc\u00db\u0099t#B\u00d5q\u00baH\u0080@4/\u00db\u00ac\u00be~\u001bQ\u00c4=J)W\u00dd\"xI\u011c\u00cft}\u00c5\u00e7O)\u00f2\u008b\u00ef\u0017\u00f1\u00ba\u0093G\u0094F\u0006\u00aa\u009f_\u008c\u00c1\u00d5\u00d0\u001c\u00b1?y\u00fa7c\u00e9\u008e%fY\u00f5+\u00d8\u00b2Rrm\u0013\u00e4\u00a7w8p\u00a0\u0019\u00c6\u00ad\u00c6M\u0010j\u0010\u000eJg\u0080\u00c3\u00a7B5\u001c\u009e\u0096\u00f6P\u001b\"\u0004\u008a\u00ca\u00f9\u00e5i\u00c3\u0080h\u0089\u0007&e:\u008b\u0086[V\u00c5p\u0095\u00a7\u00e7\u00fcM\b";
                var4_3 = "\u001d\u00e6\u009a\u00dc5L\u00ef\u00ad\u00da\u00e8\u0012\u00f8\u008d\u00bb\u0095P\u00ec4\u0004\u00aa\u00da\u00e6}\u0088\u00a4\u000b\u0002\u00cd_\u00ee\u00b6\u0014]g\u00e2\r\u00e9\u0017\u001dV\u00d2r\u00acWh\u008ee\u00ee2y\u00f9\u00f7wq\u007f\u00c8y\u00fc\u00db\u0099t#B\u00d5q\u00baH\u0080@4/\u00db\u00ac\u00be~\u001bQ\u00c4=J)W\u00dd\"xI\u011c\u00cft}\u00c5\u00e7O)\u00f2\u008b\u00ef\u0017\u00f1\u00ba\u0093G\u0094F\u0006\u00aa\u009f_\u008c\u00c1\u00d5\u00d0\u001c\u00b1?y\u00fa7c\u00e9\u008e%fY\u00f5+\u00d8\u00b2Rrm\u0013\u00e4\u00a7w8p\u00a0\u0019\u00c6\u00ad\u00c6M\u0010j\u0010\u000eJg\u0080\u00c3\u00a7B5\u001c\u009e\u0096\u00f6P\u001b\"\u0004\u008a\u00ca\u00f9\u00e5i\u00c3\u0080h\u0089\u0007&e:\u008b\u0086[V\u00c5p\u0095\u00a7\u00e7\u00fcM\b".length();
                var1_4 = 25;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "H\u0000\u00ee<H\u00a7\u0089\u00b7\u00b3kTV(\u00ef\u009dQ\u00e9=q\u0013!\u0013\u00cc#\u00d0\u0080\u00c4:\u00fd\u00f7\u00a6Bn\u001b\u008f\u00dbe\u00bb\u00ee";
                    var4_3 = "H\u0000\u00ee<H\u00a7\u0089\u00b7\u00b3kTV(\u00ef\u009dQ\u00e9=q\u0013!\u0013\u00cc#\u00d0\u0080\u00c4:\u00fd\u00f7\u00a6Bn\u001b\u008f\u00dbe\u00bb\u00ee".length();
                    var1_4 = 19;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 96;
                            break;
                        }
                        case 1: {
                            v13 = 9;
                            break;
                        }
                        case 2: {
                            v13 = 116;
                            break;
                        }
                        case 3: {
                            v13 = 78;
                            break;
                        }
                        case 4: {
                            v13 = 85;
                            break;
                        }
                        case 5: {
                            v13 = 75;
                            break;
                        }
                        default: {
                            v13 = 127;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        FindSystem.l = var5;
        FindSystem.m = new String[9];
        FindSystem.a = LoggerFactory.getLogger(FindSystem.class);
        FindSystem.b = new ArrayList<ECertificate>(0);
        FindSystem.c = new ArrayList<ECRL>(0);
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0xFFFFF2C6) & 0xFFFF;
        if (m[n3] == null) {
            int n4;
            int n5;
            char[] cArray = l[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 127;
                    break;
                }
                case 1: {
                    n5 = 252;
                    break;
                }
                case 2: {
                    n5 = 56;
                    break;
                }
                case 3: {
                    n5 = 217;
                    break;
                }
                case 4: {
                    n5 = 255;
                    break;
                }
                case 5: {
                    n5 = 224;
                    break;
                }
                case 6: {
                    n5 = 98;
                    break;
                }
                case 7: {
                    n5 = 134;
                    break;
                }
                case 8: {
                    n5 = 234;
                    break;
                }
                case 9: {
                    n5 = 231;
                    break;
                }
                case 10: {
                    n5 = 211;
                    break;
                }
                case 11: {
                    n5 = 169;
                    break;
                }
                case 12: {
                    n5 = 48;
                    break;
                }
                case 13: {
                    n5 = 192;
                    break;
                }
                case 14: {
                    n5 = 130;
                    break;
                }
                case 15: {
                    n5 = 119;
                    break;
                }
                case 16: {
                    n5 = 221;
                    break;
                }
                case 17: {
                    n5 = 147;
                    break;
                }
                case 18: {
                    n5 = 216;
                    break;
                }
                case 19: {
                    n5 = 232;
                    break;
                }
                case 20: {
                    n5 = 73;
                    break;
                }
                case 21: {
                    n5 = 170;
                    break;
                }
                case 22: {
                    n5 = 222;
                    break;
                }
                case 23: {
                    n5 = 15;
                    break;
                }
                case 24: {
                    n5 = 105;
                    break;
                }
                case 25: {
                    n5 = 223;
                    break;
                }
                case 26: {
                    n5 = 114;
                    break;
                }
                case 27: {
                    n5 = 191;
                    break;
                }
                case 28: {
                    n5 = 204;
                    break;
                }
                case 29: {
                    n5 = 39;
                    break;
                }
                case 30: {
                    n5 = 189;
                    break;
                }
                case 31: {
                    n5 = 143;
                    break;
                }
                case 32: {
                    n5 = 89;
                    break;
                }
                case 33: {
                    n5 = 121;
                    break;
                }
                case 34: {
                    n5 = 85;
                    break;
                }
                case 35: {
                    n5 = 140;
                    break;
                }
                case 36: {
                    n5 = 27;
                    break;
                }
                case 37: {
                    n5 = 88;
                    break;
                }
                case 38: {
                    n5 = 125;
                    break;
                }
                case 39: {
                    n5 = 69;
                    break;
                }
                case 40: {
                    n5 = 163;
                    break;
                }
                case 41: {
                    n5 = 7;
                    break;
                }
                case 42: {
                    n5 = 194;
                    break;
                }
                case 43: {
                    n5 = 197;
                    break;
                }
                case 44: {
                    n5 = 150;
                    break;
                }
                case 45: {
                    n5 = 33;
                    break;
                }
                case 46: {
                    n5 = 146;
                    break;
                }
                case 47: {
                    n5 = 63;
                    break;
                }
                case 48: {
                    n5 = 228;
                    break;
                }
                case 49: {
                    n5 = 100;
                    break;
                }
                case 50: {
                    n5 = 174;
                    break;
                }
                case 51: {
                    n5 = 241;
                    break;
                }
                case 52: {
                    n5 = 70;
                    break;
                }
                case 53: {
                    n5 = 80;
                    break;
                }
                case 54: {
                    n5 = 0;
                    break;
                }
                case 55: {
                    n5 = 181;
                    break;
                }
                case 56: {
                    n5 = 31;
                    break;
                }
                case 57: {
                    n5 = 11;
                    break;
                }
                case 58: {
                    n5 = 202;
                    break;
                }
                case 59: {
                    n5 = 205;
                    break;
                }
                case 60: {
                    n5 = 41;
                    break;
                }
                case 61: {
                    n5 = 111;
                    break;
                }
                case 62: {
                    n5 = 45;
                    break;
                }
                case 63: {
                    n5 = 52;
                    break;
                }
                case 64: {
                    n5 = 36;
                    break;
                }
                case 65: {
                    n5 = 10;
                    break;
                }
                case 66: {
                    n5 = 87;
                    break;
                }
                case 67: {
                    n5 = 96;
                    break;
                }
                case 68: {
                    n5 = 99;
                    break;
                }
                case 69: {
                    n5 = 161;
                    break;
                }
                case 70: {
                    n5 = 18;
                    break;
                }
                case 71: {
                    n5 = 23;
                    break;
                }
                case 72: {
                    n5 = 50;
                    break;
                }
                case 73: {
                    n5 = 206;
                    break;
                }
                case 74: {
                    n5 = 236;
                    break;
                }
                case 75: {
                    n5 = 107;
                    break;
                }
                case 76: {
                    n5 = 207;
                    break;
                }
                case 77: {
                    n5 = 66;
                    break;
                }
                case 78: {
                    n5 = 142;
                    break;
                }
                case 79: {
                    n5 = 21;
                    break;
                }
                case 80: {
                    n5 = 78;
                    break;
                }
                case 81: {
                    n5 = 53;
                    break;
                }
                case 82: {
                    n5 = 209;
                    break;
                }
                case 83: {
                    n5 = 243;
                    break;
                }
                case 84: {
                    n5 = 131;
                    break;
                }
                case 85: {
                    n5 = 184;
                    break;
                }
                case 86: {
                    n5 = 240;
                    break;
                }
                case 87: {
                    n5 = 151;
                    break;
                }
                case 88: {
                    n5 = 126;
                    break;
                }
                case 89: {
                    n5 = 101;
                    break;
                }
                case 90: {
                    n5 = 138;
                    break;
                }
                case 91: {
                    n5 = 239;
                    break;
                }
                case 92: {
                    n5 = 22;
                    break;
                }
                case 93: {
                    n5 = 162;
                    break;
                }
                case 94: {
                    n5 = 182;
                    break;
                }
                case 95: {
                    n5 = 159;
                    break;
                }
                case 96: {
                    n5 = 62;
                    break;
                }
                case 97: {
                    n5 = 249;
                    break;
                }
                case 98: {
                    n5 = 25;
                    break;
                }
                case 99: {
                    n5 = 124;
                    break;
                }
                case 100: {
                    n5 = 92;
                    break;
                }
                case 101: {
                    n5 = 253;
                    break;
                }
                case 102: {
                    n5 = 112;
                    break;
                }
                case 103: {
                    n5 = 215;
                    break;
                }
                case 104: {
                    n5 = 220;
                    break;
                }
                case 105: {
                    n5 = 86;
                    break;
                }
                case 106: {
                    n5 = 35;
                    break;
                }
                case 107: {
                    n5 = 57;
                    break;
                }
                case 108: {
                    n5 = 165;
                    break;
                }
                case 109: {
                    n5 = 201;
                    break;
                }
                case 110: {
                    n5 = 40;
                    break;
                }
                case 111: {
                    n5 = 108;
                    break;
                }
                case 112: {
                    n5 = 145;
                    break;
                }
                case 113: {
                    n5 = 229;
                    break;
                }
                case 114: {
                    n5 = 60;
                    break;
                }
                case 115: {
                    n5 = 12;
                    break;
                }
                case 116: {
                    n5 = 2;
                    break;
                }
                case 117: {
                    n5 = 58;
                    break;
                }
                case 118: {
                    n5 = 233;
                    break;
                }
                case 119: {
                    n5 = 251;
                    break;
                }
                case 120: {
                    n5 = 179;
                    break;
                }
                case 121: {
                    n5 = 81;
                    break;
                }
                case 122: {
                    n5 = 132;
                    break;
                }
                case 123: {
                    n5 = 8;
                    break;
                }
                case 124: {
                    n5 = 167;
                    break;
                }
                case 125: {
                    n5 = 242;
                    break;
                }
                case 126: {
                    n5 = 154;
                    break;
                }
                case 127: {
                    n5 = 187;
                    break;
                }
                case 128: {
                    n5 = 210;
                    break;
                }
                case 129: {
                    n5 = 115;
                    break;
                }
                case 130: {
                    n5 = 3;
                    break;
                }
                case 131: {
                    n5 = 219;
                    break;
                }
                case 132: {
                    n5 = 129;
                    break;
                }
                case 133: {
                    n5 = 188;
                    break;
                }
                case 134: {
                    n5 = 42;
                    break;
                }
                case 135: {
                    n5 = 160;
                    break;
                }
                case 136: {
                    n5 = 139;
                    break;
                }
                case 137: {
                    n5 = 200;
                    break;
                }
                case 138: {
                    n5 = 46;
                    break;
                }
                case 139: {
                    n5 = 199;
                    break;
                }
                case 140: {
                    n5 = 5;
                    break;
                }
                case 141: {
                    n5 = 168;
                    break;
                }
                case 142: {
                    n5 = 237;
                    break;
                }
                case 143: {
                    n5 = 235;
                    break;
                }
                case 144: {
                    n5 = 226;
                    break;
                }
                case 145: {
                    n5 = 230;
                    break;
                }
                case 146: {
                    n5 = 176;
                    break;
                }
                case 147: {
                    n5 = 104;
                    break;
                }
                case 148: {
                    n5 = 227;
                    break;
                }
                case 149: {
                    n5 = 254;
                    break;
                }
                case 150: {
                    n5 = 123;
                    break;
                }
                case 151: {
                    n5 = 43;
                    break;
                }
                case 152: {
                    n5 = 137;
                    break;
                }
                case 153: {
                    n5 = 55;
                    break;
                }
                case 154: {
                    n5 = 72;
                    break;
                }
                case 155: {
                    n5 = 149;
                    break;
                }
                case 156: {
                    n5 = 178;
                    break;
                }
                case 157: {
                    n5 = 172;
                    break;
                }
                case 158: {
                    n5 = 9;
                    break;
                }
                case 159: {
                    n5 = 51;
                    break;
                }
                case 160: {
                    n5 = 116;
                    break;
                }
                case 161: {
                    n5 = 166;
                    break;
                }
                case 162: {
                    n5 = 67;
                    break;
                }
                case 163: {
                    n5 = 144;
                    break;
                }
                case 164: {
                    n5 = 37;
                    break;
                }
                case 165: {
                    n5 = 97;
                    break;
                }
                case 166: {
                    n5 = 90;
                    break;
                }
                case 167: {
                    n5 = 38;
                    break;
                }
                case 168: {
                    n5 = 214;
                    break;
                }
                case 169: {
                    n5 = 133;
                    break;
                }
                case 170: {
                    n5 = 1;
                    break;
                }
                case 171: {
                    n5 = 94;
                    break;
                }
                case 172: {
                    n5 = 95;
                    break;
                }
                case 173: {
                    n5 = 4;
                    break;
                }
                case 174: {
                    n5 = 79;
                    break;
                }
                case 175: {
                    n5 = 17;
                    break;
                }
                case 176: {
                    n5 = 64;
                    break;
                }
                case 177: {
                    n5 = 74;
                    break;
                }
                case 178: {
                    n5 = 122;
                    break;
                }
                case 179: {
                    n5 = 76;
                    break;
                }
                case 180: {
                    n5 = 32;
                    break;
                }
                case 181: {
                    n5 = 6;
                    break;
                }
                case 182: {
                    n5 = 190;
                    break;
                }
                case 183: {
                    n5 = 195;
                    break;
                }
                case 184: {
                    n5 = 193;
                    break;
                }
                case 185: {
                    n5 = 158;
                    break;
                }
                case 186: {
                    n5 = 93;
                    break;
                }
                case 187: {
                    n5 = 153;
                    break;
                }
                case 188: {
                    n5 = 61;
                    break;
                }
                case 189: {
                    n5 = 44;
                    break;
                }
                case 190: {
                    n5 = 213;
                    break;
                }
                case 191: {
                    n5 = 196;
                    break;
                }
                case 192: {
                    n5 = 83;
                    break;
                }
                case 193: {
                    n5 = 185;
                    break;
                }
                case 194: {
                    n5 = 82;
                    break;
                }
                case 195: {
                    n5 = 136;
                    break;
                }
                case 196: {
                    n5 = 26;
                    break;
                }
                case 197: {
                    n5 = 183;
                    break;
                }
                case 198: {
                    n5 = 157;
                    break;
                }
                case 199: {
                    n5 = 49;
                    break;
                }
                case 200: {
                    n5 = 24;
                    break;
                }
                case 201: {
                    n5 = 250;
                    break;
                }
                case 202: {
                    n5 = 177;
                    break;
                }
                case 203: {
                    n5 = 244;
                    break;
                }
                case 204: {
                    n5 = 245;
                    break;
                }
                case 205: {
                    n5 = 16;
                    break;
                }
                case 206: {
                    n5 = 103;
                    break;
                }
                case 207: {
                    n5 = 14;
                    break;
                }
                case 208: {
                    n5 = 186;
                    break;
                }
                case 209: {
                    n5 = 30;
                    break;
                }
                case 210: {
                    n5 = 225;
                    break;
                }
                case 211: {
                    n5 = 109;
                    break;
                }
                case 212: {
                    n5 = 34;
                    break;
                }
                case 213: {
                    n5 = 212;
                    break;
                }
                case 214: {
                    n5 = 75;
                    break;
                }
                case 215: {
                    n5 = 203;
                    break;
                }
                case 216: {
                    n5 = 19;
                    break;
                }
                case 217: {
                    n5 = 164;
                    break;
                }
                case 218: {
                    n5 = 246;
                    break;
                }
                case 219: {
                    n5 = 68;
                    break;
                }
                case 220: {
                    n5 = 156;
                    break;
                }
                case 221: {
                    n5 = 248;
                    break;
                }
                case 222: {
                    n5 = 28;
                    break;
                }
                case 223: {
                    n5 = 155;
                    break;
                }
                case 224: {
                    n5 = 141;
                    break;
                }
                case 225: {
                    n5 = 208;
                    break;
                }
                case 226: {
                    n5 = 102;
                    break;
                }
                case 227: {
                    n5 = 106;
                    break;
                }
                case 228: {
                    n5 = 59;
                    break;
                }
                case 229: {
                    n5 = 148;
                    break;
                }
                case 230: {
                    n5 = 20;
                    break;
                }
                case 231: {
                    n5 = 198;
                    break;
                }
                case 232: {
                    n5 = 175;
                    break;
                }
                case 233: {
                    n5 = 218;
                    break;
                }
                case 234: {
                    n5 = 180;
                    break;
                }
                case 235: {
                    n5 = 84;
                    break;
                }
                case 236: {
                    n5 = 65;
                    break;
                }
                case 237: {
                    n5 = 54;
                    break;
                }
                case 238: {
                    n5 = 29;
                    break;
                }
                case 239: {
                    n5 = 77;
                    break;
                }
                case 240: {
                    n5 = 110;
                    break;
                }
                case 241: {
                    n5 = 152;
                    break;
                }
                case 242: {
                    n5 = 238;
                    break;
                }
                case 243: {
                    n5 = 71;
                    break;
                }
                case 244: {
                    n5 = 120;
                    break;
                }
                case 245: {
                    n5 = 13;
                    break;
                }
                case 246: {
                    n5 = 91;
                    break;
                }
                case 247: {
                    n5 = 47;
                    break;
                }
                case 248: {
                    n5 = 247;
                    break;
                }
                case 249: {
                    n5 = 117;
                    break;
                }
                case 250: {
                    n5 = 118;
                    break;
                }
                case 251: {
                    n5 = 173;
                    break;
                }
                case 252: {
                    n5 = 171;
                    break;
                }
                case 253: {
                    n5 = 135;
                    break;
                }
                case 254: {
                    n5 = 113;
                    break;
                }
                default: {
                    n5 = 128;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            FindSystem.m[n3] = new String(cArray).intern();
        }
        return m[n3];
    }
}

