/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1InvalidLengthException;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.IntHolder;
import java.io.IOException;
import java.util.Vector;

public class Asn1BerDecodeContext {
    protected Asn1BerDecodeBuffer mDecodeBuffer;
    protected int mDecBufByteCount;
    protected int mElemLength;
    protected boolean mExplicitTagging;
    protected Asn1Tag mTagHolder;
    protected Vector mTagHistory;

    public Asn1BerDecodeContext(Asn1BerDecodeBuffer asn1BerDecodeBuffer, int n2) {
        this.mDecodeBuffer = asn1BerDecodeBuffer;
        this.mDecBufByteCount = asn1BerDecodeBuffer.getByteCount();
        this.mElemLength = n2;
        this.mTagHolder = new Asn1Tag();
        this.mTagHistory = new Vector();
    }

    public final boolean expired() throws Asn1Exception, IOException {
        boolean bl;
        block5: {
            int n2;
            block4: {
                if (this.mElemLength != -9999) break block4;
                IntHolder intHolder = new IntHolder();
                bl = this.mDecodeBuffer.matchTag((short)0, (short)0, 0, null, intHolder);
                if (bl) {
                    this.mDecodeBuffer.reset();
                }
                if (!Asn1Exception.z) break block5;
            }
            bl = (n2 = this.mDecodeBuffer.getByteCount() - this.mDecBufByteCount) >= this.mElemLength;
        }
        return bl;
    }

    public final boolean matchElemTag(short s2, short s3, int n2, IntHolder intHolder, boolean bl) throws Asn1Exception, IOException {
        if (!this.expired()) {
            boolean bl2 = this.mDecodeBuffer.matchTag(s2, s3, n2, this.mTagHolder, intHolder);
            if (this.mElemLength != -9999 && intHolder.value != -9999) {
                int n3 = this.mDecodeBuffer.getByteCount() - this.mDecBufByteCount;
                if (intHolder.value < 0 || intHolder.value > this.mElemLength - n3) {
                    throw new Asn1InvalidLengthException();
                }
            }
            if (bl2 && !bl) {
                this.mDecodeBuffer.reset();
            }
            return bl2;
        }
        return false;
    }

    public final boolean matchElemTag(Asn1Tag asn1Tag, IntHolder intHolder, boolean bl) throws Asn1Exception, IOException {
        return this.matchElemTag(asn1Tag.mClass, asn1Tag.mForm, asn1Tag.mIDCode, intHolder, bl);
    }

    public final void addTag(Asn1Tag asn1Tag) {
        this.mTagHistory.addElement(new Asn1Tag(asn1Tag));
    }

    public final boolean hasDecoded(Asn1Tag asn1Tag) {
        return this.mTagHistory.contains(asn1Tag);
    }
}

