/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerDecodeContext;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1CharSet;
import com.objsys.asn1j.runtime.Asn1ConsVioException;
import com.objsys.asn1j.runtime.Asn1EndOfBufferException;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1InvalidLengthException;
import com.objsys.asn1j.runtime.Asn1JsonDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1JsonOutputStream;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerMessageBuffer;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import com.objsys.asn1j.runtime.Asn1XmlEncoder;
import com.objsys.asn1j.runtime.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class Asn1CharString
extends Asn1Type {
    public transient String value;
    protected transient StringBuffer mStringBuffer;
    private transient short d;
    private static final long serialVersionUID = -3999513667217895517L;
    private static h e = h.a();

    protected Asn1CharString(short s2) {
        this.value = new String();
        this.d = s2;
    }

    protected Asn1CharString(String string, short s2) {
        if (string == null) {
            throw new NullPointerException("Data parameter is null!");
        }
        this.value = string;
        this.d = s2;
    }

    protected void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n2, Asn1Tag asn1Tag) throws Asn1Exception, IOException {
        int n3 = bl ? Asn1CharString.matchTag(asn1BerDecodeBuffer, asn1Tag) : n2;
        Asn1Tag asn1Tag2 = asn1BerDecodeBuffer.getLastTag();
        if (asn1Tag2 != null && asn1Tag2.isConstructed()) {
            if (this.mStringBuffer == null) {
                this.mStringBuffer = new StringBuffer();
            }
            int n4 = 0;
            Asn1BerDecodeContext asn1BerDecodeContext = new Asn1BerDecodeContext(asn1BerDecodeBuffer, n3);
            while (!asn1BerDecodeContext.expired()) {
                int n5 = Asn1CharString.matchTag(asn1BerDecodeBuffer, Asn1OctetString.TAG);
                if (n5 >= 0) {
                    this.mStringBuffer.ensureCapacity(n4 += n5);
                    while (n5 > 0) {
                        int n6 = asn1BerDecodeBuffer.read();
                        if (n6 == -1) {
                            throw new Asn1EndOfBufferException(asn1BerDecodeBuffer);
                        }
                        this.mStringBuffer.append((char)n6);
                        --n5;
                    }
                    continue;
                }
                throw new Asn1Exception(asn1BerDecodeBuffer, "Invalid format of constructed value");
            }
            if (n3 == -9999) {
                Asn1CharString.matchTag(asn1BerDecodeBuffer, Asn1Tag.EOC);
            }
            this.value = this.mStringBuffer.toString();
        } else {
            if (n3 < 0) {
                throw new Asn1InvalidLengthException();
            }
            byte[] byArray = new byte[n3];
            asn1BerDecodeBuffer.read(byArray, 0, n3);
            char[] cArray = new char[n3];
            int n7 = 0;
            while (n7 < n3) {
                cArray[n7] = (char)byArray[n7];
                int n8 = n7++;
                cArray[n8] = (char)(cArray[n8] & 0xFF);
            }
            this.value = new String(cArray);
        }
        asn1BerDecodeBuffer.setTypeCode((short)asn1Tag.mIDCode);
    }

    protected int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl, Asn1Tag asn1Tag) throws Asn1Exception {
        int n2 = this.value.length();
        asn1BerEncodeBuffer.copy(this.value);
        if (bl) {
            n2 += asn1BerEncodeBuffer.encodeTagAndLength(asn1Tag, n2);
        }
        return n2;
    }

    protected void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, int n2, int n3, Asn1CharSet asn1CharSet) throws Asn1Exception, IOException {
        int n4;
        int n5 = 0;
        if (this.mStringBuffer == null) {
            this.mStringBuffer = new StringBuffer();
        } else {
            this.mStringBuffer.setLength(0);
        }
        do {
            if ((n4 = (int)asn1PerDecodeBuffer.decodeLength()) <= 0) continue;
            asn1PerDecodeBuffer.byteAlign();
            this.mStringBuffer.ensureCapacity(n5 += n4);
            asn1PerDecodeBuffer.decodeCharString(n4, n2, n3, asn1CharSet, this.mStringBuffer);
        } while (n4 >= 16384);
        this.value = this.mStringBuffer.toString();
        asn1PerDecodeBuffer.setTypeCode(this.d);
    }

    protected void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, int n2, int n3, Asn1CharSet asn1CharSet, long l2, long l3) throws Asn1Exception, IOException {
        if (l3 < 65536L) {
            int n4 = (int)asn1PerDecodeBuffer.decodeLength(l2, l3);
            if (this.mStringBuffer == null) {
                this.mStringBuffer = new StringBuffer();
            } else {
                this.mStringBuffer.setLength(0);
            }
            if (n4 > 0) {
                int n5 = asn1CharSet == null ? (asn1PerDecodeBuffer.isAligned() ? n2 : n3) : asn1CharSet.getNumBitsPerChar(asn1PerDecodeBuffer.isAligned());
                Asn1CharString.a(asn1PerDecodeBuffer, n5, l2, l3);
                this.mStringBuffer.ensureCapacity(n4);
                asn1PerDecodeBuffer.decodeCharString(n4, n2, n3, asn1CharSet, this.mStringBuffer);
            }
            this.value = this.mStringBuffer.toString();
            asn1PerDecodeBuffer.setTypeCode(this.d);
        } else {
            this.decode(asn1PerDecodeBuffer, n2, n3, asn1CharSet);
        }
    }

    protected void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, int n2, int n3, Asn1CharSet asn1CharSet) throws Asn1Exception, IOException {
        int n4 = this.value.length();
        int n5 = 0;
        while (true) {
            int n6;
            if ((n6 = (int)asn1PerEncodeBuffer.encodeLength(n4)) > 0) {
                asn1PerEncodeBuffer.byteAlign();
                asn1PerEncodeBuffer.encodeCharString(this.value, n6, n5, n2, n3, asn1CharSet);
            }
            if ((n4 -= n6) <= 0) break;
            n5 += n6;
        }
        asn1PerEncodeBuffer.encodeLengthEOM(n4);
    }

    protected void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, int n2, int n3, Asn1CharSet asn1CharSet, long l2, long l3) throws Asn1Exception, IOException {
        int n4 = this.value.length();
        if ((long)n4 >= l2 && (long)n4 <= l3) {
            if (l3 < 65536L) {
                asn1PerEncodeBuffer.encodeLength(n4, l2, l3);
                if (n4 > 0) {
                    int n5 = asn1CharSet == null ? (asn1PerEncodeBuffer.isAligned() ? n2 : n3) : asn1CharSet.getNumBitsPerChar(asn1PerEncodeBuffer.isAligned());
                    Asn1CharString.a(asn1PerEncodeBuffer, n5, l2, l3);
                    asn1PerEncodeBuffer.encodeCharString(this.value, n4, 0, n2, n3, asn1CharSet);
                }
            } else {
                this.encode(asn1PerEncodeBuffer, n2, n3, asn1CharSet);
            }
        } else {
            throw new Asn1ConsVioException("Asn1CharString.length", n4);
        }
    }

    public void encode(Asn1XerEncoder asn1XerEncoder, String string) throws IOException, Asn1Exception {
        asn1XerEncoder.encodeStartElement(string);
        asn1XerEncoder.encodeData(this.value);
        asn1XerEncoder.encodeEndElement(string);
    }

    public void decodeXER(String string, String string2) throws Asn1Exception {
        this.value = string;
    }

    public void encode(Asn1XmlEncoder asn1XmlEncoder, String string, String string2) throws IOException, Asn1Exception {
        asn1XmlEncoder.encodeStartElement(string, string2, true);
        asn1XmlEncoder.encodeData(this.value);
        asn1XmlEncoder.encodeEndElement(string, string2);
    }

    public void decodeXML(String string, String string2) throws Asn1Exception {
        this.decodeXER(string, string2);
    }

    public void decode(Asn1JsonDecodeBuffer asn1JsonDecodeBuffer) throws IOException {
        this.value = asn1JsonDecodeBuffer.readString();
    }

    public void encode(Asn1JsonOutputStream asn1JsonOutputStream) throws IOException {
        asn1JsonOutputStream.encodeString(this.value);
    }

    public boolean equals(String string) {
        return this.value != null && string != null && this.value.equals(string);
    }

    public int hashCode() {
        return 0 == this.value.hashCode() ? 1 : this.value.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass().equals(object.getClass())) {
            return this.equals(((Asn1CharString)object).value);
        }
        return false;
    }

    public int getLength() throws Asn1InvalidLengthException {
        return this.value.length();
    }

    public boolean validate(Asn1CharSet asn1CharSet) {
        return asn1CharSet.validate(this.value);
    }

    public String toString() {
        return this.value;
    }

    private static void a(Asn1PerMessageBuffer asn1PerMessageBuffer, int n2, long l2, long l3) {
        block5: {
            boolean bl;
            block7: {
                long l4;
                block6: {
                    if (!asn1PerMessageBuffer.isAligned()) break block5;
                    l4 = l3 * (long)n2;
                    bl = true;
                    if (l3 != l2) break block6;
                    if (l4 > 16L) break block7;
                    bl = false;
                    if (!Asn1Exception.z) break block7;
                }
                if (l4 < 16L) {
                    bl = false;
                }
            }
            if (bl) {
                asn1PerMessageBuffer.byteAlign();
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(1);
        objectOutputStream.writeUTF(this.value);
        objectOutputStream.writeShort(this.d);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readShort();
        this.value = objectInputStream.readUTF();
        this.d = objectInputStream.readShort();
    }
}

