/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerDecodeContext;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1ConsVioException;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1InvalidLengthException;
import com.objsys.asn1j.runtime.Asn1JsonDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1JsonOutputStream;
import com.objsys.asn1j.runtime.Asn1MderDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1MderOutputStream;
import com.objsys.asn1j.runtime.Asn1MderUnsupported;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerOutputStream;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1Util;
import com.objsys.asn1j.runtime.Asn1Value;
import com.objsys.asn1j.runtime.Asn1ValueParseException;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import com.objsys.asn1j.runtime.Asn1XmlEncoder;
import com.objsys.asn1j.runtime.Base64;
import com.objsys.asn1j.runtime.h;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Asn1OctetString
extends Asn1Type
implements Comparable {
    public static final Asn1Tag TAG = new Asn1Tag(0, 0, 4);
    public transient byte[] value;
    private static final long serialVersionUID = -1633161801793532563L;
    private static h d = h.a();

    public Asn1OctetString() {
        this.value = new byte[0];
    }

    public Asn1OctetString(byte[] byArray) {
        this.value = byArray;
    }

    public Asn1OctetString(byte[] byArray, int n2, int n3) {
        this.value = new byte[n3];
        if (byArray != null) {
            System.arraycopy(byArray, n2, this.value, 0, n3);
        }
    }

    public Asn1OctetString(String string) throws Asn1ValueParseException {
        block3: {
            block2: {
                if (string != null && string.length() != 0) break block2;
                this.value = new byte[0];
                if (!Asn1Exception.z) break block3;
            }
            this.value = Asn1Value.parseString(string);
        }
    }

    public int compareTo(Object object) {
        boolean bl = Asn1Exception.z;
        byte[] byArray = ((Asn1OctetString)object).value;
        int n2 = this.value.length < byArray.length ? this.value.length : byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.value[i2] & 0xFF;
            int n4 = byArray[i2] & 0xFF;
            if (n3 < n4) {
                return -1;
            }
            if (n3 <= n4) continue;
            return 1;
        }
        if (this.value.length == byArray.length) {
            return 0;
        }
        if (this.value.length < byArray.length) {
            return -1;
        }
        return 1;
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n2) throws Asn1Exception, IOException {
        int n3 = bl ? Asn1OctetString.matchTag(asn1BerDecodeBuffer, TAG) : n2;
        Asn1Tag asn1Tag = asn1BerDecodeBuffer.getLastTag();
        if (asn1Tag != null && asn1Tag.isConstructed()) {
            int n4 = 0;
            int n5 = 0;
            Asn1BerDecodeContext asn1BerDecodeContext = new Asn1BerDecodeContext(asn1BerDecodeBuffer, n3);
            while (!asn1BerDecodeContext.expired()) {
                int n6 = Asn1OctetString.matchTag(asn1BerDecodeBuffer, TAG);
                if (n6 > 0) {
                    n4 += n6;
                    if (n5 == 0) {
                        this.value = new byte[n4];
                    } else {
                        this.b(n4);
                    }
                    asn1BerDecodeBuffer.read(this.value, n5, n6);
                    n5 = n4;
                    continue;
                }
                throw new Asn1Exception(asn1BerDecodeBuffer, "Invalid format of constructed value");
            }
            if (n3 == -9999) {
                Asn1OctetString.matchTag(asn1BerDecodeBuffer, Asn1Tag.EOC);
            }
        } else if (n3 >= 0) {
            this.value = new byte[n3];
            if (n3 != 0) {
                asn1BerDecodeBuffer.read(this.value);
            }
        } else {
            throw new Asn1InvalidLengthException();
        }
        d.lcheck(1);
        asn1BerDecodeBuffer.setTypeCode((short)4);
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        int n2;
        if (this.value == null) {
            this.value = new byte[0];
        }
        if ((n2 = this.value.length) != 0) {
            asn1BerEncodeBuffer.copy(this.value);
        }
        if (bl) {
            n2 += asn1BerEncodeBuffer.encodeTagAndLength(TAG, n2);
        }
        d.lcheck(1);
        return n2;
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws Asn1Exception, IOException {
        int n2;
        int n3 = 0;
        int n4 = 0;
        do {
            if ((n2 = (int)asn1PerDecodeBuffer.decodeLength()) <= 0) continue;
            n3 += n2;
            asn1PerDecodeBuffer.byteAlign();
            if (n4 == 0) {
                this.a(n3);
            } else {
                this.b(n3);
            }
            asn1PerDecodeBuffer.decodeBitsToOctetArray(this.value, n4, n2 * 8);
            if (n2 < 16384) continue;
            n4 = n3;
        } while (n2 >= 16384);
        if (n3 == 0) {
            this.value = new byte[0];
        }
        asn1PerDecodeBuffer.setTypeCode((short)4);
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, long l2, long l3) throws Asn1Exception, IOException {
        if (l3 < 65536L) {
            int n2 = (int)asn1PerDecodeBuffer.decodeLength(l2, l3);
            if (n2 > 0) {
                if (l2 != l3 || l3 > 2L) {
                    asn1PerDecodeBuffer.byteAlign();
                }
                this.a(n2);
                asn1PerDecodeBuffer.decodeBitsToOctetArray(this.value, 0, n2 * 8);
            } else {
                this.value = new byte[0];
            }
        } else {
            this.decode(asn1PerDecodeBuffer);
        }
        asn1PerDecodeBuffer.setTypeCode((short)4);
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer) throws Asn1Exception, IOException {
        if (this.value == null) {
            this.value = new byte[0];
        }
        asn1PerEncodeBuffer.encodeOctetString(this.value, 0, this.value.length);
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, long l2, long l3) throws Asn1Exception, IOException {
        if (this.value == null) {
            this.value = new byte[0];
        }
        if ((long)this.value.length >= l2 && (long)this.value.length <= l3) {
            if (l3 < 65536L) {
                asn1PerEncodeBuffer.encodeLength(this.value.length, l2, l3);
                if (this.value.length > 0) {
                    if (l2 != l3 || l3 > 2L) {
                        asn1PerEncodeBuffer.byteAlign();
                    }
                    asn1PerEncodeBuffer.encodeBits(this.value, 0, this.value.length * 8);
                }
            } else {
                asn1PerEncodeBuffer.encodeOctetString(this.value, 0, this.value.length);
            }
        } else {
            throw new Asn1ConsVioException("Asn1OctetString.length", this.value.length);
        }
    }

    public void decode(Asn1MderDecodeBuffer asn1MderDecodeBuffer) throws Asn1Exception, IOException {
        this.decode(asn1MderDecodeBuffer, -1);
    }

    public void decode(Asn1MderDecodeBuffer asn1MderDecodeBuffer, int n2) throws Asn1Exception, IOException {
        d.lcheck(1);
        int n3 = n2 < 0 ? asn1MderDecodeBuffer.read2Bytes() : n2;
        this.a(n3);
        asn1MderDecodeBuffer.read(this.value, 0, n3);
    }

    public int getMderLength() {
        return 2 + this.value.length;
    }

    public void encode(Asn1XerEncoder asn1XerEncoder, String string) throws IOException, Asn1Exception {
        if (string == null) {
            string = "OCTET_STRING";
        }
        if (this.value.length == 0) {
            asn1XerEncoder.indent();
            asn1XerEncoder.encodeEmptyElement(string);
        } else {
            asn1XerEncoder.encodeStartElement(string);
            asn1XerEncoder.encodeHexStrValue(this.value);
            asn1XerEncoder.encodeEndElement(string);
        }
    }

    public void decodeXER(String string, String string2, boolean bl) throws Asn1Exception {
        block3: {
            block2: {
                string = string.trim();
                d.lcheck(4);
                if (!bl) break block2;
                this.value = Base64.decode(string);
                if (!Asn1Exception.z) break block3;
            }
            this.value = h.a(string);
        }
    }

    public void encode(Asn1XmlEncoder asn1XmlEncoder, String string, String string2) throws IOException, Asn1Exception {
        this.encode(asn1XmlEncoder, string, string2, false);
    }

    public void encode(Asn1XmlEncoder asn1XmlEncoder, String string, String string2, boolean bl) throws IOException, Asn1Exception {
        if (string == null) {
            string = "OCTET_STRING";
        }
        if (this.value.length == 0) {
            asn1XmlEncoder.indent();
            asn1XmlEncoder.encodeEmptyElement(string, string2);
        } else {
            asn1XmlEncoder.encodeStartElement(string, string2, true);
            if (bl) {
                asn1XmlEncoder.copy(Asn1OctetString.encodeBase64Binary(this.value));
            } else {
                asn1XmlEncoder.encodeHexStrValue(this.value);
            }
            asn1XmlEncoder.encodeEndElement(string, string2);
        }
    }

    public void encodeAttribute(Asn1XmlEncoder asn1XmlEncoder, String string) throws Asn1Exception, IOException {
        block5: {
            block4: {
                if (string == null) {
                    return;
                }
                if (this.value.length != 0) break block4;
                asn1XmlEncoder.copy(new String(" " + string + "=\"\""));
                if (!Asn1Exception.z) break block5;
            }
            asn1XmlEncoder.copy(new String(" " + string + "=\"" + this.toString() + "\""));
        }
    }

    public void decodeXML(String string, String string2) throws Asn1Exception {
        this.decodeXER(string, string2, false);
    }

    public void decode(Asn1JsonDecodeBuffer asn1JsonDecodeBuffer) throws IOException {
        String string = asn1JsonDecodeBuffer.readString();
        this.value = h.a(string);
    }

    public void encode(Asn1JsonOutputStream asn1JsonOutputStream) throws IOException {
        asn1JsonOutputStream.write(34);
        for (int i2 = 0; i2 < this.value.length; ++i2) {
            byte by = this.value[i2];
            byte by2 = (byte)((by & 0xFF) >>> 4);
            char c2 = by2 >= 0 && by2 <= 9 ? (char)(by2 + 48) : (char)(by2 - 10 + 65);
            asn1JsonOutputStream.write(c2);
            by2 = (byte)(by & 0xF);
            c2 = by2 >= 0 && by2 <= 9 ? (char)(by2 + 48) : (char)(by2 - 10 + 65);
            asn1JsonOutputStream.write(c2);
        }
        asn1JsonOutputStream.write(34);
    }

    public static String encodeBase64Binary(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return "";
        }
        return Base64.encodeBytes(byArray);
    }

    public boolean equals(byte[] byArray) {
        boolean bl = Asn1Exception.z;
        if (this.value == null) {
            return byArray == null;
        }
        if (byArray == null) {
            return false;
        }
        if (byArray.length == this.value.length) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                if (byArray[i2] == this.value[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Asn1OctetString) {
            return this.equals(((Asn1OctetString)object).value);
        }
        return false;
    }

    public int hashCode() {
        if (this.value == null) {
            return 1;
        }
        String string = new String(this.value);
        return string.hashCode() == 0 ? 1 : string.hashCode();
    }

    public int getLength() throws Asn1InvalidLengthException {
        return this.value.length;
    }

    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.value, 0, this.value.length);
    }

    public String toString() {
        boolean bl = Asn1Exception.z;
        StringBuffer stringBuffer = new StringBuffer(this.value.length * 2);
        if (this.value != null) {
            for (int i2 = 0; i2 < this.value.length; ++i2) {
                Asn1Util.toHexString(this.value[i2], stringBuffer);
                if (!bl) continue;
            }
        }
        return stringBuffer.toString();
    }

    private void a(int n2) {
        this.value = new byte[n2];
    }

    private void b(int n2) {
        byte[] byArray = this.value;
        this.value = new byte[n2];
        if (byArray != null) {
            System.arraycopy(byArray, 0, this.value, 0, byArray.length);
        }
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl) throws Asn1Exception, IOException {
        asn1BerOutputStream.encodeOctetString(this.value, bl, TAG);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream) throws Asn1Exception, IOException {
        if (this.value == null) {
            this.value = new byte[0];
        }
        asn1PerOutputStream.b.encodeOctetString(this.value, 0, this.value.length);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream, long l2, long l3) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.b, l2, l3);
        asn1PerOutputStream.a(false);
    }

    public void encode(Asn1MderOutputStream asn1MderOutputStream) throws Asn1Exception, IOException {
        this.encode(asn1MderOutputStream, -1);
    }

    public void encode(Asn1MderOutputStream asn1MderOutputStream, int n2) throws Asn1Exception, IOException {
        d.lcheck(1);
        if (n2 >= 0 && this.value.length != n2) {
            throw new Asn1ConsVioException("length", this.value.length);
        }
        if (n2 < 0) {
            if (this.value.length > 65535) {
                throw new Asn1MderUnsupported("Variable length octet string exceeds 65535 octets.");
            }
            asn1MderOutputStream.write2Bytes(this.value.length);
        }
        asn1MderOutputStream.write(this.value);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(1);
        objectOutputStream.writeObject(this.value);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readShort();
        this.value = (byte[])objectInputStream.readObject();
    }
}

