/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1InvalidObjectIDException;
import com.objsys.asn1j.runtime.Asn1ObjectIdentifier;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerOutputStream;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import com.objsys.asn1j.runtime.Asn1XmlEncoder;
import com.objsys.asn1j.runtime.h;
import java.io.IOException;

public class Asn1RelativeOID
extends Asn1ObjectIdentifier {
    public static final Asn1Tag TAG = new Asn1Tag(0, 0, 13);
    private static final long serialVersionUID = -6333449510838564262L;
    private static h e = h.a();

    public Asn1RelativeOID() {
    }

    public Asn1RelativeOID(int[] nArray) {
        super(nArray);
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n2) throws Asn1Exception, IOException {
        int n3 = bl ? Asn1RelativeOID.matchTag(asn1BerDecodeBuffer, TAG) : n2;
        this.value = asn1BerDecodeBuffer.decodeRelOIDContents(n3);
        asn1BerDecodeBuffer.setTypeCode((short)13);
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        boolean bl2 = Asn1Exception.z;
        if (this.value.length < 1) {
            throw new Asn1InvalidObjectIDException();
        }
        int n2 = 0;
        for (int i2 = this.value.length - 1; i2 >= 0; --i2) {
            n2 += asn1BerEncodeBuffer.encodeIdentifier(this.value[i2]);
            if (!bl2) continue;
        }
        if (bl) {
            n2 += asn1BerEncodeBuffer.encodeTagAndLength(TAG, n2);
        }
        return n2;
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws Asn1Exception, IOException {
        block3: {
            block2: {
                int n2 = (int)asn1PerDecodeBuffer.decodeLength();
                if (n2 <= 0) break block2;
                asn1PerDecodeBuffer.getTraceHandler().newBitField("value", 0);
                this.value = asn1PerDecodeBuffer.decodeRelOIDContents(n2);
                asn1PerDecodeBuffer.getTraceHandler().setBitCount();
                asn1PerDecodeBuffer.setTypeCode((short)13);
                if (!Asn1Exception.z) break block3;
            }
            throw new Asn1InvalidObjectIDException();
        }
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer) throws Asn1Exception, IOException {
        if (this.value.length < 1) {
            throw new Asn1InvalidObjectIDException();
        }
        asn1PerEncodeBuffer.encodeRelOIDLengthAndValue(this.value);
    }

    public void encode(Asn1XerEncoder asn1XerEncoder, String string) throws IOException, Asn1Exception {
        if (string == null) {
            string = "RELATIVE_OID";
        }
        asn1XerEncoder.encodeStartElement(string);
        e.lcheck(4);
        asn1XerEncoder.copy(this.toXMLValue());
        asn1XerEncoder.encodeEndElement(string);
    }

    public void decodeXER(String string, String string2) throws Asn1Exception {
        boolean bl = Asn1Exception.z;
        string = string.trim();
        int n2 = 0;
        int n3 = string.length();
        if (n3 == 0) {
            throw new Asn1InvalidObjectIDException();
        }
        int n4 = 0;
        int n5 = -1;
        while ((n5 = string.indexOf(46, n5 + 1)) > 0) {
            ++n4;
            if (!bl) continue;
        }
        if (++n4 > 128) {
            throw new Asn1InvalidObjectIDException();
        }
        this.value = new int[n4];
        int n6 = 0;
        for (n5 = 0; n5 < n3; ++n5) {
            char c2 = string.charAt(n5);
            if (Character.isDigit(c2)) {
                n2 = n2 * 10 + (c2 - 48);
                if (!bl) continue;
            }
            if (c2 == '.') {
                if (n5 + 1 >= n3) {
                    throw new Asn1InvalidObjectIDException();
                }
                this.value[n6++] = n2;
                n2 = 0;
                if (!bl) continue;
            }
            throw new Asn1InvalidObjectIDException();
        }
        this.value[n6] = n2;
    }

    public void encode(Asn1XmlEncoder asn1XmlEncoder, String string, String string2) throws IOException, Asn1Exception {
        if (string == null) {
            string = "RELATIVE_OID";
        }
        asn1XmlEncoder.encodeStartElement(string, string2, true);
        e.lcheck(4);
        asn1XmlEncoder.copy(this.toXMLValue());
        asn1XmlEncoder.encodeEndElement(string, string2);
    }

    public void decodeXML(String string, String string2) throws Asn1Exception {
        this.decodeXER(string, string2);
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl) throws Asn1Exception, IOException {
        int n2;
        boolean bl2 = Asn1Exception.z;
        int n3 = 0;
        for (n2 = 0; n2 < this.value.length; ++n2) {
            n3 += h.d(this.value[n2]);
            if (!bl2) continue;
        }
        if (bl) {
            asn1BerOutputStream.encodeTag(TAG);
        }
        asn1BerOutputStream.encodeLength(n3);
        for (n2 = 0; n2 < this.value.length; ++n2) {
            asn1BerOutputStream.encodeIdentifier(this.value[n2]);
            if (!bl2) continue;
        }
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream) throws Asn1Exception, IOException {
        if (this.value.length < 1) {
            throw new Asn1InvalidObjectIDException();
        }
        asn1PerOutputStream.encodeRelOIDLengthAndValue(this.value);
    }

    protected void validate() {
        if (this.value == null) {
            throw new NullPointerException("value is null");
        }
        if (this.value.length == 0 || this.value.length > 128) {
            throw new Asn1InvalidObjectIDException();
        }
    }
}

