/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn18BitCharString;
import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerOutputStream;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1XmlEncoder;
import com.objsys.asn1j.runtime.Asn1XmlXerEncoder;
import com.objsys.asn1j.runtime.IntHolder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.SimpleTimeZone;

public abstract class Asn1Time
extends Asn18BitCharString
implements Comparable {
    protected transient int year;
    protected transient int month;
    protected transient int day;
    protected transient int hour;
    protected transient int minute;
    protected transient int second;
    protected transient String secFraction = new String();
    protected transient int diffHour;
    protected transient int diffMin;
    protected transient boolean utcFlag;
    protected transient boolean parsed;
    protected transient boolean derRules;
    public static final int January = 1;
    public static final int Jan = 1;
    public static final int February = 2;
    public static final int Feb = 2;
    public static final int March = 3;
    public static final int Mar = 3;
    public static final int April = 4;
    public static final int Apr = 4;
    public static final int May = 5;
    public static final int June = 6;
    public static final int Jun = 6;
    public static final int July = 7;
    public static final int Jul = 7;
    public static final int August = 8;
    public static final int Aug = 8;
    public static final int September = 9;
    public static final int Sep = 9;
    public static final int October = 10;
    public static final int Oct = 10;
    public static final int November = 11;
    public static final int Nov = 11;
    public static final int December = 12;
    public static final int Dec = 12;
    static short[] f = new short[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final long serialVersionUID = 6260627786112948830L;

    public Asn1Time(short s2, boolean bl) {
        super(s2);
        this.derRules = bl;
        this.init();
    }

    public Asn1Time(String string, short s2, boolean bl) {
        super(string, s2);
        this.derRules = bl;
        this.init();
    }

    protected void init() {
        this.hour = -1;
        this.day = -1;
        this.month = -1;
        this.year = -1;
        this.second = 0;
        this.minute = 0;
        this.diffMin = 0;
        this.diffHour = 0;
        this.utcFlag = this.derRules;
    }

    public int getYear() throws Asn1Exception {
        if (!this.parsed) {
            this.parseString(this.value);
        }
        return this.year;
    }

    public int getMonth() throws Asn1Exception {
        if (!this.parsed) {
            this.parseString(this.value);
        }
        return this.month;
    }

    public int getDay() throws Asn1Exception {
        if (!this.parsed) {
            this.parseString(this.value);
        }
        return this.day;
    }

    public int getHour() throws Asn1Exception {
        if (!this.parsed) {
            this.parseString(this.value);
        }
        return this.hour;
    }

    public int getMinute() throws Asn1Exception {
        if (!this.parsed) {
            this.parseString(this.value);
        }
        return this.minute;
    }

    public int getSecond() throws Asn1Exception {
        if (!this.parsed) {
            this.parseString(this.value);
        }
        return this.second;
    }

    public String getFraction() throws Asn1Exception {
        if (!this.parsed) {
            this.parseString(this.value);
        }
        return this.secFraction;
    }

    public int getDiffHour() throws Asn1Exception {
        if (!this.parsed) {
            this.parseString(this.value);
        }
        return this.diffHour;
    }

    public int getDiffMinute() throws Asn1Exception {
        if (!this.parsed) {
            this.parseString(this.value);
        }
        return this.diffMin;
    }

    public int getDiff() throws Asn1Exception {
        if (!this.parsed) {
            this.parseString(this.value);
        }
        return this.diffHour * 60 + this.diffMin;
    }

    public boolean getUTC() throws Asn1Exception {
        if (!this.parsed) {
            this.parseString(this.value);
        }
        return this.utcFlag;
    }

    public Calendar getTime() throws Asn1Exception {
        int n2;
        Calendar calendar;
        block5: {
            block6: {
                boolean bl;
                block4: {
                    bl = Asn1Exception.z;
                    if (!this.parsed) {
                        this.parseString(this.value);
                    }
                    calendar = Calendar.getInstance();
                    n2 = this.utcFlag ? 0 : this.diffHour * 3600 * 1000 + this.diffMin * 60 * 1000;
                    calendar.setTimeZone(new SimpleTimeZone(n2, ""));
                    calendar.setLenient(false);
                    calendar.set(this.year, this.month - 1, this.day, this.hour, this.minute, this.second);
                    if (this.secFraction.length() <= 3) break block4;
                    calendar.set(14, Integer.parseInt(this.secFraction.substring(0, 3)));
                    if (!bl) break block5;
                }
                if (this.secFraction.length() <= 0) break block6;
                calendar.set(14, Integer.parseInt(this.secFraction));
                if (!bl) break block5;
            }
            calendar.set(14, 0);
        }
        calendar.set(15, n2);
        return calendar;
    }

    public void setDER(boolean bl) {
        this.derRules = bl;
    }

    public void setUTC(boolean bl) throws Asn1Exception {
        if (this.derRules) {
            return;
        }
        this.safeParseString();
        this.utcFlag = bl;
        this.compileString();
    }

    public void setYear(int n2) throws Asn1Exception {
        if (n2 < 0) {
            throw new Asn1Exception("Invalid year value: " + n2);
        }
        if (!this.a(this.day, this.month, n2)) {
            throw new Asn1Exception("Invalid year value: " + n2 + " for day (" + this.day + ") and month (" + this.month + ")");
        }
        this.safeParseString();
        this.year = n2;
        this.compileString();
    }

    public void setMonth(int n2) throws Asn1Exception {
        if (n2 < 1 || n2 > 12) {
            throw new Asn1Exception("Invalid month value: " + n2);
        }
        if (!this.a(this.day, n2, this.year)) {
            throw new Asn1Exception("Invalid month value: " + n2 + " for day (" + this.day + ") and year (" + this.year + ")");
        }
        this.safeParseString();
        this.month = n2;
        this.compileString();
    }

    private boolean a(int n2, int n3, int n4) {
        block10: {
            block9: {
                if (n2 <= 0 || n3 <= 0) {
                    return true;
                }
                if (n4 < 0 || n3 <= 0) break block9;
                int n5 = f[n3];
                if (n3 == 2 && n4 % 4 == 0 && (n4 % 100 != 0 || n4 % 400 == 0)) {
                    ++n5;
                }
                if (n2 >= 1 && n2 <= n5) {
                    return true;
                }
                if (!Asn1Exception.z) break block10;
            }
            if (n3 > 0) {
                if (n2 <= f[n3]) {
                    return true;
                }
                if (n3 == 2 && n2 <= f[n3] + 1) {
                    return true;
                }
            }
        }
        return false;
    }

    public void setDay(int n2) throws Asn1Exception {
        if (n2 < 1 || n2 > 31 || !this.a(n2, this.month, this.year)) {
            throw new Asn1Exception("Invalid day value: " + n2 + " for month (" + this.month + ") and year (" + this.year + ")");
        }
        this.safeParseString();
        this.day = n2;
        this.compileString();
    }

    public void setHour(int n2) throws Asn1Exception {
        if (n2 < 0 || n2 > 23) {
            throw new Asn1Exception("Invalid hour value: " + n2);
        }
        this.safeParseString();
        this.hour = n2;
        this.compileString();
    }

    public void setMinute(int n2) throws Asn1Exception {
        if (n2 < 0 || n2 > 59) {
            throw new Asn1Exception("Invalid minute value: " + n2);
        }
        this.safeParseString();
        this.minute = n2;
        this.compileString();
    }

    public void setSecond(int n2) throws Asn1Exception {
        if (n2 < 0 || n2 > 59) {
            throw new Asn1Exception("Invalid second value: " + n2);
        }
        this.safeParseString();
        this.second = n2;
        this.compileString();
    }

    public void setFraction(String string) throws Asn1Exception {
        this.safeParseString();
        this.secFraction = string;
        this.compileString();
    }

    public void setTime(Calendar calendar) throws Asn1Exception {
        int n2;
        block40: {
            block39: {
                boolean bl;
                block38: {
                    block37: {
                        block36: {
                            block35: {
                                block34: {
                                    block33: {
                                        block32: {
                                            block31: {
                                                block30: {
                                                    block29: {
                                                        block28: {
                                                            block27: {
                                                                block26: {
                                                                    block25: {
                                                                        bl = Asn1Exception.z;
                                                                        this.clear();
                                                                        if (!calendar.isSet(1)) break block25;
                                                                        this.year = calendar.get(1);
                                                                        if (!bl) break block26;
                                                                    }
                                                                    throw new Asn1Exception("Invalid Calendar value: no year");
                                                                }
                                                                if (!calendar.isSet(2)) break block27;
                                                                this.month = calendar.get(2) + 1;
                                                                if (!bl) break block28;
                                                            }
                                                            throw new Asn1Exception("Invalid Calendar value: no month");
                                                        }
                                                        if (!calendar.isSet(5)) break block29;
                                                        this.day = calendar.get(5);
                                                        if (!bl) break block30;
                                                    }
                                                    throw new Asn1Exception("Invalid Calendar value: no day");
                                                }
                                                if (!calendar.isSet(11)) break block31;
                                                this.hour = calendar.get(11);
                                                if (!bl) break block32;
                                            }
                                            throw new Asn1Exception("Invalid Calendar value: no hours");
                                        }
                                        if (!calendar.isSet(12)) break block33;
                                        this.minute = calendar.get(12);
                                        if (!bl) break block34;
                                    }
                                    this.minute = 0;
                                }
                                if (!calendar.isSet(13)) break block35;
                                this.second = calendar.get(13);
                                if (!bl) break block36;
                            }
                            this.second = 0;
                        }
                        if (!calendar.isSet(14)) break block37;
                        this.secFraction = Integer.toString(calendar.get(14));
                        if (!bl) break block38;
                    }
                    this.secFraction = new String();
                }
                if (!calendar.isSet(15)) break block39;
                n2 = calendar.get(15);
                this.diffHour = n2 / 3600000;
                this.diffMin = n2 % 3600000 / 60000;
                if (!bl) break block40;
            }
            this.diffMin = 0;
            this.diffHour = 0;
        }
        if (calendar.isSet(16)) {
            n2 = calendar.get(16);
            this.diffHour += n2 / 3600000;
            this.diffMin += n2 % 3600000 / 60000;
        }
        this.utcFlag = this.derRules;
        this.compileString();
    }

    public void setDiffHour(int n2) throws Asn1Exception {
        if (n2 < -12 || n2 > 12) {
            throw new Asn1Exception("Invalid diffhour value: " + n2);
        }
        this.safeParseString();
        this.diffHour = n2;
        this.compileString();
    }

    public void setDiff(int n2, int n3) throws Asn1Exception {
        block6: {
            block5: {
                if (n2 < -12 || n2 > 12) {
                    throw new Asn1Exception("Invalid diffhour value: " + n2);
                }
                if (Math.abs(n3) > 59) {
                    throw new Asn1Exception("Invalid diffminute value: " + n3);
                }
                this.safeParseString();
                this.diffHour = n2;
                if (n2 >= 0) break block5;
                this.diffMin = -Math.abs(n3);
                if (!Asn1Exception.z) break block6;
            }
            this.diffMin = Math.abs(n3);
        }
        this.compileString();
    }

    public void setDiff(int n2) throws Asn1Exception {
        if (Math.abs(n2) > 720) {
            throw new Asn1Exception("Invalid diff value: " + n2);
        }
        this.safeParseString();
        this.diffHour = n2 / 60;
        this.diffMin = n2 % 60;
        this.compileString();
    }

    public void clear() {
        this.hour = -1;
        this.day = -1;
        this.month = -1;
        this.year = -1;
        this.diffMin = 0;
        this.diffHour = 0;
        this.second = 0;
        this.minute = 0;
        this.utcFlag = this.derRules;
        this.parsed = true;
        this.value = "";
        this.secFraction = "";
    }

    public abstract boolean equals(String var1);

    public boolean equals(Object object) {
        try {
            if (object instanceof Asn1Time) {
                if (this.getTime().compareTo(((Asn1Time)object).getTime()) == 0) {
                    return true;
                }
                if (this.getTime().equals(((Asn1Time)object).getTime())) {
                    return true;
                }
            } else if (object instanceof Calendar) {
                if (this.getTime().compareTo((Calendar)object) == 0) {
                    return true;
                }
                if (this.getTime().equals((Calendar)object)) {
                    return true;
                }
            }
        }
        catch (Asn1Exception asn1Exception) {
            // empty catch block
        }
        return false;
    }

    public int compareTo(Object object) {
        try {
            if (object instanceof Calendar) {
                return (int)(this.getTime().getTime().getTime() - ((Calendar)object).getTime().getTime());
            }
            return (int)(this.getTime().getTime().getTime() - ((Asn1Time)object).getTime().getTime().getTime());
        }
        catch (Asn1Exception asn1Exception) {
            throw new ClassCastException(asn1Exception.getMessage());
        }
    }

    public abstract void parseString(String var1) throws Asn1Exception;

    protected abstract boolean compileString() throws Asn1Exception;

    protected static int parseInt(String string, IntHolder intHolder, int n2) {
        if (intHolder.value + n2 > string.length()) {
            throw new IndexOutOfBoundsException();
        }
        return Integer.parseInt(string.substring(intHolder.value, intHolder.value += n2));
    }

    public static void putInteger(StringBuffer stringBuffer, int n2, int n3) {
        String string;
        block6: {
            int n4;
            block5: {
                boolean bl = Asn1Exception.z;
                string = String.valueOf(n3);
                n4 = string.length();
                if (n4 >= n2) break block5;
                boolean bl2 = false;
                for (int i2 = n4; i2 < n2; ++i2) {
                    stringBuffer.append('0');
                    if (!bl) continue;
                }
                if (!bl) break block6;
            }
            if (n4 > n2) {
                string = string.substring(n4 - n2);
            }
        }
        stringBuffer.append(string);
    }

    protected void putInteger(int n2, int n3) {
        Asn1Time.putInteger(this.mStringBuffer, n2, n3);
    }

    protected static char charAt(String string, int n2) {
        if (n2 >= string.length()) {
            return '\u0000';
        }
        return string.charAt(n2);
    }

    protected void safeParseString() {
        try {
            if (!this.parsed) {
                this.parseString(this.value);
            }
        }
        catch (Asn1Exception asn1Exception) {
            // empty catch block
        }
    }

    protected void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n2, Asn1Tag asn1Tag) throws Asn1Exception, IOException {
        this.parsed = false;
        super.decode(asn1BerDecodeBuffer, bl, n2, asn1Tag);
        this.setDER(asn1BerDecodeBuffer instanceof Asn1DerDecodeBuffer);
    }

    protected int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl, Asn1Tag asn1Tag) throws Asn1Exception {
        this.safeParseString();
        boolean bl2 = asn1BerEncodeBuffer instanceof Asn1DerEncodeBuffer;
        if (this.derRules != bl2) {
            this.setDER(bl2);
            if (!this.compileString()) {
                throw new Asn1Exception("Time string could not be generated.");
            }
        }
        return super.encode(asn1BerEncodeBuffer, bl, asn1Tag);
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws Asn1Exception, IOException {
        this.parsed = false;
        super.decode(asn1PerDecodeBuffer);
        this.setDER(true);
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer) throws Asn1Exception, IOException {
        this.safeParseString();
        if (!this.derRules) {
            this.setDER(true);
            if (!this.compileString()) {
                throw new Asn1Exception("Time string could not be generated.");
            }
        }
        super.encode(asn1PerEncodeBuffer);
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl, Asn1Tag asn1Tag) throws Asn1Exception, IOException {
        this.safeParseString();
        asn1BerOutputStream.encodeCharString(this.value, bl, asn1Tag);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.b);
        asn1PerOutputStream.a(false);
    }

    public void decodeXML(String string, String string2) throws Asn1Exception {
        this.parseXmlString(string);
    }

    private static int a(String string, IntHolder intHolder, int n2) {
        char c2;
        boolean bl = Asn1Exception.z;
        if (intHolder.value + n2 > string.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            while (n2 < string.length() && (Character.isDigit(string.charAt(n2)) || n2 == 0 && (string.charAt(n2) == '-' || string.charAt(n2) == '+'))) {
                ++n2;
                if (!bl) continue;
            }
        }
        if ((c2 = string.charAt(intHolder.value)) == '-' || c2 == 'T' || c2 == ':' || c2 == '.' || c2 == ',' || c2 == 'Z') {
            ++intHolder.value;
        }
        int n3 = Integer.parseInt(string.substring(intHolder.value, intHolder.value += n2));
        return n3;
    }

    public void parseXmlString(String string) throws Asn1Exception {
        boolean bl = Asn1Exception.z;
        if (string == null) {
            throw new Asn1Exception("Invalid parameter");
        }
        this.clear();
        IntHolder intHolder = new IntHolder(0);
        try {
            block25: {
                int n2;
                block27: {
                    block26: {
                        block24: {
                            this.year = Asn1Time.a(string, intHolder, 0);
                            this.month = Asn1Time.a(string, intHolder, 2);
                            this.day = Asn1Time.a(string, intHolder, 2);
                            this.hour = Asn1Time.a(string, intHolder, 2);
                            this.minute = Asn1Time.a(string, intHolder, 2);
                            this.second = Asn1Time.a(string, intHolder, 2);
                            if (this.year == 0) {
                                throw new Asn1Exception("Invalid year value: " + this.year);
                            }
                            if (this.month < 1 || this.month > 12) {
                                throw new Asn1Exception("Invalid month value: " + this.month);
                            }
                            int n3 = f[this.month];
                            if (this.month == 2 && this.year % 4 == 0 && (this.year % 100 != 0 || this.year % 400 == 0)) {
                                ++n3;
                            }
                            if (this.day < 1 || this.day > n3) {
                                throw new Asn1Exception("Invalid day value: " + this.day);
                            }
                            if (this.hour < 0 || this.hour > 23) {
                                throw new Asn1Exception("Invalid hour value: " + this.hour);
                            }
                            if (this.minute < 0 || this.minute > 59) {
                                throw new Asn1Exception("Invalid minute value: " + this.minute);
                            }
                            if (this.second < 0 || this.second > 59) {
                                throw new Asn1Exception("Invalid second value: " + this.second);
                            }
                            char c2 = Asn1Time.charAt(string, intHolder.value);
                            if (c2 == '.' || c2 == ',') {
                                ++intHolder.value;
                                n2 = 0;
                                while (Character.isDigit(Asn1Time.charAt(string, intHolder.value + n2))) {
                                    ++n2;
                                    if (!bl) continue;
                                }
                                if (n2 == 0) {
                                    throw new Asn1Exception("Unexpected '.' or ','");
                                }
                                this.secFraction = string.substring(intHolder.value, intHolder.value + n2);
                                intHolder.value += n2;
                            }
                            if (Asn1Time.charAt(string, intHolder.value) != 'Z') break block24;
                            ++intHolder.value;
                            this.utcFlag = true;
                            if (intHolder.value != string.length()) {
                                throw new Asn1Exception("Unexpected values at end of string");
                            }
                            break block25;
                        }
                        this.utcFlag = false;
                        n2 = Asn1Time.charAt(string, intHolder.value);
                        if (n2 != 45 && n2 != 43) break block25;
                        ++intHolder.value;
                        if (!Character.isDigit(Asn1Time.charAt(string, intHolder.value))) break block26;
                        this.diffHour = Asn1Time.a(string, intHolder, 2);
                        this.diffMin = Asn1Time.a(string, intHolder, 2);
                        if (!bl) break block27;
                    }
                    throw new Asn1Exception("Invalid diffhour");
                }
                if (this.diffHour < 0 || this.diffHour > 12) {
                    throw new Asn1Exception("Invalid diffhour value: " + this.diffHour);
                }
                if (this.diffMin < 0 || this.diffMin > 59) {
                    throw new Asn1Exception("Invalid diffminute value: " + this.diffMin);
                }
                if (n2 == 45) {
                    this.diffHour = -this.diffHour;
                    this.diffMin = -this.diffMin;
                }
            }
            this.parsed = true;
            if (string != this.value) {
                this.compileString();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new Asn1Exception("Invalid date format");
        }
        catch (NumberFormatException numberFormatException) {
            throw new Asn1Exception("Invalid number format");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Asn1Exception("Invalid date format");
        }
    }

    public void encode(Asn1XmlEncoder asn1XmlEncoder, String string, String string2) throws IOException, Asn1Exception {
        asn1XmlEncoder.encodeStartElement(string, string2, true);
        this.encodeXMLData(asn1XmlEncoder);
        asn1XmlEncoder.encodeEndElement(string, string2);
    }

    public void encodeXER(Asn1XmlEncoder asn1XmlEncoder, String string, String string2) throws IOException, Asn1Exception {
        asn1XmlEncoder.encodeStartElement(string, string2, true);
        asn1XmlEncoder.encodeData(this.value);
        asn1XmlEncoder.encodeEndElement(string, string2);
    }

    public void encodeXMLData(Asn1XmlXerEncoder asn1XmlXerEncoder) throws IOException, Asn1Exception {
        StringBuffer stringBuffer;
        block7: {
            block6: {
                this.parseString(this.value);
                if (this.year < 0 || this.day <= 0 || this.month <= 0 || this.hour < 0 || this.minute < 0 || this.second < 0) {
                    throw new Asn1Exception("Invalid date format");
                }
                stringBuffer = new StringBuffer();
                Asn1Time.putInteger(stringBuffer, 4, this.year);
                stringBuffer.append('-');
                Asn1Time.putInteger(stringBuffer, 2, this.month);
                stringBuffer.append('-');
                Asn1Time.putInteger(stringBuffer, 2, this.day);
                stringBuffer.append('T');
                Asn1Time.putInteger(stringBuffer, 2, this.hour);
                stringBuffer.append(':');
                Asn1Time.putInteger(stringBuffer, 2, this.minute);
                stringBuffer.append(':');
                Asn1Time.putInteger(stringBuffer, 2, this.second);
                if (this.secFraction.length() > 0) {
                    stringBuffer.append('.');
                    stringBuffer.append(this.secFraction);
                }
                if (!this.utcFlag) break block6;
                stringBuffer.append('Z');
                if (!Asn1Exception.z) break block7;
            }
            if (this.diffHour != 0 || this.diffMin != 0) {
                stringBuffer.append(this.diffHour > 0 ? (char)'+' : '-');
                Asn1Time.putInteger(stringBuffer, 2, Math.abs(this.diffHour));
                stringBuffer.append(':');
                Asn1Time.putInteger(stringBuffer, 2, Math.abs(this.diffMin));
            }
        }
        asn1XmlXerEncoder.copy(stringBuffer.toString());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(3);
        objectOutputStream.writeShort(this.year);
        objectOutputStream.writeByte(this.month);
        objectOutputStream.writeByte(this.day);
        objectOutputStream.writeByte(this.hour);
        objectOutputStream.writeByte(this.minute);
        objectOutputStream.writeByte(this.second);
        objectOutputStream.writeObject(this.secFraction);
        objectOutputStream.writeByte(this.diffHour);
        objectOutputStream.writeByte(this.diffMin);
        objectOutputStream.writeBoolean(this.utcFlag);
        objectOutputStream.writeBoolean(this.parsed);
        objectOutputStream.writeBoolean(this.derRules);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        block3: {
            block4: {
                short s2;
                boolean bl;
                block2: {
                    bl = Asn1Exception.z;
                    objectInputStream.defaultReadObject();
                    s2 = objectInputStream.readShort();
                    this.year = objectInputStream.readShort();
                    this.month = objectInputStream.read();
                    this.day = objectInputStream.read();
                    this.hour = objectInputStream.read();
                    this.minute = objectInputStream.read();
                    this.second = objectInputStream.read();
                    if (s2 != 1) break block2;
                    this.secFraction = Integer.toString(objectInputStream.read());
                    if (!bl) break block3;
                }
                if (s2 != 2) break block4;
                this.secFraction = Integer.toString(objectInputStream.readInt());
                if (!bl) break block3;
            }
            this.secFraction = (String)objectInputStream.readObject();
        }
        this.diffHour = objectInputStream.read();
        this.diffMin = objectInputStream.read();
        this.utcFlag = objectInputStream.readBoolean();
        this.parsed = objectInputStream.readBoolean();
        this.derRules = objectInputStream.readBoolean();
    }
}

