/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1Real;
import com.objsys.asn1j.runtime.Asn1XmlEncoder;
import java.io.IOException;

public class Asn1XmlUtil {
    public static void encodeDouble(Asn1XmlEncoder asn1XmlEncoder, double d2, String string, String string2) throws IOException, Asn1Exception {
        asn1XmlEncoder.encodeStartElement(string, string2, true);
        Asn1XmlUtil.encodeDouble(asn1XmlEncoder, d2);
        asn1XmlEncoder.encodeEndElement(string, string2);
    }

    public static void encodeDouble(Asn1XmlEncoder asn1XmlEncoder, double d2) throws IOException, Asn1Exception {
        block3: {
            block7: {
                boolean bl;
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                bl = Asn1Exception.z;
                                if (!Asn1XmlUtil.isMinusZero(d2)) break block2;
                                asn1XmlEncoder.copy("-0");
                                if (!bl) break block3;
                            }
                            if (d2 != Double.NEGATIVE_INFINITY) break block4;
                            asn1XmlEncoder.copy("-INF");
                            if (!bl) break block3;
                        }
                        if (d2 != Double.POSITIVE_INFINITY) break block5;
                        asn1XmlEncoder.copy("INF");
                        if (!bl) break block3;
                    }
                    if (d2 == d2) break block6;
                    asn1XmlEncoder.copy("NaN");
                    if (!bl) break block3;
                }
                if (d2 != 0.0) break block7;
                asn1XmlEncoder.copy("0");
                if (!bl) break block3;
            }
            asn1XmlEncoder.copy(Asn1Real.normalizedRealValueToString(d2));
        }
    }

    public static String getXMLString(String string) {
        boolean bl = Asn1Exception.z;
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '&') {
                stringBuffer.append("&amp;");
                if (!bl) continue;
            }
            if (c2 == '<') {
                stringBuffer.append("&lt;");
                if (!bl) continue;
            }
            if (c2 == '>') {
                stringBuffer.append("&gt;");
                if (!bl) continue;
            }
            if (c2 == '\'') {
                stringBuffer.append("&apos;");
                if (!bl) continue;
            }
            if (c2 == '\"') {
                stringBuffer.append("&quot;");
                if (!bl) continue;
            }
            if (c2 == '\n') {
                stringBuffer.append("&#10;");
                if (!bl) continue;
            }
            if (c2 == '\r') {
                stringBuffer.append("&#13;");
                if (!bl) continue;
            }
            if (c2 == '\t') {
                stringBuffer.append("&#9;");
                if (!bl) continue;
            }
            stringBuffer.append(c2);
            if (!bl) continue;
        }
        return stringBuffer.toString();
    }

    public static boolean isMinusZero(double d2) {
        if (Math.abs(d2) != 0.0) {
            return false;
        }
        long l2 = Double.doubleToLongBits(d2);
        return l2 == Long.MIN_VALUE;
    }

    public static boolean isNaN(double d2) {
        long l2 = Double.doubleToLongBits(d2);
        return l2 == 9221120237041090560L;
    }

    public static String[] tokenizeXsdList(String string) {
        return Asn1XmlUtil.a(string, null);
    }

    private static String[] a(String string, String[] stringArray) {
        boolean bl = Asn1Exception.z;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5;
            int n6;
            if (n4 < n2 && ((n6 = string.charAt(n4)) == 9 || n6 == 10 || n6 == 13 || n6 == 32 || bl)) {
                ++n4;
                if (!bl) continue;
            }
            if (n4 == n2) break;
            n6 = n4;
            while (n4 < n2 && (n5 = (int)string.charAt(n4)) != 9 && n5 != 10 && n5 != 13 && (n5 != 32 || bl)) {
                ++n4;
                if (!bl) continue;
            }
            n5 = n4;
            if (stringArray != null) {
                stringArray[n3] = string.substring(n6, n5);
            }
            ++n3;
            if (++n4 >= n2) break;
        }
        if (stringArray == null) {
            stringArray = new String[n3];
            return Asn1XmlUtil.a(string, stringArray);
        }
        return stringArray;
    }
}

