/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation.find;

import java.util.Iterator;
import java.util.List;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.MatchSystem;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.SaveSystem;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.Finder;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.save.CertificateSaver;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;

public class Find {
    public static ECertificate fromList(MatchSystem aMatchSystem, List<ECertificate> aCertList, ECertificate aCertificate) {
        boolean bl = Finder.b;
        if (aCertList != null) {
            for (ECertificate eCertificate : aCertList) {
                if (Find.isMatchingIssuer(aMatchSystem, aCertificate, eCertificate)) {
                    return eCertificate;
                }
                if (!bl) continue;
            }
        }
        return null;
    }

    public static List<ECertificate> issuerCertificatesFromList(MatchSystem aMatchSystem, List<ECertificate> aCertList, ECertificate aCertificate, List<ECertificate> aMatches) {
        boolean bl = Finder.b;
        if (aCertList != null) {
            for (ECertificate eCertificate : aCertList) {
                if (eCertificate.equals((Object)aCertificate) && !bl) continue;
                if (Find.isMatchingIssuer(aMatchSystem, aCertificate, eCertificate) && !aMatches.contains(eCertificate)) {
                    aMatches.add(eCertificate);
                }
                if (!bl) continue;
            }
        }
        return aMatches;
    }

    public static ECertificate issuerCertificateFromList(MatchSystem aMatchSystem, List<ECertificate> aCertList, ECRL aCRL) {
        boolean bl = Finder.b;
        if (aCertList != null) {
            for (ECertificate eCertificate : aCertList) {
                if (Find.isMatchingIssuer(aMatchSystem, aCRL, eCertificate)) {
                    return eCertificate;
                }
                if (!bl) continue;
            }
        }
        return null;
    }

    public static List<ECertificate> issuerCertificatesFromList(MatchSystem aMatchSystem, List<ECertificate> aCertList, ECRL aCRL, List<ECertificate> aMatches) {
        boolean bl = Finder.b;
        if (aCertList != null) {
            for (ECertificate eCertificate : aCertList) {
                if (Find.isMatchingIssuer(aMatchSystem, aCRL, eCertificate) && !aMatches.contains(eCertificate)) {
                    aMatches.add(eCertificate);
                }
                if (!bl) continue;
            }
        }
        return aMatches;
    }

    public static List<ECRL> crlsFromList(MatchSystem aMatchSystem, List<ECRL> aCRLList, List<ECRL> aMatches, ECertificate aCertificate) {
        Iterator<ECRL> iterator = aCRLList.iterator();
        boolean bl = Finder.b;
        while (iterator.hasNext()) {
            ECRL eCRL = iterator.next();
            if (!aMatches.contains(eCRL) && Find.isMatcingCRL(aMatchSystem, aCertificate, eCRL)) {
                aMatches.add(eCRL);
            }
            if (!bl) continue;
        }
        return aMatches;
    }

    public static ECRL deltaCRLFromList(MatchSystem aMatchSystem, List<ECRL> aCRLS, ECertificate aCertificate) {
        if (aCRLS.size() > 0) {
            return aCRLS.get(0);
        }
        return null;
    }

    public static ECRL deltaCRLFromList(MatchSystem aMatchSystem, List<ECRL> aCRLList, ECRL aBaseCRL) {
        boolean bl = Finder.b;
        if (aCRLList != null) {
            for (ECRL eCRL : aCRLList) {
                if (Find.isMatchingDeltaCRL(aMatchSystem, aBaseCRL, eCRL)) {
                    return eCRL;
                }
                if (!bl) continue;
            }
        }
        return null;
    }

    public static ECertificate crossCertificateFromList(MatchSystem aMatchSystem, List<ECertificate> aCertificates, ECertificate aCertificate) {
        boolean bl = Finder.b;
        if (aCertificates != null) {
            for (ECertificate eCertificate : aCertificates) {
                if (Find.isMatchingCrossCertificate(aMatchSystem, aCertificate, eCertificate)) {
                    return eCertificate;
                }
                if (!bl) continue;
            }
        }
        return null;
    }

    public static boolean isMatchingIssuer(MatchSystem aMatchSystem, ECRL aCRL, ECertificate aIssuerCertificate) {
        return aMatchSystem.matchCertificate(aCRL, aIssuerCertificate);
    }

    public static boolean isMatchingIssuer(MatchSystem aMatchSystem, ECertificate aCertificate, ECertificate aIssuerCertificate) {
        return aMatchSystem.matchCertificate(aCertificate, aIssuerCertificate);
    }

    public static boolean isMatcingCRL(MatchSystem aMatchSystem, ECertificate aCertificate, ECRL aCRL) {
        return aMatchSystem.matchCRL(aCertificate, aCRL);
    }

    public static boolean isMatchingOCSPResponse(MatchSystem aEslestirmeSistemi, ECertificate aCertificate, ECertificate aIssuer, EOCSPResponse aOCSPResponse) {
        return aEslestirmeSistemi.matchOCSPResponse(aCertificate, aIssuer, aOCSPResponse);
    }

    public static boolean isMatchingCrossCertificate(MatchSystem aMatchSystem, ECertificate aCertificate, ECertificate aCrossCertificate) {
        return aMatchSystem.matchCrossCertificate(aCertificate, aCrossCertificate);
    }

    public static boolean isMatchingDeltaCRL(MatchSystem aMatchSystem, ECRL aBaseCRL, ECRL aDeltaCRL) {
        return aMatchSystem.matchDeltaCRL(aBaseCRL, aDeltaCRL);
    }

    public static void saveCertificate(SaveSystem aSaveSystem, ECertificate aCertificate) throws ESYAException {
        List<CertificateSaver> list = aSaveSystem.getCertificateSavers();
        Iterator<CertificateSaver> iterator = list.iterator();
        boolean bl = Finder.b;
        while (iterator.hasNext()) {
            CertificateSaver certificateSaver = iterator.next();
            certificateSaver.addCertificate(aCertificate);
            if (!bl) continue;
        }
    }
}

