/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerDecodeContext;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1CharSet;
import com.objsys.asn1j.runtime.Asn1CharString;
import com.objsys.asn1j.runtime.Asn1EndOfBufferException;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1InvalidLengthException;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerOutputStream;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.b;
import java.io.IOException;

public class Asn1BMPString
extends Asn1CharString {
    public static final Asn1CharSet CHARSET = new b();
    public static final int BITSPERCHAR = 16;
    public static final Asn1Tag TAG = new Asn1Tag(0, 0, 30);

    public Asn1BMPString() {
        super((short)30);
    }

    public Asn1BMPString(String string) {
        super(string, (short)30);
    }

    private void a(Asn1BerDecodeBuffer asn1BerDecodeBuffer, StringBuffer stringBuffer, int n2) throws Asn1Exception, IOException {
        boolean bl = Asn1Exception.z;
        if (n2 % 2 != 0) {
            throw new Asn1InvalidLengthException();
        }
        while (n2 > 0) {
            int n3 = asn1BerDecodeBuffer.read();
            if (n3 == -1) {
                throw new Asn1EndOfBufferException(asn1BerDecodeBuffer);
            }
            int n4 = n3 * 256;
            --n2;
            n3 = asn1BerDecodeBuffer.read();
            if (n3 == -1) {
                throw new Asn1EndOfBufferException(asn1BerDecodeBuffer);
            }
            --n2;
            stringBuffer.append((char)(n4 += n3));
            if (!bl) continue;
        }
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n2) throws Asn1Exception, IOException {
        int n3;
        int n4 = n3 = bl ? Asn1BMPString.matchTag(asn1BerDecodeBuffer, TAG) : n2;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        Asn1Tag asn1Tag = asn1BerDecodeBuffer.getLastTag();
        if (asn1Tag != null && asn1Tag.isConstructed()) {
            int n5 = 0;
            Asn1BerDecodeContext asn1BerDecodeContext = new Asn1BerDecodeContext(asn1BerDecodeBuffer, n3);
            while (!asn1BerDecodeContext.expired()) {
                int n6 = Asn1BMPString.matchTag(asn1BerDecodeBuffer, Asn1OctetString.TAG);
                if (n6 > 0) {
                    stringBuffer.ensureCapacity(n5 += n6);
                    this.a(asn1BerDecodeBuffer, stringBuffer, n6);
                    continue;
                }
                throw new Asn1Exception(asn1BerDecodeBuffer, "Invalid format of constructed value");
            }
            if (n3 == -9999) {
                Asn1BMPString.matchTag(asn1BerDecodeBuffer, Asn1Tag.EOC);
            }
        } else {
            stringBuffer.ensureCapacity(n3 / 2);
            this.a(asn1BerDecodeBuffer, stringBuffer, n4);
        }
        this.value = stringBuffer.toString();
        asn1BerDecodeBuffer.setTypeCode((short)30);
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        int n2 = this.value.length();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            char c2 = this.value.charAt(i2);
            int n3 = c2 % 256;
            int n4 = c2 / 256;
            asn1BerEncodeBuffer.copy((byte)n3);
            asn1BerEncodeBuffer.copy((byte)n4);
        }
        n2 *= 2;
        if (bl) {
            n2 += asn1BerEncodeBuffer.encodeTagAndLength(TAG, n2);
        }
        return n2;
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws Asn1Exception, IOException {
        this.decode(asn1PerDecodeBuffer, 16, 16, null);
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, Asn1CharSet asn1CharSet) throws Asn1Exception, IOException {
        this.decode(asn1PerDecodeBuffer, 16, 16, asn1CharSet);
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, Asn1CharSet asn1CharSet, long l2, long l3) throws Asn1Exception, IOException {
        this.decode(asn1PerDecodeBuffer, 16, 16, asn1CharSet, l2, l3);
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer) throws Asn1Exception, IOException {
        this.encode(asn1PerEncodeBuffer, 16, 16, null);
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, Asn1CharSet asn1CharSet) throws Asn1Exception, IOException {
        this.encode(asn1PerEncodeBuffer, 16, 16, asn1CharSet);
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, Asn1CharSet asn1CharSet, long l2, long l3) throws Asn1Exception, IOException {
        this.encode(asn1PerEncodeBuffer, 16, 16, asn1CharSet, l2, l3);
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl) throws Asn1Exception, IOException {
        asn1BerOutputStream.encodeBMPString(this.value, bl, TAG);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.b, 16, 16, null);
        asn1PerOutputStream.a(false);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream, Asn1CharSet asn1CharSet) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.b, 16, 16, asn1CharSet);
        asn1PerOutputStream.a(false);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream, Asn1CharSet asn1CharSet, long l2, long l3) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.b, 16, 16, asn1CharSet, l2, l3);
        asn1PerOutputStream.a(false);
    }
}

