/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Time;
import com.objsys.asn1j.runtime.IntHolder;
import java.io.IOException;
import java.util.Calendar;

public class Asn1GeneralizedTime
extends Asn1Time {
    public static final Asn1Tag TAG = new Asn1Tag(0, 0, 24);

    public Asn1GeneralizedTime() {
        super((short)24, false);
    }

    public Asn1GeneralizedTime(boolean bl) {
        super((short)24, bl);
    }

    public Asn1GeneralizedTime(String string) {
        super(string, (short)24, false);
        this.parseString(new String(this.value));
    }

    public Asn1GeneralizedTime(String string, boolean bl) {
        super(string, (short)24, bl);
    }

    public boolean equals(String string) {
        if (string == null) {
            return false;
        }
        return this.getTime().equals(new Asn1GeneralizedTime(string, this.derRules).getTime());
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n2) throws Asn1Exception, IOException {
        this.decode(asn1BerDecodeBuffer, bl, n2, TAG);
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        return this.encode(asn1BerEncodeBuffer, bl, TAG);
    }

    public int getCentury() throws Asn1Exception {
        int n2 = this.getYear();
        if (n2 < 0) {
            throw new Asn1Exception("Invalid year value: " + n2);
        }
        return n2 / 100;
    }

    public void setCentury(int n2) throws Asn1Exception {
        if (n2 < 0 || n2 > 99) {
            throw new Asn1Exception("Invalid century value: " + n2);
        }
        this.safeParseString();
        this.year = n2 * 100 + this.year % 100;
        this.compileString();
    }

    public void parseString(String string) throws Asn1Exception {
        boolean bl = Asn1Exception.z;
        if (string == null) {
            throw new Asn1Exception("Invalid parameter");
        }
        this.clear();
        IntHolder intHolder = new IntHolder(0);
        try {
            block41: {
                int n2;
                block43: {
                    block42: {
                        block40: {
                            block38: {
                                block39: {
                                    int n3;
                                    block37: {
                                        block36: {
                                            this.year = Asn1GeneralizedTime.parseInt(string, intHolder, 4);
                                            this.month = Asn1GeneralizedTime.parseInt(string, intHolder, 2);
                                            this.day = Asn1GeneralizedTime.parseInt(string, intHolder, 2);
                                            if (this.year < 0) {
                                                throw new Asn1Exception("Invalid year value: " + this.year);
                                            }
                                            if (this.month < 1 || this.month > 12) {
                                                throw new Asn1Exception("Invalid month value: " + this.month);
                                            }
                                            int n4 = f[this.month];
                                            if (this.month == 2 && this.year % 4 == 0 && (this.year % 100 != 0 || this.year % 400 == 0)) {
                                                ++n4;
                                            }
                                            if (this.day < 1 || this.day > n4) {
                                                throw new Asn1Exception("Invalid day value: " + this.day);
                                            }
                                            n3 = 0;
                                            if (!Character.isDigit(Asn1GeneralizedTime.charAt(string, intHolder.value))) break block36;
                                            this.hour = Asn1GeneralizedTime.parseInt(string, intHolder, 2);
                                            ++n3;
                                            if (!bl) break block37;
                                        }
                                        throw new Asn1Exception("Hours expected");
                                    }
                                    if (Character.isDigit(Asn1GeneralizedTime.charAt(string, intHolder.value))) {
                                        this.minute = Asn1GeneralizedTime.parseInt(string, intHolder, 2);
                                        ++n3;
                                        if (Character.isDigit(Asn1GeneralizedTime.charAt(string, intHolder.value))) {
                                            this.second = Asn1GeneralizedTime.parseInt(string, intHolder, 2);
                                            ++n3;
                                        }
                                    }
                                    if (n3 >= 1 && (this.hour < 0 || this.hour > 23)) {
                                        throw new Asn1Exception("Invalid hour value: " + this.hour);
                                    }
                                    if (n3 >= 2 && (this.minute < 0 || this.minute > 59)) {
                                        throw new Asn1Exception("Invalid minute value: " + this.minute);
                                    }
                                    if (n3 == 3 && (this.second < 0 || this.second > 59)) {
                                        throw new Asn1Exception("Invalid second value: " + this.second);
                                    }
                                    char c2 = Asn1GeneralizedTime.charAt(string, intHolder.value);
                                    if (this.derRules && c2 == ',') {
                                        throw new Asn1Exception("Invalid decimal mark");
                                    }
                                    if (c2 != '.' && c2 != ',') break block38;
                                    ++intHolder.value;
                                    if (n3 != 3) break block39;
                                    n2 = 0;
                                    while (Character.isDigit(Asn1GeneralizedTime.charAt(string, intHolder.value + n2))) {
                                        ++n2;
                                        if (!bl) continue;
                                    }
                                    if (n2 == 0) {
                                        throw new Asn1Exception("Invalid fraction value ");
                                    }
                                    this.secFraction = string.substring(intHolder.value, intHolder.value + n2);
                                    intHolder.value += n2;
                                    if (!bl) break block38;
                                }
                                throw new Asn1Exception("Unexpected '.' or ','");
                            }
                            if (Asn1GeneralizedTime.charAt(string, intHolder.value) != 'Z') break block40;
                            ++intHolder.value;
                            this.utcFlag = true;
                            if (intHolder.value != string.length()) {
                                throw new Asn1Exception("Unexpected values at end of string");
                            }
                            break block41;
                        }
                        if (this.derRules) {
                            throw new Asn1Exception("Unexpected zone offset in DER/CER/PER time string");
                        }
                        this.utcFlag = false;
                        n2 = Asn1GeneralizedTime.charAt(string, intHolder.value);
                        if (n2 != 45 && n2 != 43) break block41;
                        ++intHolder.value;
                        if (!Character.isDigit(Asn1GeneralizedTime.charAt(string, intHolder.value))) break block42;
                        this.diffHour = Asn1GeneralizedTime.parseInt(string, intHolder, 2);
                        if (!bl) break block43;
                    }
                    throw new Asn1Exception("Invalid diffhour");
                }
                if (Character.isDigit(Asn1GeneralizedTime.charAt(string, intHolder.value))) {
                    this.diffMin = Asn1GeneralizedTime.parseInt(string, intHolder, 2);
                }
                if (this.diffHour < 0 || this.diffHour > 12) {
                    throw new Asn1Exception("Invalid diffhour value: " + this.diffHour);
                }
                if (this.diffMin < 0 || this.diffMin > 59) {
                    throw new Asn1Exception("Invalid diffminute value: " + this.diffMin);
                }
                if (n2 == 45) {
                    this.diffHour = -this.diffHour;
                    this.diffMin = -this.diffMin;
                }
            }
            this.parsed = true;
            if (string != this.value) {
                this.compileString();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new Asn1Exception("Invalid date format");
        }
        catch (NumberFormatException numberFormatException) {
            throw new Asn1Exception("Invalid number format");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Asn1Exception("Invalid date format");
        }
    }

    protected boolean compileString() throws Asn1Exception {
        block18: {
            block19: {
                boolean bl;
                block17: {
                    int n2;
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    bl = Asn1Exception.z;
                                    if (this.year < 0 || this.month <= 0 || this.day <= 0 || this.hour < 0) {
                                        return false;
                                    }
                                    this.value = "";
                                    if (this.mStringBuffer != null) break block13;
                                    this.mStringBuffer = new StringBuffer();
                                    if (!bl) break block14;
                                }
                                this.mStringBuffer.setLength(0);
                            }
                            if (!this.derRules && !this.utcFlag || this.diffHour == 0 && this.diffMin == 0) break block15;
                            Calendar calendar = this.getTime();
                            calendar.add(12, -this.diffMin);
                            calendar.add(11, -this.diffHour);
                            this.putInteger(4, calendar.get(1));
                            this.putInteger(2, calendar.get(2) + 1);
                            this.putInteger(2, calendar.get(5));
                            this.putInteger(2, calendar.get(11));
                            n2 = calendar.get(12);
                            if (!bl) break block16;
                        }
                        this.putInteger(4, this.year);
                        this.putInteger(2, this.month);
                        this.putInteger(2, this.day);
                        this.putInteger(2, this.hour);
                        n2 = this.minute;
                    }
                    if (this.derRules || n2 >= 0 || this.second >= 0 || this.secFraction.length() > 0) {
                        this.putInteger(2, n2);
                        if (this.derRules || this.second >= 0 || this.secFraction.length() > 0) {
                            this.putInteger(2, this.second);
                            if (this.secFraction.length() > 0) {
                                this.mStringBuffer.append('.');
                                this.mStringBuffer.append(this.secFraction);
                            }
                        }
                    }
                    if (!this.derRules && !this.utcFlag) break block17;
                    this.mStringBuffer.append('Z');
                    if (!bl) break block18;
                }
                if (this.diffHour == 0 && this.diffMin == 0) break block18;
                this.mStringBuffer.append(this.diffHour > 0 ? (char)'+' : '-');
                if (this.diffMin == 0) break block19;
                this.putInteger(2, Math.abs(this.diffHour));
                this.putInteger(2, Math.abs(this.diffMin));
                if (!bl) break block18;
            }
            this.putInteger(2, Math.abs(this.diffHour));
        }
        this.value = this.mStringBuffer.toString();
        return true;
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl) throws Asn1Exception, IOException {
        super.encode(asn1BerOutputStream, bl, TAG);
    }
}

