/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1ConsVioException;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1JsonDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1JsonOutputStream;
import com.objsys.asn1j.runtime.Asn1MderDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1MderOutputStream;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncoder;
import com.objsys.asn1j.runtime.Asn1PerOutputStream;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import com.objsys.asn1j.runtime.Asn1XmlEncoder;
import com.objsys.asn1j.runtime.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Asn1Integer
extends Asn1Type {
    static final int d = 8;
    static final int e = 4;
    public static final Object MIN = null;
    public static final Object MAX = null;
    public static final Asn1Tag TAG = new Asn1Tag(0, 0, 2);
    public transient long value;
    private static final long serialVersionUID = 977086821174128117L;
    private static h f = h.a();

    public Asn1Integer() {
        this.value = 0L;
    }

    public Asn1Integer(long l2) {
        this.value = l2;
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n2) throws Asn1Exception, IOException {
        int n3 = bl ? Asn1Integer.matchTag(asn1BerDecodeBuffer, TAG) : n2;
        this.value = h.a(asn1BerDecodeBuffer, n3, true);
        f.lcheck(1);
        asn1BerDecodeBuffer.setTypeCode((short)2);
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        int n2 = asn1BerEncodeBuffer.encodeIntValue(this.value);
        if (bl) {
            n2 += asn1BerEncodeBuffer.encodeTagAndLength(TAG, n2);
        }
        return n2;
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws Asn1Exception, IOException {
        this.value = Asn1Integer.decodeValue(asn1PerDecodeBuffer);
    }

    public static long decodeValue(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws Asn1Exception, IOException {
        int n2 = (int)asn1PerDecodeBuffer.decodeLength();
        asn1PerDecodeBuffer.byteAlign();
        long l2 = asn1PerDecodeBuffer.decodeInt(n2, true);
        asn1PerDecodeBuffer.setTypeCode((short)2);
        return l2;
    }

    public static long decodeValue(Asn1PerDecodeBuffer asn1PerDecodeBuffer, long l2, long l3) throws Asn1Exception, IOException {
        long l4 = 0L;
        long l5 = l3 - l2 + 1L;
        if (l2 != l3) {
            l4 = asn1PerDecodeBuffer.decodeConsWholeNumber(l5);
        }
        asn1PerDecodeBuffer.setTypeCode((short)2);
        if ((l4 += l2) < l2 || l4 > l3) {
            throw new Asn1ConsVioException("Asn1Integer.value", l4);
        }
        return l4;
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, long l2, long l3) throws Asn1Exception, IOException {
        this.value = 0L;
        this.value = Asn1Integer.decodeValue(asn1PerDecodeBuffer, l2, l3);
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, Object object, long l2) throws Asn1Exception, IOException {
        int n2 = (int)asn1PerDecodeBuffer.decodeLength();
        asn1PerDecodeBuffer.byteAlign();
        this.value = asn1PerDecodeBuffer.decodeInt(n2, true);
        asn1PerDecodeBuffer.setTypeCode((short)2);
        if (this.value > l2) {
            throw new Asn1ConsVioException("Asn1Integer.value", this.value);
        }
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, long l2, Object object) throws Asn1Exception, IOException {
        int n2 = (int)asn1PerDecodeBuffer.decodeLength();
        asn1PerDecodeBuffer.byteAlign();
        this.value = asn1PerDecodeBuffer.decodeInt(n2, false);
        this.value += l2;
        asn1PerDecodeBuffer.setTypeCode((short)2);
        if (this.value < l2) {
            throw new Asn1ConsVioException("Asn1Integer.value", this.value);
        }
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, Object object, Object object2) throws Asn1Exception, IOException {
        int n2 = (int)asn1PerDecodeBuffer.decodeLength();
        asn1PerDecodeBuffer.byteAlign();
        this.value = asn1PerDecodeBuffer.decodeInt(n2, true);
        asn1PerDecodeBuffer.setTypeCode((short)2);
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer) throws Asn1Exception, IOException {
        if (this.value == 0L) {
            asn1PerEncodeBuffer.encodeLength(1L);
            asn1PerEncodeBuffer.getTraceHandler().newBitField("value", 8);
            asn1PerEncodeBuffer.copy((byte)0);
        } else {
            asn1PerEncodeBuffer.encodeInt(this.value, true, true);
        }
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, long l2, long l3) throws Asn1Exception {
        Asn1Integer.encodeValue(asn1PerEncodeBuffer, this.value, l2, l3);
    }

    public static void encodeValue(Asn1PerEncoder asn1PerEncoder, long l2, long l3, long l4) throws Asn1Exception {
        block4: {
            try {
                if (l2 >= l3 && l2 <= l4) {
                    if (l3 == l4) break block4;
                    long l5 = l2 - l3;
                    long l6 = l4 - l3 + 1L;
                    asn1PerEncoder.encodeConsWholeNumber(l5, l6);
                    if (!Asn1Exception.z) break block4;
                }
                throw new Asn1ConsVioException("Asn1Integer.value", l2);
            }
            catch (IOException iOException) {
                throw new Asn1Exception(iOException.toString());
            }
        }
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, Object object, long l2) throws Asn1Exception {
        asn1PerEncodeBuffer.encodeInt(this.value, true, true);
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, long l2, Object object) throws Asn1Exception {
        long l3 = this.value - l2;
        asn1PerEncodeBuffer.encodeInt(l3, true, false);
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, Object object, Object object2) throws Asn1Exception {
        asn1PerEncodeBuffer.encodeInt(this.value, true, true);
    }

    public void decode8Bit(Asn1MderDecodeBuffer asn1MderDecodeBuffer, boolean bl) throws Asn1Exception, IOException {
        f.lcheck(1);
        int n2 = asn1MderDecodeBuffer.read();
        if (bl && (n2 & 0x80) != 0) {
            n2 |= 0xFFFFFF00;
        }
        this.value = n2;
    }

    public void decode16Bit(Asn1MderDecodeBuffer asn1MderDecodeBuffer, boolean bl) throws Asn1Exception, IOException {
        this.value = asn1MderDecodeBuffer.read2Bytes();
        if (bl && (this.value & 0x8000L) != 0L) {
            this.value |= 0xFFFFFFFFFFFF0000L;
        }
        f.lcheck(1);
    }

    public void decode32Bit(Asn1MderDecodeBuffer asn1MderDecodeBuffer, boolean bl) throws Asn1Exception, IOException {
        this.value = asn1MderDecodeBuffer.read4Bytes();
        f.lcheck(1);
        if (!bl) {
            this.value &= 0xFFFFFFFFL;
        }
    }

    public void encode(Asn1XerEncoder asn1XerEncoder, String string) throws IOException, Asn1Exception {
        if (string == null) {
            string = "INTEGER";
        }
        asn1XerEncoder.encodeStartElement(string);
        asn1XerEncoder.copy(this.toString());
        asn1XerEncoder.encodeEndElement(string);
    }

    public void decodeXER(String string, String string2) throws Asn1Exception {
        this.value = Long.parseLong(string);
        f.lcheck(4);
    }

    public void encode(Asn1XmlEncoder asn1XmlEncoder, String string, String string2) throws IOException, Asn1Exception {
        if (string == null) {
            string = "INTEGER";
        }
        asn1XmlEncoder.encodeStartElement(string, string2, true);
        asn1XmlEncoder.copy(this.toString());
        asn1XmlEncoder.encodeEndElement(string, string2);
    }

    public void encodeAttribute(Asn1XmlEncoder asn1XmlEncoder, String string) throws Asn1Exception, IOException {
        if (string != null) {
            asn1XmlEncoder.encodeAttr(string, this.toString());
        }
    }

    public void decodeXML(String string, String string2) throws Asn1Exception {
        try {
            this.value = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Asn1Exception("Invalid INTEGER value");
        }
    }

    public void decode(Asn1JsonDecodeBuffer asn1JsonDecodeBuffer) throws IOException {
        this.value = Long.parseLong(asn1JsonDecodeBuffer.readNumber());
    }

    public void encode(Asn1JsonOutputStream asn1JsonOutputStream) throws IOException {
        f.lcheck(0);
        asn1JsonOutputStream.write(this.toString());
    }

    public boolean equals(long l2) {
        return this.value == l2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Asn1Integer)) {
            return false;
        }
        return this.value == ((Asn1Integer)object).value;
    }

    public int hashCode() {
        return 0L == this.value ? 1 : (int)this.value;
    }

    public static int getBitCount(long l2) {
        return h.a(l2);
    }

    public int getBitCount() {
        return h.a(this.value);
    }

    public static int getUnsignedBitCount(long l2) {
        int n2;
        block3: {
            block2: {
                n2 = h.a(l2 >>> 1);
                if (n2 != 0) break block2;
                n2 = (int)l2 & 1;
                if (!Asn1Exception.z) break block3;
            }
            ++n2;
        }
        return n2;
    }

    public int getUnsignedBitCount() {
        int n2;
        block3: {
            block2: {
                n2 = h.a(this.value >>> 1);
                if (n2 != 0) break block2;
                n2 = (int)this.value & 1;
                if (!Asn1Exception.z) break block3;
            }
            ++n2;
        }
        return n2;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl) throws Asn1Exception, IOException {
        if (bl) {
            asn1BerOutputStream.encodeTag(TAG);
        }
        asn1BerOutputStream.encodeIntValue(this.value, true);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream) throws Asn1Exception, IOException {
        asn1PerOutputStream.b.encodeInt(this.value, true, true);
        asn1PerOutputStream.a(false);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream, long l2, long l3) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.b, l2, l3);
        asn1PerOutputStream.a(false);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream, Object object, long l2) throws Asn1Exception, IOException {
        asn1PerOutputStream.b.encodeInt(this.value, true, true);
        asn1PerOutputStream.a(false);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream, long l2, Object object) throws Asn1Exception, IOException {
        long l3 = this.value - l2;
        asn1PerOutputStream.b.encodeInt(l3, true, false);
        asn1PerOutputStream.a(false);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream, Object object, Object object2) throws Asn1Exception, IOException {
        asn1PerOutputStream.b.encodeInt(this.value, true, true);
        asn1PerOutputStream.a(false);
    }

    private void a(long l2, long l3) throws Asn1ConsVioException {
        if (this.value < l2 || this.value > l3) {
            throw new Asn1ConsVioException("integer", this.value);
        }
    }

    public final void encode8Bit(Asn1MderOutputStream asn1MderOutputStream, boolean bl) throws Asn1Exception, IOException {
        block3: {
            block2: {
                if (!bl) break block2;
                this.a(-128L, 127L);
                if (!Asn1Exception.z) break block3;
            }
            this.a(0L, 255L);
        }
        f.lcheck(1);
        asn1MderOutputStream.write((int)this.value);
    }

    public final void encode16Bit(Asn1MderOutputStream asn1MderOutputStream, boolean bl) throws Asn1Exception, IOException {
        block3: {
            block2: {
                if (!bl) break block2;
                this.a(-32768L, 32767L);
                if (!Asn1Exception.z) break block3;
            }
            this.a(0L, 65535L);
        }
        asn1MderOutputStream.write2Bytes((int)this.value);
        f.lcheck(1);
    }

    public final void encode32Bit(Asn1MderOutputStream asn1MderOutputStream, boolean bl) throws Asn1Exception, IOException {
        block3: {
            block2: {
                f.lcheck(1);
                if (!bl) break block2;
                this.a(Integer.MIN_VALUE, Integer.MAX_VALUE);
                if (!Asn1Exception.z) break block3;
            }
            this.a(0L, 0xFFFFFFFFL);
        }
        asn1MderOutputStream.write4Bytes((int)this.value);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(1);
        objectOutputStream.writeLong(this.value);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readShort();
        this.value = objectInputStream.readLong();
    }
}

