/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1EndOfBufferException;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1JsonDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1JsonOutputStream;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerOutputStream;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1Util;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import com.objsys.asn1j.runtime.Asn1XmlEncoder;
import com.objsys.asn1j.runtime.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Asn1Real
extends Asn1Type {
    public static final Asn1Tag TAG = new Asn1Tag(0, 0, 9);
    private static final int d = 64;
    private static final int e = 65;
    private static final int f = 128;
    private static final int g = 64;
    private static final int h = 3;
    private static final int i = 0;
    private static final int j = 1;
    private static final int k = 2;
    private static final int l = 3;
    private static final int m = 12;
    private static final int n = 48;
    private static final int o = 0;
    private static final int p = 16;
    private static final int q = 32;
    private static final int r = 63;
    public transient double value;
    private static final long serialVersionUID = 3406587116835849281L;
    private static final double s = Math.log(2.0) / Math.log(10.0);

    public Asn1Real() {
        this.value = 0.0;
    }

    public Asn1Real(double d2) {
        this.value = d2;
    }

    public Asn1Real(boolean bl) {
        this.value = 0.0;
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n2) throws Asn1Exception, IOException {
        block28: {
            int n3;
            int n4;
            int n5;
            boolean bl2;
            block27: {
                int n6;
                int n7;
                bl2 = Asn1Exception.z;
                int n8 = n7 = bl ? Asn1Real.matchTag(asn1BerDecodeBuffer, TAG) : n2;
                if (n7 == 0) {
                    this.value = 0.0;
                    return;
                }
                n5 = asn1BerDecodeBuffer.readByte();
                if (n7 == 1) {
                    switch (n5) {
                        case 64: {
                            this.value = Double.POSITIVE_INFINITY;
                            return;
                        }
                        case 65: {
                            this.value = Double.NEGATIVE_INFINITY;
                            return;
                        }
                    }
                    throw new Asn1Exception(asn1BerDecodeBuffer, "Invalid REAL value");
                }
                --n7;
                int n9 = 0;
                if ((n5 & 0x80) == 0) break block27;
                switch (n5 & 3) {
                    case 0: {
                        n9 = 1;
                        if (!bl2) break;
                    }
                    case 1: {
                        n9 = 2;
                        if (!bl2) break;
                    }
                    case 2: {
                        n9 = 3;
                        if (!bl2) break;
                    }
                    default: {
                        n9 = asn1BerDecodeBuffer.readByte();
                        --n7;
                    }
                }
                n4 = (int)com.objsys.asn1j.runtime.h.a(asn1BerDecodeBuffer, n9, true);
                long l2 = com.objsys.asn1j.runtime.h.a(asn1BerDecodeBuffer, n7 -= n9, false);
                l2 *= 1L << ((n5 & 0xC) >> 2);
                switch (n5 & 0x30) {
                    case 0: {
                        n6 = 2;
                        if (!bl2) break;
                    }
                    case 16: {
                        n6 = 8;
                        if (!bl2) break;
                    }
                    case 32: {
                        n6 = 16;
                        if (!bl2) break;
                    }
                    default: {
                        throw new Asn1Exception(asn1BerDecodeBuffer, "Invalid REAL value");
                    }
                }
                this.value = (double)l2 * Math.pow(n6, n4);
                if ((n5 & 0x40) != 0) {
                    this.value = -this.value;
                }
                if (!bl2) break block28;
            }
            int n10 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.setLength(n3);
            for (n3 = n7; n3 > 0; --n3) {
                n4 = asn1BerDecodeBuffer.read();
                if (n4 == -1) {
                    throw new Asn1EndOfBufferException(asn1BerDecodeBuffer);
                }
                stringBuffer.setCharAt(n10++, (char)n4);
                if (!bl2) continue;
            }
            int n11 = n5 & 0x3F;
            int n12 = 0;
            for (int i2 = 0; i2 < stringBuffer.length(); ++i2) {
                char c2 = stringBuffer.charAt(i2);
                if (n11 >= 2 && c2 == ',') {
                    stringBuffer.setCharAt(i2, '.');
                    ++n12;
                    if (!bl2) continue;
                }
                if (n11 >= 1 && (c2 >= '0' && c2 <= '9' || c2 == '+' || c2 == '-') || n11 >= 2 && c2 == '.' || n11 == 3 && (c2 == 'E' || c2 == 'e')) {
                    ++n12;
                    if (!bl2) continue;
                }
                if (n12 == 0 && c2 == ' ' && !bl2) continue;
                throw new Asn1Exception(asn1BerDecodeBuffer, "Invalid REAL value");
            }
            try {
                this.value = Double.valueOf(stringBuffer.toString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new Asn1Exception(asn1BerDecodeBuffer, "Invalid REAL value");
            }
        }
        asn1BerDecodeBuffer.setTypeCode((short)9);
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        int n2;
        block15: {
            boolean bl2;
            block16: {
                block14: {
                    bl2 = Asn1Exception.z;
                    n2 = 0;
                    if (this.value != Double.NEGATIVE_INFINITY) break block14;
                    n2 = asn1BerEncodeBuffer.encodeIntValue(65L);
                    if (!bl2) break block15;
                }
                if (this.value != Double.POSITIVE_INFINITY) break block16;
                n2 = asn1BerEncodeBuffer.encodeIntValue(64L);
                if (!bl2) break block15;
            }
            if (this.value != 0.0) {
                long l2;
                long l3 = Double.doubleToLongBits(this.value);
                int n3 = l3 >> 63 == 0L ? 1 : -1;
                int n4 = (int)(l3 >> 52 & 0x7FFL) - 1075;
                long l4 = l2 = n4 == 0 ? (l3 & 0xFFFFFFFFFFFFFL) << 1 : l3 & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
                if (l2 != 0L) {
                    int n5 = Asn1Real.a(l2);
                    l2 >>>= n5;
                    n4 += n5;
                }
                long l5 = l2;
                do {
                    long l6 = l5 % 256L;
                    if ((l5 /= 256L) < 0L && l6 != 0L) {
                        --l5;
                    }
                    asn1BerEncodeBuffer.copy((byte)l6);
                    ++n2;
                } while (l5 != 0L && l5 != -1L);
                int n6 = asn1BerEncodeBuffer.encodeIntValue(n4);
                n2 += n6;
                int n7 = 128;
                if (n3 == -1) {
                    n7 |= 0x40;
                }
                switch (n6) {
                    case 1: {
                        n7 |= 0;
                        if (!bl2) break;
                    }
                    case 2: {
                        n7 |= 1;
                        if (!bl2) break;
                    }
                    case 3: {
                        n7 |= 2;
                        if (!bl2) break;
                    }
                    default: {
                        n7 |= 3;
                        n2 += asn1BerEncodeBuffer.encodeIntValue(n6);
                    }
                }
                asn1BerEncodeBuffer.copy((byte)n7);
                ++n2;
            }
        }
        if (bl) {
            n2 += asn1BerEncodeBuffer.encodeTagAndLength(TAG, n2);
        }
        return n2;
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws Asn1Exception, IOException {
        block26: {
            int n2;
            int n3;
            boolean bl;
            block25: {
                int n4;
                bl = Asn1Exception.z;
                n3 = (int)asn1PerDecodeBuffer.decodeLength();
                if (n3 == 0) {
                    this.value = 0.0;
                    return;
                }
                n2 = asn1PerDecodeBuffer.decodeBitsToInt(8);
                if (n3 == 1) {
                    switch (n2) {
                        case 64: {
                            this.value = Double.POSITIVE_INFINITY;
                            return;
                        }
                        case 65: {
                            this.value = Double.NEGATIVE_INFINITY;
                            return;
                        }
                    }
                    throw new Asn1Exception(asn1PerDecodeBuffer, "Invalid REAL value");
                }
                --n3;
                int n5 = 0;
                if ((n2 & 0x80) == 0) break block25;
                switch (n2 & 3) {
                    case 0: {
                        n5 = 1;
                        if (!bl) break;
                    }
                    case 1: {
                        n5 = 2;
                        if (!bl) break;
                    }
                    case 2: {
                        n5 = 3;
                        if (!bl) break;
                    }
                    default: {
                        n5 = asn1PerDecodeBuffer.decodeBitsToInt(8);
                        --n3;
                    }
                }
                int n6 = (int)asn1PerDecodeBuffer.decodeInt(n5, true);
                long l2 = asn1PerDecodeBuffer.decodeBitsToLong((n3 -= n5) * 8);
                l2 *= 1L << ((n2 & 0xC) >> 2);
                switch (n2 & 0x30) {
                    case 0: {
                        n4 = 2;
                        if (!bl) break;
                    }
                    case 16: {
                        n4 = 8;
                        if (!bl) break;
                    }
                    case 32: {
                        n4 = 16;
                        if (!bl) break;
                    }
                    default: {
                        throw new Asn1Exception(asn1PerDecodeBuffer, "Invalid REAL value");
                    }
                }
                this.value = (double)l2 * Math.pow(n4, n6);
                if ((n2 & 0x40) != 0) {
                    this.value = -this.value;
                }
                if (!bl) break block26;
            }
            if ((n2 & 0x3F) != 3) {
                throw new Asn1Exception(asn1PerDecodeBuffer, "Invalid REAL value");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer = new StringBuffer();
            stringBuffer.ensureCapacity(n3);
            asn1PerDecodeBuffer.decodeCharString(n3, 8, 8, null, stringBuffer);
            for (int i2 = 0; i2 < stringBuffer.length(); ++i2) {
                char c2 = stringBuffer.charAt(i2);
                if (c2 == ',') {
                    stringBuffer.setCharAt(i2, '.');
                    if (!bl) continue;
                }
                if (c2 >= '0' && c2 <= '9' || c2 == '+' || c2 == '-' || c2 == '.' || c2 == 'E' || c2 == 'e') continue;
                throw new Asn1Exception(asn1PerDecodeBuffer, "Invalid REAL value");
            }
            try {
                this.value = Double.valueOf(stringBuffer.toString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new Asn1Exception(asn1PerDecodeBuffer, "Invalid REAL value");
            }
        }
        asn1PerDecodeBuffer.setTypeCode((short)9);
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer) throws Asn1Exception, IOException {
        block16: {
            block14: {
                int n2;
                long l2;
                int n3;
                int n4;
                int n5;
                boolean bl;
                block19: {
                    block18: {
                        block17: {
                            block15: {
                                bl = Asn1Exception.z;
                                if (this.value == 0.0) break block14;
                                if (this.value != Double.NEGATIVE_INFINITY) break block15;
                                asn1PerEncodeBuffer.encodeLength(1L);
                                asn1PerEncodeBuffer.encodeInt(65L, 8);
                                if (!bl) break block16;
                            }
                            if (this.value != Double.POSITIVE_INFINITY) break block17;
                            asn1PerEncodeBuffer.encodeLength(1L);
                            asn1PerEncodeBuffer.encodeInt(64L, 8);
                            if (!bl) break block16;
                        }
                        n5 = 1;
                        long l3 = Double.doubleToLongBits(this.value);
                        n4 = l3 >> 63 == 0L ? 1 : -1;
                        n3 = (int)(l3 >> 52 & 0x7FFL) - 1075;
                        long l4 = l2 = n3 == 0 ? (l3 & 0xFFFFFFFFFFFFFL) << 1 : l3 & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
                        if (l2 == 0L) break block18;
                        n2 = Asn1Real.a(l2);
                        n3 += n2;
                        n5 += Asn1Util.getUlongBytesCount(l2 >>>= n2);
                        if (!bl) break block19;
                    }
                    ++n5;
                }
                n2 = 128;
                if (n4 == -1) {
                    n2 |= 0x40;
                }
                int n6 = Asn1Util.getBytesCount(n3);
                n5 += n6;
                switch (n6) {
                    case 1: {
                        n2 |= 0;
                        if (!bl) break;
                    }
                    case 2: {
                        n2 |= 1;
                        if (!bl) break;
                    }
                    case 3: {
                        n2 |= 2;
                        if (!bl) break;
                    }
                    default: {
                        n2 |= 3;
                        ++n5;
                    }
                }
                asn1PerEncodeBuffer.encodeLength(n5);
                asn1PerEncodeBuffer.encodeInt((long)n2, 8, "format");
                if ((n2 & 3) == 3) {
                    asn1PerEncodeBuffer.encodeBits((byte)n6, 8);
                }
                if (n6 > 0) {
                    asn1PerEncodeBuffer.encodeInt((long)n3, n6 * 8, "exponent");
                }
                asn1PerEncodeBuffer.encodeInt(l2, false, false);
                if (!bl) break block16;
            }
            asn1PerEncodeBuffer.encodeLength(0L);
        }
    }

    private void a(String string) {
        boolean bl;
        double d2;
        block34: {
            int n2;
            int n3;
            char c2;
            int n4;
            int n5;
            boolean bl2;
            block36: {
                block35: {
                    block31: {
                        block28: {
                            block27: {
                                bl2 = Asn1Exception.z;
                                if (string.compareTo("-0") == 0) {
                                    this.value = 0.0;
                                    return;
                                }
                                if (string.compareTo("0") == 0) {
                                    this.value = 0.0;
                                    return;
                                }
                                d2 = 0.0;
                                n5 = 0;
                                n4 = string.length();
                                bl = false;
                                c2 = '\u0000';
                                if (n4 == 0) {
                                    throw new Asn1Exception("Invalid REAL value: " + string);
                                }
                                if (string.charAt(n5) != '+') break block27;
                                ++n5;
                                if (!bl2) break block28;
                            }
                            if (string.charAt(n5) == '-') {
                                bl = true;
                                ++n5;
                            }
                        }
                        if (n5 >= n4) {
                            throw new Asn1Exception("Invalid REAL value: " + string);
                        }
                        while (n5 < n4 && string.charAt(n5) != '.' && string.charAt(n5) != 'E' && string.charAt(n5) != 'e') {
                            block30: {
                                block29: {
                                    c2 = string.charAt(n5);
                                    if (!Character.isDigit(c2)) break block29;
                                    d2 = d2 * 10.0 + (double)(c2 - 48);
                                    if (!bl2) break block30;
                                }
                                throw new Asn1Exception("Invalid REAL value: " + string);
                            }
                            ++n5;
                            if (!bl2) continue;
                        }
                        if (n5 >= n4 || (c2 = string.charAt(n5)) != '.') break block31;
                        double d3 = 0.1;
                        ++n5;
                        while (n5 < n4 && (c2 = string.charAt(n5)) != 'E' && c2 != 'e') {
                            block33: {
                                block32: {
                                    if (!Character.isDigit(c2)) break block32;
                                    d2 += (double)(c2 - 48) * d3;
                                    if (!bl2) break block33;
                                }
                                throw new Asn1Exception("Invalid REAL value: " + string);
                            }
                            ++n5;
                            d3 *= 0.1;
                            if (!bl2) continue;
                        }
                    }
                    if (n5 >= n4 || c2 != 'E' && c2 != 'e') break block34;
                    n3 = 0;
                    if (++n5 >= n4) {
                        throw new Asn1Exception("Invalid REAL value: " + string);
                    }
                    c2 = string.charAt(n5);
                    if (c2 != '-') break block35;
                    n2 = -1;
                    ++n5;
                    if (!bl2) break block36;
                }
                n2 = 1;
                if (c2 == '+') {
                    ++n5;
                }
            }
            if (n5 >= n4) {
                throw new Asn1Exception("Invalid REAL value: " + string);
            }
            while (n5 < n4) {
                block38: {
                    block37: {
                        c2 = string.charAt(n5);
                        if (!Character.isDigit(c2)) break block37;
                        n3 = n3 * 10 + (c2 - 48);
                        if (!bl2) break block38;
                    }
                    throw new Asn1Exception("Invalid REAL value: " + string);
                }
                ++n5;
                if (!bl2) continue;
            }
            d2 *= Math.pow(10.0, n3 * n2);
        }
        if (bl) {
            d2 = 0.0 - d2;
        }
        this.value = d2;
    }

    public void encode(Asn1XerEncoder asn1XerEncoder, String string) throws IOException, Asn1Exception {
        asn1XerEncoder.encodeRealValue(this.value, string);
    }

    public void decodeXER(String string, String string2, boolean bl, boolean bl2) throws Asn1Exception {
        block2: {
            block4: {
                block6: {
                    boolean bl3;
                    block5: {
                        block3: {
                            bl3 = Asn1Exception.z;
                            string = string.trim();
                            if (!bl) break block2;
                            if (string.compareTo("MINUS-INFINITY") != 0) break block3;
                            this.value = Double.NEGATIVE_INFINITY;
                            if (!bl3) break block4;
                        }
                        if (string.compareTo("PLUS-INFINITY") != 0) break block5;
                        this.value = Double.POSITIVE_INFINITY;
                        if (!bl3) break block4;
                    }
                    if (string.compareTo("NOT-A-NUMBER") != 0) break block6;
                    this.value = Double.NaN;
                    if (!bl3) break block4;
                }
                throw new Asn1Exception("Invalid REAL value: " + string);
            }
            return;
        }
        this.a(string, bl2);
    }

    public void encode(Asn1XmlEncoder asn1XmlEncoder, String string, String string2) throws IOException, Asn1Exception {
        asn1XmlEncoder.encodeStartElement(string, string2, true);
        this.encodeValue(asn1XmlEncoder);
        asn1XmlEncoder.encodeEndElement(string, string2);
    }

    public void encode(Asn1XmlEncoder asn1XmlEncoder, String string, String string2, boolean bl) throws IOException, Asn1Exception {
        block3: {
            block7: {
                boolean bl2;
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                bl2 = Asn1Exception.z;
                                asn1XmlEncoder.encodeStartElement(string, string2, true);
                                if (!bl) break block2;
                                this.encodeValue(asn1XmlEncoder);
                                if (!bl2) break block3;
                            }
                            if (this.value != 0.0) break block4;
                            asn1XmlEncoder.copy("0");
                            if (!bl2) break block3;
                        }
                        if (this.value != Double.NEGATIVE_INFINITY) break block5;
                        asn1XmlEncoder.encodeEmptyElement("MINUS-INFINITY", "");
                        if (!bl2) break block3;
                    }
                    if (this.value != Double.POSITIVE_INFINITY) break block6;
                    asn1XmlEncoder.encodeEmptyElement("PLUS-INFINITY", "");
                    if (!bl2) break block3;
                }
                if (!Double.isNaN(this.value)) break block7;
                asn1XmlEncoder.encodeEmptyElement("NOT-A-NUMBER", "");
                if (!bl2) break block3;
            }
            asn1XmlEncoder.copy(Asn1Real.normalizedRealValueToString(this.value));
        }
        asn1XmlEncoder.encodeEndElement(string, string2);
    }

    public void encodeAttribute(Asn1XmlEncoder asn1XmlEncoder, String string) throws Asn1Exception, IOException {
        if (string == null) {
            return;
        }
        asn1XmlEncoder.copy(" " + string + "=\"");
        this.encodeValue(asn1XmlEncoder);
        asn1XmlEncoder.copy("\"");
    }

    public void encodeValue(Asn1XmlEncoder asn1XmlEncoder) throws IOException, Asn1Exception {
        block3: {
            block6: {
                boolean bl;
                block5: {
                    block4: {
                        block2: {
                            bl = Asn1Exception.z;
                            if (this.value != Double.NEGATIVE_INFINITY) break block2;
                            asn1XmlEncoder.copy("-INF");
                            if (!bl) break block3;
                        }
                        if (this.value != Double.POSITIVE_INFINITY) break block4;
                        asn1XmlEncoder.copy("INF");
                        if (!bl) break block3;
                    }
                    if (this.value == this.value) break block5;
                    asn1XmlEncoder.copy("NaN");
                    if (!bl) break block3;
                }
                if (this.value != 0.0) break block6;
                asn1XmlEncoder.copy("0");
                if (!bl) break block3;
            }
            asn1XmlEncoder.copy(Asn1Real.normalizedRealValueToString(this.value));
        }
    }

    public void decodeXML(String string, String string2) throws Asn1Exception {
        string = string.trim();
        this.a(string, true);
    }

    private void a(String string, boolean bl) {
        if (bl) {
            if (string.compareTo("-INF") == 0) {
                this.value = Double.NEGATIVE_INFINITY;
                return;
            }
            if (string.compareTo("INF") == 0) {
                this.value = Double.POSITIVE_INFINITY;
                return;
            }
            if (string.compareTo("NaN") == 0) {
                this.value = Double.NaN;
                return;
            }
        }
        this.a(string);
    }

    public void decode(Asn1JsonDecodeBuffer asn1JsonDecodeBuffer) throws IOException {
        block12: {
            String string;
            block7: {
                boolean bl;
                block9: {
                    block11: {
                        block10: {
                            block8: {
                                bl = Asn1Exception.z;
                                int n2 = asn1JsonDecodeBuffer.seekCharacter();
                                if (n2 < 0) {
                                    throw new Asn1Exception("unexpected end of input");
                                }
                                if (n2 != 34) break block7;
                                string = asn1JsonDecodeBuffer.readString();
                                if (!string.equals("NEGATIVE_INFINITY")) break block8;
                                this.value = Double.NEGATIVE_INFINITY;
                                if (!bl) break block9;
                            }
                            if (!string.equals("POSITIVE_INFINITY")) break block10;
                            this.value = Double.POSITIVE_INFINITY;
                            if (!bl) break block9;
                        }
                        if (!string.equals("NaN")) break block11;
                        this.value = Double.NaN;
                        if (!bl) break block9;
                    }
                    throw new Asn1Exception("invalid real: '" + string + "'");
                }
                if (!bl) break block12;
            }
            string = asn1JsonDecodeBuffer.readNumber();
            this.a(string);
        }
    }

    public void encode(Asn1JsonOutputStream asn1JsonOutputStream) throws IOException {
        block3: {
            block6: {
                boolean bl;
                block5: {
                    block4: {
                        block2: {
                            bl = Asn1Exception.z;
                            if (this.value != Double.NEGATIVE_INFINITY) break block2;
                            asn1JsonOutputStream.write("\"NEGATIVE_INFINITY\"");
                            if (!bl) break block3;
                        }
                        if (this.value != Double.POSITIVE_INFINITY) break block4;
                        asn1JsonOutputStream.write("\"POSITIVE_INFINITY\"");
                        if (!bl) break block3;
                    }
                    if (this.value == this.value) break block5;
                    asn1JsonOutputStream.write("\"NaN\"");
                    if (!bl) break block3;
                }
                if (this.value != 0.0) break block6;
                asn1JsonOutputStream.write("0");
                if (!bl) break block3;
            }
            asn1JsonOutputStream.write(Asn1Real.normalizedRealValueToString(this.value));
        }
    }

    public boolean equals(double d2) {
        return this.value == d2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Asn1Real)) {
            return false;
        }
        return this.value == ((Asn1Real)object).value;
    }

    public int hashCode() {
        Double d2 = new Double(this.value);
        return d2.hashCode() == 0 ? 1 : d2.hashCode();
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public static String normalizedRealValueToString(double d2) {
        double d3;
        boolean bl = Asn1Exception.z;
        if (d2 == 0.0) {
            return "0";
        }
        long l2 = Double.doubleToLongBits(d2);
        int n2 = l2 >> 63 == 0L ? 1 : -1;
        int n3 = (int)(l2 >> 52 & 0x7FFL) - 1075;
        long l3 = n3 == 0 ? (l2 & 0xFFFFFFFFFFFFFL) << 1 : l2 & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        double d4 = (double)n3 * s;
        int n4 = (int)d4;
        double d5 = d3 = (double)l3 * Math.pow(10.0, d4 - (double)n4);
        while (d5 >= 10.0) {
            d5 /= 10.0;
            ++n4;
            if (!bl) continue;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = (int)(d5 += 5.0E-15);
        if (n2 < 0) {
            stringBuffer.append('-');
        }
        stringBuffer.append(String.valueOf(n5));
        stringBuffer.append('.');
        int n6 = 0;
        int n7 = stringBuffer.length();
        int n8 = n5;
        for (int i2 = 0; d5 != 0.0 && i2 < 14; ++i2) {
            if ((n5 = (int)(d5 = (d5 - (double)n5) * 10.0)) == 0 && n8 != 0) {
                n6 = i2;
            }
            stringBuffer.append((char)(n5 + 48));
            n8 = n5;
            if (!bl) continue;
        }
        if (n6 == 0) {
            ++n6;
        }
        stringBuffer.setLength(n6 + n7);
        stringBuffer.append('E');
        stringBuffer.append(String.valueOf(n4));
        return stringBuffer.toString();
    }

    private static int a(long l2) {
        int n2 = com.objsys.asn1j.runtime.h.a((int)l2);
        return n2 < 32 ? n2 : com.objsys.asn1j.runtime.h.a((int)(l2 >>> 32)) + 32;
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl) throws Asn1Exception, IOException {
        block18: {
            block16: {
                int n2;
                long l2;
                int n3;
                int n4;
                int n5;
                boolean bl2;
                block21: {
                    block20: {
                        block19: {
                            block17: {
                                bl2 = Asn1Exception.z;
                                if (bl) {
                                    asn1BerOutputStream.encodeTag(TAG);
                                }
                                if (this.value == 0.0) break block16;
                                if (this.value != Double.NEGATIVE_INFINITY) break block17;
                                asn1BerOutputStream.encodeIntValue(65L, true);
                                if (!bl2) break block18;
                            }
                            if (this.value != Double.POSITIVE_INFINITY) break block19;
                            asn1BerOutputStream.encodeIntValue(64L, true);
                            if (!bl2) break block18;
                        }
                        n5 = 1;
                        long l3 = Double.doubleToLongBits(this.value);
                        n4 = l3 >> 63 == 0L ? 1 : -1;
                        n3 = (int)(l3 >> 52 & 0x7FFL) - 1075;
                        long l4 = l2 = n3 == 0 ? (l3 & 0xFFFFFFFFFFFFFL) << 1 : l3 & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
                        if (l2 == 0L) break block20;
                        n2 = Asn1Real.a(l2);
                        n3 += n2;
                        n5 += Asn1Util.getUlongBytesCount(l2 >>>= n2);
                        if (!bl2) break block21;
                    }
                    ++n5;
                }
                n2 = 128;
                if (n4 == -1) {
                    n2 |= 0x40;
                }
                int n6 = Asn1Util.getBytesCount(n3);
                n5 += n6;
                switch (n6) {
                    case 1: {
                        n2 |= 0;
                        if (!bl2) break;
                    }
                    case 2: {
                        n2 |= 1;
                        if (!bl2) break;
                    }
                    case 3: {
                        n2 |= 2;
                        if (!bl2) break;
                    }
                    default: {
                        n2 |= 3;
                        ++n5;
                    }
                }
                asn1BerOutputStream.encodeLength(n5);
                asn1BerOutputStream.write((byte)n2);
                if ((n2 & 3) == 3) {
                    asn1BerOutputStream.encodeIntValue(n6, false);
                }
                asn1BerOutputStream.encodeIntValue(n3, false);
                long l5 = l2;
                byte[] byArray = new byte[8];
                int n7 = 0;
                int n8 = byArray.length;
                do {
                    long l6 = l5 % 256L;
                    if ((l5 /= 256L) < 0L && l6 != 0L) {
                        --l5;
                    }
                    byArray[--n8] = (byte)l6;
                    ++n7;
                } while (l5 != 0L && l5 != -1L);
                asn1BerOutputStream.write(byArray, n8, n7);
                if (!bl2) break block18;
            }
            asn1BerOutputStream.encodeLength(0);
        }
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.b);
        asn1PerOutputStream.a(false);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(1);
        objectOutputStream.writeDouble(this.value);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readShort();
        this.value = objectInputStream.readDouble();
    }
}

