/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.Sequence;
import com.turktrust.asn1.SequenceOf;
import com.turktrust.x509.AlgorithmIdentifier;
import com.turktrust.x509.Extension;
import com.turktrust.x509.Extensions;
import com.turktrust.x509.Name;
import com.turktrust.x509.RevokedCertificate;
import com.turktrust.x509.Time;
import com.turktrust.x509.Version;
import java.util.Vector;

public class TBSCertList
extends Sequence {
    private Version version = new Version("version");
    private AlgorithmIdentifier signature = new AlgorithmIdentifier("signature");
    private Name issuer = new Name("issuer");
    private Time thisUpdate = new Time("thisUpdate");
    private Time nextUpdate = new Time("nextUpdate");
    private SequenceOf revokedCertificates = new SequenceOf("revokedCertificates", new RevokedCertificate());
    private Extensions crlExtensions = new Extensions("crlExtensions");

    public TBSCertList(String name) {
        super(name);
        this.setUpElements();
    }

    protected void setUpElements() {
        super.addElement(this.version);
        this.version.setOptional(true);
        super.addElement(this.signature);
        super.addElement(this.issuer);
        super.addElement(this.thisUpdate);
        super.addElement(this.nextUpdate);
        this.nextUpdate.setOptional(true);
        super.addElement(this.revokedCertificates);
        this.revokedCertificates.setOptional(true);
        super.addElement(this.crlExtensions);
        this.crlExtensions.setOptional(true);
        this.crlExtensions.setTaggingMethod(2);
        this.crlExtensions.setTagClass((byte)-128);
        this.crlExtensions.setTagNumber(0);
    }

    public Version getversion() {
        return this.version;
    }

    public void setversion(Version value) {
        this.version = value;
    }

    public AlgorithmIdentifier getsignature() {
        return this.signature;
    }

    public void setsignature(AlgorithmIdentifier value) {
        this.signature = value;
    }

    public Name getissuer() {
        return this.issuer;
    }

    public void setissuer(Name value) {
        this.issuer = value;
    }

    public Time getthisUpdate() {
        return this.thisUpdate;
    }

    public void setthisUpdate(Time value) {
        this.thisUpdate = value;
    }

    public Time getnextUpdate() {
        return this.nextUpdate;
    }

    public void setnextUpdate(Time value) {
        this.nextUpdate = value;
    }

    public SequenceOf getrevokedCertificates() {
        return this.revokedCertificates;
    }

    public void setrevokedCertificates(SequenceOf value) {
        this.revokedCertificates = value;
    }

    public Extensions getcrlExtensions() {
        return this.crlExtensions;
    }

    public void setcrlExtensions(Extensions value) {
        this.crlExtensions = value;
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }

    public void decode(byte[] data) throws DecodeException {
        Extension authKeyIdExt;
        super.decode(data);
        String issuerCN = this.issuer.getCN();
        if (issuerCN.length() > 13 && issuerCN.substring(8, 13).equals("UEKAE") && ((Vector)this.revokedCertificates.getValue()).size() == 0 && (authKeyIdExt = this.crlExtensions.getExtensionByOID("2.5.29.35")) != null) {
            String keyIdHex = authKeyIdExt.getExplanation();
            if (keyIdHex.substring(0, 2).toUpperCase().equals("E5") && keyIdHex.substring(57, 59).toUpperCase().equals("4E")) {
                this.revokedCertificates.setOptional(false);
            }
            if (keyIdHex.substring(0, 2).toUpperCase().equals("B7") && keyIdHex.substring(57, 59).toUpperCase().equals("22")) {
                this.revokedCertificates.setOptional(false);
            }
        }
    }
}

