/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.certstore.ops;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.ItemSource;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStore;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVEN;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVTKatmani;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.JDBCUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.NotFoundException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzetTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzneTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.SILTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoDizin;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoOzet;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoSIL;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.ops.CertStoreRootCertificateOps;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.template.CRLSearchTemplate;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.util.RsItemSource;

public class CertStoreCRLOps {
    private static Logger a;
    private final CertStore b;
    private static final String[] c;
    private static final String[] d;

    public CertStoreCRLOps(CertStore aDepo) {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            a.error(CertStoreCRLOps.a(20597, 29811), (Throwable)lE);
            throw new ESYARuntimeException(CertStoreCRLOps.a(20595, 28764) + lE.getMessage(), (Throwable)lE);
        }
        this.b = aDepo;
    }

    public DepoSIL readStoreCRL(Long aSILNo) throws CertStoreException {
        if (aSILNo <= 0L) {
            throw new CertStoreException(CertStoreCRLOps.a(20578, -14022));
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            DepoSIL depoSIL = depoVEN.sILOku(aSILNo);
            return depoSIL;
        }
        catch (NotFoundException notFoundException) {
            throw new CertStoreException(aSILNo + CertStoreCRLOps.a(20577, 24072), notFoundException);
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(aSILNo + CertStoreCRLOps.a(20590, -26484), certStoreException);
        }
    }

    public void writeCRL(ECRL aCRL, Long aDizinNo) throws CertStoreException {
        this.writeCRL(aCRL.getEncoded(), aDizinNo);
    }

    public void writeCRL(byte[] aCRL, Long aDizinNo) throws CertStoreException {
        DepoSIL depoSIL = null;
        try {
            depoSIL = CertStoreUtil.asnCRLTODepoSIL(aCRL);
        }
        catch (Exception exception) {
            throw new CertStoreException(CertStoreCRLOps.a(20579, -17275), exception);
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            List<DepoOzet> list = CertStoreUtil.convertToDepoOzet(depoSIL.getValue(), OzneTipi.SIL);
            depoVEN.sILYaz(depoSIL, list, aDizinNo);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(CertStoreCRLOps.a(20589, 20283), certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemSource<DepoSIL> listStoreCRL() throws CertStoreException {
        ItemSource<DepoSIL> itemSource2;
        try {
            ItemSource<DepoSIL> itemSource;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            itemSource2 = itemSource = depoVEN.sILListele();
        }
        catch (CertStoreException certStoreException) {
            try {
                throw new CertStoreException(CertStoreCRLOps.a(20585, -24599), certStoreException);
            }
            catch (Throwable throwable) {
                try {
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException2) {
                    throw new CertStoreException(CertStoreCRLOps.a(20585, -24599), certStoreException2);
                }
            }
        }
        try {
            JDBCUtil.commit(this.b.getConn());
            return itemSource2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(CertStoreCRLOps.a(20560, -16723), certStoreException);
        }
    }

    public List<ECRL> listCRL(CRLSearchTemplate aSAS, SILTipi[] aTipler) throws CertStoreException {
        ItemSource<DepoSIL> itemSource = this.listStoreCRL(aSAS, aTipler);
        boolean bl = CertStoreRootCertificateOps.c;
        ArrayList<ECRL> arrayList = new ArrayList<ECRL>();
        try {
            DepoSIL depoSIL = (DepoSIL)itemSource.nextItem();
            while (depoSIL != null) {
                arrayList.add(new ECRL(depoSIL.getValue()));
                depoSIL = (DepoSIL)itemSource.nextItem();
                if (!bl) continue;
                break;
            }
        }
        catch (Exception exception) {
            throw new CertStoreException(exception);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemSource<DepoSIL> listStoreCRL(CRLSearchTemplate aSAS, SILTipi[] aTipler) throws CertStoreException {
        ItemSource<DepoSIL> itemSource2;
        try {
            ItemSource<DepoSIL> itemSource;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            Pair<String, List<Object>> pair = this.a(aSAS, aTipler);
            String string = (String)pair.first();
            List list = (List)pair.second();
            itemSource2 = itemSource = depoVEN.sILListele(string, list.toArray());
        }
        catch (CertStoreException certStoreException) {
            try {
                throw new CertStoreException(CertStoreCRLOps.a(20587, 24381), certStoreException);
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException2) {
                    throw new CertStoreException(CertStoreCRLOps.a(20587, 24381), certStoreException2);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return itemSource2;
            JDBCUtil.commit(this.b.getConn());
            return itemSource2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(CertStoreCRLOps.a(20602, 6235), certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DepoDizin> listCRLDirectories(long aSILNo) throws CertStoreException {
        List<DepoDizin> list2;
        if (aSILNo <= 0L) {
            throw new CertStoreException(CertStoreCRLOps.a(20588, 19931));
        }
        try {
            List<DepoDizin> list;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            list2 = list = ((RsItemSource)depoVEN.sILDizinleriniListele(aSILNo)).toList();
        }
        catch (CertStoreException certStoreException) {
            try {
                throw new CertStoreException(aSILNo + CertStoreCRLOps.a(20566, 23650), certStoreException);
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException2) {
                    throw new CertStoreException(aSILNo + CertStoreCRLOps.a(20566, 23650), certStoreException2);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return list2;
            JDBCUtil.commit(this.b.getConn());
            return list2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(aSILNo + CertStoreCRLOps.a(20599, 19148), certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteCRLFromDirectory(long aSILNo, long aDizinNo) throws CertStoreException {
        if (aSILNo <= 0L) throw new CertStoreException(CertStoreCRLOps.a(20588, 19931));
        if (aDizinNo <= 0L) {
            throw new CertStoreException(CertStoreCRLOps.a(20588, 19931));
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.dizindenSILSil(aSILNo, aDizinNo);
            JDBCUtil.commit(this.b.getConn());
            return;
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() == null) throw new CertStoreException(aSILNo + CertStoreCRLOps.a(20596, -27107) + aDizinNo + CertStoreCRLOps.a(20583, -23182), certStoreException);
            JDBCUtil.rollback(this.b.getConn());
            throw new CertStoreException(aSILNo + CertStoreCRLOps.a(20596, -27107) + aDizinNo + CertStoreCRLOps.a(20583, -23182), certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void moveCRL(long aSILNo, long aEskiDizinNo, long aYeniDizinNo) throws CertStoreException {
        if (aSILNo <= 0L) throw new CertStoreException(CertStoreCRLOps.a(20588, 19931));
        if (aEskiDizinNo <= 0L) throw new CertStoreException(CertStoreCRLOps.a(20588, 19931));
        if (aYeniDizinNo <= 0L) {
            throw new CertStoreException(CertStoreCRLOps.a(20588, 19931));
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.sILTasi(aSILNo, aEskiDizinNo, aYeniDizinNo);
            JDBCUtil.commit(this.b.getConn());
            return;
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() == null) throw new CertStoreException(aSILNo + CertStoreCRLOps.a(20600, -637) + aEskiDizinNo + CertStoreCRLOps.a(20581, -7881) + aYeniDizinNo + CertStoreCRLOps.a(20593, -15421), certStoreException);
            JDBCUtil.rollback(this.b.getConn());
            throw new CertStoreException(aSILNo + CertStoreCRLOps.a(20600, -637) + aEskiDizinNo + CertStoreCRLOps.a(20581, -7881) + aYeniDizinNo + CertStoreCRLOps.a(20593, -15421), certStoreException);
        }
    }

    public void deleteCRL(long aSILNo) throws CertStoreException {
        if (aSILNo <= 0L) {
            throw new CertStoreException(CertStoreCRLOps.a(20588, 19931));
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.sILSil(aSILNo);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(aSILNo + CertStoreCRLOps.a(20586, 4646), certStoreException);
        }
    }

    public int deleteCRL(CRLSearchTemplate aSAS) throws CertStoreException {
        Long l = aSAS.getDizinNo();
        boolean bl = CertStoreRootCertificateOps.c;
        SILTipi[] sILTipiArray = new SILTipi[]{SILTipi.BASE, SILTipi.DELTA};
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            Pair<String, List<Object>> pair = this.a(aSAS, sILTipiArray);
            String string = (String)pair.first();
            List list = (List)pair.second();
            ItemSource<DepoSIL> itemSource = depoVEN.sILListele(string, list.toArray());
            int n = 0;
            DepoSIL depoSIL = (DepoSIL)itemSource.nextItem();
            while (depoSIL != null) {
                block11: {
                    block10: {
                        if (l != null) break block10;
                        n += depoVEN.sILSil(depoSIL.getSILNo());
                        if (!bl) break block11;
                    }
                    n += depoVEN.dizindenSILSil(depoSIL.getSILNo(), l);
                }
                depoSIL = (DepoSIL)itemSource.nextItem();
                if (!bl) continue;
            }
            JDBCUtil.commit(this.b.getConn());
            return n;
        }
        catch (Exception exception) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(CertStoreCRLOps.a(20567, 30371), exception);
        }
    }

    private Pair<String, List<Object>> a(CRLSearchTemplate cRLSearchTemplate, SILTipi[] sILTipiArray) {
        ArrayList<Object> arrayList;
        boolean bl;
        StringBuffer stringBuffer;
        block38: {
            stringBuffer = new StringBuffer("");
            bl = CertStoreRootCertificateOps.c;
            arrayList = new ArrayList<Object>();
            stringBuffer.append(CertStoreCRLOps.a(20603, 32663));
            if (sILTipiArray == null || sILTipiArray.length == 0) break block38;
            stringBuffer.append(CertStoreCRLOps.a(20580, 4504));
            stringBuffer.append(CertStoreCRLOps.a(20592, 12446));
            stringBuffer.append("(");
            for (int i = 0; i < sILTipiArray.length - 1; ++i) {
                stringBuffer.append(sILTipiArray[i].getIntValue() + CertStoreCRLOps.a(20606, -4886));
                if (!bl) continue;
            }
            stringBuffer.append(sILTipiArray[sILTipiArray.length - 1].getIntValue());
            stringBuffer.append(")");
        }
        if (cRLSearchTemplate != null) {
            block41: {
                OzetTipi ozetTipi;
                block39: {
                    block40: {
                        Long l = cRLSearchTemplate.getDizinNo();
                        if (l != null) {
                            stringBuffer.append(CertStoreCRLOps.a(20584, 5495));
                            arrayList.add(l);
                        }
                        byte[] byArray = cRLSearchTemplate.getValue();
                        if (byArray != null) {
                            stringBuffer.append(CertStoreCRLOps.a(20565, 993));
                            arrayList.add(byArray);
                        }
                        byte[] byArray2 = cRLSearchTemplate.getHash();
                        ozetTipi = cRLSearchTemplate.getHashType();
                        if (byArray2 == null) break block39;
                        stringBuffer.append(CertStoreCRLOps.a(20564, 2895));
                        arrayList.add(OzneTipi.SIL.getIntValue());
                        arrayList.add(byArray2);
                        if (ozetTipi == null) break block40;
                        stringBuffer.append(CertStoreCRLOps.a(20591, 11958));
                        arrayList.add(ozetTipi.getIntValue());
                        if (!bl) break block41;
                    }
                    stringBuffer.append(CertStoreCRLOps.a(20598, -21191));
                    if (!bl) break block41;
                }
                if (ozetTipi == null) break block41;
                stringBuffer.append(CertStoreCRLOps.a(20604, -24092));
                arrayList.add(OzneTipi.SIL.getIntValue());
                arrayList.add(ozetTipi.getIntValue());
            }
            byte[] byArray = cRLSearchTemplate.getIssuer();
            if (byArray != null) {
                stringBuffer.append(CertStoreCRLOps.a(20601, 32522));
                arrayList.add(byArray);
            }
            byte[] byArray3 = cRLSearchTemplate.getSILNumber();
            if (byArray3 != null) {
                stringBuffer.append(CertStoreCRLOps.a(20582, -11044));
                arrayList.add(byArray3);
            }
            Date date = cRLSearchTemplate.getPublishedBefore();
            if (date != null) {
                stringBuffer.append(CertStoreCRLOps.a(20607, -9071));
                arrayList.add(date);
            }
            Date date2 = cRLSearchTemplate.getPublishedAfter();
            if (date2 != null) {
                stringBuffer.append(CertStoreCRLOps.a(20576, -4826));
                arrayList.add(date2);
            }
            Date date3 = cRLSearchTemplate.getValidAt();
            if (date3 != null) {
                stringBuffer.append(CertStoreCRLOps.a(20605, -7571));
                arrayList.add(date3);
                arrayList.add(date3);
            }
            byte[] byArray4 = cRLSearchTemplate.getBaseSILNumber();
            if (byArray4 != null) {
                stringBuffer.append(CertStoreCRLOps.a(20594, -25652));
                arrayList.add(byArray4);
            }
        }
        return new Pair((Object)stringBuffer.toString(), arrayList);
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[37];
                var3_1 = 0;
                var2_2 = "bT\u00c0\u00d6\u0012\u001b\u00e4%\b#\u001a\u001f8\u0092\u00b1\u00dc\b6\\l$\u00e8\u00a8\u0088k\u00cdM\u00c7\u007fX\u00c3Jw\u00e7\u0004\b\u0017\u0003}\u00e3e6\u00bf|{\u00d3e\u00bb\n1\u00d5\u00a1\u0085\u0083\u00d4\u0099\u00fc@u\u00c0{\u00de\u00d2P\u00a7\u00e5*\u00d3u,\u0013\u00c8**ijZ\u000eC\u00f3\u008b?\u00c7\u008c\u00c2\\\u0016<\u0002\u00ac&I\u00b7A\r\u0001\u000b\u00d8S\u00a9\u00cdd\u0017\u008f\u0097\u001d_pJP\u001d\u0086\u00ff\u00da>\u00ca\u00a1*\u00de\u008d\u00072s(\u0006\u00e6 \f\u00d5\u0080\u00c8\u00997Uk\u0016\u00f5\u00acN~\u00d3\u0016G\u00c7\u008b\u00ee$\u00e1\u0011\u00e8\u008e\u00bc2t\u00c7Vw\u00890\u00a0}0\u0005.\u00f6b\u009a.S\u0098v\u001e\u00a4\u00db\u00f3\u00f4\u00a6\u00d6\u00de~\u001a\u00c2\u0016\u0017\u00bf\u00a2Z\u00ea\u0011\u00d3I(\u00e0\u008c\u000f\u0019\u00cf\u00bd8\u00efe2\u00b8G=fB\u001b\u0017\u001d\u0093\u0015\u00fc\u009c2\u00ce\u00ecv\u00f8\u00e2\u008a\"\u008dd\u00cfZYgj\u00e3\u00e3\u0096\u0088E\u0004S\u00fb\\\u00d25\u00009Cy\u00a7B\u00c0~r\u00a1\u00ca\u00a2\u00f6\u00b2\u008b\u00d0\u00e6:\u00ac\u00c6\u00can\u001d^\u00c9\u00bfY\u00a0\u00a0\u00d5o\u0017\u00a0@\u0095\u00d4\u00ab\u00a22M\u0092\u0092\u0097\u0097\u00d8\u00bb\u00bc|O6T\u00b3\"9\u00b0\u00ea\u001fYh\u0004u-\u0010\u00ff\u0086\u0094\u00c9V\u00b7E\u00a5\u009b\u00c4\u00ac}\u00f78\u00f2\n)\u00a3<\u00d99a\u00bfNk>\u00bb9\u00118\u0090\u0004)\u00b2\u00af0P,\u00b8\u000e\u00fd\u00f5\u00b1\u00ba\u00fce\u00e5\u00bfn\u00f5p\u00b2\u00af,-\u008ap\u008b\u0003\u00f8\u00c9\u00dc\u0014\u0012\u00c5\u00ef\u0006\u00a7X\u0096\u0097%$Z\u00e2T\u00ee\u0089\u00e6\u0003K\u0019m\u000b\u009b\\\u00ff\u00d7\u00f5;\u0018!\u0097\u00af\u0084\u0014S\u00ac\u00c7+\u00a2\u00e0-$,;\u00bf\u001d\u00aagV\u00ed\u00f9*gA23\u00c1\u00fa\u008a\u00e3\u00de\u00b1s\u00fd\u00e2\u00d5F\u00a6|\u0092\u001b\u00d5T\u0011\u00a6]\u00d3\u00aa\u0083\u008b\u00e2T=\u00855W\u00f7\u00df\u00e5\u00a5+\u00e3\u00e7\u00fe-V\u00af\u00dc?\u0014\u0083\u00ed\u00df\u00fb\u0004\u0003\u00ab\u00bc\u0094\u00055\u00ce\u000bg;\u000fm\u009e!\u008f.0T`\u00f9\u00e6\u00f7\u00018\u0088\u00c5\u0012\u00dd\u00b7\u0016H\u0098\u0096P\u008c\u00c5\u00e6\u00c1\u0098\u009daq\u00cc\u00ed\u00afN\u0007\u00b9lk\u0087\u00aca\u00f3_\u0094#O\u00a2A\u0096\u0019X\u00c1\u00db\u00b7x\f\u00c1\u001f\u00c3\u00f7\u008d\u00a0&CF\u00ea\u0019\u00d4)\u008c\u00ef\u001e\u0099\u00ac\u009c\u00d3l\u0019\u00c0\u00b2\u00c1D3,\u00ea\u00b7\u00be\u00b7`\u008f\u000fh\u00aa;\r\u00f4/\u00a9'\u00b3\u008e+\u00cdn\u00da\b\u0013\u00b7_\u00da\u00a1\u0013\u0015\u00ae\u0095x\fU\u0019\u00c8\u00bf\u00ee!#B{\u00fald\u00bd\u0006\u0093eX#X\u00bf\u0087\u00ab\u00fa\u00b4\u00f9\u00d0\u00ab\u009dU\u000f`oo)\u00b2\u009a\u00ebw\u009e\u00e5\u00f0\u00b3\u00a2\u00da\u0016\u00dbf \u00c5\u00bb\u00e1S\u00d4*\u00fb\u00a0L \f\u0087/\u00bbD\u0010Zl\u00eb\u00bf\"\u0012\u00d1\u0094A\u00ff\u00c7\u0085N\u00d9g=\u0085\u00c1tY\u00e2\u00d5\u00dd\u00f1\u00d2\u00e2\u00e9$l\u00f5\u00a9\nD\u00ac\u00d6Ut\u0087\u00c3\u00af7\u008cd$U\u0089\u00a9i\u00f4(\u008b\u0095\u00a4\u00ddu\u00fa!\u00e9A\u0011F-\u00aa_\u00830T%\u008c6s\u00d6\u00bd\u009b\u00e0\u00f87\u00f5$'7\u0087\u00a24\u00dc1\u0015\u0006N#\r\u00e6#\r\u00be\u00ad\u00b4\u00a3\u00c3H\u00ed*\u0093-A\u0091\u00ad\u00b1\u001b}\u00c2\u00c8\u008aw\u00f1\u00dca~\u00b9\u0019LNf\u00b3z\u001f\u00e1\u00e5U\u00dan:\u00a1\u00b9\u00b5|\u00dfSH\u0012X3/\u00d2A\u00a9\u00dc\u0087H\u00b1L4\u0086>:\u00c7\u0095\u00a1\u00f4\u00f6\u008ai~f\u008a\u00f3V\u0016)l\u00f3\u00c5\u00a7\u0001\u00ba\u008f\u0010\u008e\u0088\u00fd\u001eL!\u0095\u00b4G\u00c8\u007fO\u007fRj\u00c6\u00c6V\u00aa\u00ad\u00dak\u001a\u00ba\u00c8\u00aa\u00fb\u008e\u00a6^\u00da*|-h1\u0081z:\u008e\u00e1\u0097\u00a8u,\u001cr\u00c5\u00cb\u0088\u000e\u00dbT\u0092q8\u0005`{\u00d4\u00f7\u0098\u0095\u00d6\u00f6ef\u00bd\u00ce\u0015\u001cX;\u00be\u0090k\u0096\u00e4\u00c1\u0014\u00ea\u0000\u00f0\u00beDS\u00e3s\u00b8\u00e0\u0098O \u0099\u00db\u00d6\u0019M/\u00a4=\u0082\u0086\u00fdn\u00e5R\u00ff\u00140\u00ef2\u00cb,\u0017\u0001t\u008fh\u00a4\u008b\u0003Q\f\u0080g\u00c3F\u00f1'\u00a9\u00e2\u00f3'\u00de\u00a7f<T'\u00b9\u0091Y\u008b\u00a6NT\u009c\u00b2\u00140\u00d5\u00ecrj\u0082\u00c4\u00c4}\u00fa8S*!\u00d9PSd\u0007\u00d7\u008b\u00b2\u00f7V\u00ea\u009a>\u00ea\u0016\u00e2\u00c7\rw/\u0014+\u001c\u009e\u0097&\u00acS\u00c2\u00e8\u00da\u00cc\u00d2\u0093L\u00b8\u0006s\u00af\u00c1\u00b3G\u00c9\u00b0\u00b5J\u00bc\u00881W\u00b2ms\u001d\u001f\u00a0G\u00d8\u00fe\u00a7{\u009c\u00a8M\u0084\u00d2\u00b5\u00e2\u00a7^V\u000e0y\u00b3\u00d8\u00ca\u009f\u00d0\u00e0\u000bkcgU(\u00e2\u00fbT\u000f\u0018}\u00b5@]y\u000e\u00a4y\u00d5\u00f4\n\"\u00b8\u00ca \u009d\u008b\u0004\u0003\u00a0\u0084\u00f92e\u00b60d\u00ba\u0003\u009a\u00c8\u0098\u0095y\u00a83\u00a1 \u00a0\u0083#\u00dbH\u0004\u000e\u00818\u00ee\u0095\u00f8\u00d3\u0010\u00e8\u00e5L\u0089\u0092o\u00c5\u00ba:\u00d5\u00963\u00d8p\u00d1\u0081^_d\u00adsR\f\",\u00fa\u00df\u00c0\u00b8F\u00d8\u00a5/\u0082\u008f>uQ\u0001\u00ccu\u001f9\u00c3W\u00f9\u00b5\u0089\u00f2\u00a24 \u00e6SW\u00ab\u0091\u00d8\u007f\u00b9n\u00eb\u00d4E\u00dd\u00b1o\r(d/\u00c5B\u00b3\u0090\u00cf\u00af\u008c]\u00de_\u0016\u00e2\u00c6\u00d7\u00f7\u0082S\u00ee0Ym2i\u00ca\u00baTo =\u0011d\u0014u\u00120|\u00ab1/\u00b9\u00a6i\u0003N\u0003\f\u00e4TCo\nz6\u00fc\u00bf\u0013\u00abh\u00b4\u00ab\u00d0\u00e1\u009d\u0003\u0004\u0004i\u00e6^6\u0003\u0013\u00a6\u00df_\u0006\u0004\u001e\u00ef\u00f3\u00ab\u00c3804*\u00a92vN\u00fc*\u00de\u00f3\u00b0D\u00db\u00c6\u00cc\u0018\u00b2e\u008a\u00df9\u0000\u000e";
                var4_3 = "bT\u00c0\u00d6\u0012\u001b\u00e4%\b#\u001a\u001f8\u0092\u00b1\u00dc\b6\\l$\u00e8\u00a8\u0088k\u00cdM\u00c7\u007fX\u00c3Jw\u00e7\u0004\b\u0017\u0003}\u00e3e6\u00bf|{\u00d3e\u00bb\n1\u00d5\u00a1\u0085\u0083\u00d4\u0099\u00fc@u\u00c0{\u00de\u00d2P\u00a7\u00e5*\u00d3u,\u0013\u00c8**ijZ\u000eC\u00f3\u008b?\u00c7\u008c\u00c2\\\u0016<\u0002\u00ac&I\u00b7A\r\u0001\u000b\u00d8S\u00a9\u00cdd\u0017\u008f\u0097\u001d_pJP\u001d\u0086\u00ff\u00da>\u00ca\u00a1*\u00de\u008d\u00072s(\u0006\u00e6 \f\u00d5\u0080\u00c8\u00997Uk\u0016\u00f5\u00acN~\u00d3\u0016G\u00c7\u008b\u00ee$\u00e1\u0011\u00e8\u008e\u00bc2t\u00c7Vw\u00890\u00a0}0\u0005.\u00f6b\u009a.S\u0098v\u001e\u00a4\u00db\u00f3\u00f4\u00a6\u00d6\u00de~\u001a\u00c2\u0016\u0017\u00bf\u00a2Z\u00ea\u0011\u00d3I(\u00e0\u008c\u000f\u0019\u00cf\u00bd8\u00efe2\u00b8G=fB\u001b\u0017\u001d\u0093\u0015\u00fc\u009c2\u00ce\u00ecv\u00f8\u00e2\u008a\"\u008dd\u00cfZYgj\u00e3\u00e3\u0096\u0088E\u0004S\u00fb\\\u00d25\u00009Cy\u00a7B\u00c0~r\u00a1\u00ca\u00a2\u00f6\u00b2\u008b\u00d0\u00e6:\u00ac\u00c6\u00can\u001d^\u00c9\u00bfY\u00a0\u00a0\u00d5o\u0017\u00a0@\u0095\u00d4\u00ab\u00a22M\u0092\u0092\u0097\u0097\u00d8\u00bb\u00bc|O6T\u00b3\"9\u00b0\u00ea\u001fYh\u0004u-\u0010\u00ff\u0086\u0094\u00c9V\u00b7E\u00a5\u009b\u00c4\u00ac}\u00f78\u00f2\n)\u00a3<\u00d99a\u00bfNk>\u00bb9\u00118\u0090\u0004)\u00b2\u00af0P,\u00b8\u000e\u00fd\u00f5\u00b1\u00ba\u00fce\u00e5\u00bfn\u00f5p\u00b2\u00af,-\u008ap\u008b\u0003\u00f8\u00c9\u00dc\u0014\u0012\u00c5\u00ef\u0006\u00a7X\u0096\u0097%$Z\u00e2T\u00ee\u0089\u00e6\u0003K\u0019m\u000b\u009b\\\u00ff\u00d7\u00f5;\u0018!\u0097\u00af\u0084\u0014S\u00ac\u00c7+\u00a2\u00e0-$,;\u00bf\u001d\u00aagV\u00ed\u00f9*gA23\u00c1\u00fa\u008a\u00e3\u00de\u00b1s\u00fd\u00e2\u00d5F\u00a6|\u0092\u001b\u00d5T\u0011\u00a6]\u00d3\u00aa\u0083\u008b\u00e2T=\u00855W\u00f7\u00df\u00e5\u00a5+\u00e3\u00e7\u00fe-V\u00af\u00dc?\u0014\u0083\u00ed\u00df\u00fb\u0004\u0003\u00ab\u00bc\u0094\u00055\u00ce\u000bg;\u000fm\u009e!\u008f.0T`\u00f9\u00e6\u00f7\u00018\u0088\u00c5\u0012\u00dd\u00b7\u0016H\u0098\u0096P\u008c\u00c5\u00e6\u00c1\u0098\u009daq\u00cc\u00ed\u00afN\u0007\u00b9lk\u0087\u00aca\u00f3_\u0094#O\u00a2A\u0096\u0019X\u00c1\u00db\u00b7x\f\u00c1\u001f\u00c3\u00f7\u008d\u00a0&CF\u00ea\u0019\u00d4)\u008c\u00ef\u001e\u0099\u00ac\u009c\u00d3l\u0019\u00c0\u00b2\u00c1D3,\u00ea\u00b7\u00be\u00b7`\u008f\u000fh\u00aa;\r\u00f4/\u00a9'\u00b3\u008e+\u00cdn\u00da\b\u0013\u00b7_\u00da\u00a1\u0013\u0015\u00ae\u0095x\fU\u0019\u00c8\u00bf\u00ee!#B{\u00fald\u00bd\u0006\u0093eX#X\u00bf\u0087\u00ab\u00fa\u00b4\u00f9\u00d0\u00ab\u009dU\u000f`oo)\u00b2\u009a\u00ebw\u009e\u00e5\u00f0\u00b3\u00a2\u00da\u0016\u00dbf \u00c5\u00bb\u00e1S\u00d4*\u00fb\u00a0L \f\u0087/\u00bbD\u0010Zl\u00eb\u00bf\"\u0012\u00d1\u0094A\u00ff\u00c7\u0085N\u00d9g=\u0085\u00c1tY\u00e2\u00d5\u00dd\u00f1\u00d2\u00e2\u00e9$l\u00f5\u00a9\nD\u00ac\u00d6Ut\u0087\u00c3\u00af7\u008cd$U\u0089\u00a9i\u00f4(\u008b\u0095\u00a4\u00ddu\u00fa!\u00e9A\u0011F-\u00aa_\u00830T%\u008c6s\u00d6\u00bd\u009b\u00e0\u00f87\u00f5$'7\u0087\u00a24\u00dc1\u0015\u0006N#\r\u00e6#\r\u00be\u00ad\u00b4\u00a3\u00c3H\u00ed*\u0093-A\u0091\u00ad\u00b1\u001b}\u00c2\u00c8\u008aw\u00f1\u00dca~\u00b9\u0019LNf\u00b3z\u001f\u00e1\u00e5U\u00dan:\u00a1\u00b9\u00b5|\u00dfSH\u0012X3/\u00d2A\u00a9\u00dc\u0087H\u00b1L4\u0086>:\u00c7\u0095\u00a1\u00f4\u00f6\u008ai~f\u008a\u00f3V\u0016)l\u00f3\u00c5\u00a7\u0001\u00ba\u008f\u0010\u008e\u0088\u00fd\u001eL!\u0095\u00b4G\u00c8\u007fO\u007fRj\u00c6\u00c6V\u00aa\u00ad\u00dak\u001a\u00ba\u00c8\u00aa\u00fb\u008e\u00a6^\u00da*|-h1\u0081z:\u008e\u00e1\u0097\u00a8u,\u001cr\u00c5\u00cb\u0088\u000e\u00dbT\u0092q8\u0005`{\u00d4\u00f7\u0098\u0095\u00d6\u00f6ef\u00bd\u00ce\u0015\u001cX;\u00be\u0090k\u0096\u00e4\u00c1\u0014\u00ea\u0000\u00f0\u00beDS\u00e3s\u00b8\u00e0\u0098O \u0099\u00db\u00d6\u0019M/\u00a4=\u0082\u0086\u00fdn\u00e5R\u00ff\u00140\u00ef2\u00cb,\u0017\u0001t\u008fh\u00a4\u008b\u0003Q\f\u0080g\u00c3F\u00f1'\u00a9\u00e2\u00f3'\u00de\u00a7f<T'\u00b9\u0091Y\u008b\u00a6NT\u009c\u00b2\u00140\u00d5\u00ecrj\u0082\u00c4\u00c4}\u00fa8S*!\u00d9PSd\u0007\u00d7\u008b\u00b2\u00f7V\u00ea\u009a>\u00ea\u0016\u00e2\u00c7\rw/\u0014+\u001c\u009e\u0097&\u00acS\u00c2\u00e8\u00da\u00cc\u00d2\u0093L\u00b8\u0006s\u00af\u00c1\u00b3G\u00c9\u00b0\u00b5J\u00bc\u00881W\u00b2ms\u001d\u001f\u00a0G\u00d8\u00fe\u00a7{\u009c\u00a8M\u0084\u00d2\u00b5\u00e2\u00a7^V\u000e0y\u00b3\u00d8\u00ca\u009f\u00d0\u00e0\u000bkcgU(\u00e2\u00fbT\u000f\u0018}\u00b5@]y\u000e\u00a4y\u00d5\u00f4\n\"\u00b8\u00ca \u009d\u008b\u0004\u0003\u00a0\u0084\u00f92e\u00b60d\u00ba\u0003\u009a\u00c8\u0098\u0095y\u00a83\u00a1 \u00a0\u0083#\u00dbH\u0004\u000e\u00818\u00ee\u0095\u00f8\u00d3\u0010\u00e8\u00e5L\u0089\u0092o\u00c5\u00ba:\u00d5\u00963\u00d8p\u00d1\u0081^_d\u00adsR\f\",\u00fa\u00df\u00c0\u00b8F\u00d8\u00a5/\u0082\u008f>uQ\u0001\u00ccu\u001f9\u00c3W\u00f9\u00b5\u0089\u00f2\u00a24 \u00e6SW\u00ab\u0091\u00d8\u007f\u00b9n\u00eb\u00d4E\u00dd\u00b1o\r(d/\u00c5B\u00b3\u0090\u00cf\u00af\u008c]\u00de_\u0016\u00e2\u00c6\u00d7\u00f7\u0082S\u00ee0Ym2i\u00ca\u00baTo =\u0011d\u0014u\u00120|\u00ab1/\u00b9\u00a6i\u0003N\u0003\f\u00e4TCo\nz6\u00fc\u00bf\u0013\u00abh\u00b4\u00ab\u00d0\u00e1\u009d\u0003\u0004\u0004i\u00e6^6\u0003\u0013\u00a6\u00df_\u0006\u0004\u001e\u00ef\u00f3\u00ab\u00c3804*\u00a92vN\u00fc*\u00de\u00f3\u00b0D\u00db\u00c6\u00cc\u0018\u00b2e\u008a\u00df9\u0000\u000e".length();
                var1_4 = 10;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00e9\u00f5\u00a1\f\u0088\u000e\u00dciP\u00a1`.\u0010qD\u00ba\u000frQ?-H\u00a4nP\u0018r\u00a1\u00c5{_:\u00de\u00e6\u00b0\u00e6\u00db\u00c1\u00ca\u008d\u00ae\rQ(9*+x\u0011gL\u0081\u00d2[\u0012\u00edB\u00a9\u0018V\u00ba\u001b\u00e8fLC\u0007\u0092.\u00cc>\u008d2\u00ef\u00d1\u00aa\u00b8\u00d7\u00c6s\u00d2x\u0090\u0080v\u007fa\u00a9";
                    var4_3 = "\u00e9\u00f5\u00a1\f\u0088\u000e\u00dciP\u00a1`.\u0010qD\u00ba\u000frQ?-H\u00a4nP\u0018r\u00a1\u00c5{_:\u00de\u00e6\u00b0\u00e6\u00db\u00c1\u00ca\u008d\u00ae\rQ(9*+x\u0011gL\u0081\u00d2[\u0012\u00edB\u00a9\u0018V\u00ba\u001b\u00e8fLC\u0007\u0092.\u00cc>\u008d2\u00ef\u00d1\u00aa\u00b8\u00d7\u00c6s\u00d2x\u0090\u0080v\u007fa\u00a9".length();
                    var1_4 = 45;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 71;
                            break;
                        }
                        case 1: {
                            v13 = 68;
                            break;
                        }
                        case 2: {
                            v13 = 47;
                            break;
                        }
                        case 3: {
                            v13 = 27;
                            break;
                        }
                        case 4: {
                            v13 = 24;
                            break;
                        }
                        case 5: {
                            v13 = 99;
                            break;
                        }
                        default: {
                            v13 = 45;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        CertStoreCRLOps.c = var5;
        CertStoreCRLOps.d = new String[37];
        CertStoreCRLOps.a = LoggerFactory.getLogger(CertStoreCRLOps.class);
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0x5074) & 0xFFFF;
        if (d[n3] == null) {
            int n4;
            int n5;
            char[] cArray = c[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 192;
                    break;
                }
                case 1: {
                    n5 = 115;
                    break;
                }
                case 2: {
                    n5 = 197;
                    break;
                }
                case 3: {
                    n5 = 62;
                    break;
                }
                case 4: {
                    n5 = 43;
                    break;
                }
                case 5: {
                    n5 = 36;
                    break;
                }
                case 6: {
                    n5 = 97;
                    break;
                }
                case 7: {
                    n5 = 165;
                    break;
                }
                case 8: {
                    n5 = 112;
                    break;
                }
                case 9: {
                    n5 = 69;
                    break;
                }
                case 10: {
                    n5 = 49;
                    break;
                }
                case 11: {
                    n5 = 143;
                    break;
                }
                case 12: {
                    n5 = 74;
                    break;
                }
                case 13: {
                    n5 = 193;
                    break;
                }
                case 14: {
                    n5 = 171;
                    break;
                }
                case 15: {
                    n5 = 176;
                    break;
                }
                case 16: {
                    n5 = 110;
                    break;
                }
                case 17: {
                    n5 = 208;
                    break;
                }
                case 18: {
                    n5 = 48;
                    break;
                }
                case 19: {
                    n5 = 4;
                    break;
                }
                case 20: {
                    n5 = 214;
                    break;
                }
                case 21: {
                    n5 = 8;
                    break;
                }
                case 22: {
                    n5 = 44;
                    break;
                }
                case 23: {
                    n5 = 140;
                    break;
                }
                case 24: {
                    n5 = 73;
                    break;
                }
                case 25: {
                    n5 = 251;
                    break;
                }
                case 26: {
                    n5 = 30;
                    break;
                }
                case 27: {
                    n5 = 96;
                    break;
                }
                case 28: {
                    n5 = 32;
                    break;
                }
                case 29: {
                    n5 = 175;
                    break;
                }
                case 30: {
                    n5 = 255;
                    break;
                }
                case 31: {
                    n5 = 201;
                    break;
                }
                case 32: {
                    n5 = 190;
                    break;
                }
                case 33: {
                    n5 = 7;
                    break;
                }
                case 34: {
                    n5 = 204;
                    break;
                }
                case 35: {
                    n5 = 152;
                    break;
                }
                case 36: {
                    n5 = 25;
                    break;
                }
                case 37: {
                    n5 = 24;
                    break;
                }
                case 38: {
                    n5 = 14;
                    break;
                }
                case 39: {
                    n5 = 123;
                    break;
                }
                case 40: {
                    n5 = 180;
                    break;
                }
                case 41: {
                    n5 = 40;
                    break;
                }
                case 42: {
                    n5 = 45;
                    break;
                }
                case 43: {
                    n5 = 84;
                    break;
                }
                case 44: {
                    n5 = 22;
                    break;
                }
                case 45: {
                    n5 = 187;
                    break;
                }
                case 46: {
                    n5 = 157;
                    break;
                }
                case 47: {
                    n5 = 125;
                    break;
                }
                case 48: {
                    n5 = 178;
                    break;
                }
                case 49: {
                    n5 = 239;
                    break;
                }
                case 50: {
                    n5 = 63;
                    break;
                }
                case 51: {
                    n5 = 15;
                    break;
                }
                case 52: {
                    n5 = 234;
                    break;
                }
                case 53: {
                    n5 = 211;
                    break;
                }
                case 54: {
                    n5 = 220;
                    break;
                }
                case 55: {
                    n5 = 248;
                    break;
                }
                case 56: {
                    n5 = 10;
                    break;
                }
                case 57: {
                    n5 = 241;
                    break;
                }
                case 58: {
                    n5 = 31;
                    break;
                }
                case 59: {
                    n5 = 148;
                    break;
                }
                case 60: {
                    n5 = 99;
                    break;
                }
                case 61: {
                    n5 = 195;
                    break;
                }
                case 62: {
                    n5 = 124;
                    break;
                }
                case 63: {
                    n5 = 104;
                    break;
                }
                case 64: {
                    n5 = 18;
                    break;
                }
                case 65: {
                    n5 = 245;
                    break;
                }
                case 66: {
                    n5 = 155;
                    break;
                }
                case 67: {
                    n5 = 218;
                    break;
                }
                case 68: {
                    n5 = 229;
                    break;
                }
                case 69: {
                    n5 = 132;
                    break;
                }
                case 70: {
                    n5 = 203;
                    break;
                }
                case 71: {
                    n5 = 170;
                    break;
                }
                case 72: {
                    n5 = 101;
                    break;
                }
                case 73: {
                    n5 = 231;
                    break;
                }
                case 74: {
                    n5 = 113;
                    break;
                }
                case 75: {
                    n5 = 228;
                    break;
                }
                case 76: {
                    n5 = 196;
                    break;
                }
                case 77: {
                    n5 = 29;
                    break;
                }
                case 78: {
                    n5 = 235;
                    break;
                }
                case 79: {
                    n5 = 103;
                    break;
                }
                case 80: {
                    n5 = 64;
                    break;
                }
                case 81: {
                    n5 = 205;
                    break;
                }
                case 82: {
                    n5 = 134;
                    break;
                }
                case 83: {
                    n5 = 86;
                    break;
                }
                case 84: {
                    n5 = 35;
                    break;
                }
                case 85: {
                    n5 = 28;
                    break;
                }
                case 86: {
                    n5 = 122;
                    break;
                }
                case 87: {
                    n5 = 136;
                    break;
                }
                case 88: {
                    n5 = 95;
                    break;
                }
                case 89: {
                    n5 = 6;
                    break;
                }
                case 90: {
                    n5 = 174;
                    break;
                }
                case 91: {
                    n5 = 173;
                    break;
                }
                case 92: {
                    n5 = 85;
                    break;
                }
                case 93: {
                    n5 = 127;
                    break;
                }
                case 94: {
                    n5 = 78;
                    break;
                }
                case 95: {
                    n5 = 185;
                    break;
                }
                case 96: {
                    n5 = 53;
                    break;
                }
                case 97: {
                    n5 = 215;
                    break;
                }
                case 98: {
                    n5 = 149;
                    break;
                }
                case 99: {
                    n5 = 20;
                    break;
                }
                case 100: {
                    n5 = 145;
                    break;
                }
                case 101: {
                    n5 = 209;
                    break;
                }
                case 102: {
                    n5 = 183;
                    break;
                }
                case 103: {
                    n5 = 19;
                    break;
                }
                case 104: {
                    n5 = 21;
                    break;
                }
                case 105: {
                    n5 = 162;
                    break;
                }
                case 106: {
                    n5 = 253;
                    break;
                }
                case 107: {
                    n5 = 240;
                    break;
                }
                case 108: {
                    n5 = 117;
                    break;
                }
                case 109: {
                    n5 = 76;
                    break;
                }
                case 110: {
                    n5 = 1;
                    break;
                }
                case 111: {
                    n5 = 227;
                    break;
                }
                case 112: {
                    n5 = 67;
                    break;
                }
                case 113: {
                    n5 = 33;
                    break;
                }
                case 114: {
                    n5 = 70;
                    break;
                }
                case 115: {
                    n5 = 194;
                    break;
                }
                case 116: {
                    n5 = 52;
                    break;
                }
                case 117: {
                    n5 = 222;
                    break;
                }
                case 118: {
                    n5 = 38;
                    break;
                }
                case 119: {
                    n5 = 138;
                    break;
                }
                case 120: {
                    n5 = 100;
                    break;
                }
                case 121: {
                    n5 = 17;
                    break;
                }
                case 122: {
                    n5 = 200;
                    break;
                }
                case 123: {
                    n5 = 191;
                    break;
                }
                case 124: {
                    n5 = 216;
                    break;
                }
                case 125: {
                    n5 = 207;
                    break;
                }
                case 126: {
                    n5 = 59;
                    break;
                }
                case 127: {
                    n5 = 61;
                    break;
                }
                case 128: {
                    n5 = 153;
                    break;
                }
                case 129: {
                    n5 = 54;
                    break;
                }
                case 130: {
                    n5 = 246;
                    break;
                }
                case 131: {
                    n5 = 66;
                    break;
                }
                case 132: {
                    n5 = 254;
                    break;
                }
                case 133: {
                    n5 = 213;
                    break;
                }
                case 134: {
                    n5 = 119;
                    break;
                }
                case 135: {
                    n5 = 252;
                    break;
                }
                case 136: {
                    n5 = 224;
                    break;
                }
                case 137: {
                    n5 = 23;
                    break;
                }
                case 138: {
                    n5 = 154;
                    break;
                }
                case 139: {
                    n5 = 202;
                    break;
                }
                case 140: {
                    n5 = 68;
                    break;
                }
                case 141: {
                    n5 = 137;
                    break;
                }
                case 142: {
                    n5 = 120;
                    break;
                }
                case 143: {
                    n5 = 12;
                    break;
                }
                case 144: {
                    n5 = 181;
                    break;
                }
                case 145: {
                    n5 = 37;
                    break;
                }
                case 146: {
                    n5 = 108;
                    break;
                }
                case 147: {
                    n5 = 247;
                    break;
                }
                case 148: {
                    n5 = 250;
                    break;
                }
                case 149: {
                    n5 = 161;
                    break;
                }
                case 150: {
                    n5 = 168;
                    break;
                }
                case 151: {
                    n5 = 114;
                    break;
                }
                case 152: {
                    n5 = 98;
                    break;
                }
                case 153: {
                    n5 = 55;
                    break;
                }
                case 154: {
                    n5 = 34;
                    break;
                }
                case 155: {
                    n5 = 159;
                    break;
                }
                case 156: {
                    n5 = 26;
                    break;
                }
                case 157: {
                    n5 = 130;
                    break;
                }
                case 158: {
                    n5 = 92;
                    break;
                }
                case 159: {
                    n5 = 210;
                    break;
                }
                case 160: {
                    n5 = 111;
                    break;
                }
                case 161: {
                    n5 = 58;
                    break;
                }
                case 162: {
                    n5 = 238;
                    break;
                }
                case 163: {
                    n5 = 226;
                    break;
                }
                case 164: {
                    n5 = 158;
                    break;
                }
                case 165: {
                    n5 = 233;
                    break;
                }
                case 166: {
                    n5 = 56;
                    break;
                }
                case 167: {
                    n5 = 82;
                    break;
                }
                case 168: {
                    n5 = 160;
                    break;
                }
                case 169: {
                    n5 = 206;
                    break;
                }
                case 170: {
                    n5 = 89;
                    break;
                }
                case 171: {
                    n5 = 182;
                    break;
                }
                case 172: {
                    n5 = 0;
                    break;
                }
                case 173: {
                    n5 = 41;
                    break;
                }
                case 174: {
                    n5 = 166;
                    break;
                }
                case 175: {
                    n5 = 106;
                    break;
                }
                case 176: {
                    n5 = 11;
                    break;
                }
                case 177: {
                    n5 = 223;
                    break;
                }
                case 178: {
                    n5 = 142;
                    break;
                }
                case 179: {
                    n5 = 237;
                    break;
                }
                case 180: {
                    n5 = 164;
                    break;
                }
                case 181: {
                    n5 = 57;
                    break;
                }
                case 182: {
                    n5 = 42;
                    break;
                }
                case 183: {
                    n5 = 172;
                    break;
                }
                case 184: {
                    n5 = 141;
                    break;
                }
                case 185: {
                    n5 = 46;
                    break;
                }
                case 186: {
                    n5 = 77;
                    break;
                }
                case 187: {
                    n5 = 199;
                    break;
                }
                case 188: {
                    n5 = 72;
                    break;
                }
                case 189: {
                    n5 = 225;
                    break;
                }
                case 190: {
                    n5 = 88;
                    break;
                }
                case 191: {
                    n5 = 75;
                    break;
                }
                case 192: {
                    n5 = 179;
                    break;
                }
                case 193: {
                    n5 = 129;
                    break;
                }
                case 194: {
                    n5 = 151;
                    break;
                }
                case 195: {
                    n5 = 188;
                    break;
                }
                case 196: {
                    n5 = 128;
                    break;
                }
                case 197: {
                    n5 = 146;
                    break;
                }
                case 198: {
                    n5 = 3;
                    break;
                }
                case 199: {
                    n5 = 51;
                    break;
                }
                case 200: {
                    n5 = 232;
                    break;
                }
                case 201: {
                    n5 = 150;
                    break;
                }
                case 202: {
                    n5 = 177;
                    break;
                }
                case 203: {
                    n5 = 221;
                    break;
                }
                case 204: {
                    n5 = 116;
                    break;
                }
                case 205: {
                    n5 = 167;
                    break;
                }
                case 206: {
                    n5 = 2;
                    break;
                }
                case 207: {
                    n5 = 47;
                    break;
                }
                case 208: {
                    n5 = 71;
                    break;
                }
                case 209: {
                    n5 = 242;
                    break;
                }
                case 210: {
                    n5 = 144;
                    break;
                }
                case 211: {
                    n5 = 212;
                    break;
                }
                case 212: {
                    n5 = 65;
                    break;
                }
                case 213: {
                    n5 = 60;
                    break;
                }
                case 214: {
                    n5 = 133;
                    break;
                }
                case 215: {
                    n5 = 90;
                    break;
                }
                case 216: {
                    n5 = 249;
                    break;
                }
                case 217: {
                    n5 = 83;
                    break;
                }
                case 218: {
                    n5 = 5;
                    break;
                }
                case 219: {
                    n5 = 9;
                    break;
                }
                case 220: {
                    n5 = 135;
                    break;
                }
                case 221: {
                    n5 = 236;
                    break;
                }
                case 222: {
                    n5 = 27;
                    break;
                }
                case 223: {
                    n5 = 105;
                    break;
                }
                case 224: {
                    n5 = 198;
                    break;
                }
                case 225: {
                    n5 = 50;
                    break;
                }
                case 226: {
                    n5 = 230;
                    break;
                }
                case 227: {
                    n5 = 13;
                    break;
                }
                case 228: {
                    n5 = 169;
                    break;
                }
                case 229: {
                    n5 = 217;
                    break;
                }
                case 230: {
                    n5 = 87;
                    break;
                }
                case 231: {
                    n5 = 80;
                    break;
                }
                case 232: {
                    n5 = 121;
                    break;
                }
                case 233: {
                    n5 = 93;
                    break;
                }
                case 234: {
                    n5 = 189;
                    break;
                }
                case 235: {
                    n5 = 219;
                    break;
                }
                case 236: {
                    n5 = 186;
                    break;
                }
                case 237: {
                    n5 = 107;
                    break;
                }
                case 238: {
                    n5 = 126;
                    break;
                }
                case 239: {
                    n5 = 16;
                    break;
                }
                case 240: {
                    n5 = 109;
                    break;
                }
                case 241: {
                    n5 = 163;
                    break;
                }
                case 242: {
                    n5 = 81;
                    break;
                }
                case 243: {
                    n5 = 131;
                    break;
                }
                case 244: {
                    n5 = 156;
                    break;
                }
                case 245: {
                    n5 = 79;
                    break;
                }
                case 246: {
                    n5 = 91;
                    break;
                }
                case 247: {
                    n5 = 184;
                    break;
                }
                case 248: {
                    n5 = 244;
                    break;
                }
                case 249: {
                    n5 = 147;
                    break;
                }
                case 250: {
                    n5 = 118;
                    break;
                }
                case 251: {
                    n5 = 94;
                    break;
                }
                case 252: {
                    n5 = 243;
                    break;
                }
                case 253: {
                    n5 = 139;
                    break;
                }
                case 254: {
                    n5 = 39;
                    break;
                }
                default: {
                    n5 = 102;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            CertStoreCRLOps.d[n3] = new String(cArray).intern();
        }
        return d[n3];
    }
}

