/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.certstore.ops;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStore;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVEN;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVTKatmani;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.JDBCUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.GuvenlikSeviyesi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzetTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzneTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.SertifikaTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoKokSertifika;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoOzet;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoSilinecekKokSertifika;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.template.CertificateSearchTemplate;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.template.KeyUsageSearchTemplate;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.util.RsItemSource;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNEklenecekKokSertifika;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNImza;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNImzalar;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNKokSertifika;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNKokSertifikalar;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNRawImza;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNSilinecekKokSertifika;
import tr.gov.tubitak.uekae.esya.asn.x509.Certificate;

public class CertStoreRootCertificateOps {
    private static Logger a;
    private final CertStore b;
    public static boolean c;
    private static final String[] d;
    private static final String[] e;

    public CertStoreRootCertificateOps(CertStore aDepo) {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            a.error(CertStoreRootCertificateOps.a(22200, 24220));
            throw new ESYARuntimeException(CertStoreRootCertificateOps.a(22183, -23944) + lE.getMessage());
        }
        this.b = aDepo;
    }

    public void deleteRootCertificate(long aKokNo) throws CertStoreException {
        if (aKokNo <= 0L) {
            throw new CertStoreException(CertStoreRootCertificateOps.a(22206, -30795));
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.kokSertifikaSil(aKokNo);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(aKokNo + CertStoreRootCertificateOps.a(22198, 7905), certStoreException);
        }
    }

    public byte[] createRootCertificatesTobeSigned(List<Certificate> aEklenecekList, List<SertifikaTipi> aTipler, List<GuvenlikSeviyesi> aSeviyeler, List<Certificate> aSilinecekList) throws CertStoreException, Asn1Exception {
        byte[] byArray;
        block13: {
            boolean bl;
            block15: {
                block14: {
                    DepoASNKokSertifika depoASNKokSertifika;
                    int n;
                    int n2;
                    boolean bl2;
                    int n3;
                    block12: {
                        n3 = 0;
                        bl2 = c;
                        int n4 = 0;
                        int n5 = 0;
                        n2 = 0;
                        if (aEklenecekList != null) {
                            n3 = aEklenecekList.size();
                            n4 = aTipler.size();
                            n5 = aSeviyeler.size();
                        }
                        if (aSilinecekList != null) {
                            n2 = aSilinecekList.size();
                        }
                        if (n3 == n4 && n4 == n5) break block12;
                        throw new CertStoreException(CertStoreRootCertificateOps.a(22145, -17432));
                    }
                    DepoASNKokSertifikalar depoASNKokSertifikalar = new DepoASNKokSertifikalar();
                    depoASNKokSertifikalar.elements = new DepoASNKokSertifika[n3 + n2];
                    for (n = 0; n < n3; ++n) {
                        DepoASNKokSertifika depoASNKokSertifika2 = new DepoASNKokSertifika();
                        depoASNKokSertifika = CertStoreUtil.asnCertTOAsnEklenecek(aEklenecekList.get(n), aTipler.get(n), aSeviyeler.get(n));
                        depoASNKokSertifika2.set_eklenecekSertifika((DepoASNEklenecekKokSertifika)depoASNKokSertifika);
                        depoASNKokSertifikalar.elements[n] = depoASNKokSertifika2;
                        if (!bl2) continue;
                    }
                    for (int i = 0; i < n2; ++i) {
                        depoASNKokSertifika = new DepoASNKokSertifika();
                        DepoASNSilinecekKokSertifika depoASNSilinecekKokSertifika = CertStoreUtil.asnCertTOAsnSilinecek(aSilinecekList.get(i));
                        depoASNKokSertifika.set_silinecekSertifika(depoASNSilinecekKokSertifika);
                        depoASNKokSertifikalar.elements[n] = depoASNKokSertifika;
                        ++n;
                        if (!bl2) continue;
                    }
                    Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
                    depoASNKokSertifikalar.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
                    byArray = asn1DerEncodeBuffer.getMsgCopy();
                    if (CertStoreException.b == 0) break block13;
                    if (!bl2) break block14;
                    bl = false;
                    break block15;
                }
                bl = true;
            }
            c = bl;
        }
        return byArray;
    }

    public void addPersonalRootCertificate(Certificate aCert, SertifikaTipi aTip) throws CertStoreException {
        DepoKokSertifika depoKokSertifika = CertStoreUtil.asnCertTODepoEklenecek(aCert);
        depoKokSertifika.setKokTipi(aTip);
        depoKokSertifika.setKokGuvenSeviyesi(GuvenlikSeviyesi.PERSONAL);
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            List<DepoOzet> list = CertStoreUtil.convertToDepoOzet(depoKokSertifika.getValue(), OzneTipi.KOK_SERTIFIKA);
            depoVEN.kokSertifikaYaz(depoKokSertifika, list);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(CertStoreRootCertificateOps.a(22150, -11446), certStoreException);
        }
    }

    public boolean verifySignature(DepoKokSertifika aKok) throws CertStoreException {
        boolean bl = CertStoreUtil.verifyDepoKokSertifika(aKok);
        if (!bl) {
            this.deleteRootCertificate(aKok.getKokSertifikaNo());
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DepoKokSertifika> listStoreRootCertificates() throws CertStoreException {
        boolean bl = c;
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            List list = ((RsItemSource)depoVEN.kokSertifikaListele()).toList();
            ArrayList<DepoKokSertifika> arrayList = new ArrayList<DepoKokSertifika>();
            for (DepoKokSertifika depoKokSertifika : list) {
                block9: {
                    try {
                        boolean bl2 = CertStoreUtil.verifyDepoKokSertifika(depoKokSertifika);
                        if (bl2) {
                            arrayList.add(depoKokSertifika);
                            if (!bl) break block9;
                        }
                        depoVEN.kokSertifikaSil(depoKokSertifika.getKokSertifikaNo());
                    }
                    catch (Exception exception) {
                        a.error(CertStoreRootCertificateOps.a(22147, -28178), (Throwable)exception);
                    }
                }
                if (!bl) continue;
            }
            JDBCUtil.commit(this.b.getConn());
            return arrayList;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(CertStoreRootCertificateOps.a(22199, -7528), certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DepoKokSertifika> listStoreRootCertificates(CertificateSearchTemplate aSAS, SertifikaTipi[] aTipler, GuvenlikSeviyesi[] aSeviyeler) throws CertStoreException {
        boolean bl = c;
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            Pair<String, List<Object>> pair = this.a(aSAS, aTipler, aSeviyeler);
            String string = (String)pair.first();
            List list = (List)pair.second();
            List list2 = ((RsItemSource)depoVEN.kokSertifikaListele(string, list.toArray())).toList();
            ArrayList<DepoKokSertifika> arrayList = new ArrayList<DepoKokSertifika>();
            for (DepoKokSertifika depoKokSertifika : list2) {
                block9: {
                    try {
                        boolean bl2 = CertStoreUtil.verifyDepoKokSertifika(depoKokSertifika);
                        if (bl2) {
                            arrayList.add(depoKokSertifika);
                            if (!bl) break block9;
                        }
                        depoVEN.kokSertifikaSil(depoKokSertifika.getKokSertifikaNo());
                    }
                    catch (Exception exception) {
                        a.error(CertStoreRootCertificateOps.a(22144, -8918), (Throwable)exception);
                    }
                }
                if (!bl) continue;
            }
            JDBCUtil.commit(this.b.getConn());
            return arrayList;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(CertStoreRootCertificateOps.a(22190, -7886), certStoreException);
        }
    }

    public void addSignedRootCertificates(byte[] aImzaliKokSertifikalar) throws CertStoreException {
        boolean bl = c;
        try {
            Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(aImzaliKokSertifikalar);
            DepoASNImzalar depoASNImzalar = new DepoASNImzalar();
            depoASNImzalar.decode((Asn1BerDecodeBuffer)asn1DerDecodeBuffer);
            DepoASNImza[] depoASNImzaArray = depoASNImzalar.elements;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            for (DepoASNImza depoASNImza : depoASNImzaArray) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                int n;
                DepoASNKokSertifika depoASNKokSertifika;
                block23: {
                    byte[] byArray = null;
                    depoASNKokSertifika = depoASNImza.imzalanan;
                    n = depoASNKokSertifika.getChoiceID();
                    DepoASNRawImza depoASNRawImza = depoASNImza.imza;
                    object6 = new Asn1DerEncodeBuffer();
                    depoASNRawImza.encode((Asn1BerEncodeBuffer)object6);
                    object5 = object6.getMsgCopy();
                    object4 = new Asn1DerEncodeBuffer();
                    depoASNKokSertifika.encode((Asn1BerEncodeBuffer)object4);
                    byArray = object4.getMsgCopy();
                    boolean bl2 = false;
                    try {
                        bl2 = CertStoreUtil.verifyEncodedRootCertificate(byArray, depoASNRawImza);
                    }
                    catch (Exception exception) {
                        a.error(CertStoreRootCertificateOps.a(22188, -219), (Throwable)exception);
                        if (!bl) continue;
                    }
                    if (bl2) break block23;
                    try {
                        object3 = null;
                        if (n == 1) {
                            object2 = (DepoASNEklenecekKokSertifika)depoASNKokSertifika.getElement();
                            object3 = ((DepoASNEklenecekKokSertifika)object2).kokSertifikaValue.value;
                        } else if (n == 2) {
                            object2 = (DepoASNSilinecekKokSertifika)depoASNKokSertifika.getElement();
                            object3 = ((DepoASNSilinecekKokSertifika)object2).kokSertifikaValue.value;
                        }
                        object2 = new ECertificate((byte[])object3);
                        object = object2.getSerialNumberHex();
                        String string = object2.getSubject().stringValue();
                        a.error(CertStoreRootCertificateOps.a(22179, 9249) + (String)object + CertStoreRootCertificateOps.a(22148, -28578) + string + CertStoreRootCertificateOps.a(22196, 11821));
                        continue;
                    }
                    catch (Exception exception) {
                        a.error(CertStoreRootCertificateOps.a(22176, -13338), (Throwable)exception);
                        if (!bl) continue;
                    }
                }
                try {
                    if (n == 1) {
                        object3 = (DepoASNEklenecekKokSertifika)depoASNKokSertifika.getElement();
                        object2 = CertStoreUtil.asnEklenecekTODepoKok(object3);
                        ((DepoKokSertifika)object2).setSatirImzasi((byte[])object5);
                        object = CertStoreUtil.convertToDepoOzet(((DepoKokSertifika)object2).getValue(), OzneTipi.KOK_SERTIFIKA);
                        depoVEN.kokSertifikaYaz((DepoKokSertifika)object2, (List<DepoOzet>)object);
                    }
                    if (n != 2) continue;
                    object3 = (DepoASNSilinecekKokSertifika)depoASNKokSertifika.getElement();
                    object2 = CertStoreUtil.asnSilinecekToDepoSilinecek((DepoASNSilinecekKokSertifika)object3);
                    ((DepoSilinecekKokSertifika)object2).setSatirImzasi((byte[])object5);
                    depoVEN.silinecekKokSertifikaYaz((DepoSilinecekKokSertifika)object2);
                    continue;
                }
                catch (Exception exception) {
                    try {
                        object6 = null;
                        if (n == 1) {
                            object5 = (DepoASNEklenecekKokSertifika)depoASNKokSertifika.getElement();
                            object6 = object5.kokSertifikaValue.value;
                        } else if (n == 2) {
                            object5 = (DepoASNSilinecekKokSertifika)depoASNKokSertifika.getElement();
                            object6 = object5.kokSertifikaValue.value;
                        }
                        object5 = new ECertificate((byte[])object6);
                        object4 = object5.getSerialNumberHex();
                        String string = object5.getSubject().stringValue();
                        a.error(CertStoreRootCertificateOps.a(22146, -22550) + (String)object4 + CertStoreRootCertificateOps.a(22203, 3885) + string + CertStoreRootCertificateOps.a(22197, 19194), (Throwable)exception);
                        continue;
                    }
                    catch (Exception exception2) {
                        a.error(CertStoreRootCertificateOps.a(22177, 19664), (Throwable)exception2);
                    }
                }
                if (!bl) continue;
            }
            JDBCUtil.commit(this.b.getConn());
        }
        catch (Exception exception) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            a.error(CertStoreRootCertificateOps.a(22149, 27324), (Throwable)exception);
            throw new CertStoreException(CertStoreRootCertificateOps.a(22181, -15102), exception);
        }
    }

    private Pair<String, List<Object>> a(CertificateSearchTemplate certificateSearchTemplate, SertifikaTipi[] sertifikaTipiArray, GuvenlikSeviyesi[] guvenlikSeviyesiArray) {
        ArrayList<Object> arrayList;
        StringBuffer stringBuffer;
        block39: {
            boolean bl;
            block38: {
                stringBuffer = new StringBuffer("");
                arrayList = new ArrayList<Object>();
                stringBuffer.append(CertStoreRootCertificateOps.a(22195, -6690));
                bl = c;
                if (certificateSearchTemplate != null) {
                    block37: {
                        OzetTipi ozetTipi;
                        block35: {
                            block36: {
                                byte[] byArray = certificateSearchTemplate.getValue();
                                if (byArray != null) {
                                    stringBuffer.append(CertStoreRootCertificateOps.a(22192, -12886));
                                    arrayList.add(byArray);
                                }
                                byte[] byArray2 = certificateSearchTemplate.getHash();
                                ozetTipi = certificateSearchTemplate.getHashType();
                                if (byArray2 == null) break block35;
                                stringBuffer.append(CertStoreRootCertificateOps.a(22194, -28509));
                                arrayList.add(OzneTipi.KOK_SERTIFIKA.getIntValue());
                                arrayList.add(byArray2);
                                if (ozetTipi == null) break block36;
                                stringBuffer.append(CertStoreRootCertificateOps.a(22191, -1773));
                                arrayList.add(ozetTipi.getIntValue());
                                if (!bl) break block37;
                            }
                            stringBuffer.append(CertStoreRootCertificateOps.a(22187, 27330));
                            if (!bl) break block37;
                        }
                        if (ozetTipi == null) break block37;
                        stringBuffer.append(CertStoreRootCertificateOps.a(22182, 13949));
                        arrayList.add(OzneTipi.KOK_SERTIFIKA.getIntValue());
                        arrayList.add(ozetTipi.getIntValue());
                    }
                    byte[] byArray = certificateSearchTemplate.getIssuer();
                    if (byArray != null) {
                        stringBuffer.append(CertStoreRootCertificateOps.a(22204, -27192));
                        arrayList.add(byArray);
                    }
                    byte[] byArray3 = certificateSearchTemplate.getSubject();
                    if (byArray3 != null) {
                        stringBuffer.append(CertStoreRootCertificateOps.a(22180, 19694));
                        arrayList.add(byArray3);
                    }
                    byte[] byArray4 = certificateSearchTemplate.getSerialNumber();
                    if (byArray4 != null) {
                        stringBuffer.append(CertStoreRootCertificateOps.a(22186, -3471));
                        arrayList.add(byArray4);
                    }
                    byte[] byArray5 = certificateSearchTemplate.getSubjectKeyID();
                    if (byArray5 != null) {
                        stringBuffer.append(CertStoreRootCertificateOps.a(22205, -11372));
                        arrayList.add(byArray5);
                    }
                    KeyUsageSearchTemplate keyUsageSearchTemplate = certificateSearchTemplate.getAnahtarKullanim();
                    if (keyUsageSearchTemplate != null) {
                        stringBuffer.append(CertStoreRootCertificateOps.a(22193, -1944));
                        arrayList.add(keyUsageSearchTemplate.sorguOlustur());
                    }
                }
                if (sertifikaTipiArray == null || sertifikaTipiArray.length == 0) break block38;
                stringBuffer.append(CertStoreRootCertificateOps.a(22185, 22362));
                stringBuffer.append(CertStoreRootCertificateOps.a(22202, 24222));
                for (int i = 0; i < sertifikaTipiArray.length - 1; ++i) {
                    stringBuffer.append(sertifikaTipiArray[i].getIntValue() + CertStoreRootCertificateOps.a(22178, -6999));
                    if (!bl) continue;
                }
                stringBuffer.append(sertifikaTipiArray[sertifikaTipiArray.length - 1].getIntValue() + CertStoreRootCertificateOps.a(22189, -7777));
            }
            if (guvenlikSeviyesiArray == null || guvenlikSeviyesiArray.length == 0) break block39;
            stringBuffer.append(CertStoreRootCertificateOps.a(22151, 13387));
            stringBuffer.append(CertStoreRootCertificateOps.a(22184, -27499));
            for (int i = 0; i < guvenlikSeviyesiArray.length - 1; ++i) {
                stringBuffer.append(guvenlikSeviyesiArray[i].getIntValue() + CertStoreRootCertificateOps.a(22201, 30952));
                if (!bl) continue;
            }
            stringBuffer.append(guvenlikSeviyesiArray[guvenlikSeviyesiArray.length - 1].getIntValue() + CertStoreRootCertificateOps.a(22207, -29463));
        }
        return new Pair((Object)stringBuffer.toString(), arrayList);
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[40];
                var3_1 = 0;
                var2_2 = "HN\u0013\u00cb\u00fd\u001e\u001b\u001d\u00ba\u001c\u000f9\u0090nJ2\u0003\u0090\u0084\u0016S\u00ae+\u00cfgf\u008bh\u008f\u00d4j\u00c2\u00f7)\u00b7x@)\u0084\u00a8\u00be\u00d2|\u0089\u00e0/\u008f:\u00b9X\u0080a\u009fy\u0099\u0017k\u001d\u00acM\u000f\u00c7\u0098\u0007\u00ceE\u0019\u00e1\u00cc\u0097\u00eb\u00c4\u00dd\u00fdjrc-\u00ab9\u00fb \u0019G\u00d27\u0018fMh\u00ed@\u008f\u0014w\f\u0089k\u00ca1}<B\u00e0V\u00fc\u0010\u0085\u0000/gA\u0012\u00f1\u00d9f\u0081\u00bdy\u00ea\u0099{\u00bf\u00e2\u00d9\u009b\u0090\u00a0}\n<\u009e\u00cf\u00ccN\u00f3F+\u00a2]\fT@d\u0092\u00e2+\u00a2\u00bc\u00db\u00c4C\u008b\u00b7 H\u00ca\u0086;\u00b7\u00c4?\u0084\u00ac\u008e\u0006\u000e\u0088\u00de\u00a6\u00fdX4\n\u00c0\u0017m\u00c3\u009d\u001e\u00ec\u0083\u000b\u00c6\u00ee^\u00d5\u00acf`z\u001bc9\u00da\u00a1\u00eeI;\u0081\u00beX\u0082\u001c\u0086\u00b6\u00f9\u0085\u0086VK\u00a5cN\u00b1\u00e4\u00f20\b\\\u00cc\u00cf\u00f3w\u001f*\u00ed\u00f2\u00da\u0019\u00b3X`\u00f2\u00ff\r\u00daJ\u00bf\u00adY\u0001\u00f9\u008f\u00eb_K&1\u00ef-\u00cf%v\u008aT~\u00cb\u00f9\u0018\u00b8\u0010\b\u00c5\u0087\u00b7S\u00a7.3A\ns\u0094\u0085\u00cf\u00abo\u0017\b\u00e8\t<BN\u00cb\u00c4\u008c\u0085\u0000j7I\u00dc\u0085\u00f5r\u00e4\u0099\u00ae\u00b5Z\u00e9\u0080\u00d0\u00dc\u00ee<\u00be\u00c0C\u00cba\u00f7+\u00e4g\u0003\u008b\u00c4\u0080A})\u001c'\u0089\u0087\u00f6lP\u008al^\u007f\u00ca\u0082\u00b0\u00d7\u009f?eP4\u0085\u0000\u00d7\u00a8\u0001\u0004\fl~\u00a9\"\u00cf\u0086\u00d4\u00e0s\u0006c\u00f75\u00bb\u0014\u009d\u001b\u00f4\u00f5\u00fb,s+\u00f9\u0082k\u00c0I\u00a9\u00ca\u00f9Q\u0014\u00c8>\rV\u00ca\u00d7\u000b\u00cd\u00c4\u0089\u00fen\u0099RX\u00ea\u00b4\u00be\u009d\u0096\u00e2e\u009c#1D\u0017a\u0087F~\u00a9\u000b;\u00d6\u0000\u008d\u00f8\u00c6\u0017\u00f9\u0081\u00ec\u00ab\u00d4\u009b9\u00e2\u00fdk\u0003+\u00dfh\u0019\"\u00e5.2\u00a4\u0082\u009a\u00e74\u00bbn\u0011\u00d3o\u00a7\u00eb\u001eg\u00a0\u00f3\u0098\u00a1\u0085\u0091\u0017\u0005\u000fN\u008bG\u0010\u0015&\u0004\u00ad\u00c2$\u00c2_P\u00e3\u00cc\u0090\u00ff\u0090\u00bb\u00e9E\u0000\u0006\u00ac\u00c3_\u0014\u00f5\u009b\u00d4\u00fd\u00fbx_\u00e3\\54\u00ce\u00f6\u00e2\u00f4\u00ca;\u00feP\u00919\u0081\u00e7k~\u00ea\u0003\u00db=\u00c3\u00ec\"\u00bc\u001bP\u00f6\u00f5/~L1\u00b9d\u0088M\u0097I\u0090\u0001^\u0082\u00b3e\u001c`F\u0003u9e\b\u001a\u0014!\u00a6af\u00c6\u0006\u0099#\u008a,\u0005\u00d1L7\u0083\u0002\u00d938{\u00a0u\u00161\u00a5\u0082J\u0089\u00d2i\u00e0\\U\u00d6\u001c\u00fc\u000f\u0012\u00cf\u0085Rc%r7\u0091\u00ae-b\u00cf\u00c3\u00ac\u0012\u00ad\u001aJ\u0082\u00a7\u00ca\u009a \u00ad\u00dd:\u00e8\u007f\u000e0\u0090\u00b8\u00dc\u0098\u00f9t\u009c\u0003\u00be\u00e8\u00f1[s\u001a\u0004\u00cd\u00e1}2\u0018!D\u00cc\u00f3\u008f\u0087\u0002\u00a3e\u009fH\u0017\u00a7V&e\u0010\u00024\u008d\u00de\u009a\u00d0a\u009a\u00a3}\u00ee\u0080\u009c&\u00f2CMwnh\u00c2\u00ae\t\u0091\u00e6\u00b6\u00b0\u008d\u00c3Z%P2h\u00a3\u0007|\u00c1\u00ec\u00f1\u001e36{W\u00b5\u00dd\u00b2\u0081\u00fa^\u009d\u0091d\u0000\n\u008d\u0006$&\u0092?\u0005%F\u00c5\u001a\u00fd)\u00d5\u00ab\u00db\u00b1u\u0081\u00d1w\u00c2\u00b4>mc\u0017\u00b4\u00fc\u001b\u0006vs\u00d2K\u00fb}\u001b\u00ba\u009b=\u00fd\u00c6{\u00d6\u00d8\u00bd\\_\u00f0\u00fd\u00e7L\u00af\u00ac\u0006\u007fs\u00b24?r@-O3-\u00f7\u0016\u00a6\u00af\u00dc\u00fd\u00b4N\u00f9\u00d7\u00ac%\u00dd\u00bb\f\u001d\u000e\u00f6\u00ef\u00ebn}\u00fdt\u00efa\u0017R\u00a1e\u00ce\u0002s\u00d0\u00c04\u00ae`\u0002c\u00ac\u0096:\u00f9\u00ac\u000eD\u000b>'P\u0014<\u00c9\u00eb\b\u00ff\u00d4je\u00bcl>s\u00f7,AD\u00aeh\u00a8%\u00ba\u001b\u00d8\u00ed\f\u00d1\u00bd\u008c\u00ccdJ\u00f6\u009c\u00fexa\u0086\u00ab+=H\u00aa\t\u00fa\u00eaM\u009cFO~\u00fbI6\u0007VN\u00e4~h!6\u00cd\u00bd\u008e$\u00d2^:\u00ef`\u00cf\u0010\u007f\u008c\u0088{\u00ef7;$\u00d8~J\u0013>j\u00e6.-V\u00c7#\u00f0lbj\r\u0081\u00da&\u00a27\u0007\u00c3e\u0096\u00a0\u0012\u00a9_\u0099\u0086Y7\u00ee\u00fe'\u0089\u00fe`\u0003{hNn8^e\"\u00a4L\u00e8n\\\u0001\u00f06\u00e75\u00af\u0083p\u009f\u0006\u0019\u00eeO\u008d\u00f0\u00f8q\u00b4\u00dc\u00a0\u00bfq\u000b\u009e\n\u0092\u008d4\u00ee\u00c9Hd\u00fe\u00ee\u0015\u0083\u00e2\u0019\n\u00a2I\u008c\u00a2\u009fy\u0091\u00cc#\u00d8\u0014\u00a4\u00dc:7D,\u0003\u000b\u0092e\u001a\u0017UT,?\u00f8\u0001\u00b7\u00f9\u009ej\u00c4\u009b\u00adZ\u00e6\u00f2:\u00c5(\u00b2\u00ff\u008b\u00d2\u00b5\u00f6\u0002\u0095\u0016*\u00f5)J!\u00f7\u00e4\u001b\"\u00b1\u00e4\u00d4\u00c9y@\u0085\u009e\u00e25\u001c\u0088'\u009e!}\u00ba\u0092}\u007f\u009e\u00fdxq\u00b5&\u0094\u00edR\u0002+\n\u0002\u00be \u00ddZ\u00d1\u00c5[|e8\u00cbP\u0081}8\u008ed\u0007\u0013\u0018$r\u00e4\u0016\u00b3\bI\u00ea\u00a5\u000e\u0083RtL\u0017\u00d7\u00c6\u0090Vs\u000e`vq\u009f\u009e]\u00e8gD#b\u00efjJ,2\u0013\u001eC\u00a7!\u00f5\u0097\u00bc\u00f8\u00f4\u00d8\u0002\u0095G\u00d4\u00abm\u00ac\"\u00c6|\u00cbP+\u00b4\u00c1\u00196E\u00e6gb\u0010\u00ed/\u00a7\u00e7k\u009b\u00c9\u00ad\u00e0\nD\u00fb\u00f96g9ACu\u00e9nt\"+6\u0093/\u00a4b\u00b8\u0094\u009c\u009c\u00be\u00f14\u0017\u00cf\u00af\u0006\u00a0$\u00ff\u00a6\u00fe\u00c5\u0000*\u0093\u00fb\u00eb\u00b1\u00e8\u00f3\u00ea\u00ff,'s\u001e\u00e0\u00e6\u00e29 \u00c1\u00f1\u00e2\u00d1\u007fW\u00c1\u00f3\u00ad\u00abB\u00841\u0011\u00cf\u00d8\u00f1\u001e4\u0086\u00cf\u00d1J8Cd\u00af\u0010{\u0005\t\u00e3\u00d6\u00a5U\u00e7\u0092\u00ef\u008d\u00af\u000fQn$\u00ab\u00a4\u00ba*\u0005\u0098#y\u00eaNJ\u0018\u0090J`\u00ec\u0004E\u000b\u00a6L\u00b6j\u00b3\u001c\u00ed=\u0099]\u00d8{Q\u00e8\u00d0\u00f4L(v\u00d6UY\u0086\u00012^\b]d9\u0080\u0089\u0087\u00d6\u00a4J\u00b0\u00f8\u00f5\u00d3\u00b6Q4\u0096\u0092C9uu\u0099\u000b\u0003\u0007?\u00a6x\u00bf\u00afH\u0016\u0002\u0083\u0011\u00c2\u00e8=";
                var4_3 = "HN\u0013\u00cb\u00fd\u001e\u001b\u001d\u00ba\u001c\u000f9\u0090nJ2\u0003\u0090\u0084\u0016S\u00ae+\u00cfgf\u008bh\u008f\u00d4j\u00c2\u00f7)\u00b7x@)\u0084\u00a8\u00be\u00d2|\u0089\u00e0/\u008f:\u00b9X\u0080a\u009fy\u0099\u0017k\u001d\u00acM\u000f\u00c7\u0098\u0007\u00ceE\u0019\u00e1\u00cc\u0097\u00eb\u00c4\u00dd\u00fdjrc-\u00ab9\u00fb \u0019G\u00d27\u0018fMh\u00ed@\u008f\u0014w\f\u0089k\u00ca1}<B\u00e0V\u00fc\u0010\u0085\u0000/gA\u0012\u00f1\u00d9f\u0081\u00bdy\u00ea\u0099{\u00bf\u00e2\u00d9\u009b\u0090\u00a0}\n<\u009e\u00cf\u00ccN\u00f3F+\u00a2]\fT@d\u0092\u00e2+\u00a2\u00bc\u00db\u00c4C\u008b\u00b7 H\u00ca\u0086;\u00b7\u00c4?\u0084\u00ac\u008e\u0006\u000e\u0088\u00de\u00a6\u00fdX4\n\u00c0\u0017m\u00c3\u009d\u001e\u00ec\u0083\u000b\u00c6\u00ee^\u00d5\u00acf`z\u001bc9\u00da\u00a1\u00eeI;\u0081\u00beX\u0082\u001c\u0086\u00b6\u00f9\u0085\u0086VK\u00a5cN\u00b1\u00e4\u00f20\b\\\u00cc\u00cf\u00f3w\u001f*\u00ed\u00f2\u00da\u0019\u00b3X`\u00f2\u00ff\r\u00daJ\u00bf\u00adY\u0001\u00f9\u008f\u00eb_K&1\u00ef-\u00cf%v\u008aT~\u00cb\u00f9\u0018\u00b8\u0010\b\u00c5\u0087\u00b7S\u00a7.3A\ns\u0094\u0085\u00cf\u00abo\u0017\b\u00e8\t<BN\u00cb\u00c4\u008c\u0085\u0000j7I\u00dc\u0085\u00f5r\u00e4\u0099\u00ae\u00b5Z\u00e9\u0080\u00d0\u00dc\u00ee<\u00be\u00c0C\u00cba\u00f7+\u00e4g\u0003\u008b\u00c4\u0080A})\u001c'\u0089\u0087\u00f6lP\u008al^\u007f\u00ca\u0082\u00b0\u00d7\u009f?eP4\u0085\u0000\u00d7\u00a8\u0001\u0004\fl~\u00a9\"\u00cf\u0086\u00d4\u00e0s\u0006c\u00f75\u00bb\u0014\u009d\u001b\u00f4\u00f5\u00fb,s+\u00f9\u0082k\u00c0I\u00a9\u00ca\u00f9Q\u0014\u00c8>\rV\u00ca\u00d7\u000b\u00cd\u00c4\u0089\u00fen\u0099RX\u00ea\u00b4\u00be\u009d\u0096\u00e2e\u009c#1D\u0017a\u0087F~\u00a9\u000b;\u00d6\u0000\u008d\u00f8\u00c6\u0017\u00f9\u0081\u00ec\u00ab\u00d4\u009b9\u00e2\u00fdk\u0003+\u00dfh\u0019\"\u00e5.2\u00a4\u0082\u009a\u00e74\u00bbn\u0011\u00d3o\u00a7\u00eb\u001eg\u00a0\u00f3\u0098\u00a1\u0085\u0091\u0017\u0005\u000fN\u008bG\u0010\u0015&\u0004\u00ad\u00c2$\u00c2_P\u00e3\u00cc\u0090\u00ff\u0090\u00bb\u00e9E\u0000\u0006\u00ac\u00c3_\u0014\u00f5\u009b\u00d4\u00fd\u00fbx_\u00e3\\54\u00ce\u00f6\u00e2\u00f4\u00ca;\u00feP\u00919\u0081\u00e7k~\u00ea\u0003\u00db=\u00c3\u00ec\"\u00bc\u001bP\u00f6\u00f5/~L1\u00b9d\u0088M\u0097I\u0090\u0001^\u0082\u00b3e\u001c`F\u0003u9e\b\u001a\u0014!\u00a6af\u00c6\u0006\u0099#\u008a,\u0005\u00d1L7\u0083\u0002\u00d938{\u00a0u\u00161\u00a5\u0082J\u0089\u00d2i\u00e0\\U\u00d6\u001c\u00fc\u000f\u0012\u00cf\u0085Rc%r7\u0091\u00ae-b\u00cf\u00c3\u00ac\u0012\u00ad\u001aJ\u0082\u00a7\u00ca\u009a \u00ad\u00dd:\u00e8\u007f\u000e0\u0090\u00b8\u00dc\u0098\u00f9t\u009c\u0003\u00be\u00e8\u00f1[s\u001a\u0004\u00cd\u00e1}2\u0018!D\u00cc\u00f3\u008f\u0087\u0002\u00a3e\u009fH\u0017\u00a7V&e\u0010\u00024\u008d\u00de\u009a\u00d0a\u009a\u00a3}\u00ee\u0080\u009c&\u00f2CMwnh\u00c2\u00ae\t\u0091\u00e6\u00b6\u00b0\u008d\u00c3Z%P2h\u00a3\u0007|\u00c1\u00ec\u00f1\u001e36{W\u00b5\u00dd\u00b2\u0081\u00fa^\u009d\u0091d\u0000\n\u008d\u0006$&\u0092?\u0005%F\u00c5\u001a\u00fd)\u00d5\u00ab\u00db\u00b1u\u0081\u00d1w\u00c2\u00b4>mc\u0017\u00b4\u00fc\u001b\u0006vs\u00d2K\u00fb}\u001b\u00ba\u009b=\u00fd\u00c6{\u00d6\u00d8\u00bd\\_\u00f0\u00fd\u00e7L\u00af\u00ac\u0006\u007fs\u00b24?r@-O3-\u00f7\u0016\u00a6\u00af\u00dc\u00fd\u00b4N\u00f9\u00d7\u00ac%\u00dd\u00bb\f\u001d\u000e\u00f6\u00ef\u00ebn}\u00fdt\u00efa\u0017R\u00a1e\u00ce\u0002s\u00d0\u00c04\u00ae`\u0002c\u00ac\u0096:\u00f9\u00ac\u000eD\u000b>'P\u0014<\u00c9\u00eb\b\u00ff\u00d4je\u00bcl>s\u00f7,AD\u00aeh\u00a8%\u00ba\u001b\u00d8\u00ed\f\u00d1\u00bd\u008c\u00ccdJ\u00f6\u009c\u00fexa\u0086\u00ab+=H\u00aa\t\u00fa\u00eaM\u009cFO~\u00fbI6\u0007VN\u00e4~h!6\u00cd\u00bd\u008e$\u00d2^:\u00ef`\u00cf\u0010\u007f\u008c\u0088{\u00ef7;$\u00d8~J\u0013>j\u00e6.-V\u00c7#\u00f0lbj\r\u0081\u00da&\u00a27\u0007\u00c3e\u0096\u00a0\u0012\u00a9_\u0099\u0086Y7\u00ee\u00fe'\u0089\u00fe`\u0003{hNn8^e\"\u00a4L\u00e8n\\\u0001\u00f06\u00e75\u00af\u0083p\u009f\u0006\u0019\u00eeO\u008d\u00f0\u00f8q\u00b4\u00dc\u00a0\u00bfq\u000b\u009e\n\u0092\u008d4\u00ee\u00c9Hd\u00fe\u00ee\u0015\u0083\u00e2\u0019\n\u00a2I\u008c\u00a2\u009fy\u0091\u00cc#\u00d8\u0014\u00a4\u00dc:7D,\u0003\u000b\u0092e\u001a\u0017UT,?\u00f8\u0001\u00b7\u00f9\u009ej\u00c4\u009b\u00adZ\u00e6\u00f2:\u00c5(\u00b2\u00ff\u008b\u00d2\u00b5\u00f6\u0002\u0095\u0016*\u00f5)J!\u00f7\u00e4\u001b\"\u00b1\u00e4\u00d4\u00c9y@\u0085\u009e\u00e25\u001c\u0088'\u009e!}\u00ba\u0092}\u007f\u009e\u00fdxq\u00b5&\u0094\u00edR\u0002+\n\u0002\u00be \u00ddZ\u00d1\u00c5[|e8\u00cbP\u0081}8\u008ed\u0007\u0013\u0018$r\u00e4\u0016\u00b3\bI\u00ea\u00a5\u000e\u0083RtL\u0017\u00d7\u00c6\u0090Vs\u000e`vq\u009f\u009e]\u00e8gD#b\u00efjJ,2\u0013\u001eC\u00a7!\u00f5\u0097\u00bc\u00f8\u00f4\u00d8\u0002\u0095G\u00d4\u00abm\u00ac\"\u00c6|\u00cbP+\u00b4\u00c1\u00196E\u00e6gb\u0010\u00ed/\u00a7\u00e7k\u009b\u00c9\u00ad\u00e0\nD\u00fb\u00f96g9ACu\u00e9nt\"+6\u0093/\u00a4b\u00b8\u0094\u009c\u009c\u00be\u00f14\u0017\u00cf\u00af\u0006\u00a0$\u00ff\u00a6\u00fe\u00c5\u0000*\u0093\u00fb\u00eb\u00b1\u00e8\u00f3\u00ea\u00ff,'s\u001e\u00e0\u00e6\u00e29 \u00c1\u00f1\u00e2\u00d1\u007fW\u00c1\u00f3\u00ad\u00abB\u00841\u0011\u00cf\u00d8\u00f1\u001e4\u0086\u00cf\u00d1J8Cd\u00af\u0010{\u0005\t\u00e3\u00d6\u00a5U\u00e7\u0092\u00ef\u008d\u00af\u000fQn$\u00ab\u00a4\u00ba*\u0005\u0098#y\u00eaNJ\u0018\u0090J`\u00ec\u0004E\u000b\u00a6L\u00b6j\u00b3\u001c\u00ed=\u0099]\u00d8{Q\u00e8\u00d0\u00f4L(v\u00d6UY\u0086\u00012^\b]d9\u0080\u0089\u0087\u00d6\u00a4J\u00b0\u00f8\u00f5\u00d3\u00b6Q4\u0096\u0092C9uu\u0099\u000b\u0003\u0007?\u00a6x\u00bf\u00afH\u0016\u0002\u0083\u0011\u00c2\u00e8=".length();
                var1_4 = 16;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00f5F\u00a4\u00ca\u000b>\u00c56a\u00ab-\u00c6\u00a7\u00d2\u0097\u009dn=\u00ca\u00c1V\u00ca\u00cb4\u0090\u0001\u009b\u00e5\u00e5\u000b$\u00ee\u0002\u00ba\u00e8\u00ac\f\u00b9m\u00c8\u0089\u00f4\u00cb\\T\u00bbcma\u009au\u0016\u001c(\u001aB\u00d5-(\u00a9\u00ab\u00a2\u0092\u0000\u00c2$\u00e9g\u00f1\u00e4\u0015~\u001e\u00dbR\u0010WP\u00dd\u00af\u008b\u0093.4Z\u00ed\u00eb\u0002\u009eK\u00928\u00e5\u00c73ZF\u000b\u00b3\u00b77:\u0080\u0018_\u0096\u00b6%\u00b4";
                    var4_3 = "\u00f5F\u00a4\u00ca\u000b>\u00c56a\u00ab-\u00c6\u00a7\u00d2\u0097\u009dn=\u00ca\u00c1V\u00ca\u00cb4\u0090\u0001\u009b\u00e5\u00e5\u000b$\u00ee\u0002\u00ba\u00e8\u00ac\f\u00b9m\u00c8\u0089\u00f4\u00cb\\T\u00bbcma\u009au\u0016\u001c(\u001aB\u00d5-(\u00a9\u00ab\u00a2\u0092\u0000\u00c2$\u00e9g\u00f1\u00e4\u0015~\u001e\u00dbR\u0010WP\u00dd\u00af\u008b\u0093.4Z\u00ed\u00eb\u0002\u009eK\u00928\u00e5\u00c73ZF\u000b\u00b3\u00b77:\u0080\u0018_\u0096\u00b6%\u00b4".length();
                    var1_4 = 97;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 51;
                            break;
                        }
                        case 1: {
                            v13 = 22;
                            break;
                        }
                        case 2: {
                            v13 = 102;
                            break;
                        }
                        case 3: {
                            v13 = 97;
                            break;
                        }
                        case 4: {
                            v13 = 10;
                            break;
                        }
                        case 5: {
                            v13 = 111;
                            break;
                        }
                        default: {
                            v13 = 36;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        CertStoreRootCertificateOps.d = var5;
        CertStoreRootCertificateOps.e = new String[40];
        CertStoreRootCertificateOps.a = LoggerFactory.getLogger(CertStoreRootCertificateOps.class);
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0x56A3) & 0xFFFF;
        if (e[n3] == null) {
            int n4;
            int n5;
            char[] cArray = d[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 220;
                    break;
                }
                case 1: {
                    n5 = 97;
                    break;
                }
                case 2: {
                    n5 = 66;
                    break;
                }
                case 3: {
                    n5 = 65;
                    break;
                }
                case 4: {
                    n5 = 197;
                    break;
                }
                case 5: {
                    n5 = 165;
                    break;
                }
                case 6: {
                    n5 = 13;
                    break;
                }
                case 7: {
                    n5 = 222;
                    break;
                }
                case 8: {
                    n5 = 135;
                    break;
                }
                case 9: {
                    n5 = 104;
                    break;
                }
                case 10: {
                    n5 = 107;
                    break;
                }
                case 11: {
                    n5 = 216;
                    break;
                }
                case 12: {
                    n5 = 126;
                    break;
                }
                case 13: {
                    n5 = 201;
                    break;
                }
                case 14: {
                    n5 = 249;
                    break;
                }
                case 15: {
                    n5 = 238;
                    break;
                }
                case 16: {
                    n5 = 119;
                    break;
                }
                case 17: {
                    n5 = 64;
                    break;
                }
                case 18: {
                    n5 = 2;
                    break;
                }
                case 19: {
                    n5 = 39;
                    break;
                }
                case 20: {
                    n5 = 113;
                    break;
                }
                case 21: {
                    n5 = 55;
                    break;
                }
                case 22: {
                    n5 = 191;
                    break;
                }
                case 23: {
                    n5 = 242;
                    break;
                }
                case 24: {
                    n5 = 138;
                    break;
                }
                case 25: {
                    n5 = 210;
                    break;
                }
                case 26: {
                    n5 = 215;
                    break;
                }
                case 27: {
                    n5 = 153;
                    break;
                }
                case 28: {
                    n5 = 84;
                    break;
                }
                case 29: {
                    n5 = 51;
                    break;
                }
                case 30: {
                    n5 = 78;
                    break;
                }
                case 31: {
                    n5 = 184;
                    break;
                }
                case 32: {
                    n5 = 143;
                    break;
                }
                case 33: {
                    n5 = 144;
                    break;
                }
                case 34: {
                    n5 = 231;
                    break;
                }
                case 35: {
                    n5 = 194;
                    break;
                }
                case 36: {
                    n5 = 52;
                    break;
                }
                case 37: {
                    n5 = 230;
                    break;
                }
                case 38: {
                    n5 = 223;
                    break;
                }
                case 39: {
                    n5 = 218;
                    break;
                }
                case 40: {
                    n5 = 29;
                    break;
                }
                case 41: {
                    n5 = 196;
                    break;
                }
                case 42: {
                    n5 = 175;
                    break;
                }
                case 43: {
                    n5 = 234;
                    break;
                }
                case 44: {
                    n5 = 241;
                    break;
                }
                case 45: {
                    n5 = 100;
                    break;
                }
                case 46: {
                    n5 = 207;
                    break;
                }
                case 47: {
                    n5 = 48;
                    break;
                }
                case 48: {
                    n5 = 183;
                    break;
                }
                case 49: {
                    n5 = 93;
                    break;
                }
                case 50: {
                    n5 = 219;
                    break;
                }
                case 51: {
                    n5 = 121;
                    break;
                }
                case 52: {
                    n5 = 75;
                    break;
                }
                case 53: {
                    n5 = 71;
                    break;
                }
                case 54: {
                    n5 = 181;
                    break;
                }
                case 55: {
                    n5 = 146;
                    break;
                }
                case 56: {
                    n5 = 208;
                    break;
                }
                case 57: {
                    n5 = 91;
                    break;
                }
                case 58: {
                    n5 = 69;
                    break;
                }
                case 59: {
                    n5 = 76;
                    break;
                }
                case 60: {
                    n5 = 62;
                    break;
                }
                case 61: {
                    n5 = 217;
                    break;
                }
                case 62: {
                    n5 = 225;
                    break;
                }
                case 63: {
                    n5 = 68;
                    break;
                }
                case 64: {
                    n5 = 67;
                    break;
                }
                case 65: {
                    n5 = 30;
                    break;
                }
                case 66: {
                    n5 = 35;
                    break;
                }
                case 67: {
                    n5 = 111;
                    break;
                }
                case 68: {
                    n5 = 154;
                    break;
                }
                case 69: {
                    n5 = 7;
                    break;
                }
                case 70: {
                    n5 = 79;
                    break;
                }
                case 71: {
                    n5 = 247;
                    break;
                }
                case 72: {
                    n5 = 36;
                    break;
                }
                case 73: {
                    n5 = 182;
                    break;
                }
                case 74: {
                    n5 = 240;
                    break;
                }
                case 75: {
                    n5 = 150;
                    break;
                }
                case 76: {
                    n5 = 132;
                    break;
                }
                case 77: {
                    n5 = 203;
                    break;
                }
                case 78: {
                    n5 = 177;
                    break;
                }
                case 79: {
                    n5 = 209;
                    break;
                }
                case 80: {
                    n5 = 92;
                    break;
                }
                case 81: {
                    n5 = 123;
                    break;
                }
                case 82: {
                    n5 = 124;
                    break;
                }
                case 83: {
                    n5 = 46;
                    break;
                }
                case 84: {
                    n5 = 88;
                    break;
                }
                case 85: {
                    n5 = 156;
                    break;
                }
                case 86: {
                    n5 = 170;
                    break;
                }
                case 87: {
                    n5 = 131;
                    break;
                }
                case 88: {
                    n5 = 61;
                    break;
                }
                case 89: {
                    n5 = 187;
                    break;
                }
                case 90: {
                    n5 = 161;
                    break;
                }
                case 91: {
                    n5 = 33;
                    break;
                }
                case 92: {
                    n5 = 157;
                    break;
                }
                case 93: {
                    n5 = 105;
                    break;
                }
                case 94: {
                    n5 = 211;
                    break;
                }
                case 95: {
                    n5 = 90;
                    break;
                }
                case 96: {
                    n5 = 43;
                    break;
                }
                case 97: {
                    n5 = 246;
                    break;
                }
                case 98: {
                    n5 = 118;
                    break;
                }
                case 99: {
                    n5 = 17;
                    break;
                }
                case 100: {
                    n5 = 141;
                    break;
                }
                case 101: {
                    n5 = 0;
                    break;
                }
                case 102: {
                    n5 = 151;
                    break;
                }
                case 103: {
                    n5 = 224;
                    break;
                }
                case 104: {
                    n5 = 19;
                    break;
                }
                case 105: {
                    n5 = 42;
                    break;
                }
                case 106: {
                    n5 = 204;
                    break;
                }
                case 107: {
                    n5 = 137;
                    break;
                }
                case 108: {
                    n5 = 112;
                    break;
                }
                case 109: {
                    n5 = 233;
                    break;
                }
                case 110: {
                    n5 = 15;
                    break;
                }
                case 111: {
                    n5 = 152;
                    break;
                }
                case 112: {
                    n5 = 179;
                    break;
                }
                case 113: {
                    n5 = 185;
                    break;
                }
                case 114: {
                    n5 = 110;
                    break;
                }
                case 115: {
                    n5 = 226;
                    break;
                }
                case 116: {
                    n5 = 24;
                    break;
                }
                case 117: {
                    n5 = 186;
                    break;
                }
                case 118: {
                    n5 = 133;
                    break;
                }
                case 119: {
                    n5 = 116;
                    break;
                }
                case 120: {
                    n5 = 195;
                    break;
                }
                case 121: {
                    n5 = 60;
                    break;
                }
                case 122: {
                    n5 = 26;
                    break;
                }
                case 123: {
                    n5 = 239;
                    break;
                }
                case 124: {
                    n5 = 109;
                    break;
                }
                case 125: {
                    n5 = 248;
                    break;
                }
                case 126: {
                    n5 = 59;
                    break;
                }
                case 127: {
                    n5 = 101;
                    break;
                }
                case 128: {
                    n5 = 190;
                    break;
                }
                case 129: {
                    n5 = 251;
                    break;
                }
                case 130: {
                    n5 = 58;
                    break;
                }
                case 131: {
                    n5 = 94;
                    break;
                }
                case 132: {
                    n5 = 235;
                    break;
                }
                case 133: {
                    n5 = 173;
                    break;
                }
                case 134: {
                    n5 = 145;
                    break;
                }
                case 135: {
                    n5 = 250;
                    break;
                }
                case 136: {
                    n5 = 130;
                    break;
                }
                case 137: {
                    n5 = 1;
                    break;
                }
                case 138: {
                    n5 = 50;
                    break;
                }
                case 139: {
                    n5 = 86;
                    break;
                }
                case 140: {
                    n5 = 244;
                    break;
                }
                case 141: {
                    n5 = 34;
                    break;
                }
                case 142: {
                    n5 = 168;
                    break;
                }
                case 143: {
                    n5 = 9;
                    break;
                }
                case 144: {
                    n5 = 98;
                    break;
                }
                case 145: {
                    n5 = 140;
                    break;
                }
                case 146: {
                    n5 = 3;
                    break;
                }
                case 147: {
                    n5 = 166;
                    break;
                }
                case 148: {
                    n5 = 125;
                    break;
                }
                case 149: {
                    n5 = 25;
                    break;
                }
                case 150: {
                    n5 = 120;
                    break;
                }
                case 151: {
                    n5 = 237;
                    break;
                }
                case 152: {
                    n5 = 114;
                    break;
                }
                case 153: {
                    n5 = 148;
                    break;
                }
                case 154: {
                    n5 = 73;
                    break;
                }
                case 155: {
                    n5 = 102;
                    break;
                }
                case 156: {
                    n5 = 228;
                    break;
                }
                case 157: {
                    n5 = 252;
                    break;
                }
                case 158: {
                    n5 = 6;
                    break;
                }
                case 159: {
                    n5 = 129;
                    break;
                }
                case 160: {
                    n5 = 128;
                    break;
                }
                case 161: {
                    n5 = 254;
                    break;
                }
                case 162: {
                    n5 = 85;
                    break;
                }
                case 163: {
                    n5 = 38;
                    break;
                }
                case 164: {
                    n5 = 205;
                    break;
                }
                case 165: {
                    n5 = 57;
                    break;
                }
                case 166: {
                    n5 = 99;
                    break;
                }
                case 167: {
                    n5 = 127;
                    break;
                }
                case 168: {
                    n5 = 8;
                    break;
                }
                case 169: {
                    n5 = 236;
                    break;
                }
                case 170: {
                    n5 = 255;
                    break;
                }
                case 171: {
                    n5 = 192;
                    break;
                }
                case 172: {
                    n5 = 74;
                    break;
                }
                case 173: {
                    n5 = 160;
                    break;
                }
                case 174: {
                    n5 = 232;
                    break;
                }
                case 175: {
                    n5 = 199;
                    break;
                }
                case 176: {
                    n5 = 163;
                    break;
                }
                case 177: {
                    n5 = 164;
                    break;
                }
                case 178: {
                    n5 = 81;
                    break;
                }
                case 179: {
                    n5 = 80;
                    break;
                }
                case 180: {
                    n5 = 21;
                    break;
                }
                case 181: {
                    n5 = 172;
                    break;
                }
                case 182: {
                    n5 = 200;
                    break;
                }
                case 183: {
                    n5 = 87;
                    break;
                }
                case 184: {
                    n5 = 32;
                    break;
                }
                case 185: {
                    n5 = 245;
                    break;
                }
                case 186: {
                    n5 = 147;
                    break;
                }
                case 187: {
                    n5 = 188;
                    break;
                }
                case 188: {
                    n5 = 171;
                    break;
                }
                case 189: {
                    n5 = 44;
                    break;
                }
                case 190: {
                    n5 = 54;
                    break;
                }
                case 191: {
                    n5 = 202;
                    break;
                }
                case 192: {
                    n5 = 12;
                    break;
                }
                case 193: {
                    n5 = 95;
                    break;
                }
                case 194: {
                    n5 = 227;
                    break;
                }
                case 195: {
                    n5 = 167;
                    break;
                }
                case 196: {
                    n5 = 117;
                    break;
                }
                case 197: {
                    n5 = 253;
                    break;
                }
                case 198: {
                    n5 = 45;
                    break;
                }
                case 199: {
                    n5 = 162;
                    break;
                }
                case 200: {
                    n5 = 214;
                    break;
                }
                case 201: {
                    n5 = 72;
                    break;
                }
                case 202: {
                    n5 = 176;
                    break;
                }
                case 203: {
                    n5 = 178;
                    break;
                }
                case 204: {
                    n5 = 155;
                    break;
                }
                case 205: {
                    n5 = 28;
                    break;
                }
                case 206: {
                    n5 = 122;
                    break;
                }
                case 207: {
                    n5 = 96;
                    break;
                }
                case 208: {
                    n5 = 139;
                    break;
                }
                case 209: {
                    n5 = 40;
                    break;
                }
                case 210: {
                    n5 = 41;
                    break;
                }
                case 211: {
                    n5 = 49;
                    break;
                }
                case 212: {
                    n5 = 77;
                    break;
                }
                case 213: {
                    n5 = 23;
                    break;
                }
                case 214: {
                    n5 = 82;
                    break;
                }
                case 215: {
                    n5 = 14;
                    break;
                }
                case 216: {
                    n5 = 212;
                    break;
                }
                case 217: {
                    n5 = 103;
                    break;
                }
                case 218: {
                    n5 = 63;
                    break;
                }
                case 219: {
                    n5 = 5;
                    break;
                }
                case 220: {
                    n5 = 31;
                    break;
                }
                case 221: {
                    n5 = 159;
                    break;
                }
                case 222: {
                    n5 = 83;
                    break;
                }
                case 223: {
                    n5 = 221;
                    break;
                }
                case 224: {
                    n5 = 174;
                    break;
                }
                case 225: {
                    n5 = 149;
                    break;
                }
                case 226: {
                    n5 = 142;
                    break;
                }
                case 227: {
                    n5 = 16;
                    break;
                }
                case 228: {
                    n5 = 4;
                    break;
                }
                case 229: {
                    n5 = 53;
                    break;
                }
                case 230: {
                    n5 = 180;
                    break;
                }
                case 231: {
                    n5 = 115;
                    break;
                }
                case 232: {
                    n5 = 18;
                    break;
                }
                case 233: {
                    n5 = 193;
                    break;
                }
                case 234: {
                    n5 = 213;
                    break;
                }
                case 235: {
                    n5 = 47;
                    break;
                }
                case 236: {
                    n5 = 206;
                    break;
                }
                case 237: {
                    n5 = 106;
                    break;
                }
                case 238: {
                    n5 = 198;
                    break;
                }
                case 239: {
                    n5 = 136;
                    break;
                }
                case 240: {
                    n5 = 108;
                    break;
                }
                case 241: {
                    n5 = 229;
                    break;
                }
                case 242: {
                    n5 = 89;
                    break;
                }
                case 243: {
                    n5 = 20;
                    break;
                }
                case 244: {
                    n5 = 243;
                    break;
                }
                case 245: {
                    n5 = 134;
                    break;
                }
                case 246: {
                    n5 = 70;
                    break;
                }
                case 247: {
                    n5 = 11;
                    break;
                }
                case 248: {
                    n5 = 27;
                    break;
                }
                case 249: {
                    n5 = 189;
                    break;
                }
                case 250: {
                    n5 = 169;
                    break;
                }
                case 251: {
                    n5 = 56;
                    break;
                }
                case 252: {
                    n5 = 10;
                    break;
                }
                case 253: {
                    n5 = 22;
                    break;
                }
                case 254: {
                    n5 = 37;
                    break;
                }
                default: {
                    n5 = 158;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            CertStoreRootCertificateOps.e[n3] = new String(cArray).intern();
        }
        return e[n3];
    }
}

