/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.revocation;

import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.ESingleResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.ValidationSystem;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.CheckStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.revocation.RevocationChecker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.revocation.RevocationStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.revocation.b;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.RevocationCheckResult;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.RevokeCheckStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPResponseController;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPResponseStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.FinderOCSPResponseSource;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.OCSPResponseFinderIteration;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.bundle.cert.CertI18n;

public class RevocationFromOCSPChecker
extends RevocationChecker {
    private static final Logger e = LoggerFactory.getLogger(RevocationFromOCSPChecker.class);

    public static RevokeCheckStatus checkFromOCSP(ValidationSystem aParentSystem, CertificateStatusInfo aCertificateStatusInfo, EOCSPResponse ocspResp) throws ESYAException {
        block15: {
            ESingleResponse eSingleResponse;
            block16: {
                if (aCertificateStatusInfo == null) {
                    return RevokeCheckStatus.CANT_CHECK;
                }
                ECertificate eCertificate = aCertificateStatusInfo.getCertificate();
                OCSPResponseController oCSPResponseController = new OCSPResponseController();
                OCSPResponseStatusInfo oCSPResponseStatusInfo = oCSPResponseController.check(aParentSystem, ocspResp);
                aCertificateStatusInfo.addOCSPResponseInfo(oCSPResponseStatusInfo);
                if (ocspResp.getResponseStatus() != 0) {
                    return RevokeCheckStatus.CANT_CHECK;
                }
                if (ocspResp.getSingleResponseCount() == 0) {
                    return RevokeCheckStatus.CANT_CHECK;
                }
                eSingleResponse = ocspResp.getSingleResponse(0);
                if (oCSPResponseStatusInfo.getOCSPResponseStatus() != OCSPResponseStatusInfo.OCSPResponseStatus.VALID) break block15;
                if (eSingleResponse.getCertificateStatus() != 1) break block16;
                aCertificateStatusInfo.addRevocationCheckDetail(new RevocationCheckResult(CertI18n.message((String)CertI18n.OCSPDEN_IPTAL_KONTROLU), RevocationFromOCSPCheckStatus.CERTIFICATE_VALID.getText(), (CheckStatus)RevocationFromOCSPCheckStatus.CERTIFICATE_VALID, RevokeCheckStatus.NOT_REVOKED));
                return RevokeCheckStatus.NOT_REVOKED;
            }
            if (eSingleResponse.getCertificateStatus() == 2) {
                Calendar calendar = eSingleResponse.getRevocationTime();
                Calendar calendar2 = aParentSystem.getBaseValidationTime();
                if (calendar2.after(calendar)) {
                    RevocationStatusInfo revocationStatusInfo = new RevocationStatusInfo();
                    revocationStatusInfo.setRevocationDate(eSingleResponse.getRevocationTime().getTime());
                    revocationStatusInfo.setRevocationCause(eSingleResponse.getRevokationReason());
                    aCertificateStatusInfo.setRevocationInfo(revocationStatusInfo);
                    aCertificateStatusInfo.addRevocationCheckDetail(new RevocationCheckResult(CertI18n.message((String)CertI18n.OCSPDEN_IPTAL_KONTROLU), RevocationFromOCSPCheckStatus.CERTIFICATE_INVALID.getText(), (CheckStatus)RevocationFromOCSPCheckStatus.CERTIFICATE_INVALID, RevokeCheckStatus.REVOKED));
                    return RevokeCheckStatus.REVOKED;
                }
                aCertificateStatusInfo.addRevocationCheckDetail(new RevocationCheckResult(CertI18n.message((String)CertI18n.OCSPDEN_IPTAL_KONTROLU), RevocationFromOCSPCheckStatus.CERTIFICATE_VALID.getText(), (CheckStatus)RevocationFromOCSPCheckStatus.CERTIFICATE_VALID, RevokeCheckStatus.NOT_REVOKED));
                return RevokeCheckStatus.NOT_REVOKED;
            }
            return RevokeCheckStatus.CANT_CHECK;
        }
        return RevokeCheckStatus.CANT_CHECK;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected RevokeCheckStatus _check(ECertificate aIssuerCertificate, CertificateStatusInfo aCertificateStatusInfo) throws ESYAException {
        var3_3 = RevocationChecker.d;
        if (this.mParentSystem == null) {
            return RevokeCheckStatus.CANT_CHECK;
        }
        var4_4 = aCertificateStatusInfo.getCertificate();
        var5_5 = new OCSPResponseFinderIteration(var4_4, aIssuerCertificate, this.mParentSystem);
        var5_5.addItemSource(new FinderOCSPResponseSource(var4_4, aIssuerCertificate, this.mFinders));
        while (var5_5.nextIteration(this.mParentSystem)) {
            var7_7 = (EOCSPResponse)var5_5.getCurrentItem();
            var6_6 = RevocationFromOCSPChecker.checkFromOCSP(this.mParentSystem, aCertificateStatusInfo, var7_7);
            switch (b.b[var6_6.ordinal()]) {
                case 1: {
                    return RevokeCheckStatus.REVOKED;
                }
                case 2: {
                    return RevokeCheckStatus.NOT_REVOKED;
                }
                case 3: {
                    if (var3_3 == 0) ** break;
                    break;
                }
            }
            if (var3_3 == 0) continue;
        }
        aCertificateStatusInfo.addRevocationCheckDetail(this, RevocationFromOCSPCheckStatus.OCSP_RESPONSE_NOT_FOUND, RevokeCheckStatus.CANT_CHECK);
        return RevokeCheckStatus.CANT_CHECK;
    }

    @Override
    public String getCheckText() {
        return CertI18n.message((String)CertI18n.OCSPDEN_IPTAL_KONTROLU);
    }

    public static final class RevocationFromOCSPCheckStatus
    extends Enum<RevocationFromOCSPCheckStatus>
    implements CheckStatus {
        public static final /* enum */ RevocationFromOCSPCheckStatus INVALID_OCSP_RESPONSE;
        public static final /* enum */ RevocationFromOCSPCheckStatus OCSP_RESPONSE_NOT_FOUND;
        public static final /* enum */ RevocationFromOCSPCheckStatus ISSUER_CERTIFICATE_NOT_FOUND;
        public static final /* enum */ RevocationFromOCSPCheckStatus CERTIFICATE_VALID;
        public static final /* enum */ RevocationFromOCSPCheckStatus CERTIFICATE_INVALID;
        private static final /* synthetic */ RevocationFromOCSPCheckStatus[] a;

        public static RevocationFromOCSPCheckStatus[] values() {
            return (RevocationFromOCSPCheckStatus[])a.clone();
        }

        public static RevocationFromOCSPCheckStatus valueOf(String name) {
            return Enum.valueOf(RevocationFromOCSPCheckStatus.class, name);
        }

        @Override
        public String getText() {
            switch (this) {
                case INVALID_OCSP_RESPONSE: {
                    return CertI18n.message((String)CertI18n.OCSP_CEVABI_GECERSIZ);
                }
                case OCSP_RESPONSE_NOT_FOUND: {
                    return CertI18n.message((String)CertI18n.OCSP_CEVABI_BULUNAMADI);
                }
                case ISSUER_CERTIFICATE_NOT_FOUND: {
                    return CertI18n.message((String)CertI18n.SM_SERTIFIKASI_BULUNAMADI);
                }
                case CERTIFICATE_VALID: {
                    return CertI18n.message((String)CertI18n.SERTIFIKA_OCSPDE_GECERLI);
                }
                case CERTIFICATE_INVALID: {
                    return CertI18n.message((String)CertI18n.SERTIFIKA_OCSPDE_GECERLI_DEGIL);
                }
            }
            return CertI18n.message((String)CertI18n.KONTROL_SONUCU);
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var6 = new String[5];
                    var4_1 = 0;
                    var3_2 = "\u001d\u001a_@z\n\u000e\u001d\u001eYQl\u0005\t\b\u001eA]w\u0015\u0017\u0011[U\u007f\u0005\u0003\u0001\u0010NGc\u0013\u0015\u001b\f][}\u001f\u0002\u0011\u001d\u001a_@z\n\u000e\u001d\u001eYQl\u001a\u0006\u0012\u0016I";
                    var5_3 = "\u001d\u001a_@z\n\u000e\u001d\u001eYQl\u0005\t\b\u001eA]w\u0015\u0017\u0011[U\u007f\u0005\u0003\u0001\u0010NGc\u0013\u0015\u001b\f][}\u001f\u0002\u0011\u001d\u001a_@z\n\u000e\u001d\u001eYQl\u001a\u0006\u0012\u0016I".length();
                    var2_4 = 19;
                    var1_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = ++var1_5;
                        v1 = var3_2.substring(v0, v0 + var2_4);
                        v2 = -1;
                        break block19;
                        break;
                    }
lbl12:
                    // 1 sources

                    while (true) {
                        var6[var4_1++] = v3.intern();
                        if ((var1_5 += var2_4) < var5_3) {
                            var2_4 = var3_2.charAt(var1_5);
                            ** continue;
                        }
                        var3_2 = "\u0011\u001c^Dl\u001e\u0002\r\u000fBZ`\t\u0018\u0010\u0010YKu\u0003\u0012\u0010\u001b\u001c\u0017\f^Av\u001e\u0018\u001d\u001a_@z\n\u000e\u001d\u001eYQl\u0002\b\n\u0000K[f\u0002\u0003";
                        var5_3 = "\u0011\u001c^Dl\u001e\u0002\r\u000fBZ`\t\u0018\u0010\u0010YKu\u0003\u0012\u0010\u001b\u001c\u0017\f^Av\u001e\u0018\u001d\u001a_@z\n\u000e\u001d\u001eYQl\u0002\b\n\u0000K[f\u0002\u0003".length();
                        var2_4 = 23;
                        var1_5 = -1;
lbl21:
                        // 2 sources

                        while (true) {
                            v4 = ++var1_5;
                            v1 = var3_2.substring(v4, v4 + var2_4);
                            v2 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl26:
                    // 1 sources

                    while (true) {
                        var6[var4_1++] = v3.intern();
                        if ((var1_5 += var2_4) < var5_3) {
                            var2_4 = var3_2.charAt(var1_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v5 = v1.toCharArray();
                var7_6 = 0;
                v6 = v5.length;
                v7 = v5;
                v8 = v6;
                if (v6 > 1) ** GOTO lbl76
                do {
                    v9 = v7;
                    v10 = v7;
                    v11 = var7_6;
                    while (true) {
                        v12 = v9[v11];
                        switch (var7_6 % 7) {
                            case 0: {
                                v13 = 94;
                                break;
                            }
                            case 1: {
                                v13 = 95;
                                break;
                            }
                            case 2: {
                                v13 = 13;
                                break;
                            }
                            case 3: {
                                v13 = 20;
                                break;
                            }
                            case 4: {
                                v13 = 51;
                                break;
                            }
                            case 5: {
                                v13 = 76;
                                break;
                            }
                            default: {
                                v13 = 71;
                            }
                        }
                        v9[v11] = (char)(v12 ^ v13);
                        ++var7_6;
                        v7 = v10;
                        v8 = v8;
                        if (v8 != 0) break;
                        v10 = v7;
                        v14 = v8;
                        v11 = v8;
                        v9 = v7;
                    }
lbl76:
                    // 2 sources

                    v15 = v7;
                    v14 = v8;
                } while (v8 > var7_6);
                v3 = new String(v15);
                switch (v2) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl85:
                    // 1 sources

                    ** continue;
                }
            }
            var0_7 = var6;
            RevocationFromOCSPCheckStatus.INVALID_OCSP_RESPONSE = new RevocationFromOCSPCheckStatus();
            RevocationFromOCSPCheckStatus.OCSP_RESPONSE_NOT_FOUND = new RevocationFromOCSPCheckStatus();
            RevocationFromOCSPCheckStatus.ISSUER_CERTIFICATE_NOT_FOUND = new RevocationFromOCSPCheckStatus();
            RevocationFromOCSPCheckStatus.CERTIFICATE_VALID = new RevocationFromOCSPCheckStatus();
            RevocationFromOCSPCheckStatus.CERTIFICATE_INVALID = new RevocationFromOCSPCheckStatus();
            RevocationFromOCSPCheckStatus.a = new RevocationFromOCSPCheckStatus[]{RevocationFromOCSPCheckStatus.INVALID_OCSP_RESPONSE, RevocationFromOCSPCheckStatus.OCSP_RESPONSE_NOT_FOUND, RevocationFromOCSPCheckStatus.ISSUER_CERTIFICATE_NOT_FOUND, RevocationFromOCSPCheckStatus.CERTIFICATE_VALID, RevocationFromOCSPCheckStatus.CERTIFICATE_INVALID};
        }
    }
}

