/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.ASN1Boolean;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.asn1.SequenceOf;
import com.turktrust.x509.Extension;
import com.turktrust.x509.PolicyInformation;
import java.util.Vector;

public class CertificatePolicies
extends Extension {
    public static final String EXT_OBJ_ID = "2.5.29.32";
    private Vector policyInfoVec;

    public CertificatePolicies(String name, boolean critical, Vector polInfos) {
        super(name);
        this.policyInfoVec = polInfos;
        ObjectID certPolExtObjId = new ObjectID("certificatePolicies");
        certPolExtObjId.setValue(EXT_OBJ_ID);
        this.setextnID(certPolExtObjId);
        if (critical) {
            ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(critical));
            this.setcritical(crit);
        }
        SequenceOf polSeq = new SequenceOf(name, (PolicyInformation)polInfos.elementAt(0));
        polSeq.setValue(polInfos);
        byte[] polSeqEncBytes = polSeq.getEncoded();
        OctetString extOcts = new OctetString("extCertPolicies");
        extOcts.setValue(polSeqEncBytes);
        this.setextnValue(extOcts);
        this.commitElementUpdate();
    }

    public CertificatePolicies() {
        super("defaultCP");
        ObjectID certPolExtObjId = new ObjectID("certificatePolicies");
        certPolExtObjId.setValue(EXT_OBJ_ID);
        this.setextnID(certPolExtObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(false));
        this.setcritical(crit);
        this.commitElementUpdate();
    }

    public void decodeExtVal(byte[] extValBytes) {
        SequenceOf polSeq = new SequenceOf("seqof", new PolicyInformation());
        try {
            polSeq.decode(extValBytes);
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.policyInfoVec = (Vector)polSeq.getValue();
        OctetString extOcts = new OctetString("extCertPolicies", extValBytes);
        this.setextnValue(extOcts);
        this.commitElementUpdate();
    }

    public String getExtensionTitle() {
        return "Certificate Policies";
    }

    public String getTurkishExtensionTitle() {
        return "Sertifika \u0130lkeleri";
    }

    public String getExplanation() {
        String exp = "";
        for (int i = 0; i < this.policyInfoVec.size(); ++i) {
            PolicyInformation polinf = (PolicyInformation)this.policyInfoVec.elementAt(i);
            exp = exp + polinf.getExplanation();
            if (i >= this.policyInfoVec.size() - 1) continue;
            exp = exp + "\n";
        }
        return exp;
    }

    public String getTurkishExplanation() {
        String exp = "";
        for (int i = 0; i < this.policyInfoVec.size(); ++i) {
            PolicyInformation polinf = (PolicyInformation)this.policyInfoVec.elementAt(i);
            exp = exp + polinf.getTurkishExplanation();
            if (i >= this.policyInfoVec.size() - 1) continue;
            exp = exp + "\n";
        }
        return exp;
    }
}

