/*
 * Decompiled with CFR 0.152.
 */
package sune.security.x509;

import java.io.IOException;
import sune.security.util.DerOutputStream;
import sune.security.util.DerValue;
import sune.security.x509.GeneralName;

public class GeneralSubtree {
    private static final byte TAG_MIN = 0;
    private static final byte TAG_MAX = 1;
    private static final int MIN_DEFAULT = 0;
    private GeneralName name;
    private int minimum = 0;
    private int maximum = -1;
    private int myhash = -1;

    public GeneralSubtree(GeneralName name, int min, int max) {
        this.name = name;
        this.minimum = min;
        this.maximum = max;
    }

    public GeneralSubtree(DerValue val) throws IOException {
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for GeneralSubtree.");
        }
        this.name = new GeneralName(val.data.getDerValue(), true);
        while (val.data.available() != 0) {
            DerValue opt = val.data.getDerValue();
            if (opt.isContextSpecific((byte)0) && !opt.isConstructed()) {
                opt.resetTag((byte)2);
                this.minimum = opt.getInteger();
                continue;
            }
            if (opt.isContextSpecific((byte)1) && !opt.isConstructed()) {
                opt.resetTag((byte)2);
                this.maximum = opt.getInteger();
                continue;
            }
            throw new IOException("Invalid encoding of GeneralSubtree.");
        }
    }

    public GeneralName getName() {
        return this.name;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public String toString() {
        String s = "\n   GeneralSubtree: [\n    GeneralName: " + (this.name == null ? "" : this.name.toString()) + "\n    Minimum: " + this.minimum;
        s = this.maximum == -1 ? s + "\t    Maximum: undefined" : s + "\t    Maximum: " + this.maximum;
        s = s + "    ]\n";
        return s;
    }

    public boolean equals(Object other) {
        if (!(other instanceof GeneralSubtree)) {
            return false;
        }
        GeneralSubtree otherGS = (GeneralSubtree)other;
        if (this.name == null ? otherGS.name != null : !this.name.equals(otherGS.name)) {
            return false;
        }
        if (this.minimum != otherGS.minimum) {
            return false;
        }
        return this.maximum == otherGS.maximum;
    }

    public int hashCode() {
        if (this.myhash == -1) {
            this.myhash = 17;
            if (this.name != null) {
                this.myhash = 37 * this.myhash + this.name.hashCode();
            }
            if (this.minimum != 0) {
                this.myhash = 37 * this.myhash + this.minimum;
            }
            if (this.maximum != -1) {
                this.myhash = 37 * this.myhash + this.maximum;
            }
        }
        return this.myhash;
    }

    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp;
        DerOutputStream seq = new DerOutputStream();
        this.name.encode(seq);
        if (this.minimum != 0) {
            tmp = new DerOutputStream();
            tmp.putInteger(this.minimum);
            seq.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), tmp);
        }
        if (this.maximum != -1) {
            tmp = new DerOutputStream();
            tmp.putInteger(this.maximum);
            seq.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), tmp);
        }
        out.write((byte)48, seq);
    }
}

