/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.pkcs8;

import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.Sequence;
import com.turktrust.pkcs8.Attributes;
import com.turktrust.pkcs8.PrivateKey;
import com.turktrust.x509.AlgorithmIdentifier;
import com.turktrust.x509.Version;

public class PrivateKeyInfo
extends Sequence {
    private Version version = new Version("version");
    private AlgorithmIdentifier privateKeyAlgorithm = new AlgorithmIdentifier("privateKeyAlgorithm");
    private PrivateKey privateKey = new PrivateKey("privateKey");
    private Attributes attributes = new Attributes("attributes");

    public PrivateKeyInfo(String name) {
        super(name);
        this.setUpElements();
    }

    protected void setUpElements() {
        super.addElement(this.version);
        super.addElement(this.privateKeyAlgorithm);
        super.addElement(this.privateKey);
        super.addElement(this.attributes);
        this.attributes.setOptional(true);
        this.attributes.setTaggingMethod(1);
        this.attributes.setTagClass((byte)-128);
        this.attributes.setTagNumber(0);
    }

    public Version getversion() {
        return this.version;
    }

    public void setversion(Version value) {
        this.version = value;
    }

    public AlgorithmIdentifier getprivateKeyAlgorithm() {
        return this.privateKeyAlgorithm;
    }

    public void setprivateKeyAlgorithm(AlgorithmIdentifier value) {
        this.privateKeyAlgorithm = value;
    }

    public PrivateKey getprivateKey() {
        return this.privateKey;
    }

    public void setprivateKey(PrivateKey value) {
        this.privateKey = value;
    }

    public Attributes getattributes() {
        return this.attributes;
    }

    public void setattributes(Attributes value) {
        this.attributes = value;
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }

    public void decode(byte[] data) throws DecodeException {
        super.decode(data);
        this.setversion((Version)super.getElement(0));
        this.setprivateKeyAlgorithm((AlgorithmIdentifier)super.getElement(1));
        this.setprivateKey((PrivateKey)super.getElement(2));
        if (super.getElement(3) != null) {
            this.setattributes((Attributes)super.getElement(3));
        }
        this.commitElementUpdate();
    }
}

