/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.certstore.ops;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.ItemSource;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStore;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVEN;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVTKatmani;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.JDBCUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.NotFoundException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.DizinYardimci;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoDizin;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.ops.CertStoreRootCertificateOps;

public class CertStoreDirectoryOps {
    private static Logger a;
    private final CertStore b;
    private static final String[] c;
    private static final String[] d;

    public CertStoreDirectoryOps(CertStore aDepo) {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            a.error(CertStoreDirectoryOps.a(-26800, 29695));
            throw new ESYARuntimeException(CertStoreDirectoryOps.a(-26786, -29510) + lE.getMessage());
        }
        this.b = aDepo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DepoDizin readDirectory(long aDizinNo) throws CertStoreException {
        DepoDizin depoDizin;
        if (aDizinNo <= 0L) {
            throw new CertStoreException(CertStoreDirectoryOps.a(-26792, 16107));
        }
        try {
            DepoDizin depoDizin2;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoDizin = depoDizin2 = depoVEN.dizinOku(aDizinNo);
        }
        catch (NotFoundException notFoundException) {
            try {
                throw new CertStoreException(aDizinNo + CertStoreDirectoryOps.a(-26785, 26331), notFoundException);
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(aDizinNo + CertStoreDirectoryOps.a(-26789, 31258), certStoreException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(aDizinNo + CertStoreDirectoryOps.a(-26789, 31258), certStoreException);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return depoDizin;
            JDBCUtil.commit(this.b.getConn());
            return depoDizin;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(aDizinNo + CertStoreDirectoryOps.a(-26791, 27558), certStoreException);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DepoDizin findDirectory(String aDizinAdi) throws CertStoreException {
        DepoDizin depoDizin;
        try {
            DepoDizin depoDizin2;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoDizin = depoDizin2 = depoVEN.dizinBul(aDizinAdi);
        }
        catch (NotFoundException notFoundException) {
            try {
                throw new CertStoreException(aDizinAdi + CertStoreDirectoryOps.a(-26799, 25445) + notFoundException);
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(aDizinAdi + CertStoreDirectoryOps.a(-26793, 23151) + certStoreException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(aDizinAdi + CertStoreDirectoryOps.a(-26793, 23151), certStoreException);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return depoDizin;
            JDBCUtil.commit(this.b.getConn());
            return depoDizin;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(aDizinAdi + CertStoreDirectoryOps.a(-26804, -30581), certStoreException);
        }
    }

    public void renameDirectory(long aDizinNo, String aYeniAd) throws CertStoreException {
        if (aDizinNo <= 0L) {
            throw new CertStoreException(CertStoreDirectoryOps.a(-26788, 6685));
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.dizinAdiDegistir(aDizinNo, aYeniAd);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(aDizinNo + CertStoreDirectoryOps.a(-26796, 1169) + aYeniAd + CertStoreDirectoryOps.a(-26795, -27280), certStoreException);
        }
    }

    public void writeDirectory(String aDizinAdi) throws CertStoreException {
        DepoDizin depoDizin = new DepoDizin();
        depoDizin.setDizinAdi(aDizinAdi);
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.dizinYaz(depoDizin);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(aDizinAdi + CertStoreDirectoryOps.a(-26787, -19763), certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DepoDizin> listDirectory() throws CertStoreException {
        ArrayList<DepoDizin> arrayList2;
        boolean bl = CertStoreRootCertificateOps.c;
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            ArrayList<DepoDizin> arrayList = new ArrayList<DepoDizin>();
            ItemSource<DepoDizin> itemSource = depoVEN.dizinListele();
            DepoDizin depoDizin = (DepoDizin)itemSource.nextItem();
            while (depoDizin != null) {
                arrayList.add(depoDizin);
                depoDizin = (DepoDizin)itemSource.nextItem();
                if (!bl) continue;
            }
            arrayList2 = arrayList;
        }
        catch (Exception exception) {
            try {
                throw new CertStoreException(CertStoreDirectoryOps.a(-26797, -25041), exception);
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException) {
                    throw new CertStoreException(CertStoreDirectoryOps.a(-26797, -25041), certStoreException);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return arrayList2;
            JDBCUtil.commit(this.b.getConn());
            return arrayList2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(CertStoreDirectoryOps.a(-26798, 31825), certStoreException);
        }
    }

    public void deleteDirectory(long aDizinNo) throws CertStoreException {
        if (aDizinNo == DizinYardimci.getDefaultDizinNo()) {
            throw new CertStoreException(CertStoreDirectoryOps.a(-26794, 13206));
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.dizinSil(aDizinNo);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(aDizinNo + CertStoreDirectoryOps.a(-26790, 11503), certStoreException);
        }
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[17];
                var3_1 = 0;
                var2_2 = "\u00ce\u0086.\u00a39\u000b\u00a9:=\u00e42\u008b\u001ac\f \u00d0\u0095\u0018#\u00cc\u000e\u0086l9\u00f2\u00b2\u0018\u0082\u00cb\u00f8\u00c0\u00e7\u00af\u00b59\u00ac\u009b\u0083{\u00a8\u00fbI\u00c2\u0014\u001bwf\u00d3\u00e2\f\u0086\u00af_\u0015\u00cd\u00e9\u00aeQ\u008f\u00d3\u00e6\u00a9\u008bf\u00d0:\u00be\u007f\u009d\u00a4\u0099\u00f0\u00b9\u00ee\u008e\n\u0097\u008d(\u001d\u00b9\u00f3I\u00fa\u00103\u0013\u0097ic\u00d6'.PF\u00a6LV\u0017'r\u0090\u00d6\u00cd\u0095{Zp\u00ba\u00c2\u008f\u00d9\u00ea\u00b9\u0098\u001b}v\u001a?\u00b4%\u001b\u00e9`V.\u009f\u00ac\u00adY<\u0091\u0016\u00eb\u0012\u001c]\u0084\u0085#^\u008d%<\u009b\u00cfh\u008a0\u00e0p\u00c6 W\u00e4\u00c3\u00d3\u0089\u0092z\u00a3S\u00a4$\u008b\u0001R6\u0006\u0015\u009f\u00db\u0015\u00f7\u00cc\u00b4I<6\t*,\u000er\u00b2\u00b2)\u00d8~\u0013l\u00f7\u009a\u00a2A\u001bd2\u001dD2G,\u00f7(\u0017zw\t:\u00e9\u00ef\u0084\u0005'\u00e9('\u00b9\u00f2?\u0086s'}\u0092\u00e7I\u008f\u0014@\u00f4\u00d2\u00b0\u00d5\u00f6\u008a\u009f\u009d\u00d3\u001e\u007f\u00f7J\u0098\u009b\u00ae\u0000\u00bd2\u000eY\u00d6\u00ea\u00fd\u00b4\u0010\"\u00fb\u00ed\u0098\u00d6\u0013I`\rD\u00ba\u00fbj\u00ce;\u0003I\u00ef\u00c9\u00d1zp*\u0082\u00bc\u0005D\u00f7\u00db_\u008dO\u0089\u00a3z^+A\u0095\u0091et`T\u00a06D\u00b8\f.\u00ed\u00d4L\u0091\u0018\u00c9H\u00cd\u00bd:\u001b\u00c3\u00e1\u00e6\u00d1LN\u0011\u0016m\u0000E\u001fY/\u00f3de\u000ei'\u00c1\u0093pi}\u0010\u001et\u0019\u00a0\u00ac\u00f4\u00a5\u00dfx\u00db\u00a2~`jj\u009f\u00f0\u0080v\"w[\u00f9\u00aa\u0018\u00bc\u00ac#l\u00cdj\u00d2M\u0014\u00f4{\u00d6t\u00a9\u00b3\u0084\u0000J.\u00c6l\u00e9\u00e7\u00c4\u00f4\u00bf\u00cc^\u00e6H7\u00e9\u00ad\n\u00a2\u0091\rd\u008b\u00ce*\u00fdA\u0081g\u00f0\u00c2\u0084\u00f35\u0018t\u00be\u00fd\u00bf\u008dN\u00ae\u00de\u0014\u00fck0\u00d9\u00ff\u0092\u00189\u0003!\u0016(\u00dd_\u009d\u00b0Z\u001f5dY\u00d8\u00d7\u00e7\u008aW\u00cf1Z\u00ee\u00ec`j\u0097\u0019\u00d4\u00bf:\u0084ia\u00a31\u0011\u00c3X\u00e7@\u00f7\u00c7z\u00fd\u00deF\u0004PIp\u00ef\u00a5\u00f6\u0011\u008d\u00ed\u0014\u00b8\u0013\u00ee\u00bdEu\u00db\u0000\u00ec[\u00b7<J\u00fb,\u001d5\u00f7\u0017\u0081\u00f4\u00f7\u00bc\u00e4\u00bf\u00da\u001e(\u007fu\u00ac[\u0090V<\u00bc]\u00b9$\u00d7\u00b9\u00a5NRE0\u00fdJ\u00e8\u001a\u00bc\u00b53\u008e,\u009a\u00af7\u007f\u0016V\u0015\u008cnKa\u00d5|\u001aT\u00b9?\u00c6\u0010\u001a\u008f\u000e\u00f2\u00aa|\u0000\u00e6^\u0010B\u00b8\u00d9\u00ce\u00eb\u00b8b\u0010b\u00b1\u00a2%\u00d4\u00ef\u00d9\b><\u00e9\u00f1\u00e7\u0010s\u00e2G\u0013\u0019\u008ah\u00a0\u0011\u00c4l\u0087\b\u00d3\u001761\u0099_\u00d5g\u00d4\u00a6J~VA,\r+\u0011J\u0002\u00f8\u00dc\t\u0088\n\u0003Vu\u0094\u00d8H(\u00a5\u0017\u00e4c\u0007\u00f5\u00cc3usU%^\u0011Z\u00b7\u009bql[\u00a5\u00f7\u00c7\u0090YA\u00b7";
                var4_3 = "\u00ce\u0086.\u00a39\u000b\u00a9:=\u00e42\u008b\u001ac\f \u00d0\u0095\u0018#\u00cc\u000e\u0086l9\u00f2\u00b2\u0018\u0082\u00cb\u00f8\u00c0\u00e7\u00af\u00b59\u00ac\u009b\u0083{\u00a8\u00fbI\u00c2\u0014\u001bwf\u00d3\u00e2\f\u0086\u00af_\u0015\u00cd\u00e9\u00aeQ\u008f\u00d3\u00e6\u00a9\u008bf\u00d0:\u00be\u007f\u009d\u00a4\u0099\u00f0\u00b9\u00ee\u008e\n\u0097\u008d(\u001d\u00b9\u00f3I\u00fa\u00103\u0013\u0097ic\u00d6'.PF\u00a6LV\u0017'r\u0090\u00d6\u00cd\u0095{Zp\u00ba\u00c2\u008f\u00d9\u00ea\u00b9\u0098\u001b}v\u001a?\u00b4%\u001b\u00e9`V.\u009f\u00ac\u00adY<\u0091\u0016\u00eb\u0012\u001c]\u0084\u0085#^\u008d%<\u009b\u00cfh\u008a0\u00e0p\u00c6 W\u00e4\u00c3\u00d3\u0089\u0092z\u00a3S\u00a4$\u008b\u0001R6\u0006\u0015\u009f\u00db\u0015\u00f7\u00cc\u00b4I<6\t*,\u000er\u00b2\u00b2)\u00d8~\u0013l\u00f7\u009a\u00a2A\u001bd2\u001dD2G,\u00f7(\u0017zw\t:\u00e9\u00ef\u0084\u0005'\u00e9('\u00b9\u00f2?\u0086s'}\u0092\u00e7I\u008f\u0014@\u00f4\u00d2\u00b0\u00d5\u00f6\u008a\u009f\u009d\u00d3\u001e\u007f\u00f7J\u0098\u009b\u00ae\u0000\u00bd2\u000eY\u00d6\u00ea\u00fd\u00b4\u0010\"\u00fb\u00ed\u0098\u00d6\u0013I`\rD\u00ba\u00fbj\u00ce;\u0003I\u00ef\u00c9\u00d1zp*\u0082\u00bc\u0005D\u00f7\u00db_\u008dO\u0089\u00a3z^+A\u0095\u0091et`T\u00a06D\u00b8\f.\u00ed\u00d4L\u0091\u0018\u00c9H\u00cd\u00bd:\u001b\u00c3\u00e1\u00e6\u00d1LN\u0011\u0016m\u0000E\u001fY/\u00f3de\u000ei'\u00c1\u0093pi}\u0010\u001et\u0019\u00a0\u00ac\u00f4\u00a5\u00dfx\u00db\u00a2~`jj\u009f\u00f0\u0080v\"w[\u00f9\u00aa\u0018\u00bc\u00ac#l\u00cdj\u00d2M\u0014\u00f4{\u00d6t\u00a9\u00b3\u0084\u0000J.\u00c6l\u00e9\u00e7\u00c4\u00f4\u00bf\u00cc^\u00e6H7\u00e9\u00ad\n\u00a2\u0091\rd\u008b\u00ce*\u00fdA\u0081g\u00f0\u00c2\u0084\u00f35\u0018t\u00be\u00fd\u00bf\u008dN\u00ae\u00de\u0014\u00fck0\u00d9\u00ff\u0092\u00189\u0003!\u0016(\u00dd_\u009d\u00b0Z\u001f5dY\u00d8\u00d7\u00e7\u008aW\u00cf1Z\u00ee\u00ec`j\u0097\u0019\u00d4\u00bf:\u0084ia\u00a31\u0011\u00c3X\u00e7@\u00f7\u00c7z\u00fd\u00deF\u0004PIp\u00ef\u00a5\u00f6\u0011\u008d\u00ed\u0014\u00b8\u0013\u00ee\u00bdEu\u00db\u0000\u00ec[\u00b7<J\u00fb,\u001d5\u00f7\u0017\u0081\u00f4\u00f7\u00bc\u00e4\u00bf\u00da\u001e(\u007fu\u00ac[\u0090V<\u00bc]\u00b9$\u00d7\u00b9\u00a5NRE0\u00fdJ\u00e8\u001a\u00bc\u00b53\u008e,\u009a\u00af7\u007f\u0016V\u0015\u008cnKa\u00d5|\u001aT\u00b9?\u00c6\u0010\u001a\u008f\u000e\u00f2\u00aa|\u0000\u00e6^\u0010B\u00b8\u00d9\u00ce\u00eb\u00b8b\u0010b\u00b1\u00a2%\u00d4\u00ef\u00d9\b><\u00e9\u00f1\u00e7\u0010s\u00e2G\u0013\u0019\u008ah\u00a0\u0011\u00c4l\u0087\b\u00d3\u001761\u0099_\u00d5g\u00d4\u00a6J~VA,\r+\u0011J\u0002\u00f8\u00dc\t\u0088\n\u0003Vu\u0094\u00d8H(\u00a5\u0017\u00e4c\u0007\u00f5\u00cc3usU%^\u0011Z\u00b7\u009bql[\u00a5\u00f7\u00c7\u0090YA\u00b7".length();
                var1_4 = 42;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "G\u00a9X\u001a+\u00f2\u00f9H,\"\u0097S\u00e74\u008a\\b'^\u00b4J\r\u00d0\u008d\u0097]\u00e7P\u00b7\u00feCN\u00fd\u00198<r\u00af\u00d2\u00864q\u00d5\u00b2(\u0081\u00a1s\u00c1k\u0005C\u00d6\u00b2\u00f4\u00d9~\u0006\u0090\u00b9\u00f4\u00bb\u00e4\"\u00d0\u0013I\u00c3\u00df\u00dc\u00c3\u00d13\u0010\u0002\u0088\u00b0\u00a8\u00c1S\u00f4\u00b02\u00aa\u0016";
                    var4_3 = "G\u00a9X\u001a+\u00f2\u00f9H,\"\u0097S\u00e74\u008a\\b'^\u00b4J\r\u00d0\u008d\u0097]\u00e7P\u00b7\u00feCN\u00fd\u00198<r\u00af\u00d2\u00864q\u00d5\u00b2(\u0081\u00a1s\u00c1k\u0005C\u00d6\u00b2\u00f4\u00d9~\u0006\u0090\u00b9\u00f4\u00bb\u00e4\"\u00d0\u0013I\u00c3\u00df\u00dc\u00c3\u00d13\u0010\u0002\u0088\u00b0\u00a8\u00c1S\u00f4\u00b02\u00aa\u0016".length();
                    var1_4 = 44;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 113;
                            break;
                        }
                        case 1: {
                            v13 = 13;
                            break;
                        }
                        case 2: {
                            v13 = 45;
                            break;
                        }
                        case 3: {
                            v13 = 117;
                            break;
                        }
                        case 4: {
                            v13 = 33;
                            break;
                        }
                        case 5: {
                            v13 = 82;
                            break;
                        }
                        default: {
                            v13 = 42;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        CertStoreDirectoryOps.c = var5;
        CertStoreDirectoryOps.d = new String[17];
        CertStoreDirectoryOps.a = LoggerFactory.getLogger(CertStoreDirectoryOps.class);
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0xFFFF975C) & 0xFFFF;
        if (d[n3] == null) {
            int n4;
            int n5;
            char[] cArray = c[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 182;
                    break;
                }
                case 1: {
                    n5 = 235;
                    break;
                }
                case 2: {
                    n5 = 39;
                    break;
                }
                case 3: {
                    n5 = 131;
                    break;
                }
                case 4: {
                    n5 = 237;
                    break;
                }
                case 5: {
                    n5 = 116;
                    break;
                }
                case 6: {
                    n5 = 249;
                    break;
                }
                case 7: {
                    n5 = 90;
                    break;
                }
                case 8: {
                    n5 = 99;
                    break;
                }
                case 9: {
                    n5 = 147;
                    break;
                }
                case 10: {
                    n5 = 7;
                    break;
                }
                case 11: {
                    n5 = 14;
                    break;
                }
                case 12: {
                    n5 = 122;
                    break;
                }
                case 13: {
                    n5 = 154;
                    break;
                }
                case 14: {
                    n5 = 65;
                    break;
                }
                case 15: {
                    n5 = 84;
                    break;
                }
                case 16: {
                    n5 = 17;
                    break;
                }
                case 17: {
                    n5 = 190;
                    break;
                }
                case 18: {
                    n5 = 16;
                    break;
                }
                case 19: {
                    n5 = 32;
                    break;
                }
                case 20: {
                    n5 = 159;
                    break;
                }
                case 21: {
                    n5 = 89;
                    break;
                }
                case 22: {
                    n5 = 112;
                    break;
                }
                case 23: {
                    n5 = 223;
                    break;
                }
                case 24: {
                    n5 = 230;
                    break;
                }
                case 25: {
                    n5 = 47;
                    break;
                }
                case 26: {
                    n5 = 206;
                    break;
                }
                case 27: {
                    n5 = 246;
                    break;
                }
                case 28: {
                    n5 = 232;
                    break;
                }
                case 29: {
                    n5 = 165;
                    break;
                }
                case 30: {
                    n5 = 208;
                    break;
                }
                case 31: {
                    n5 = 121;
                    break;
                }
                case 32: {
                    n5 = 210;
                    break;
                }
                case 33: {
                    n5 = 94;
                    break;
                }
                case 34: {
                    n5 = 29;
                    break;
                }
                case 35: {
                    n5 = 134;
                    break;
                }
                case 36: {
                    n5 = 193;
                    break;
                }
                case 37: {
                    n5 = 150;
                    break;
                }
                case 38: {
                    n5 = 88;
                    break;
                }
                case 39: {
                    n5 = 125;
                    break;
                }
                case 40: {
                    n5 = 24;
                    break;
                }
                case 41: {
                    n5 = 162;
                    break;
                }
                case 42: {
                    n5 = 226;
                    break;
                }
                case 43: {
                    n5 = 252;
                    break;
                }
                case 44: {
                    n5 = 86;
                    break;
                }
                case 45: {
                    n5 = 141;
                    break;
                }
                case 46: {
                    n5 = 22;
                    break;
                }
                case 47: {
                    n5 = 215;
                    break;
                }
                case 48: {
                    n5 = 67;
                    break;
                }
                case 49: {
                    n5 = 75;
                    break;
                }
                case 50: {
                    n5 = 77;
                    break;
                }
                case 51: {
                    n5 = 95;
                    break;
                }
                case 52: {
                    n5 = 124;
                    break;
                }
                case 53: {
                    n5 = 229;
                    break;
                }
                case 54: {
                    n5 = 205;
                    break;
                }
                case 55: {
                    n5 = 108;
                    break;
                }
                case 56: {
                    n5 = 101;
                    break;
                }
                case 57: {
                    n5 = 66;
                    break;
                }
                case 58: {
                    n5 = 185;
                    break;
                }
                case 59: {
                    n5 = 233;
                    break;
                }
                case 60: {
                    n5 = 178;
                    break;
                }
                case 61: {
                    n5 = 170;
                    break;
                }
                case 62: {
                    n5 = 209;
                    break;
                }
                case 63: {
                    n5 = 59;
                    break;
                }
                case 64: {
                    n5 = 85;
                    break;
                }
                case 65: {
                    n5 = 161;
                    break;
                }
                case 66: {
                    n5 = 55;
                    break;
                }
                case 67: {
                    n5 = 49;
                    break;
                }
                case 68: {
                    n5 = 253;
                    break;
                }
                case 69: {
                    n5 = 82;
                    break;
                }
                case 70: {
                    n5 = 10;
                    break;
                }
                case 71: {
                    n5 = 20;
                    break;
                }
                case 72: {
                    n5 = 245;
                    break;
                }
                case 73: {
                    n5 = 247;
                    break;
                }
                case 74: {
                    n5 = 255;
                    break;
                }
                case 75: {
                    n5 = 196;
                    break;
                }
                case 76: {
                    n5 = 158;
                    break;
                }
                case 77: {
                    n5 = 110;
                    break;
                }
                case 78: {
                    n5 = 126;
                    break;
                }
                case 79: {
                    n5 = 13;
                    break;
                }
                case 80: {
                    n5 = 115;
                    break;
                }
                case 81: {
                    n5 = 251;
                    break;
                }
                case 82: {
                    n5 = 149;
                    break;
                }
                case 83: {
                    n5 = 40;
                    break;
                }
                case 84: {
                    n5 = 220;
                    break;
                }
                case 85: {
                    n5 = 57;
                    break;
                }
                case 86: {
                    n5 = 64;
                    break;
                }
                case 87: {
                    n5 = 195;
                    break;
                }
                case 88: {
                    n5 = 132;
                    break;
                }
                case 89: {
                    n5 = 70;
                    break;
                }
                case 90: {
                    n5 = 107;
                    break;
                }
                case 91: {
                    n5 = 213;
                    break;
                }
                case 92: {
                    n5 = 243;
                    break;
                }
                case 93: {
                    n5 = 216;
                    break;
                }
                case 94: {
                    n5 = 96;
                    break;
                }
                case 95: {
                    n5 = 157;
                    break;
                }
                case 96: {
                    n5 = 69;
                    break;
                }
                case 97: {
                    n5 = 148;
                    break;
                }
                case 98: {
                    n5 = 21;
                    break;
                }
                case 99: {
                    n5 = 179;
                    break;
                }
                case 100: {
                    n5 = 153;
                    break;
                }
                case 101: {
                    n5 = 172;
                    break;
                }
                case 102: {
                    n5 = 87;
                    break;
                }
                case 103: {
                    n5 = 254;
                    break;
                }
                case 104: {
                    n5 = 35;
                    break;
                }
                case 105: {
                    n5 = 48;
                    break;
                }
                case 106: {
                    n5 = 136;
                    break;
                }
                case 107: {
                    n5 = 54;
                    break;
                }
                case 108: {
                    n5 = 83;
                    break;
                }
                case 109: {
                    n5 = 151;
                    break;
                }
                case 110: {
                    n5 = 143;
                    break;
                }
                case 111: {
                    n5 = 201;
                    break;
                }
                case 112: {
                    n5 = 38;
                    break;
                }
                case 113: {
                    n5 = 248;
                    break;
                }
                case 114: {
                    n5 = 202;
                    break;
                }
                case 115: {
                    n5 = 76;
                    break;
                }
                case 116: {
                    n5 = 214;
                    break;
                }
                case 117: {
                    n5 = 207;
                    break;
                }
                case 118: {
                    n5 = 175;
                    break;
                }
                case 119: {
                    n5 = 109;
                    break;
                }
                case 120: {
                    n5 = 119;
                    break;
                }
                case 121: {
                    n5 = 238;
                    break;
                }
                case 122: {
                    n5 = 156;
                    break;
                }
                case 123: {
                    n5 = 0;
                    break;
                }
                case 124: {
                    n5 = 41;
                    break;
                }
                case 125: {
                    n5 = 228;
                    break;
                }
                case 126: {
                    n5 = 174;
                    break;
                }
                case 127: {
                    n5 = 3;
                    break;
                }
                case 128: {
                    n5 = 113;
                    break;
                }
                case 129: {
                    n5 = 123;
                    break;
                }
                case 130: {
                    n5 = 139;
                    break;
                }
                case 131: {
                    n5 = 163;
                    break;
                }
                case 132: {
                    n5 = 52;
                    break;
                }
                case 133: {
                    n5 = 236;
                    break;
                }
                case 134: {
                    n5 = 203;
                    break;
                }
                case 135: {
                    n5 = 97;
                    break;
                }
                case 136: {
                    n5 = 50;
                    break;
                }
                case 137: {
                    n5 = 192;
                    break;
                }
                case 138: {
                    n5 = 244;
                    break;
                }
                case 139: {
                    n5 = 71;
                    break;
                }
                case 140: {
                    n5 = 1;
                    break;
                }
                case 141: {
                    n5 = 186;
                    break;
                }
                case 142: {
                    n5 = 176;
                    break;
                }
                case 143: {
                    n5 = 104;
                    break;
                }
                case 144: {
                    n5 = 60;
                    break;
                }
                case 145: {
                    n5 = 42;
                    break;
                }
                case 146: {
                    n5 = 225;
                    break;
                }
                case 147: {
                    n5 = 189;
                    break;
                }
                case 148: {
                    n5 = 211;
                    break;
                }
                case 149: {
                    n5 = 43;
                    break;
                }
                case 150: {
                    n5 = 198;
                    break;
                }
                case 151: {
                    n5 = 72;
                    break;
                }
                case 152: {
                    n5 = 2;
                    break;
                }
                case 153: {
                    n5 = 5;
                    break;
                }
                case 154: {
                    n5 = 102;
                    break;
                }
                case 155: {
                    n5 = 130;
                    break;
                }
                case 156: {
                    n5 = 103;
                    break;
                }
                case 157: {
                    n5 = 177;
                    break;
                }
                case 158: {
                    n5 = 111;
                    break;
                }
                case 159: {
                    n5 = 128;
                    break;
                }
                case 160: {
                    n5 = 191;
                    break;
                }
                case 161: {
                    n5 = 188;
                    break;
                }
                case 162: {
                    n5 = 26;
                    break;
                }
                case 163: {
                    n5 = 152;
                    break;
                }
                case 164: {
                    n5 = 15;
                    break;
                }
                case 165: {
                    n5 = 224;
                    break;
                }
                case 166: {
                    n5 = 8;
                    break;
                }
                case 167: {
                    n5 = 133;
                    break;
                }
                case 168: {
                    n5 = 81;
                    break;
                }
                case 169: {
                    n5 = 12;
                    break;
                }
                case 170: {
                    n5 = 194;
                    break;
                }
                case 171: {
                    n5 = 118;
                    break;
                }
                case 172: {
                    n5 = 140;
                    break;
                }
                case 173: {
                    n5 = 145;
                    break;
                }
                case 174: {
                    n5 = 227;
                    break;
                }
                case 175: {
                    n5 = 129;
                    break;
                }
                case 176: {
                    n5 = 138;
                    break;
                }
                case 177: {
                    n5 = 184;
                    break;
                }
                case 178: {
                    n5 = 219;
                    break;
                }
                case 179: {
                    n5 = 58;
                    break;
                }
                case 180: {
                    n5 = 197;
                    break;
                }
                case 181: {
                    n5 = 231;
                    break;
                }
                case 182: {
                    n5 = 212;
                    break;
                }
                case 183: {
                    n5 = 117;
                    break;
                }
                case 184: {
                    n5 = 80;
                    break;
                }
                case 185: {
                    n5 = 79;
                    break;
                }
                case 186: {
                    n5 = 62;
                    break;
                }
                case 187: {
                    n5 = 222;
                    break;
                }
                case 188: {
                    n5 = 56;
                    break;
                }
                case 189: {
                    n5 = 137;
                    break;
                }
                case 190: {
                    n5 = 240;
                    break;
                }
                case 191: {
                    n5 = 44;
                    break;
                }
                case 192: {
                    n5 = 221;
                    break;
                }
                case 193: {
                    n5 = 34;
                    break;
                }
                case 194: {
                    n5 = 217;
                    break;
                }
                case 195: {
                    n5 = 169;
                    break;
                }
                case 196: {
                    n5 = 183;
                    break;
                }
                case 197: {
                    n5 = 142;
                    break;
                }
                case 198: {
                    n5 = 160;
                    break;
                }
                case 199: {
                    n5 = 73;
                    break;
                }
                case 200: {
                    n5 = 46;
                    break;
                }
                case 201: {
                    n5 = 199;
                    break;
                }
                case 202: {
                    n5 = 250;
                    break;
                }
                case 203: {
                    n5 = 78;
                    break;
                }
                case 204: {
                    n5 = 144;
                    break;
                }
                case 205: {
                    n5 = 68;
                    break;
                }
                case 206: {
                    n5 = 239;
                    break;
                }
                case 207: {
                    n5 = 127;
                    break;
                }
                case 208: {
                    n5 = 30;
                    break;
                }
                case 209: {
                    n5 = 181;
                    break;
                }
                case 210: {
                    n5 = 173;
                    break;
                }
                case 211: {
                    n5 = 105;
                    break;
                }
                case 212: {
                    n5 = 11;
                    break;
                }
                case 213: {
                    n5 = 6;
                    break;
                }
                case 214: {
                    n5 = 242;
                    break;
                }
                case 215: {
                    n5 = 166;
                    break;
                }
                case 216: {
                    n5 = 100;
                    break;
                }
                case 217: {
                    n5 = 204;
                    break;
                }
                case 218: {
                    n5 = 180;
                    break;
                }
                case 219: {
                    n5 = 31;
                    break;
                }
                case 220: {
                    n5 = 9;
                    break;
                }
                case 221: {
                    n5 = 218;
                    break;
                }
                case 222: {
                    n5 = 61;
                    break;
                }
                case 223: {
                    n5 = 234;
                    break;
                }
                case 224: {
                    n5 = 164;
                    break;
                }
                case 225: {
                    n5 = 23;
                    break;
                }
                case 226: {
                    n5 = 19;
                    break;
                }
                case 227: {
                    n5 = 91;
                    break;
                }
                case 228: {
                    n5 = 155;
                    break;
                }
                case 229: {
                    n5 = 146;
                    break;
                }
                case 230: {
                    n5 = 168;
                    break;
                }
                case 231: {
                    n5 = 98;
                    break;
                }
                case 232: {
                    n5 = 120;
                    break;
                }
                case 233: {
                    n5 = 74;
                    break;
                }
                case 234: {
                    n5 = 45;
                    break;
                }
                case 235: {
                    n5 = 167;
                    break;
                }
                case 236: {
                    n5 = 51;
                    break;
                }
                case 237: {
                    n5 = 25;
                    break;
                }
                case 238: {
                    n5 = 135;
                    break;
                }
                case 239: {
                    n5 = 200;
                    break;
                }
                case 240: {
                    n5 = 187;
                    break;
                }
                case 241: {
                    n5 = 53;
                    break;
                }
                case 242: {
                    n5 = 114;
                    break;
                }
                case 243: {
                    n5 = 106;
                    break;
                }
                case 244: {
                    n5 = 63;
                    break;
                }
                case 245: {
                    n5 = 4;
                    break;
                }
                case 246: {
                    n5 = 28;
                    break;
                }
                case 247: {
                    n5 = 37;
                    break;
                }
                case 248: {
                    n5 = 93;
                    break;
                }
                case 249: {
                    n5 = 241;
                    break;
                }
                case 250: {
                    n5 = 33;
                    break;
                }
                case 251: {
                    n5 = 171;
                    break;
                }
                case 252: {
                    n5 = 27;
                    break;
                }
                case 253: {
                    n5 = 18;
                    break;
                }
                case 254: {
                    n5 = 36;
                    break;
                }
                default: {
                    n5 = 92;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            CertStoreDirectoryOps.d[n3] = new String(cArray).intern();
        }
        return d[n3];
    }
}

