/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.smyy.utils;

import com.turktrust.smyy.utils.AkilliKarttakiAcikAnahtar;
import com.turktrust.smyy.utils.AkilliKarttakiGizliAnahtar;
import com.turktrust.smyy.utils.AkilliKarttakiSertifika;
import com.turktrust.x509.Certificate;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;

public class Smartcard {
    public static int OK = 0;
    public static int PIN_LOCKED = 164;
    private static String p11DLLName;

    private static native int initDLL(String var0);

    private static native int openSessionDLL(String var0);

    private static native int loginDLL(String var0, int var1);

    private static native int logoutDLL();

    private static native int closeSessionDLL();

    private static native int finalizeDLL();

    private static native int isSessionOpenDLL();

    private static native int[] getSessionInfoDLL();

    private static native int changePINDLL(String var0, int var1, String var2, int var3);

    private static native int initUserPINDLL(String var0, int var1);

    private static native int initTokenDLL(String var0, int var1);

    private static native byte[] generateKeyPairDLL(int var0, byte[] var1, byte[] var2, byte[] var3);

    private static native byte[] signDLL(byte[] var0);

    private static native byte[] signWithIDDLL(byte[] var0, byte[] var1);

    private static native byte[] readAttributeCertificateDLL();

    private static native byte[] readCertificateIDDLL();

    private static native byte[] readCertificateLabelDLL();

    private static native byte[] readPublicKeyIDDLL();

    private static native byte[] readPublicKeyLabelDLL();

    private static native byte[] readPrivateKeyIDDLL();

    private static native byte[] readPrivateKeyLabelDLL();

    private static native int deleteDLL();

    private static native byte[] readCertificateDLL();

    private static native byte[][] readAllCertificatesDLL();

    private static native int waitForSlotEventDLL();

    private static native int setCertificateLabelDLL(byte[] var0);

    private static native int isCardEmptyDLL();

    private static native int writeAttributeCertificateDLL(byte[] var0);

    private static native int writeCertificateDLL(byte[] var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5);

    private static native int writeCertificateAndPrivateKeyDLL(byte[] var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7, byte[] var8, byte[] var9, byte[] var10, byte[] var11, byte[] var12, byte[] var13);

    private static native int writePrivateKeyDLL(byte[] var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7, byte[] var8, byte[] var9);

    private static native int writePublicKeyDLL(byte[] var0, byte[] var1, byte[] var2, byte[] var3);

    private static native int deleteCertificateDLL(byte[] var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    private static native int deletePublicKeyDLL(byte[] var0);

    private static native int deletePrivateKeyDLL(byte[] var0);

    private static native int deleteAllCertificatesDLL();

    private static native int[] getSupportedMechanismListDLL();

    private static native int getObjectCountInTheTokenDLL();

    private static native int getSlotInfoDLL();

    private static native int getTokenInfoDLL();

    private static native int getMechanismInfoDLL(int var0);

    private static native byte[] readCardLabelDLL();

    private static native int updateKeyPairIDAndLabelDLL(byte[] var0, byte[] var1, byte[] var2);

    private static native byte[][] readAllRSAPublicKeysDLL();

    private static native byte[][] readAllRSAPrivateKeysDLL();

    private static native byte[] readCardSerialNumberDLL();

    public static int getSlotInfo() {
        return Smartcard.getSlotInfoDLL();
    }

    public static int getMechanismInfo(int mechanismType) {
        return Smartcard.getMechanismInfoDLL(mechanismType);
    }

    public static int getTokenInfo() {
        return Smartcard.getTokenInfoDLL();
    }

    public static String readCardLabel() {
        try {
            byte[] labelBytes = Smartcard.readCardLabelDLL();
            if (labelBytes.length > 1) {
                String labelStr = new String(labelBytes, "UTF-8");
                return labelStr.trim();
            }
            return "P11 Error : " + new String(labelBytes, "UTF-8");
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static int getObjectCountInTheToken() {
        return Smartcard.getObjectCountInTheTokenDLL();
    }

    public static int[] getSupportedMechanismList() {
        return Smartcard.getSupportedMechanismListDLL();
    }

    public static int setCertificateLabel(String label) {
        return Smartcard.setCertificateLabelDLL(label.getBytes());
    }

    public static int[] getSessionInfo() {
        return Smartcard.getSessionInfoDLL();
    }

    public static boolean isCardEmpty() {
        return Smartcard.isCardEmptyDLL() == 0;
    }

    public static int waitForSlotEvent() {
        return Smartcard.waitForSlotEventDLL();
    }

    public static int delete() {
        return Smartcard.deleteDLL();
    }

    public static byte[] generateKeyPair(int modulusLengthInBits, byte[] publicExponent, String id, String label) {
        try {
            byte[] arr = Smartcard.generateKeyPairDLL(modulusLengthInBits, publicExponent, Smartcard.correctID(id), label.getBytes("UTF-8"));
            if (arr.length == 1) {
                System.out.println("RV = " + arr[0]);
                return null;
            }
            return arr;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static int writeCertificate(Certificate cert, String id, String label) {
        try {
            byte[] certValue = cert.getEncoded();
            byte[] subject = cert.gettbsCertificate().getsubject().getEncoded();
            byte[] issuer = cert.gettbsCertificate().getissuer().getEncoded();
            byte[] serialNo = ((BigInteger)cert.gettbsCertificate().getserialNumber().getValue()).toByteArray();
            return Smartcard.writeCertificateDLL(certValue, subject, issuer, serialNo, Smartcard.correctID(id), label.getBytes("UTF-8"));
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return -1;
        }
    }

    public static int writeCertificate(AkilliKarttakiSertifika aks) {
        try {
            Certificate cert = aks.getCertificate();
            byte[] certValue = cert.getEncoded();
            byte[] subject = cert.gettbsCertificate().getsubject().getEncoded();
            byte[] issuer = cert.gettbsCertificate().getissuer().getEncoded();
            byte[] serialNo = ((BigInteger)cert.gettbsCertificate().getserialNumber().getValue()).toByteArray();
            return Smartcard.writeCertificateDLL(certValue, subject, issuer, serialNo, aks.getIdBytes(), aks.getLabelBytes());
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return -1;
        }
    }

    public static byte[] readCertificateID() {
        byte[] id = Smartcard.readCertificateIDDLL();
        return Smartcard.removeEndingZero(id);
    }

    public static String readCertificateLabel() {
        byte[] label = Smartcard.readCertificateLabelDLL();
        if (label.length == 1) {
            return null;
        }
        try {
            return new String(label, "UTF-8");
        }
        catch (Exception exc) {
            return new String(label);
        }
    }

    public static byte[] readPublicKeyID() {
        byte[] id = Smartcard.readPublicKeyIDDLL();
        return Smartcard.removeEndingZero(id);
    }

    public static String readPublicKeyLabel() {
        byte[] label = Smartcard.readPublicKeyLabelDLL();
        if (label.length == 1) {
            return null;
        }
        try {
            return new String(label, "UTF-8");
        }
        catch (Exception exc) {
            return new String(label);
        }
    }

    public static byte[] readPrivateKeyID() {
        byte[] id = Smartcard.readPrivateKeyIDDLL();
        return Smartcard.removeEndingZero(id);
    }

    public static String readPrivateKeyLabel() {
        byte[] label = Smartcard.readPrivateKeyLabelDLL();
        if (label.length == 1) {
            return null;
        }
        try {
            return new String(label, "UTF-8");
        }
        catch (Exception exc) {
            return new String(label);
        }
    }

    public static boolean isSessionOpen() {
        return Smartcard.isSessionOpenDLL() == 0;
    }

    public static boolean isUserPinBlocked() {
        int tokenInfo = Smartcard.getTokenInfoDLL();
        return (tokenInfo & 0x40000) != 0;
    }

    public static int getUserLoginAttemptFlag() {
        if (p11DLLName.equals("gclib.dll")) {
            int[] sessionInfo = Smartcard.getSessionInfo();
            int ulDeviceError = sessionInfo[3];
            int remainingTryCount = (ulDeviceError & 0xFF0000) >> 16;
            return remainingTryCount;
        }
        int tokenInfo = Smartcard.getTokenInfoDLL();
        int flag = (tokenInfo & 0x70000) >> 16;
        if (flag == 4) {
            return 0;
        }
        if (flag == 2) {
            return 1;
        }
        if (flag == 1) {
            return 2;
        }
        return 3;
    }

    public static boolean isTokenPresent() {
        int slotInfo = Smartcard.getSlotInfoDLL();
        return (slotInfo & 1) != 0;
    }

    public static int changePIN(String oldPIN, String newPIN) {
        return Smartcard.changePINDLL(oldPIN, oldPIN.length(), newPIN, newPIN.length());
    }

    public static int initUserPIN(String newPIN) {
        return Smartcard.initUserPINDLL(newPIN, newPIN.length());
    }

    public static int initToken(String adminPin) {
        return Smartcard.initTokenDLL(adminPin, adminPin.length());
    }

    public static byte[] sign(byte[] hash) {
        byte[] arr = Smartcard.signDLL(hash);
        if (arr.length == 1) {
            System.out.println("Sign hata = " + arr[0]);
            int[] sesInfo = Smartcard.getSessionInfo();
            for (int i = 0; i < sesInfo.length; ++i) {
                System.out.println("Info[" + i + "] = " + sesInfo[i]);
            }
            return null;
        }
        return arr;
    }

    public static byte[] sign(byte[] data, String hashAlgOID) {
        try {
            if (!hashAlgOID.equals("1.3.14.3.2.26")) {
                return null;
            }
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            byte[] hash = sha1.digest(data);
            byte[] arr = Smartcard.signDLL(hash);
            if (arr.length == 1) {
                return null;
            }
            return arr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] signWithID(byte[] hash, byte[] certId) {
        byte[] arr = Smartcard.signWithIDDLL(hash, certId);
        if (arr.length == 1) {
            return null;
        }
        return arr;
    }

    public static int initializeSmartCardEnvironment(String p11FileName) {
        p11DLLName = p11FileName;
        return Smartcard.initDLL(p11FileName);
    }

    public static int openSession(String p11FileName) {
        return Smartcard.openSessionDLL(p11FileName);
    }

    public static int closeSession() {
        return Smartcard.closeSessionDLL();
    }

    public static int finalizeSmartcard() {
        return Smartcard.finalizeDLL();
    }

    public static int loginAsSecurityOfficer(String securityOfficerPIN) {
        return Smartcard.loginDLL(securityOfficerPIN, 0);
    }

    public static int login(String userPIN) {
        return Smartcard.loginDLL(userPIN, 1);
    }

    public static int logout() {
        return Smartcard.logoutDLL();
    }

    public static byte[] readCertificate() {
        byte[] arr = Smartcard.readCertificateDLL();
        if (arr.length == 1) {
            return null;
        }
        return arr;
    }

    public static AkilliKarttakiSertifika[] readAllCertificates() {
        try {
            byte[][] cardBytes = Smartcard.readAllCertificatesDLL();
            if (cardBytes[0][0] == (byte)OK) {
                AkilliKarttakiSertifika[] resaks = new AkilliKarttakiSertifika[(cardBytes.length - 1) / 3];
                for (int i = 1; i < cardBytes.length; i += 3) {
                    AkilliKarttakiSertifika aks;
                    byte[] idBytes = cardBytes[i];
                    byte[] labelBytes = cardBytes[i + 1];
                    Certificate tempCert = new Certificate("tempCert");
                    tempCert.decode(cardBytes[i + 2]);
                    resaks[(i - 1) / 3] = aks = new AkilliKarttakiSertifika(tempCert, idBytes, labelBytes);
                }
                return resaks;
            }
            return null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static byte[] readAttributeCertificate() {
        byte[] arr = Smartcard.readAttributeCertificateDLL();
        if (arr.length == 1) {
            return null;
        }
        return arr;
    }

    public static int writePrivateKey(PrivateKey pk, String id, String label) {
        try {
            RSAPrivateCrtKey pkh = (RSAPrivateCrtKey)pk;
            byte[] mod = Smartcard.getUnsignedByteArray(pkh.getModulus());
            byte[] pubExpo = Smartcard.getUnsignedByteArray(pkh.getPublicExponent());
            byte[] priExpo = Smartcard.getUnsignedByteArray(pkh.getPrivateExponent());
            byte[] prime1 = Smartcard.getUnsignedByteArray(pkh.getPrimeP());
            byte[] prime2 = Smartcard.getUnsignedByteArray(pkh.getPrimeQ());
            byte[] expo1 = Smartcard.getUnsignedByteArray(pkh.getPrimeExponentP());
            byte[] expo2 = Smartcard.getUnsignedByteArray(pkh.getPrimeExponentQ());
            byte[] coeff = Smartcard.getUnsignedByteArray(pkh.getCrtCoefficient());
            return Smartcard.writePrivateKeyDLL(mod, pubExpo, priExpo, prime1, prime2, expo1, expo2, coeff, Smartcard.correctID(id), label.getBytes("UTF-8"));
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return -1;
        }
    }

    public static int writePublicKey(PublicKey pubkey, String id, String label) {
        try {
            RSAPublicKey rpk = (RSAPublicKey)pubkey;
            byte[] modulus = Smartcard.getUnsignedByteArray(rpk.getModulus());
            byte[] pubExpo = Smartcard.getUnsignedByteArray(rpk.getPublicExponent());
            return Smartcard.writePublicKeyDLL(modulus, pubExpo, Smartcard.correctID(id), label.getBytes("UTF-8"));
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return -1;
        }
    }

    public static int writeCertificateAndPrivateKey(Certificate cert, PrivateKey pk) {
        RSAPrivateCrtKey pkh = (RSAPrivateCrtKey)pk;
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            byte[] certValue = cert.getEncoded();
            byte[] subject = cert.gettbsCertificate().getsubject().getEncoded();
            byte[] issuer = cert.gettbsCertificate().getissuer().getEncoded();
            byte[] serialNo = ((BigInteger)cert.gettbsCertificate().getserialNumber().getValue()).toByteArray();
            byte[] mod = Smartcard.getUnsignedByteArray(pkh.getModulus());
            byte[] pubExpo = Smartcard.getUnsignedByteArray(pkh.getPublicExponent());
            byte[] priExpo = Smartcard.getUnsignedByteArray(pkh.getPrivateExponent());
            byte[] prime1 = Smartcard.getUnsignedByteArray(pkh.getPrimeP());
            byte[] prime2 = Smartcard.getUnsignedByteArray(pkh.getPrimeQ());
            byte[] expo1 = Smartcard.getUnsignedByteArray(pkh.getPrimeExponentP());
            byte[] expo2 = Smartcard.getUnsignedByteArray(pkh.getPrimeExponentQ());
            byte[] coeff = Smartcard.getUnsignedByteArray(pkh.getCrtCoefficient());
            byte[] label = cert.gettbsCertificate().getsubject().getCN().getBytes("UTF-8");
            byte[] idInput = new byte[issuer.length + subject.length];
            System.arraycopy(issuer, 0, idInput, 0, issuer.length);
            System.arraycopy(subject, 0, idInput, issuer.length, subject.length);
            byte[] idIncomplete = sha1.digest(idInput);
            byte[] id = new byte[idIncomplete.length + 1];
            System.arraycopy(idIncomplete, 0, id, 0, idIncomplete.length);
            id[id.length - 1] = 0;
            return Smartcard.writeCertificateAndPrivateKeyDLL(certValue, subject, issuer, serialNo, mod, pubExpo, priExpo, prime1, prime2, expo1, expo2, coeff, id, label);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int writeCertificateAndPrivateKey(Certificate cert, PrivateKey pk, String id) {
        RSAPrivateCrtKey pkh = (RSAPrivateCrtKey)pk;
        try {
            byte[] certValue = cert.getEncoded();
            byte[] subject = cert.gettbsCertificate().getsubject().getEncoded();
            byte[] issuer = cert.gettbsCertificate().getissuer().getEncoded();
            byte[] serialNo = ((BigInteger)cert.gettbsCertificate().getserialNumber().getValue()).toByteArray();
            byte[] mod = Smartcard.getUnsignedByteArray(pkh.getModulus());
            byte[] pubExpo = Smartcard.getUnsignedByteArray(pkh.getPublicExponent());
            byte[] priExpo = Smartcard.getUnsignedByteArray(pkh.getPrivateExponent());
            byte[] prime1 = Smartcard.getUnsignedByteArray(pkh.getPrimeP());
            byte[] prime2 = Smartcard.getUnsignedByteArray(pkh.getPrimeQ());
            byte[] expo1 = Smartcard.getUnsignedByteArray(pkh.getPrimeExponentP());
            byte[] expo2 = Smartcard.getUnsignedByteArray(pkh.getPrimeExponentQ());
            byte[] coeff = Smartcard.getUnsignedByteArray(pkh.getCrtCoefficient());
            byte[] label = cert.gettbsCertificate().getsubject().getCN().getBytes("UTF-8");
            return Smartcard.writeCertificateAndPrivateKeyDLL(certValue, subject, issuer, serialNo, mod, pubExpo, priExpo, prime1, prime2, expo1, expo2, coeff, Smartcard.correctID(id), label);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private static byte[] correctID(String idStr) {
        byte[] id = idStr.getBytes();
        if (id[id.length - 1] == 0) {
            return id;
        }
        byte[] idEndingWithZero = new byte[id.length + 1];
        System.arraycopy(id, 0, idEndingWithZero, 0, id.length);
        idEndingWithZero[id.length] = 0;
        return idEndingWithZero;
    }

    private static byte[] removeEndingZero(byte[] id) {
        if (id == null) {
            return null;
        }
        int len = id.length;
        if (len == 0) {
            return new byte[0];
        }
        if (id[len - 1] == 0) {
            byte[] bt = new byte[len - 1];
            System.arraycopy(id, 0, bt, 0, len - 1);
            return bt;
        }
        return id;
    }

    public static int deleteCertificate(Certificate cert, String id, String label) {
        try {
            byte[] certValue = cert.getEncoded();
            byte[] subject = cert.gettbsCertificate().getsubject().getEncoded();
            byte[] issuer = cert.gettbsCertificate().getissuer().getEncoded();
            byte[] serialNo = ((BigInteger)cert.gettbsCertificate().getserialNumber().getValue()).toByteArray();
            return Smartcard.deleteCertificateDLL(subject, issuer, serialNo, Smartcard.correctID(id), label.getBytes("UTF-8"));
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return -1;
        }
    }

    public static int deletePublicKey(String id) {
        try {
            return Smartcard.deletePublicKeyDLL(Smartcard.correctID(id));
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return -1;
        }
    }

    public static int deletePrivateKey(String id) {
        try {
            return Smartcard.deletePrivateKeyDLL(Smartcard.correctID(id));
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return -1;
        }
    }

    public static int deletePrivateKey(byte[] idBytes) {
        try {
            return Smartcard.deletePrivateKeyDLL(idBytes);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return -1;
        }
    }

    public static int deleteCertificate(AkilliKarttakiSertifika aks) {
        try {
            Certificate cert = aks.getCertificate();
            byte[] certValue = cert.getEncoded();
            byte[] subject = cert.gettbsCertificate().getsubject().getEncoded();
            byte[] issuer = cert.gettbsCertificate().getissuer().getEncoded();
            byte[] serialNo = ((BigInteger)cert.gettbsCertificate().getserialNumber().getValue()).toByteArray();
            return Smartcard.deleteCertificateDLL(subject, issuer, serialNo, aks.getIdBytes(), aks.getLabelBytes());
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return -1;
        }
    }

    public static int deleteAllCertificates() {
        return Smartcard.deleteAllCertificatesDLL();
    }

    public static int updateKeyPairIDAndLabel(byte[] oldIdBytes, byte[] newIdBytes, byte[] labelBytes) {
        return Smartcard.updateKeyPairIDAndLabelDLL(oldIdBytes, newIdBytes, labelBytes);
    }

    public static AkilliKarttakiAcikAnahtar[] readAllPublicKeys() {
        try {
            byte[][] cardBytes = Smartcard.readAllRSAPublicKeysDLL();
            if (cardBytes[0][0] == (byte)OK) {
                AkilliKarttakiAcikAnahtar[] keyArr = new AkilliKarttakiAcikAnahtar[(cardBytes.length - 1) / 4];
                for (int i = 1; i < cardBytes.length; i += 4) {
                    AkilliKarttakiAcikAnahtar akc;
                    byte[] idBytes = cardBytes[i];
                    byte[] labelBytes = cardBytes[i + 1];
                    byte[] modulusBytes = cardBytes[i + 2];
                    byte[] pubExpBytes = cardBytes[i + 3];
                    keyArr[(i - 1) / 4] = akc = new AkilliKarttakiAcikAnahtar(modulusBytes, pubExpBytes, idBytes, labelBytes);
                }
                return keyArr;
            }
            return null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static AkilliKarttakiGizliAnahtar[] readAllPrivateKeys() {
        try {
            byte[][] cardBytes = Smartcard.readAllRSAPrivateKeysDLL();
            if (cardBytes[0][0] == (byte)OK) {
                AkilliKarttakiGizliAnahtar[] keyArr = new AkilliKarttakiGizliAnahtar[(cardBytes.length - 1) / 2];
                for (int i = 1; i < cardBytes.length; i += 2) {
                    AkilliKarttakiGizliAnahtar akg;
                    byte[] idBytes = cardBytes[i];
                    byte[] labelBytes = cardBytes[i + 1];
                    keyArr[(i - 1) / 2] = akg = new AkilliKarttakiGizliAnahtar(idBytes, labelBytes);
                }
                return keyArr;
            }
            return null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static String readCardSerialNumber() {
        try {
            byte[] serialNumberBytes = Smartcard.readCardSerialNumberDLL();
            if (serialNumberBytes.length > 1) {
                String serialNumberStr = new String(serialNumberBytes, "ASCII");
                return serialNumberStr.trim();
            }
            return "P11 Error : " + new String(serialNumberBytes, "ASCII");
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static byte[] getUnsignedByteArray(BigInteger b) {
        byte[] temp = b.toByteArray();
        if (temp[0] == 0) {
            byte[] res = new byte[temp.length - 1];
            System.arraycopy(temp, 1, res, 0, res.length);
            return res;
        }
        return temp;
    }
}

