/*
 * Decompiled with CFR 0.152.
 */
package sune.util.calendar;

import java.util.Locale;
import java.util.TimeZone;
import sune.util.calendar.CalendarDate;
import sune.util.calendar.CalendarSystem;
import sune.util.calendar.Gregorian;
import sune.util.calendar.ImmutableGregorianDate;

public final class Era {
    private final String name;
    private final String abbr;
    private final long since;
    private final CalendarDate sinceDate;
    private final boolean localTime;
    private int hash = 0;

    public Era(String name, String abbr, long since, boolean localTime) {
        this.name = name;
        this.abbr = abbr;
        this.since = since;
        this.localTime = localTime;
        Gregorian gcal = CalendarSystem.getGregorianCalendar();
        Gregorian.Date d = gcal.newCalendarDate(null);
        gcal.getCalendarDate(since, d);
        this.sinceDate = new ImmutableGregorianDate(d);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName(Locale locale) {
        return this.name;
    }

    public String getAbbreviation() {
        return this.abbr;
    }

    public String getDiaplayAbbreviation(Locale locale) {
        return this.abbr;
    }

    public long getSince(TimeZone zone) {
        if (zone == null || !this.localTime) {
            return this.since;
        }
        int offset = zone.getOffset(this.since);
        return this.since - (long)offset;
    }

    public CalendarDate getSinceDate() {
        return this.sinceDate;
    }

    public boolean isLocalTime() {
        return this.localTime;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Era)) {
            return false;
        }
        Era that = (Era)o;
        return this.name.equals(that.name) && this.abbr.equals(that.abbr) && this.since == that.since && this.localTime == that.localTime;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.name.hashCode() ^ this.abbr.hashCode() ^ (int)this.since ^ (int)(this.since >> 32) ^ (this.localTime ? 1 : 0);
        }
        return this.hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.getName()).append(" (");
        sb.append(this.getAbbreviation()).append(')');
        sb.append(" since ").append(this.getSinceDate());
        if (this.localTime) {
            sb.setLength(sb.length() - 1);
            sb.append(" local time");
        }
        sb.append(']');
        return sb.toString();
    }
}

