/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.smyy.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Base64 {
    protected static final char[] table = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public String encodeToString(byte[] bytesToEncode, boolean putLineBreaks) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Base64OutStream bos = new Base64OutStream(baos, putLineBreaks);
            bos.write(bytesToEncode);
            bos.close();
            byte[] res = baos.toByteArray();
            return new String(res, "ASCII");
        }
        catch (Exception exc) {
            return null;
        }
    }

    public byte[] decode(String b64Str) {
        try {
            return this.decode(b64Str.getBytes("ASCII"));
        }
        catch (Exception exc) {
            return null;
        }
    }

    public byte[] decode(byte[] b64Bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(b64Bytes);
            Base64InpStream bis = new Base64InpStream(bais);
            byte[] result = new byte[bis.available()];
            bis.read(result);
            bis.close();
            return result;
        }
        catch (Exception exc) {
            return null;
        }
    }

    class Base64InpStream
    extends FilterInputStream {
        private byte[] inputArray;
        private int equSign;

        public Base64InpStream(InputStream is) {
            super(is);
            this.inputArray = null;
            this.equSign = 0;
        }

        public int available() throws IOException {
            this.inputArray = new byte[this.in.available()];
            this.in.read(this.inputArray);
            int count = 0;
            for (int i = 0; i < this.inputArray.length; ++i) {
                if (this.inputArray[i] >= 43 && this.inputArray[i] <= 122) {
                    ++count;
                }
                if (this.inputArray[i] != 61) continue;
                ++this.equSign;
            }
            return count * 3 / 4 - this.equSign;
        }

        public int read(byte[] rx) throws IOException {
            int say;
            byte[] input = new byte[4];
            int index = 0;
            for (say = 0; say < rx.length; say += 3) {
                int count = 0;
                while (count < 4 && index < this.inputArray.length) {
                    byte next = this.inputArray[index];
                    ++index;
                    if (next == -1) {
                        if (count > 0) {
                            throw new IOException();
                        }
                        return say;
                    }
                    if (next < 43 || next > 122) continue;
                    input[count] = next;
                    ++count;
                }
                if (say < rx.length - 3) {
                    System.arraycopy(this.fromBase64(input), 0, rx, say, 3);
                    continue;
                }
                System.arraycopy(this.fromBase64(input), 0, rx, say, 3 - this.equSign);
            }
            return say;
        }

        private final byte[] fromBase64(byte[] in) {
            int[] index = new int[4];
            byte[] sonuc = new byte[3];
            for (int i = 0; i < 4; ++i) {
                byte current = in[i];
                if (current > 96) {
                    index[i] = current - 71;
                    continue;
                }
                if (current > 64) {
                    index[i] = current - 65;
                    continue;
                }
                if (current > 47) {
                    index[i] = current + 4;
                    continue;
                }
                if (current == 43) {
                    index[i] = 62;
                    continue;
                }
                if (current != 47) continue;
                index[i] = 63;
            }
            sonuc[0] = (byte)((index[0] & 0xFF) << 2 | (index[1] & 0xFF) >> 4);
            sonuc[1] = (byte)((index[1] & 0xFF) << 4 | (index[2] & 0xFF) >> 2);
            sonuc[2] = (byte)((index[2] & 0xFF) << 6 | index[3] & 0xFF);
            return sonuc;
        }
    }

    class Base64OutStream
    extends FilterOutputStream {
        private byte[] son;
        private static final int WIDTH = 16;
        private int count;
        private byte[] buffer;
        private int bufferLen;
        private boolean putLineBreaks;

        public Base64OutStream(OutputStream os, boolean lineBreaksWanted) {
            super(os);
            this.count = 0;
            this.buffer = new byte[3];
            this.putLineBreaks = lineBreaksWanted;
        }

        private void writeBase64(byte[] input, int offset) throws IOException {
            this.out.write(table[(input[offset] & 0xFC) >> 2]);
            this.out.write(table[(input[offset] & 3) << 4 | (input[offset + 1] & 0xF0) >> 4]);
            this.out.write(table[(input[offset + 1] & 0xF) << 2 | (input[offset + 2] & 0xC0) >> 6]);
            this.out.write(table[input[offset + 2] & 0x3F]);
        }

        public void write(byte[] data) throws IOException {
            int current = 0;
            if (data.length >= 3) {
                if (this.bufferLen != 0) {
                    int extra = this.buffer.length - this.bufferLen;
                    System.arraycopy(data, current, this.buffer, this.bufferLen, extra);
                    this.writeBase64(this.buffer, 0);
                    this.bufferLen = 0;
                    current += extra;
                }
                do {
                    this.writeBase64(data, current);
                    current += 3;
                    ++this.count;
                    if (!this.putLineBreaks || this.count != 16) continue;
                    this.out.write(10);
                    this.count = 0;
                } while (current < data.length - 3);
                this.bufferLen = data.length - current;
                System.arraycopy(data, current, this.buffer, 0, this.bufferLen);
            } else {
                this.bufferLen = data.length;
                System.arraycopy(data, 0, this.buffer, 0, this.bufferLen);
            }
        }

        private void writeLastBlock() throws IOException {
            if (this.bufferLen == 0) {
                return;
            }
            for (int i = this.bufferLen; i < this.buffer.length; ++i) {
                this.buffer[i] = 0;
            }
            char[] temp = new char[]{table[(this.buffer[0] & 0xFC) >> 2], table[(this.buffer[0] & 3) << 4 | (this.buffer[1] & 0xF0) >> 4], table[(this.buffer[1] & 0xF) << 2 | (this.buffer[2] & 0xC0) >> 6], table[this.buffer[2] & 0x3F]};
            switch (this.bufferLen) {
                case 1: {
                    temp[2] = 61;
                    temp[3] = 61;
                    break;
                }
                case 2: {
                    temp[3] = 61;
                }
            }
            for (int i = 0; i < temp.length; ++i) {
                this.out.write(temp[i]);
            }
        }

        public void flush() throws IOException {
            this.writeLastBlock();
            super.flush();
        }
    }
}

