/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.ocsp;

import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.Sequence;
import com.turktrust.asn1.SequenceOf;
import com.turktrust.ocsp.Request;
import com.turktrust.x509.Extensions;
import com.turktrust.x509.GeneralName;
import java.util.Iterator;
import java.util.Vector;

public class TBSRequest
extends Sequence {
    private ASN1Integer version = new ASN1Integer("version");
    private GeneralName requestorName = new GeneralName("requestorName");
    private SequenceOf requestList = new SequenceOf("requestList", new Request());
    private Extensions requestExtensions = new Extensions("requestExtensions");

    public TBSRequest() {
        super("default_tbsRequest");
        this.setUpElements();
    }

    public TBSRequest(String name) {
        super(name);
        this.setUpElements();
    }

    private void setUpElements() {
        super.addElement(this.version);
        this.version.setDefaultValue(new ASN1Integer("v1", "0"));
        this.version.setOptional(true);
        this.version.setTaggingMethod(2);
        this.version.setTagClass((byte)-128);
        this.version.setTagNumber(0);
        super.addElement(this.requestorName);
        this.requestorName.setOptional(true);
        this.requestorName.setTaggingMethod(2);
        this.requestorName.setTagClass((byte)-128);
        this.requestorName.setTagNumber(1);
        super.addElement(this.requestList);
        super.addElement(this.requestExtensions);
        this.requestExtensions.setOptional(true);
        this.requestExtensions.setTaggingMethod(2);
        this.requestExtensions.setTagClass((byte)-128);
        this.requestExtensions.setTagNumber(2);
    }

    public void setVersion(ASN1Integer value) {
        this.version = value;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public void setRequestorName(GeneralName value) {
        this.requestorName = value;
    }

    public GeneralName getRequestorName() {
        return this.requestorName;
    }

    public void setRequestList(Vector requestVec) {
        this.requestList = new SequenceOf("requestList", new Request());
        Iterator iter = requestVec.iterator();
        while (iter.hasNext()) {
            this.requestList.addElement((Request)iter.next());
        }
    }

    public SequenceOf getRequestList() {
        return this.requestList;
    }

    public void setRequestExtensions(Extensions value) {
        this.requestExtensions = value;
    }

    public Extensions getRequestExtensions() {
        return this.requestExtensions;
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }
}

