/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.ASN1Boolean;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.asn1.SequenceOf;
import com.turktrust.x509.DistributionPoint;
import com.turktrust.x509.DistributionPointName;
import com.turktrust.x509.Extension;
import com.turktrust.x509.GeneralName;
import java.util.Vector;

public class CRLDistributionPoints
extends Extension {
    public static final String EXT_OBJ_ID = "2.5.29.31";
    private Vector distPointVec;

    public CRLDistributionPoints(String name, boolean critical, Vector dpVec) {
        super(name);
        this.distPointVec = dpVec;
        ObjectID crlDistPointObjId = new ObjectID("crlDistributionPoint");
        crlDistPointObjId.setValue(EXT_OBJ_ID);
        this.setextnID(crlDistPointObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(critical));
        this.setcritical(crit);
        SequenceOf seq = new SequenceOf("distPoints", new DistributionPoint());
        for (int i = 0; i < dpVec.size(); ++i) {
            DistributionPoint dp = (DistributionPoint)dpVec.elementAt(i);
            seq.addElement(dp);
        }
        byte[] seqBytes = seq.getEncoded();
        OctetString octs = new OctetString("seq", seqBytes);
        this.setextnValue(octs);
        this.commitElementUpdate();
    }

    public CRLDistributionPoints() {
        super("defaultCRLDP");
        this.distPointVec = null;
        ObjectID crlDistPointObjId = new ObjectID("crlDistributionPoint");
        crlDistPointObjId.setValue(EXT_OBJ_ID);
        this.setextnID(crlDistPointObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(false));
        this.setcritical(crit);
        this.commitElementUpdate();
    }

    public void decodeExtVal(byte[] extValBytes) {
        SequenceOf seq = new SequenceOf("distPoints", new DistributionPoint());
        try {
            seq.decode(extValBytes);
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.distPointVec = (Vector)seq.getValue();
        OctetString octs = new OctetString("seq", extValBytes);
        this.setextnValue(octs);
        this.commitElementUpdate();
    }

    public String getExtensionTitle() {
        return "CRL Distribution Points";
    }

    public String getTurkishExtensionTitle() {
        return "\u0130ptal Listesi Da\u011f\u0131t\u0131m Noktalar\u0131";
    }

    public String getExplanation() {
        String exp = "";
        for (int i = 0; i < this.distPointVec.size(); ++i) {
            DistributionPoint dp = (DistributionPoint)this.distPointVec.elementAt(i);
            DistributionPointName dpn = dp.getDistributionPointName();
            Vector dpnVec = dpn.getFullName();
            for (int k = 0; k < dpnVec.size(); ++k) {
                GeneralName gn = (GeneralName)dpnVec.elementAt(k);
                if (gn.getURI() == null || gn.getURI().length() <= 0) continue;
                exp = exp + gn.getURI();
                if (k >= dpnVec.size() - 1) continue;
                exp = exp + "\n";
            }
            if (i >= this.distPointVec.size() - 1) continue;
            exp = exp + "\n";
        }
        return exp;
    }

    public String getTurkishExplanation() {
        return this.getExplanation();
    }

    public Vector getDistributionPoints() {
        return this.distPointVec;
    }
}

