/*
 * Decompiled with CFR 0.152.
 */
package sune.security.x509;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sune.misc.HexDumpEncoder;
import sune.security.util.DerInputStream;
import sune.security.util.DerOutputStream;
import sune.security.util.DerValue;
import sune.security.util.ObjectIdentifier;
import sune.security.x509.CRLExtensions;
import sune.security.x509.CRLReasonCodeExtension;
import sune.security.x509.CertificateIssuerExtension;
import sune.security.x509.Extension;
import sune.security.x509.OIDMap;
import sune.security.x509.PKIXExtensions;
import sune.security.x509.SerialNumber;

public class X509CRLEntryImpl
extends X509CRLEntry {
    protected static Logger logger = LoggerFactory.getLogger(X509CRLEntryImpl.class);
    private SerialNumber serialNumber = null;
    private Date revocationDate = null;
    private CRLExtensions extensions = null;
    private byte[] revokedCert = null;
    private X500Principal certIssuer;
    private static final boolean isExplicit = false;
    private static final long YR_2050 = 2524636800000L;

    public X509CRLEntryImpl(BigInteger num, Date date) {
        this.serialNumber = new SerialNumber(num);
        this.revocationDate = date;
    }

    public X509CRLEntryImpl(BigInteger num, Date date, CRLExtensions crlEntryExts) {
        this.serialNumber = new SerialNumber(num);
        this.revocationDate = date;
        this.extensions = crlEntryExts;
    }

    public X509CRLEntryImpl(byte[] revokedCert) throws CRLException {
        try {
            this.parse(new DerValue(revokedCert));
        }
        catch (IOException e) {
            this.revokedCert = null;
            throw new CRLException("Parsing error: " + e.toString(), e);
        }
    }

    public X509CRLEntryImpl(DerValue derValue) throws CRLException {
        try {
            this.parse(derValue);
        }
        catch (IOException e) {
            this.revokedCert = null;
            throw new CRLException("Parsing error: " + e.toString(), e);
        }
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public void encode(DerOutputStream outStrm) throws CRLException {
        try {
            if (this.revokedCert == null) {
                DerOutputStream tmp = new DerOutputStream();
                this.serialNumber.encode(tmp);
                if (this.revocationDate.getTime() < 2524636800000L) {
                    tmp.putUTCTime(this.revocationDate);
                } else {
                    tmp.putGeneralizedTime(this.revocationDate);
                }
                if (this.extensions != null) {
                    this.extensions.encode(tmp, false);
                }
                DerOutputStream seq = new DerOutputStream();
                seq.write((byte)48, tmp);
                this.revokedCert = seq.toByteArray();
            }
            outStrm.write(this.revokedCert);
        }
        catch (IOException e) {
            throw new CRLException("Encoding error: " + e.toString(), e);
        }
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        if (this.revokedCert == null) {
            this.encode(new DerOutputStream());
        }
        return (byte[])this.revokedCert.clone();
    }

    @Override
    public X500Principal getCertificateIssuer() {
        return this.certIssuer;
    }

    void setCertificateIssuer(X500Principal crlIssuer, X500Principal certIssuer) {
        this.certIssuer = crlIssuer.equals(certIssuer) ? null : certIssuer;
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.serialNumber.getNumber();
    }

    @Override
    public Date getRevocationDate() {
        return new Date(this.revocationDate.getTime());
    }

    public Integer getReasonCode() throws IOException {
        Extension obj = this.getExtension(PKIXExtensions.ReasonCode_Id);
        if (obj == null) {
            return null;
        }
        CRLReasonCodeExtension reasonCode = (CRLReasonCodeExtension)obj;
        return (Integer)reasonCode.get("reason");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.serialNumber.toString());
        sb.append("  On: " + this.revocationDate.toString());
        if (this.certIssuer != null) {
            sb.append("\n    Certificate issuer: " + this.certIssuer);
        }
        if (this.extensions != null) {
            Collection<Extension> allEntryExts = this.extensions.getAllExtensions();
            Object[] objs = allEntryExts.toArray();
            sb.append("\n    CRL Entry Extensions: " + objs.length);
            for (int i = 0; i < objs.length; ++i) {
                sb.append("\n    [" + (i + 1) + "]: ");
                Extension ext = (Extension)objs[i];
                try {
                    if (OIDMap.getClass(ext.getExtensionId()) == null) {
                        sb.append(ext.toString());
                        byte[] extValue = ext.getExtensionValue();
                        if (extValue == null) continue;
                        DerOutputStream out = new DerOutputStream();
                        out.putOctetString(extValue);
                        extValue = out.toByteArray();
                        HexDumpEncoder enc = new HexDumpEncoder();
                        sb.append("Extension unknown: DER encoded OCTET string =\n" + enc.encodeBuffer(extValue) + "\n");
                        continue;
                    }
                    sb.append(ext.toString());
                    continue;
                }
                catch (Exception e) {
                    logger.warn("Warning in X509CRLEntryImpl", (Throwable)e);
                    sb.append(", Error parsing this extension");
                }
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        if (this.extensions == null) {
            return false;
        }
        return this.extensions.hasUnsupportedCriticalExtension();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        HashSet<String> extSet = new HashSet<String>();
        for (Extension ex : this.extensions.getAllExtensions()) {
            if (!ex.isCritical()) continue;
            extSet.add(ex.getExtensionId().toString());
        }
        return extSet;
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        HashSet<String> extSet = new HashSet<String>();
        for (Extension ex : this.extensions.getAllExtensions()) {
            if (ex.isCritical()) continue;
            extSet.add(ex.getExtensionId().toString());
        }
        return extSet;
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        if (this.extensions == null) {
            return null;
        }
        try {
            String extAlias = OIDMap.getName(new ObjectIdentifier(oid));
            Extension crlExt = null;
            if (extAlias == null) {
                ObjectIdentifier findOID = new ObjectIdentifier(oid);
                Extension ex = null;
                Enumeration<Extension> e = this.extensions.getElements();
                while (e.hasMoreElements()) {
                    ex = e.nextElement();
                    ObjectIdentifier inCertOID = ex.getExtensionId();
                    if (!inCertOID.equals(findOID)) continue;
                    crlExt = ex;
                    break;
                }
            } else {
                crlExt = this.extensions.get(extAlias);
            }
            if (crlExt == null) {
                return null;
            }
            byte[] extData = crlExt.getExtensionValue();
            if (extData == null) {
                return null;
            }
            DerOutputStream out = new DerOutputStream();
            out.putOctetString(extData);
            return out.toByteArray();
        }
        catch (Exception e) {
            logger.warn("Warning in X509CRLEntryImpl", (Throwable)e);
            return null;
        }
    }

    public Extension getExtension(ObjectIdentifier oid) {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.get(OIDMap.getName(oid));
    }

    private void parse(DerValue derVal) throws CRLException, IOException {
        if (derVal.tag != 48) {
            throw new CRLException("Invalid encoded RevokedCertificate, starting sequence tag missing.");
        }
        if (derVal.data.available() == 0) {
            throw new CRLException("No data encoded for RevokedCertificates");
        }
        this.revokedCert = derVal.toByteArray();
        DerInputStream in = derVal.toDerInputStream();
        DerValue val = in.getDerValue();
        this.serialNumber = new SerialNumber(val);
        int nextByte = derVal.data.peekByte();
        if ((byte)nextByte == 23) {
            this.revocationDate = derVal.data.getUTCTime();
        } else if ((byte)nextByte == 24) {
            this.revocationDate = derVal.data.getGeneralizedTime();
        } else {
            throw new CRLException("Invalid encoding for revocation date");
        }
        if (derVal.data.available() == 0) {
            return;
        }
        this.extensions = new CRLExtensions(derVal.toDerInputStream());
    }

    public static X509CRLEntryImpl toImpl(X509CRLEntry entry) throws CRLException {
        if (entry instanceof X509CRLEntryImpl) {
            return (X509CRLEntryImpl)entry;
        }
        return new X509CRLEntryImpl(entry.getEncoded());
    }

    CertificateIssuerExtension getCertificateIssuerExtension() {
        return (CertificateIssuerExtension)this.getExtension(PKIXExtensions.CertificateIssuer_Id);
    }
}

