/*
 * Decompiled with CFR 0.152.
 */
package sune.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.Certificate;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;
import sune.security.util.Debug;
import sune.security.util.DerInputStream;
import sune.security.util.DerOutputStream;
import sune.security.util.DerValue;
import sune.security.x509.AlgorithmId;
import sune.security.x509.CertException;
import sune.security.x509.CertParseError;
import sune.security.x509.X500Name;
import sune.security.x509.X500Signer;
import sune.security.x509.X509Key;

@Deprecated
public class X509Cert
implements Certificate,
Serializable {
    static final long serialVersionUID = -52595524744692374L;
    protected transient AlgorithmId algid;
    private transient byte[] rawCert;
    private transient byte[] signature;
    private transient byte[] signedCert;
    private transient X500Name subject;
    private transient PublicKey pubkey;
    private transient Date notafter;
    private transient Date notbefore;
    private transient int version;
    private transient BigInteger serialnum;
    private transient X500Name issuer;
    private transient AlgorithmId issuerSigAlg;
    private transient boolean parsed = false;

    public X509Cert() {
    }

    public X509Cert(byte[] cert) throws IOException {
        DerValue in = new DerValue(cert);
        this.parse(in);
        if (in.data.available() != 0) {
            throw new CertParseError("garbage at end");
        }
        this.signedCert = cert;
    }

    public X509Cert(byte[] buf, int offset, int len) throws IOException {
        DerValue in = new DerValue(buf, offset, len);
        this.parse(in);
        if (in.data.available() != 0) {
            throw new CertParseError("garbage at end");
        }
        this.signedCert = new byte[len];
        System.arraycopy(buf, offset, this.signedCert, 0, len);
    }

    public X509Cert(DerValue derVal) throws IOException {
        this.parse(derVal);
        if (derVal.data.available() != 0) {
            throw new CertParseError("garbage at end");
        }
        this.signedCert = derVal.toByteArray();
    }

    public X509Cert(X500Name subjectName, X509Key subjectPublicKey, Date notBefore, Date notAfter) throws CertException {
        this.subject = subjectName;
        if (!(subjectPublicKey instanceof PublicKey)) {
            throw new CertException(9, "Doesn't implement PublicKey interface");
        }
        this.pubkey = subjectPublicKey;
        this.notbefore = notBefore;
        this.notafter = notAfter;
        this.version = 0;
    }

    @Override
    public void decode(InputStream in) throws IOException {
        DerValue val = new DerValue(in);
        this.parse(val);
        this.signedCert = val.toByteArray();
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        out.write(this.getSignedCert());
    }

    public boolean equals(Object other) {
        if (other instanceof X509Cert) {
            return this.equals((X509Cert)other);
        }
        return false;
    }

    public boolean equals(X509Cert src) {
        if (this == src) {
            return true;
        }
        if (this.signedCert == null || src.signedCert == null) {
            return false;
        }
        if (this.signedCert.length != src.signedCert.length) {
            return false;
        }
        for (int i = 0; i < this.signedCert.length; ++i) {
            if (this.signedCert[i] == src.signedCert[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public Principal getGuarantor() {
        return this.getIssuerName();
    }

    @Override
    public Principal getPrincipal() {
        return this.getSubjectName();
    }

    public void verify(PublicKey issuerPublicKey) throws CertException {
        Date now = new Date();
        if (now.before(this.notbefore)) {
            throw new CertException(3);
        }
        if (now.after(this.notafter)) {
            throw new CertException(4);
        }
        if (this.signedCert == null) {
            throw new CertException(1, "?? certificate is not signed yet ??");
        }
        String algName = null;
        try {
            Signature sigVerf = null;
            algName = this.issuerSigAlg.getName();
            sigVerf = Signature.getInstance(algName);
            sigVerf.initVerify(issuerPublicKey);
            sigVerf.update(this.rawCert, 0, this.rawCert.length);
            if (!sigVerf.verify(this.signature)) {
                throw new CertException(1, "Signature ... by <" + this.issuer + "> for <" + this.subject + ">");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertException(1, "Unsupported signature algorithm (" + algName + ")");
        }
        catch (InvalidKeyException e) {
            throw new CertException(9, "Algorithm (" + algName + ") rejected public key");
        }
        catch (SignatureException e) {
            throw new CertException(1, "Signature by <" + this.issuer + "> for <" + this.subject + ">");
        }
    }

    public byte[] encodeAndSign(BigInteger serial, X500Signer issuer) throws IOException, SignatureException {
        this.rawCert = null;
        this.version = 0;
        this.serialnum = serial;
        this.issuer = issuer.getSigner();
        this.issuerSigAlg = issuer.getAlgorithmId();
        if (this.subject == null || this.pubkey == null || this.notbefore == null || this.notafter == null) {
            throw new IOException("not enough cert parameters");
        }
        this.rawCert = this.DERencode();
        this.signedCert = this.sign(issuer, this.rawCert);
        return this.signedCert;
    }

    public X500Signer getSigner(AlgorithmId algorithmId, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException {
        if (!(privateKey instanceof Key)) {
            throw new InvalidKeyException("private key not a key!");
        }
        PrivateKey key = privateKey;
        String algorithm = key.getAlgorithm();
        Signature sig = Signature.getInstance(algorithmId.getName());
        if (!this.pubkey.getAlgorithm().equals(algorithm)) {
            throw new InvalidKeyException("Private key algorithm " + algorithm + " incompatible with certificate " + this.pubkey.getAlgorithm());
        }
        sig.initSign(privateKey);
        return new X500Signer(sig, this.subject);
    }

    public Signature getVerifier(String algorithm) throws NoSuchAlgorithmException, InvalidKeyException {
        Signature sig = Signature.getInstance(algorithm);
        sig.initVerify(this.pubkey);
        return sig;
    }

    public byte[] getSignedCert() {
        return (byte[])this.signedCert.clone();
    }

    public BigInteger getSerialNumber() {
        return this.serialnum;
    }

    public X500Name getSubjectName() {
        return this.subject;
    }

    public X500Name getIssuerName() {
        return this.issuer;
    }

    public AlgorithmId getIssuerAlgorithmId() {
        return this.issuerSigAlg;
    }

    public Date getNotBefore() {
        return new Date(this.notbefore.getTime());
    }

    public Date getNotAfter() {
        return new Date(this.notafter.getTime());
    }

    @Override
    public PublicKey getPublicKey() {
        return this.pubkey;
    }

    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        int retval = 0;
        for (int i = 0; i < this.signedCert.length; ++i) {
            retval += this.signedCert[i] * i;
        }
        return retval;
    }

    public String toString() {
        if (this.subject == null || this.pubkey == null || this.notbefore == null || this.notafter == null || this.issuer == null || this.issuerSigAlg == null || this.serialnum == null) {
            throw new NullPointerException("X.509 cert is incomplete");
        }
        String s = "  X.509v" + (this.version + 1) + " certificate,\n";
        s = s + "  Subject is " + this.subject + "\n";
        s = s + "  Key:  " + this.pubkey;
        s = s + "  Validity <" + this.notbefore + "> until <" + this.notafter + ">\n";
        s = s + "  Issuer is " + this.issuer + "\n";
        s = s + "  Issuer signature used " + this.issuerSigAlg.toString() + "\n";
        s = s + "  Serial number = " + Debug.toHexString(this.serialnum) + "\n";
        return "[\n" + s + "]";
    }

    @Override
    public String toString(boolean detailed) {
        return this.toString();
    }

    private void parse(DerValue val) throws IOException {
        if (this.parsed) {
            throw new IOException("Certificate already parsed");
        }
        DerValue[] seq = new DerValue[]{val.data.getDerValue(), val.data.getDerValue(), val.data.getDerValue()};
        if (val.data.available() != 0) {
            throw new CertParseError("signed overrun, bytes = " + val.data.available());
        }
        if (seq[0].tag != 48) {
            throw new CertParseError("signed fields invalid");
        }
        this.rawCert = seq[0].toByteArray();
        this.issuerSigAlg = AlgorithmId.parse(seq[1]);
        this.signature = seq[2].getBitString();
        if (seq[1].data.available() != 0) {
            throw new CertParseError("algid field overrun");
        }
        if (seq[2].data.available() != 0) {
            throw new CertParseError("signed fields overrun");
        }
        DerInputStream in = seq[0].data;
        this.version = 0;
        DerValue tmp = in.getDerValue();
        if (tmp.isConstructed() && tmp.isContextSpecific()) {
            this.version = tmp.data.getInteger();
            if (tmp.data.available() != 0) {
                throw new IOException("X.509 version, bad format");
            }
            tmp = in.getDerValue();
        }
        this.serialnum = tmp.getBigInteger();
        tmp = in.getDerValue();
        AlgorithmId algid = AlgorithmId.parse(tmp);
        if (!algid.equals(this.issuerSigAlg)) {
            throw new CertParseError("CA Algorithm mismatch!");
        }
        this.algid = algid;
        this.issuer = new X500Name(in);
        tmp = in.getDerValue();
        if (tmp.tag != 48) {
            throw new CertParseError("corrupt validity field");
        }
        this.notbefore = tmp.data.getUTCTime();
        this.notafter = tmp.data.getUTCTime();
        if (tmp.data.available() != 0) {
            throw new CertParseError("excess validity data");
        }
        this.subject = new X500Name(in);
        tmp = in.getDerValue();
        this.pubkey = X509Key.parse(tmp);
        if (in.available() != 0) {
            // empty if block
        }
        this.parsed = true;
    }

    private byte[] DERencode() throws IOException {
        DerOutputStream raw = new DerOutputStream();
        this.encode(raw);
        return raw.toByteArray();
    }

    private void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        tmp.putInteger(this.serialnum);
        this.issuerSigAlg.encode(tmp);
        this.issuer.encode(tmp);
        DerOutputStream seq = new DerOutputStream();
        seq.putUTCTime(this.notbefore);
        seq.putUTCTime(this.notafter);
        tmp.write((byte)48, seq);
        this.subject.encode(tmp);
        tmp.write(this.pubkey.getEncoded());
        out.write((byte)48, tmp);
    }

    private byte[] sign(X500Signer issuer, byte[] data) throws IOException, SignatureException {
        DerOutputStream out = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        tmp.write(data);
        issuer.getAlgorithmId().encode(tmp);
        issuer.update(data, 0, data.length);
        this.signature = issuer.sign();
        tmp.putBitString(this.signature);
        out.write((byte)48, tmp);
        return out.toByteArray();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.encode(stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        this.decode(stream);
    }
}

