/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.tools;

import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.ASN1Object;
import com.turktrust.asn1.Any;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.asn1.SetOf;
import com.turktrust.pkcs12.AuthenticatedSafe;
import com.turktrust.pkcs12.CertBag;
import com.turktrust.pkcs12.MacData;
import com.turktrust.pkcs12.PFX;
import com.turktrust.pkcs12.SafeBag;
import com.turktrust.pkcs12.SafeContents;
import com.turktrust.pkcs5.PBEParameter;
import com.turktrust.pkcs7.ContentEncryptionAlgorithmIdentifier;
import com.turktrust.pkcs7.ContentInfo;
import com.turktrust.pkcs7.Digest;
import com.turktrust.pkcs7.DigestAlgorithmIdentifier;
import com.turktrust.pkcs7.DigestInfo;
import com.turktrust.pkcs7.EncryptedContent;
import com.turktrust.pkcs7.EncryptedContentInfo;
import com.turktrust.pkcs7.EncryptedData;
import com.turktrust.pkcs8.EncryptedPrivateKeyInfo;
import com.turktrust.x509.AlgorithmIdentifier;
import com.turktrust.x509.Attribute;
import com.turktrust.x509.AttributeType;
import com.turktrust.x509.Certificate;
import java.math.BigInteger;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.RC2Parameters;

public class P12Generator {
    public static final int iterationCount = 2000;
    private PFX pfx;

    public P12Generator(Certificate cert, PrivateKey pkinfo, String passStr) {
        try {
            byte[] origPassBytes = passStr.getBytes("UTF-16BE");
            byte[] passBytes = new byte[origPassBytes.length + 2];
            System.arraycopy(origPassBytes, 0, passBytes, 0, origPassBytes.length);
            passBytes[passBytes.length - 2] = 0;
            passBytes[passBytes.length - 1] = 0;
            byte[] pkinfoBytes = pkinfo.getEncoded();
            byte[] saltInputBytes = new byte[passBytes.length + pkinfoBytes.length];
            System.arraycopy(passBytes, 0, saltInputBytes, 0, passBytes.length);
            System.arraycopy(pkinfoBytes, 0, saltInputBytes, passBytes.length, pkinfoBytes.length);
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            byte[] saltDigBytes = sha.digest(saltInputBytes);
            byte[] saltBytes = new byte[8];
            System.arraycopy(saltDigBytes, 0, saltBytes, 0, 8);
            byte[] des3Keys = P12Generator.generatePBEKey(passBytes, saltBytes, 2000, 1, 192);
            byte[] desKey1 = new byte[8];
            System.arraycopy(des3Keys, 0, desKey1, 0, 8);
            byte[] desKey2 = new byte[8];
            System.arraycopy(des3Keys, 8, desKey2, 0, 8);
            byte[] desKey3 = new byte[8];
            System.arraycopy(des3Keys, 16, desKey3, 0, 8);
            desKey1 = P12Generator.makeOddParity(desKey1);
            desKey2 = P12Generator.makeOddParity(desKey2);
            desKey3 = P12Generator.makeOddParity(desKey3);
            byte[] des3KeysWithParity = new byte[24];
            System.arraycopy(desKey1, 0, des3KeysWithParity, 0, 8);
            System.arraycopy(desKey2, 0, des3KeysWithParity, 8, 8);
            System.arraycopy(desKey3, 0, des3KeysWithParity, 16, 8);
            byte[] desIV = P12Generator.generatePBEKey(passBytes, saltBytes, 2000, 2, 64);
            Cipher des3Cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            DESedeKeySpec des3KeySpec = new DESedeKeySpec(des3KeysWithParity);
            SecretKeyFactory desFac = SecretKeyFactory.getInstance("DESede");
            SecretKey des3Key = desFac.generateSecret(des3KeySpec);
            IvParameterSpec ivPars = new IvParameterSpec(desIV);
            des3Cipher.init(1, (Key)des3Key, ivPars);
            byte[] encpkinfo = des3Cipher.doFinal(pkinfoBytes);
            ObjectID shaDESObjId = new ObjectID("SHA1with3DESede_CBC");
            shaDESObjId.setValue("1.2.840.113549.1.12.1.3");
            PBEParameter ttParams = new PBEParameter("SHA1_3DES_par");
            OctetString saltOcts = new OctetString("salt");
            saltOcts.setValue(saltBytes);
            ttParams.setsalt(saltOcts);
            ASN1Integer iterAsn = new ASN1Integer("iterCount");
            iterAsn.setValue(Integer.toString(2000));
            ttParams.setiterationCount(iterAsn);
            ttParams.commitElementUpdate();
            Any anyTTParams = new Any("ttparams", ttParams);
            AlgorithmIdentifier algId = new AlgorithmIdentifier("SHA1_3DESede_CBC");
            algId.setalgorithm(shaDESObjId);
            algId.setparameters(anyTTParams);
            algId.commitElementUpdate();
            com.turktrust.pkcs8.EncryptedData edata = new com.turktrust.pkcs8.EncryptedData("ed");
            edata.setValue(encpkinfo);
            EncryptedPrivateKeyInfo epki = new EncryptedPrivateKeyInfo("keyInP12");
            epki.setencryptionAlgorithm(algId);
            epki.setencryptedData(edata);
            epki.commitElementUpdate();
            AttributeType aTypeLKId = new AttributeType("aTypeLKId");
            aTypeLKId.setValue("1.2.840.113549.1.9.21");
            byte[] localKeyIdBytes = new byte[]{1, 2, 0, 0};
            OctetString localKeyIdOcts = new OctetString("lkidocts", localKeyIdBytes);
            SetOf aValSetLKId = new SetOf("localKeyIdValSet", localKeyIdOcts);
            aValSetLKId.addElement(localKeyIdOcts);
            Attribute attLKId = new Attribute("attLKId");
            attLKId.settype(aTypeLKId);
            attLKId.setvalues(aValSetLKId);
            attLKId.commitElementUpdate();
            ObjectID p8KeyBagOid = new ObjectID("p8KeyBagOid", "1.2.840.113549.1.12.10.1.2");
            Any p8KeyBagValue = new Any("p8KeyBagValue", epki);
            SetOf p8KeyBagAtts = new SetOf("p8KeyBagAtts", attLKId);
            p8KeyBagAtts.addElement(attLKId);
            SafeBag p8KeyBag = new SafeBag("p8KeyBag");
            p8KeyBag.setbagId(p8KeyBagOid);
            p8KeyBag.setbagValue(p8KeyBagValue);
            p8KeyBag.setbagAttributes(p8KeyBagAtts);
            p8KeyBag.commitElementUpdate();
            SafeContents keySafeContents = new SafeContents("keySafeContents");
            keySafeContents.addElement((ASN1Object)p8KeyBag);
            ObjectID contTypeDataObjId = new ObjectID("contTypeData", "1.2.840.113549.1.7.1");
            byte[] keySafeContentsBytes = keySafeContents.getEncoded();
            OctetString keySafeContOcts = new OctetString("keySafeContOcts", keySafeContentsBytes);
            Any keySafeContAny = new Any("keySafeContAny", keySafeContOcts);
            ContentInfo keySafeContInfo = new ContentInfo("keySafeContInfo");
            keySafeContInfo.setcontentType(contTypeDataObjId);
            keySafeContInfo.setcontent(keySafeContAny);
            keySafeContInfo.commitElementUpdate();
            ObjectID x509CertOid = new ObjectID("x509CertOid", "1.2.840.113549.1.9.22.1");
            byte[] certBytes = cert.getEncoded();
            OctetString certByteOcts = new OctetString("certByteOcts", certBytes);
            Any anyCertOcts = new Any("anyCertOcts", certByteOcts);
            CertBag certBag = new CertBag("x509CertBag");
            certBag.setcertId(x509CertOid);
            certBag.setcertValue(anyCertOcts);
            certBag.commitElementUpdate();
            ObjectID certBagOid = new ObjectID("certBagOid", "1.2.840.113549.1.12.10.1.3");
            Any anyCertBag = new Any("anyCertBag", certBag);
            SafeBag certSafeBag = new SafeBag("certSafeBag");
            certSafeBag.setbagId(certBagOid);
            certSafeBag.setbagValue(anyCertBag);
            certSafeBag.setbagAttributes(p8KeyBagAtts);
            certSafeBag.commitElementUpdate();
            SafeContents certSafeContents = new SafeContents("certSafeContents");
            certSafeContents.addElement((ASN1Object)certSafeBag);
            byte[] certSafeContentsBytes = certSafeContents.getEncoded();
            byte[] certSaltInputBytes = new byte[passBytes.length + certSafeContentsBytes.length];
            System.arraycopy(passBytes, 0, certSaltInputBytes, 0, passBytes.length);
            System.arraycopy(certSafeContentsBytes, 0, certSaltInputBytes, passBytes.length, certSafeContentsBytes.length);
            MessageDigest sha2 = MessageDigest.getInstance("SHA-1");
            byte[] certSaltDigBytes = sha2.digest(certSaltInputBytes);
            byte[] certSaltBytes = new byte[8];
            System.arraycopy(certSaltDigBytes, 0, certSaltBytes, 0, 8);
            byte[] certRC2Key = P12Generator.generatePBEKey(passBytes, certSaltBytes, 2000, 1, 40);
            byte[] certRC2IV = P12Generator.generatePBEKey(passBytes, certSaltBytes, 2000, 2, 64);
            RC2Engine rc2Eng = new RC2Engine();
            PaddedBufferedBlockCipher rc2Cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)rc2Eng));
            RC2Parameters rc2Params = new RC2Parameters(certRC2Key);
            ParametersWithIV rc2ParamsWithIV = new ParametersWithIV((CipherParameters)rc2Params, certRC2IV);
            rc2Cipher.init(true, (CipherParameters)rc2ParamsWithIV);
            byte[] encCertBytes = new byte[rc2Cipher.getOutputSize(certSafeContentsBytes.length)];
            int rc2OutputLen = rc2Cipher.processBytes(certSafeContentsBytes, 0, certSafeContentsBytes.length, encCertBytes, 0);
            rc2Cipher.doFinal(encCertBytes, rc2OutputLen);
            ObjectID sha1RC2ObjId = new ObjectID("SHA1with40bitRC2", "1.2.840.113549.1.12.1.6");
            PBEParameter pbeParCertEnc = new PBEParameter("pbeParCertEnc");
            ASN1Integer iterCountASN = new ASN1Integer("iterCount", Integer.toString(2000));
            OctetString certSaltOcts = new OctetString("certSaltOcts", certSaltBytes);
            pbeParCertEnc.setiterationCount(iterCountASN);
            pbeParCertEnc.setsalt(certSaltOcts);
            pbeParCertEnc.commitElementUpdate();
            Any anyPbe = new Any("anyPbeParCertEnc", pbeParCertEnc);
            ContentEncryptionAlgorithmIdentifier certEncAlgId = new ContentEncryptionAlgorithmIdentifier("certEncAlgId");
            certEncAlgId.setalgorithm(sha1RC2ObjId);
            certEncAlgId.setparameters(anyPbe);
            certEncAlgId.commitElementUpdate();
            EncryptedContent certECont = new EncryptedContent("certECont");
            certECont.setValue((Object)encCertBytes);
            EncryptedContentInfo certECinfo = new EncryptedContentInfo("certECinfo");
            certECinfo.setcontentType(contTypeDataObjId);
            certECinfo.setcontentEncryptionAlgorithm(certEncAlgId);
            certECinfo.setencryptedContent(certECont);
            certECinfo.commitElementUpdate();
            EncryptedData certEData = new EncryptedData("certEData");
            certEData.setversion(new ASN1Integer("ver", "0"));
            certEData.setencryptedContentInfo(certECinfo);
            certEData.commitElementUpdate();
            ObjectID contTypeEncryptedDataObjId = new ObjectID("contTypeEncryptedData", "1.2.840.113549.1.7.6");
            Any anyCertEData = new Any("anyCertEData", certEData);
            ContentInfo cinfoCert = new ContentInfo("cinfoCert");
            cinfoCert.setcontentType(contTypeEncryptedDataObjId);
            cinfoCert.setcontent(anyCertEData);
            cinfoCert.commitElementUpdate();
            AuthenticatedSafe autSafe = new AuthenticatedSafe("autSafe");
            autSafe.addElement((ASN1Object)cinfoCert);
            autSafe.addElement((ASN1Object)keySafeContInfo);
            byte[] autSafeBytes = autSafe.getEncoded();
            OctetString autSafeOcts = new OctetString("autSafeOcts", autSafeBytes);
            Any anyAutSafeOcts = new Any("anyAutSafeOcts", autSafeOcts);
            ContentInfo p12ContInfo = new ContentInfo("p12ContInfo");
            p12ContInfo.setcontentType(contTypeDataObjId);
            p12ContInfo.setcontent(anyAutSafeOcts);
            p12ContInfo.commitElementUpdate();
            byte[] macSaltBytes = new byte[20];
            SecureRandom srand = new SecureRandom();
            srand.nextBytes(macSaltBytes);
            byte[] macKeyBytes = P12Generator.generatePBEKey(passBytes, macSaltBytes, 2000, 3, 160);
            byte[] p12ContBytes = anyAutSafeOcts.getContentEncoding();
            Mac hmac = Mac.getInstance("HmacSHA1");
            SecretKeySpec hmacSecretKey = new SecretKeySpec(macKeyBytes, "HmacSHA1");
            hmac.init(hmacSecretKey);
            byte[] hmacResultBytes = hmac.doFinal(p12ContBytes);
            ObjectID shaObjId = new ObjectID("SHA1", "1.3.14.3.2.26");
            DigestAlgorithmIdentifier digestAlgId = new DigestAlgorithmIdentifier("SHA1");
            digestAlgId.setalgorithm(shaObjId);
            digestAlgId.commitElementUpdate();
            Digest macDigest = new Digest("macDigest");
            macDigest.setValue((Object)hmacResultBytes);
            DigestInfo hmacDigInfo = new DigestInfo("hmacDigInfo");
            hmacDigInfo.setdigestAlgorithm(digestAlgId);
            hmacDigInfo.setdigest(macDigest);
            hmacDigInfo.commitElementUpdate();
            OctetString macSaltOcts = new OctetString("macSaltOcts", macSaltBytes);
            ASN1Integer macIterASN = new ASN1Integer("macIterASN", Integer.toString(2000));
            MacData p12MacData = new MacData("p12MacData");
            p12MacData.setmac(hmacDigInfo);
            p12MacData.setmacSalt(macSaltOcts);
            p12MacData.setiterations(macIterASN);
            p12MacData.commitElementUpdate();
            ASN1Integer pfxVerASN = new ASN1Integer("pfxVersion", "3");
            this.pfx = new PFX("pfx");
            this.pfx.setversion(pfxVerASN);
            this.pfx.setauthSafe(p12ContInfo);
            this.pfx.setmacData(p12MacData);
            this.pfx.commitElementUpdate();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public PFX getPFX() {
        return this.pfx;
    }

    public static byte[] generatePBEKey(byte[] passBytes, byte[] saltBytes, int iterCount, int purposeID, int keyLength) {
        try {
            int n;
            int u = 160;
            int v = 512;
            byte ID = (byte)purposeID;
            byte[] D = new byte[v / 8];
            for (int i = 0; i < v / 8; ++i) {
                D[i] = ID;
            }
            int slen = v * (int)Math.ceil((double)(saltBytes.length * 8) / (double)v);
            byte[] S = new byte[1];
            if (slen > 0) {
                S = new byte[slen / 8];
            }
            int j = 0;
            while (j * 8 < slen) {
                if (slen - j * 8 >= saltBytes.length * 8) {
                    System.arraycopy(saltBytes, 0, S, j, saltBytes.length);
                    j += saltBytes.length;
                    continue;
                }
                for (int i = 0; i < slen / 8 - j; ++i) {
                    S[j + i] = saltBytes[i];
                }
                j = slen / 8;
            }
            int plen = v * (int)Math.ceil((double)(passBytes.length * 8) / (double)v);
            byte[] P = new byte[plen / 8];
            j = 0;
            while (j * 8 < plen) {
                if (plen - j * 8 >= passBytes.length * 8) {
                    System.arraycopy(passBytes, 0, P, j, passBytes.length);
                    j += passBytes.length;
                    continue;
                }
                for (int i = 0; i < (plen - j * 8) / 8; ++i) {
                    P[j + i] = passBytes[i];
                }
                j += (plen - j * 8) / 8;
            }
            byte[] I = new byte[(slen + plen) / 8];
            System.arraycopy(S, 0, I, 0, slen / 8);
            System.arraycopy(P, 0, I, slen / 8, plen / 8);
            int c = (int)Math.ceil((double)keyLength / (double)u);
            byte[][] A = new byte[c][u / 8];
            byte[] Atemp = new byte[u / 8];
            byte[] dconi = new byte[D.length + I.length];
            BigInteger two = new BigInteger("2");
            BigInteger twopowerv = two.pow(v);
            for (int i = 1; i <= c; ++i) {
                System.arraycopy(D, 0, dconi, 0, D.length);
                System.arraycopy(I, 0, dconi, D.length, I.length);
                MessageDigest sha = MessageDigest.getInstance("SHA-1");
                for (int iter = 0; iter < iterCount; ++iter) {
                    if (iter == 0) {
                        Atemp = sha.digest(dconi);
                        sha.reset();
                        continue;
                    }
                    Atemp = sha.digest(Atemp);
                    sha.reset();
                }
                A[i - 1] = Atemp;
                byte[] B = new byte[v / 8];
                j = 0;
                while (j < v / 8) {
                    if (v / 8 - j >= Atemp.length) {
                        System.arraycopy(Atemp, 0, B, j, Atemp.length);
                        j += Atemp.length;
                        continue;
                    }
                    for (int m = 0; m < v / 8 - j; ++m) {
                        B[j + m] = Atemp[m];
                    }
                    j = v / 8;
                }
                BigInteger Bbig = new BigInteger(B);
                int k = (int)(Math.ceil((double)(saltBytes.length * 8) / (double)v) + Math.ceil((double)(passBytes.length * 8) / (double)v));
                for (int m = 0; m < k; ++m) {
                    byte[] tempK = new byte[v / 8];
                    for (int r = 0; r < v / 8; ++r) {
                        tempK[r] = I[m * (v / 8) + r];
                    }
                    BigInteger tempKbig = new BigInteger(tempK);
                    tempKbig = tempKbig.add(Bbig);
                    BigInteger one = new BigInteger("1");
                    tempKbig = tempKbig.add(one);
                    tempK = (tempKbig = tempKbig.mod(twopowerv)).toByteArray();
                    if (tempK.length < v / 8) {
                        byte[] yeniTempK = new byte[v / 8];
                        System.arraycopy(tempK, 0, yeniTempK, yeniTempK.length - tempK.length, tempK.length);
                        for (int x = 0; x < yeniTempK.length - tempK.length; ++x) {
                            yeniTempK[x] = 0;
                        }
                        tempK = yeniTempK;
                    }
                    for (int r = 0; r < v / 8; ++r) {
                        I[m * (v / 8) + r] = tempK[tempK.length - v / 8 + r];
                    }
                }
            }
            byte[] Acon = new byte[c * u / 8];
            for (int i = 0; i < c; ++i) {
                for (int r = 0; r < u / 8; ++r) {
                    Acon[i * (u / 8) + r] = A[i][r];
                }
            }
            int x = 0;
            byte[] resultKey = new byte[keyLength / 8];
            for (n = keyLength; n >= 8; n -= 8) {
                resultKey[x] = Acon[x];
                ++x;
            }
            if (n > 0) {
                int mask = -1;
                mask = (byte)(mask << 8 - n);
                resultKey[x] = (byte)(Acon[x] & mask);
            }
            return resultKey;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static byte[] makeOddParity(byte[] inp) {
        byte b = 0;
        int parnum = 0;
        byte[] res = new byte[8];
        for (int i = 0; i < 8; ++i) {
            res[i] = b = inp[i];
            parnum = 0;
            for (int j = 0; j < 8; ++j) {
                byte k = (byte)(b >> j);
                if ((k & 1) != 1) continue;
                ++parnum;
            }
            if (parnum % 2 != 0) continue;
            b = inp[i];
            b = (b & 1) == 1 ? (byte)(b - 1) : (byte)(b + 1);
            res[i] = b;
        }
        return res;
    }

    public static void hede() {
        System.out.println("Hede birader...");
    }

    public static void main(String[] args) {
        try {
            String pass = "abcdfg876tgyhsaaaa";
            byte[] passBytes = pass.getBytes("UTF-8");
            byte[] toBeEncBytes = new byte[]{1, 2, 3, 1, 2, 3, 1, 2, 3};
            byte[] saltInputBytes = new byte[passBytes.length + toBeEncBytes.length];
            System.arraycopy(passBytes, 0, saltInputBytes, 0, passBytes.length);
            System.arraycopy(toBeEncBytes, 0, saltInputBytes, passBytes.length, toBeEncBytes.length);
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            byte[] saltDigBytes = sha.digest(saltInputBytes);
            byte[] saltBytes = new byte[8];
            System.arraycopy(saltDigBytes, 0, saltBytes, 0, 8);
            byte[] des3Keys = P12Generator.generatePBEKey(passBytes, saltBytes, 2000, 1, 192);
            BigInteger res = new BigInteger(1, des3Keys);
            System.out.println("OK, " + res);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

