/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.apdu;

import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import tr.gov.tubitak.uekae.esya.api.common.crypto.Algorithms;
import tr.gov.tubitak.uekae.esya.api.common.crypto.BaseSigner;
import tr.gov.tubitak.uekae.esya.api.common.util.StringUtil;
import tr.gov.tubitak.uekae.esya.api.smartcard.apdu.PCTerminalHandler;
import tr.gov.tubitak.uekae.esya.api.smartcard.apdu.TerminalHandler;
import tr.gov.tubitak.uekae.esya.api.smartcard.apdu.a;
import tr.gov.tubitak.uekae.esya.api.smartcard.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.smartcard.bundle.SmartCardI18n;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.BaseSmartCard;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.LoginException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCard;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.scheme.RSAPSSSignature;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.scheme.SignatureSchemeFactory;
import tr.gov.tubitak.uekae.esya.api.smartcard.util.APDUSigner;
import tr.gov.tubitak.uekae.esya.api.smartcard.util.ECSignatureTLVUtil;
import tubitak.akis.cif.akisExceptions.AkisException;
import tubitak.akis.cif.akisExceptions.AkisSWException;
import tubitak.akis.cif.commands.AbstractAkisCommands;
import tubitak.akis.cif.commands.CIFFactory;
import tubitak.akis.cif.dataStructures.AkisKey;
import tubitak.akis.cif.dataStructures.Algorithm;
import tubitak.akis.cif.dataStructures.DF_EF;
import tubitak.akis.cif.dataStructures.KeyType;
import tubitak.akis.cif.dataStructures.Version;
import tubitak.akis.cif.functions.CommandTransmitterPCSC;
import tubitak.akis.cif.functions.ICommandTransmitter;

public class APDUSmartCard
implements BaseSmartCard {
    public static int CERT_FID_START;
    public static int CERT_FID_END;
    protected Hashtable<String, Integer> serialCertIndex;
    protected Hashtable<String, Integer> serialKeyID;
    protected List<byte[]> signingCerts;
    protected List<byte[]> encryptionCerts;
    protected TerminalHandler terminalHandler;
    protected AbstractAkisCommands commands;
    protected ICommandTransmitter pcsc;
    protected Card card;
    protected boolean disableSecureMessaging = false;
    String a;
    private static Logger b;
    private String c;
    private static final String[] d;
    private static final String[] e;

    public void setCommandLoggingPath(String commandLoggingPath) {
        this.a = commandLoggingPath;
    }

    public void setDisableSecureMessaging(boolean disableSecureMessaging) {
        this.disableSecureMessaging = disableSecureMessaging;
    }

    public static boolean isSupported(String aTerminalName) {
        CardTerminal cardTerminal = TerminalFactory.getDefault().terminals().getTerminal(aTerminalName);
        return APDUSmartCard.isSupported(cardTerminal);
    }

    public static boolean isSupported(String aTerminalName, TerminalHandler aTerminalHandler) {
        Object object;
        int n = TerminalHandler.b;
        try {
            object = aTerminalHandler.listCardTerminals(CardTerminals.State.CARD_PRESENT);
            Iterator<CardTerminal> iterator = object.iterator();
            while (iterator.hasNext()) {
                CardTerminal cardTerminal = iterator.next();
                if (cardTerminal.getName().equals(aTerminalName)) {
                    return APDUSmartCard.isSupported(cardTerminal, aTerminalHandler);
                }
                if (n == 0) continue;
                break;
            }
        }
        catch (CardException cardException) {
            b.warn(APDUSmartCard.a(-18724, -25238), (Throwable)cardException);
            return false;
        }
        object = TerminalFactory.getDefault().terminals().getTerminal(aTerminalName);
        return APDUSmartCard.isSupported((CardTerminal)object);
    }

    public static boolean isSupported(CardTerminal aTerminal, TerminalHandler aTerminalHandler) {
        try {
            ICommandTransmitter iCommandTransmitter = aTerminalHandler.getTransmitter(aTerminal);
            return APDUSmartCard.isSupported(iCommandTransmitter);
        }
        catch (CardException cardException) {
            b.error(APDUSmartCard.a(-18734, 11682), (Throwable)cardException);
            return false;
        }
        catch (Exception exception) {
            b.error(APDUSmartCard.a(-18734, 11682), (Throwable)exception);
            return false;
        }
    }

    public static boolean isSupported(CardTerminal aTerminal) {
        try {
            CommandTransmitterPCSC commandTransmitterPCSC = new CommandTransmitterPCSC(aTerminal, false);
            return APDUSmartCard.isSupported((ICommandTransmitter)commandTransmitterPCSC);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            b.error(APDUSmartCard.a(-18725, 32130), (Throwable)noClassDefFoundError);
            return false;
        }
        catch (Exception exception) {
            b.error(APDUSmartCard.a(-18729, 14244), (Throwable)exception);
            return false;
        }
    }

    protected static boolean isSupported(ICommandTransmitter transmitter) {
        try {
            AbstractAkisCommands abstractAkisCommands = CIFFactory.getAkisCIFInstance((ICommandTransmitter)transmitter);
            return abstractAkisCommands != null;
        }
        catch (Exception exception) {
            b.error(APDUSmartCard.a(-18747, -24859), (Throwable)exception);
            return false;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            b.error(APDUSmartCard.a(-18751, -21520), (Throwable)noClassDefFoundError);
            return false;
        }
    }

    public APDUSmartCard(TerminalHandler aTerminalHandler) {
        this.terminalHandler = aTerminalHandler;
        this.initialize();
    }

    public APDUSmartCard() {
        this.terminalHandler = new PCTerminalHandler();
        this.initialize();
    }

    protected void initialize() {
        this.serialKeyID = new Hashtable();
    }

    public long[] getSlotList() throws CardException {
        int n = this.a(CardTerminals.State.ALL).size();
        long[] lArray = new long[n];
        int n2 = TerminalHandler.b;
        for (int i = 0; i < n; ++i) {
            lArray[i] = i + 1;
            if (n2 == 0) continue;
        }
        return lArray;
    }

    private List<CardTerminal> a(CardTerminals.State state) throws CardException {
        ArrayList<CardTerminal> arrayList = new ArrayList();
        try {
            arrayList = this.terminalHandler.listCardTerminals(state);
        }
        catch (CardException cardException) {
            if (!cardException.getCause().getMessage().contains(APDUSmartCard.a(-18735, -24854))) {
                throw cardException;
            }
        }
        return arrayList;
    }

    public CardTerminal[] getTerminalList() throws CardException {
        List<CardTerminal> list = this.a(CardTerminals.State.ALL);
        return list.toArray(new CardTerminal[0]);
    }

    public void openSession(ICommandTransmitter iCommandTransmitter) throws SmartCardException {
        this.pcsc = iCommandTransmitter;
        this.a();
    }

    public void openSession(CardTerminal aTerminal) throws SmartCardException {
        try {
            this.pcsc = this.terminalHandler.getTransmitter(aTerminal);
        }
        catch (CardException cardException) {
            throw new SmartCardException(cardException);
        }
        this.a();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a() throws SmartCardException {
        try {
            this.commands = CIFFactory.getAkisCIFInstance((ICommandTransmitter)this.pcsc);
            if (this.a != null) {
                AbstractAkisCommands.activateCommandLogging((String)this.a);
            }
            b.debug(APDUSmartCard.a(-18728, -18035) + this.commands.getVersion());
            if (!this.disableSecureMessaging && this.commands.getVersion() != Version.V10_UEKAE && !APDUSmartCard.isVersion20(this.commands.getVersion())) {
                this.commands.activateSecureMsging();
            }
            this.commands.selectMF();
            this.commands.selectDFByName(APDUSmartCard.a(-18713, 31486).getBytes(APDUSmartCard.a(-18732, -7339)));
            return;
        }
        catch (Exception exception) {
            throw new SmartCardException(APDUSmartCard.a(-18741, -11722), exception);
        }
    }

    @Override
    public boolean isSessionActive() {
        try {
            this.commands.getSerial();
            return true;
        }
        catch (AkisException akisException) {
            b.warn(APDUSmartCard.a(-18723, 19763), (Throwable)akisException);
            return false;
        }
    }

    protected List<X509Certificate> readCertificates() throws SmartCardException {
        int n;
        Object object;
        List<DF_EF> list;
        int n2;
        CertificateFactory certificateFactory;
        block21: {
            this.serialCertIndex = new Hashtable();
            certificateFactory = null;
            n2 = TerminalHandler.b;
            list = new ArrayList();
            try {
                certificateFactory = CertificateFactory.getInstance(APDUSmartCard.a(-18731, 19475));
                if (APDUSmartCard.isVersion20(this.commands.getVersion())) {
                    object = new byte[]{47, 16};
                    for (n = 0; n < 10; ++n) {
                        DF_EF dF_EF = new DF_EF();
                        dF_EF.FID = new byte[2];
                        dF_EF.FID[0] = (byte)object[0];
                        dF_EF.FID[1] = (byte)object[1];
                        list.add(dF_EF);
                        Object object2 = object;
                        object2[1] = (byte)(object2[1] + true);
                        if (n2 == 0) continue;
                        boolean bl = SmartCardException.b = !SmartCardException.b;
                    }
                    if (n2 == 0) break block21;
                }
                list = this.commands.dir();
            }
            catch (CertificateException certificateException) {
                throw new SmartCardException(APDUSmartCard.a(-18739, -11416), certificateException);
            }
            catch (Exception exception) {
                throw new SmartCardException(exception);
            }
        }
        object = new ArrayList();
        n = 1;
        for (DF_EF dF_EF : list) {
            block22: {
                int n3 = (dF_EF.FID[0] << 8) + dF_EF.FID[1];
                if (n3 < CERT_FID_START || n3 > CERT_FID_END) break block22;
                try {
                    byte[] byArray = this.commands.readFileBySelectingUnderActiveDF(dF_EF.FID);
                    if (byArray == null) {
                        throw new AkisSWException(27266L);
                    }
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                    this.serialCertIndex.put(StringUtil.toString((byte[])x509Certificate.getSerialNumber().toByteArray()), n);
                    ++n;
                    object.add(x509Certificate);
                }
                catch (CertificateException certificateException) {
                    b.error(APDUSmartCard.a(-18742, -24122), (Throwable)certificateException);
                }
                catch (AkisSWException akisSWException) {
                    if (akisSWException.getErrorCode() != 27266L) {
                        throw new SmartCardException((Exception)((Object)akisSWException));
                    }
                }
                catch (AkisException akisException) {
                    throw new SmartCardException((Exception)((Object)akisException));
                }
            }
            if (n2 == 0) continue;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<byte[]> getSignatureCertificates() throws SmartCardException {
        List<X509Certificate> list = this.readCertificates();
        int n = TerminalHandler.b;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (X509Certificate x509Certificate : list) {
            if (x509Certificate.getKeyUsage()[0]) {
                try {
                    arrayList.add(x509Certificate.getEncoded());
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    b.error(APDUSmartCard.a(-18727, 15610), (Throwable)certificateEncodingException);
                }
            }
            if (n == 0) continue;
        }
        return arrayList;
    }

    private void b() {
        if (this.serialCertIndex == null) {
            try {
                this.readCertificates();
            }
            catch (SmartCardException smartCardException) {
                b.error(APDUSmartCard.a(-18716, -19988), (Throwable)((Object)smartCardException));
            }
        }
    }

    public byte[] sign(byte[] aData, X509Certificate aCertificate, String aSigningAlg) throws SmartCardException, CardException {
        SmartCard.checkLicense();
        this.b();
        return this.sign(aData, aCertificate, aSigningAlg, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] sign(byte[] aData, X509Certificate aCertificate, String aSigningAlg, AlgorithmParameterSpec spec) throws CardException, SmartCardException {
        byte[] byArray;
        Object object;
        SmartCard.checkLicense();
        this.b();
        X509Certificate x509Certificate = aCertificate;
        a a2 = new a(this, x509Certificate);
        long[] lArray = this.commands.getMechanisms();
        try {
            object = SignatureSchemeFactory.getSignatureScheme(true, aSigningAlg, spec, lArray, a2);
            byArray = object.getSignatureInput(aData);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new SmartCardException(pKCS11Exception);
        }
        object = StringUtil.toString((byte[])aCertificate.getSerialNumber().toByteArray());
        Integer n = this.serialKeyID.get(object);
        if (n != null) {
            return this.a(byArray, (byte)n.intValue(), aData, (String)object, x509Certificate, aSigningAlg, spec);
        }
        Integer n2 = this.serialCertIndex.get(object);
        if (n2 == null) {
            return this.a(byArray, aData, (String)object, aCertificate, aSigningAlg, spec);
        }
        n = n2 * 2 - 1;
        try {
            return this.a(byArray, n.byteValue(), aData, (String)object, aCertificate, aSigningAlg, spec);
        }
        catch (Exception exception) {
            b.debug(APDUSmartCard.a(-18724, -25238), (Throwable)exception);
            return this.a(byArray, aData, (String)object, aCertificate, aSigningAlg, spec);
        }
    }

    private byte[] a(byte[] byArray, byte[] byArray2, String string, X509Certificate x509Certificate, String string2, AlgorithmParameterSpec algorithmParameterSpec) throws CardException {
        AkisKey[] akisKeyArray;
        int n;
        block9: {
            n = TerminalHandler.b;
            try {
                if (APDUSmartCard.isVersion20(this.commands.getVersion())) {
                    akisKeyArray = new AkisKey[]{new AkisKey(1, KeyType.PRIVATE_RSA), new AkisKey(2, KeyType.PRIVATE_RSA), new AkisKey(3, KeyType.PRIVATE_RSA), new AkisKey(4, KeyType.PRIVATE_RSA), new AkisKey(5, KeyType.PRIVATE_RSA), new AkisKey(1, KeyType.PRIVATE_ECC), new AkisKey(2, KeyType.PRIVATE_ECC), new AkisKey(3, KeyType.PRIVATE_ECC), new AkisKey(4, KeyType.PRIVATE_ECC), new AkisKey(5, KeyType.PRIVATE_ECC)};
                    if (n == 0) break block9;
                }
                akisKeyArray = this.commands.getKeyInfos();
            }
            catch (Exception exception) {
                throw new CardException(exception);
            }
        }
        for (AkisKey akisKey : akisKeyArray) {
            if (akisKey.getKeyType() != KeyType.PRIVATE_RSA && akisKey.getKeyType() != KeyType.PRIVATE_ECC) continue;
            try {
                return this.a(byArray, akisKey.getKeyID(), byArray2, string, x509Certificate, string2, algorithmParameterSpec);
            }
            catch (Exception exception) {
                b.warn(APDUSmartCard.a(-18724, -25238), (Throwable)exception);
            }
            if (n == 0) continue;
        }
        throw new CardException(new AkisSWException(27015L));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] a(byte[] byArray, byte by, byte[] byArray2, String string, X509Certificate x509Certificate, String string2, AlgorithmParameterSpec algorithmParameterSpec) throws CardException {
        byte[] byArray3;
        block17: {
            byArray3 = null;
            try {
                if (string2 == Algorithms.SIGNATURE_RSA_PSS) {
                    if (!APDUSmartCard._in(13L, this.commands.getMechanisms())) {
                        throw new CardException(APDUSmartCard.a(-18749, 22086));
                    }
                    PSSParameterSpec pSSParameterSpec = (PSSParameterSpec)algorithmParameterSpec;
                    String string3 = pSSParameterSpec.getDigestAlgorithm();
                    Algorithm algorithm = this.d(string3);
                    if (this.a(by)) {
                        byte by2 = (byte)(0xFFFFFF80 | by);
                        this.commands.verify((byte)1, this.c.getBytes(APDUSmartCard.a(-18732, -7339)), false);
                        byArray3 = this.commands.sign(Algorithm.PKCS_PSS, algorithm, by2, byArray);
                    }
                    break block17;
                }
                if (this.c(string2)) {
                    if (APDUSmartCard.isVersion20(this.commands.getVersion())) {
                        if (this.a(by)) {
                            byte by3 = (byte)(0xFFFFFF80 | by);
                            this.commands.verify((byte)1, this.c.getBytes(APDUSmartCard.a(-18732, -7339)), false);
                            byArray3 = this.commands.sign(Algorithm.PKCS_1_5, null, by3, byArray);
                        }
                        break block17;
                    }
                    byArray3 = this.commands.sign(byArray, by);
                    break block17;
                }
                if (!this.b(string2)) {
                    throw new CardException(APDUSmartCard.a(-18738, -30245) + string2);
                }
                Algorithm algorithm = this.a(string2);
                if (this.a(by)) {
                    byte by4 = (byte)(0xFFFFFF80 | by);
                    this.commands.verify((byte)1, this.c.getBytes(APDUSmartCard.a(-18732, -7339)), false);
                    byArray3 = this.commands.sign(Algorithm.ECC, algorithm, by4, byArray);
                    byArray3 = ECSignatureTLVUtil.addTLVToSignature(byArray3);
                }
            }
            catch (CardException cardException) {
                throw cardException;
            }
            catch (Exception exception) {
                throw new CardException(exception);
            }
        }
        if (this.a(byArray3, byArray2, x509Certificate, string2, algorithmParameterSpec)) {
            this.serialKeyID.put(string, Integer.valueOf(by));
            return byArray3;
        }
        throw new CardException(new AkisSWException(25616L));
    }

    private Algorithm a(String string) throws CardException {
        if (string.contains(APDUSmartCard.a(-18752, -24041))) {
            return Algorithm.SHA_256;
        }
        if (string.contains(APDUSmartCard.a(-18721, 10422))) {
            return Algorithm.SHA_384;
        }
        if (string.contains(APDUSmartCard.a(-18726, 16449))) {
            return Algorithm.SHA_512;
        }
        throw new CardException(APDUSmartCard.a(-18736, 11577) + string);
    }

    private boolean b(String string) {
        return string == Algorithms.SIGNATURE_ECDSA_SHA256 || string == Algorithms.SIGNATURE_ECDSA_SHA384 || string == Algorithms.SIGNATURE_ECDSA_SHA512 || string == Algorithms.SIGNATURE_ECDSA_SHA224 || string == Algorithms.SIGNATURE_ECDSA_SHA1 || string == Algorithms.SIGNATURE_ECDSA;
    }

    private boolean c(String string) {
        return string == Algorithms.SIGNATURE_RSA || string == Algorithms.SIGNATURE_RSA_MD5 || string == Algorithms.SIGNATURE_RSA_SHA1 || string == Algorithms.SIGNATURE_RSA_SHA224 || string == Algorithms.SIGNATURE_RSA_SHA256 || string == Algorithms.SIGNATURE_RSA_SHA384 || string == Algorithms.SIGNATURE_RSA_SHA512;
    }

    private boolean a(byte by) throws CardException {
        byte by2 = by;
        boolean bl = false;
        try {
            bl = this.commands.queryObject(144, by2);
            if (!bl) {
                by2 = (byte)(0xFFFFFF80 | by2);
                bl = this.commands.queryObject(144, by2);
            }
        }
        catch (Exception exception) {
            throw new CardException(exception);
        }
        return bl;
    }

    private Algorithm d(String string) throws CardException {
        if (string == Algorithms.DIGEST_SHA1) {
            return Algorithm.SHA_1;
        }
        if (string == Algorithms.DIGEST_SHA256) {
            return Algorithm.SHA_256;
        }
        throw new CardException(APDUSmartCard.a(-18748, -20196) + string);
    }

    private boolean a(Exception exception) {
        long l;
        return exception instanceof AkisSWException && ((l = ((AkisSWException)((Object)exception)).getErrorCode()) == 25616L || l == 25625L || l == 27015L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean a(byte[] byArray, byte[] byArray2, X509Certificate x509Certificate, String string, AlgorithmParameterSpec algorithmParameterSpec) {
        int n = TerminalHandler.b;
        try {
            String string2;
            block14: {
                block15: {
                    String string3;
                    block13: {
                        block12: {
                            String string4;
                            block11: {
                                if (string.equals(Algorithms.SIGNATURE_RSA_PSS)) {
                                    PSSParameterSpec pSSParameterSpec = (PSSParameterSpec)algorithmParameterSpec;
                                    RSAPSSSignature rSAPSSSignature = new RSAPSSSignature();
                                    MessageDigest messageDigest = MessageDigest.getInstance(pSSParameterSpec.getDigestAlgorithm());
                                    messageDigest.update(byArray2);
                                    byte[] byArray3 = messageDigest.digest();
                                    messageDigest.reset();
                                    PSSParameterSpec pSSParameterSpec2 = (PSSParameterSpec)algorithmParameterSpec;
                                    return rSAPSSSignature.verifySignature(byArray, x509Certificate.getPublicKey(), byArray3, messageDigest, pSSParameterSpec2.getSaltLength());
                                }
                                string4 = Algorithms.getDigestAlgOfSignatureAlg((String)string);
                                if (string4 != null) break block11;
                                string3 = APDUSmartCard.a(-18744, -31529);
                                if (n == 0) break block12;
                            }
                            string3 = string4.replaceAll("-", "");
                        }
                        string2 = "";
                        if (!string.contains(APDUSmartCard.a(-18715, 28465))) break block13;
                        string2 = string3 + APDUSmartCard.a(-18743, 1870);
                        if (n == 0) break block14;
                    }
                    if (!string.contains(APDUSmartCard.a(-18745, -24405))) break block15;
                    string2 = string3 + APDUSmartCard.a(-18746, -28719);
                    if (n == 0) break block14;
                }
                throw new CardException(APDUSmartCard.a(-18737, 7499) + string);
            }
            Signature signature = Signature.getInstance(string2);
            signature.initVerify(x509Certificate);
            signature.update(byArray2);
            return signature.verify(byArray);
        }
        catch (Exception exception) {
            b.warn(APDUSmartCard.a(-18724, -25238), (Throwable)exception);
            return false;
        }
    }

    @Override
    public void openSession(long aSlotID) throws SmartCardException {
        try {
            List<CardTerminal> list = this.a(CardTerminals.State.ALL);
            this.openSession(list.get((int)(aSlotID - 1L)));
        }
        catch (CardException cardException) {
            b.warn(APDUSmartCard.a(-18724, -25238), (Throwable)cardException);
            throw new SmartCardException(APDUSmartCard.a(-18714, -6481));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<byte[]> getEncryptionCertificates() throws SmartCardException {
        List<X509Certificate> list = this.readCertificates();
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Iterator<X509Certificate> iterator = list.iterator();
        int n = TerminalHandler.b;
        while (iterator.hasNext()) {
            block10: {
                X509Certificate x509Certificate = iterator.next();
                if (!x509Certificate.getKeyUsage()[2]) {
                    if (x509Certificate.getKeyUsage()[3]) {
                    }
                    break block10;
                }
                arrayList.add(x509Certificate.getEncoded());
                catch (SmartCardException smartCardException) {
                    throw smartCardException;
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    b.error(APDUSmartCard.a(-18733, 31731), (Throwable)certificateEncodingException);
                }
            }
            if (n == 0) continue;
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void login(String aCardPIN) throws SmartCardException, LoginException {
        int n = TerminalHandler.b;
        try {
            if (APDUSmartCard.isVersion20(this.commands.getVersion())) {
                this.commands.verify((byte)1, aCardPIN.getBytes(APDUSmartCard.a(-18732, -7339)), false);
                this.c = aCardPIN;
                if (n == 0) return;
            }
            this.commands.verify(aCardPIN.getBytes(APDUSmartCard.a(-18732, -7339)), false);
            return;
        }
        catch (AkisSWException akisSWException) {
            if (APDUSmartCard.isVersion20(this.commands.getVersion()) ? akisSWException.getErrorCode() == 27011L : akisSWException.getErrorCode() == 27012L) {
                throw new LoginException(SmartCardI18n.getMsg(E_KEYS.PIN_LOCKED, new String[0]), akisSWException, false, true);
            }
            if ((akisSWException.getErrorCode() & 0x63C0L) != 25536L) return;
            if (akisSWException.getErrorCode() == 25536L) {
                throw new LoginException(SmartCardI18n.getMsg(E_KEYS.PIN_LOCKED, new String[0]), akisSWException, false, true);
            }
            if (akisSWException.getErrorCode() != 25537L) throw new LoginException(SmartCardI18n.getMsg(E_KEYS.INCORRECT_PIN, new String[0]), akisSWException, false, false);
            throw new LoginException(SmartCardI18n.getMsg(E_KEYS.INCORRECT_PIN_FINAL_TRY, new String[0]), akisSWException, true, false);
        }
        catch (Exception exception) {
            throw new SmartCardException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void logout() throws SmartCardException {
        int n = TerminalHandler.b;
        try {
            if (!APDUSmartCard.isVersion20(this.commands.getVersion())) {
                this.commands.logout();
                if (n == 0) return;
            }
            this.commands.selectMF();
            this.commands.selectDFByName(APDUSmartCard.a(-18740, 19666).getBytes(APDUSmartCard.a(-18750, -17228)));
            return;
        }
        catch (Exception exception) {
            throw new SmartCardException(exception);
        }
    }

    @Override
    public byte[] getSerial() throws SmartCardException {
        try {
            return this.commands.getSerial();
        }
        catch (Exception exception) {
            throw new SmartCardException(APDUSmartCard.a(-18722, 15211), exception);
        }
    }

    @Override
    public byte[] getSerial(long aSlotID) throws SmartCardException {
        int n = TerminalHandler.b;
        try {
            List<CardTerminal> list = this.a(CardTerminals.State.ALL);
            this.pcsc = this.terminalHandler.getTransmitter(list.get((int)(aSlotID - 1L)));
            this.commands = CIFFactory.getAkisCIFInstance((ICommandTransmitter)this.pcsc);
            byte[] byArray = new byte[]{};
            byArray = this.commands.getSerial();
            this.pcsc.closeCardTerminal();
            if (SmartCardException.b) {
                TerminalHandler.b = ++n;
            }
            return byArray;
        }
        catch (Exception exception) {
            throw new SmartCardException(APDUSmartCard.a(-18730, -32649), exception);
        }
    }

    @Override
    public BaseSigner getSigner(X509Certificate aCert, String aSigningAlg) throws SmartCardException {
        return new APDUSigner(this, aCert, aSigningAlg);
    }

    @Override
    public BaseSigner getSigner(X509Certificate aCert, String aSigningAlg, AlgorithmParameterSpec aParams) throws SmartCardException {
        return new APDUSigner(this, aCert, aSigningAlg, aParams);
    }

    @Override
    public void closeSession() throws SmartCardException {
        this.pcsc.closeCardTerminal();
    }

    public static boolean isVersion20(Version aVersion) {
        return aVersion != Version.V10_UEKAE && aVersion != Version.V11_UEKAE_INF && aVersion != Version.V121_UEKAE_INF && aVersion != Version.V121_UEKAE_NXP && aVersion != Version.V121_UEKAE_UKiS && aVersion != Version.V121_UEKAE_UKIS_HHNEC && aVersion != Version.V121_UEKAE_UKiS_SMIC && aVersion != Version.V122_UEKAE_INF && aVersion != Version.V122_UEKAE_NXP && aVersion != Version.V122_UEKAE_UKiS_HHNEC && aVersion != Version.V122_UEKAE_UKiS_SMIC && aVersion != Version.V12_UEKAE_INF && aVersion != Version.V12_UEKAE_NXP && aVersion != Version.V12_UEKAE_UKiS && aVersion != Version.V13_UEKAE_INF && aVersion != Version.V14_UEKAE_INF && aVersion != Version.V14_UEKAE_NXP;
    }

    public static boolean _in(long aElement, long[] aList) {
        int n = TerminalHandler.b;
        if (aList == null) {
            return false;
        }
        for (int i = 0; i < aList.length; ++i) {
            if (aList[i] != aElement) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[36];
                var3_1 = 0;
                var2_2 = "}\u0012\u00d2f\u00b2\u00a1\u0017\u001a\u00cap\u008bF9\u00c9\u00c1H\u0098\u00d0\u0098~\u0085\u00bb\u00d5N\u00b8\u0018\f\u00f0g\u0084 \u00fdE\u0091\u0080\u0001\u00c2h\u0012\u0010\u00ef\u00fdoNq\u00946\u009a\u00c3\u0092\u0005jS\u008e^\u00fd\t\u0099s\u00b4\u000e\u0088!\u00e8~N\u0016\u00c6E\u0096\u0091T\u0080\u00b3Xh\u00eb\u0014\u00b1\u001a7#\u0096\u0081$_n\u001f\u0193\u0006\u00c8\u009a\u000bl\u009c\t\u001c\u0092\u00b31#\u00ce\u00e7\u0093\u00f7-\u0012\u00ca`}\u000b\u00e9\u00cc\u001c\u0002\u0080\u000f\u0011\u00aeW\u00ae\u00aa\u0082\u00ca\u009e\u0005\u00fd\u00e5\u00ff\u0080<!*Ej\u0089!\u00bc\u00a3\u00173\u00de@'s\u009c\u0096\u00c7\u00f9\u00ed#.\u00a8\u00ca\u0002\u0016wK\u0094\u0091]\u00d5\u00a1~n\u0007z\u00d9<\u0006 \u000e\u00e9\u0019v-(?\u00c9\u008ax\u007f'\u00dc6\u00d3\u009bg+\u0018\u00ed\u0082?\u0015]\u00c8_\u00a8\f\u0019C\u001c\u008e\u0019\u001dN\u00e2\u00e7t\u00cf\\\u00b1\u00d6+\u0082\u0091\u00d8\u00b3\u00993\u0089\f\u00c50_\u0007F3O\u0006\u00e00\u0015\u0004\u00f0\u0094\u00bd=\u0015['D\u00c5\u00e45\u001b&(\u00fa\u00ae\u00ee\u00fa]<\u001bW[9\u0087\u00db\u001ct\u001b\u00bd\u0092C\b\u0015\u00eaYLO\u00f2\u0085K\u00f3\u00da\u00d9\\M\u00efg\u009e\u00b9\u001f\u0010\u00a5H\u0003\u0005\u00f3~rXE\u0005\u0092<\u0012\u00bb\u0081\u00196\u00ed\u00bb\u0083\u009fD\u00a8\u00a6d\u00e7^\u00b4\u0083\u0097\u0096\u0083r\u00a9\u00c5Q.^\u00a0\u00f2\u0016\u0012\u00db4T\u00a7\u00e6y[\u00af(\u00de\u00b6\u0093\u00b9c^\u0012\u00fc&\u001c\u00d5\u008b\u00a8D\u0099\t\u00ea\u00e8 \u008c\u0090\u00c4%\u0091/\u00c0\u0011\u00ea\u00c4\u00e3*vN\u0081\u00a4\u0016w\u00dd\u0011^c-\u00f6i\u00b3lX\u00a58fO\u0083\u00f1x;\u00ce\u001b\u00de\u00b2\u00e8\u00a7\u00e9\u00ae@>\u00f3\u00d6\u001a\u00a1/!\u00a6\u0097s\u00f5\u0018\u00da\u00cd8\u00ec\u00cb\u00ba?\u001d\u0019L\u00f3\u00f4@v<\u0095\u00a9\u00c3\u0006\u00aa\u0088\u001d\u0010Es\b\u00b7\u008a\u0092\u00c7&\u009d\u00fd\u00b1\u0018\u00b7\u00adS\u00da\u009eP\u00a0\u00ab(U-\u00e9\u0017@\u00cfI\u0001=3XI\u00b2\u00ae\u0015\u0018]\u00ac\u000e\u00fa5T\u00d5+\u0086E\u00f8\u00eb\u00ad\u0000\u0098A\u00eb<nx\u00e2\u00b6\u00db\u0095\u0006\u00e9R/t\u0015)\u0012\u00ec\u00ac\u00b2\u00b4:\u001b\u00c0\u00e3[W\u00d8\u00a2tE\u00e7\u00d6\u00cb\u00be\u001b.d\u00f6}*\u00f58U\u00fc\u00bb\u00fb\f\u0013\u0094!!\u0083#\u0006\u0000\u000ec\u0094\u00a0\u00b5R\u00fc\u001e\u00cb\u0013Y\u0094\u00fe&\u00a5D\u00a6\u00b6\u007fg\u0085{uyl&u+\u00e2\u00f9\u00c3\u00bb\u008e\u0083e\n6\u001c\u0016\u00e5\u00d8\u00f2\"\u00d8\u00f6\"\u0096Z2R\u008a\u00d2P:z\u00a2\u00b9;\u00dd\u0093\u01e5\u0006\u0016<\u00d0\u00bf\u00e3\u0090\u0003\u00ef\u001e\u00ce\u0016\u007f=\u001a\u00b8\u00acs\u0090\u0006\u00a8H-\u0085l\u007f=i\u007fX1V/\u00c1";
                var4_3 = "}\u0012\u00d2f\u00b2\u00a1\u0017\u001a\u00cap\u008bF9\u00c9\u00c1H\u0098\u00d0\u0098~\u0085\u00bb\u00d5N\u00b8\u0018\f\u00f0g\u0084 \u00fdE\u0091\u0080\u0001\u00c2h\u0012\u0010\u00ef\u00fdoNq\u00946\u009a\u00c3\u0092\u0005jS\u008e^\u00fd\t\u0099s\u00b4\u000e\u0088!\u00e8~N\u0016\u00c6E\u0096\u0091T\u0080\u00b3Xh\u00eb\u0014\u00b1\u001a7#\u0096\u0081$_n\u001f\u0193\u0006\u00c8\u009a\u000bl\u009c\t\u001c\u0092\u00b31#\u00ce\u00e7\u0093\u00f7-\u0012\u00ca`}\u000b\u00e9\u00cc\u001c\u0002\u0080\u000f\u0011\u00aeW\u00ae\u00aa\u0082\u00ca\u009e\u0005\u00fd\u00e5\u00ff\u0080<!*Ej\u0089!\u00bc\u00a3\u00173\u00de@'s\u009c\u0096\u00c7\u00f9\u00ed#.\u00a8\u00ca\u0002\u0016wK\u0094\u0091]\u00d5\u00a1~n\u0007z\u00d9<\u0006 \u000e\u00e9\u0019v-(?\u00c9\u008ax\u007f'\u00dc6\u00d3\u009bg+\u0018\u00ed\u0082?\u0015]\u00c8_\u00a8\f\u0019C\u001c\u008e\u0019\u001dN\u00e2\u00e7t\u00cf\\\u00b1\u00d6+\u0082\u0091\u00d8\u00b3\u00993\u0089\f\u00c50_\u0007F3O\u0006\u00e00\u0015\u0004\u00f0\u0094\u00bd=\u0015['D\u00c5\u00e45\u001b&(\u00fa\u00ae\u00ee\u00fa]<\u001bW[9\u0087\u00db\u001ct\u001b\u00bd\u0092C\b\u0015\u00eaYLO\u00f2\u0085K\u00f3\u00da\u00d9\\M\u00efg\u009e\u00b9\u001f\u0010\u00a5H\u0003\u0005\u00f3~rXE\u0005\u0092<\u0012\u00bb\u0081\u00196\u00ed\u00bb\u0083\u009fD\u00a8\u00a6d\u00e7^\u00b4\u0083\u0097\u0096\u0083r\u00a9\u00c5Q.^\u00a0\u00f2\u0016\u0012\u00db4T\u00a7\u00e6y[\u00af(\u00de\u00b6\u0093\u00b9c^\u0012\u00fc&\u001c\u00d5\u008b\u00a8D\u0099\t\u00ea\u00e8 \u008c\u0090\u00c4%\u0091/\u00c0\u0011\u00ea\u00c4\u00e3*vN\u0081\u00a4\u0016w\u00dd\u0011^c-\u00f6i\u00b3lX\u00a58fO\u0083\u00f1x;\u00ce\u001b\u00de\u00b2\u00e8\u00a7\u00e9\u00ae@>\u00f3\u00d6\u001a\u00a1/!\u00a6\u0097s\u00f5\u0018\u00da\u00cd8\u00ec\u00cb\u00ba?\u001d\u0019L\u00f3\u00f4@v<\u0095\u00a9\u00c3\u0006\u00aa\u0088\u001d\u0010Es\b\u00b7\u008a\u0092\u00c7&\u009d\u00fd\u00b1\u0018\u00b7\u00adS\u00da\u009eP\u00a0\u00ab(U-\u00e9\u0017@\u00cfI\u0001=3XI\u00b2\u00ae\u0015\u0018]\u00ac\u000e\u00fa5T\u00d5+\u0086E\u00f8\u00eb\u00ad\u0000\u0098A\u00eb<nx\u00e2\u00b6\u00db\u0095\u0006\u00e9R/t\u0015)\u0012\u00ec\u00ac\u00b2\u00b4:\u001b\u00c0\u00e3[W\u00d8\u00a2tE\u00e7\u00d6\u00cb\u00be\u001b.d\u00f6}*\u00f58U\u00fc\u00bb\u00fb\f\u0013\u0094!!\u0083#\u0006\u0000\u000ec\u0094\u00a0\u00b5R\u00fc\u001e\u00cb\u0013Y\u0094\u00fe&\u00a5D\u00a6\u00b6\u007fg\u0085{uyl&u+\u00e2\u00f9\u00c3\u00bb\u008e\u0083e\n6\u001c\u0016\u00e5\u00d8\u00f2\"\u00d8\u00f6\"\u0096Z2R\u008a\u00d2P:z\u00a2\u00b9;\u00dd\u0093\u01e5\u0006\u0016<\u00d0\u00bf\u00e3\u0090\u0003\u00ef\u001e\u00ce\u0016\u007f=\u001a\u00b8\u00acs\u0090\u0006\u00a8H-\u0085l\u007f=i\u007fX1V/\u00c1".length();
                var1_4 = 25;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00ae\u0003\u00a6]se\u0083\u0017\u0080\u00e7?\u00dd\u008b6\u00f6F\u009b\u00e5\u0011w\u0098\u0004\f7\u00aa\"P\u00d7\u00f4\u00fd\u008f";
                    var4_3 = "\u00ae\u0003\u00a6]se\u0083\u0017\u0080\u00e7?\u00dd\u008b6\u00f6F\u009b\u00e5\u0011w\u0098\u0004\f7\u00aa\"P\u00d7\u00f4\u00fd\u008f".length();
                    var1_4 = 7;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 99;
                            break;
                        }
                        case 1: {
                            v13 = 81;
                            break;
                        }
                        case 2: {
                            v13 = 6;
                            break;
                        }
                        case 3: {
                            v13 = 102;
                            break;
                        }
                        case 4: {
                            v13 = 97;
                            break;
                        }
                        case 5: {
                            v13 = 10;
                            break;
                        }
                        default: {
                            v13 = 124;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        APDUSmartCard.d = var5;
        APDUSmartCard.e = new String[36];
        APDUSmartCard.CERT_FID_START = 12048;
        APDUSmartCard.CERT_FID_END = 12064;
        APDUSmartCard.b = LoggerFactory.getLogger(APDUSmartCard.class);
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0xFFFFB6C5) & 0xFFFF;
        if (e[n3] == null) {
            int n4;
            int n5;
            char[] cArray = d[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 120;
                    break;
                }
                case 1: {
                    n5 = 106;
                    break;
                }
                case 2: {
                    n5 = 103;
                    break;
                }
                case 3: {
                    n5 = 198;
                    break;
                }
                case 4: {
                    n5 = 154;
                    break;
                }
                case 5: {
                    n5 = 145;
                    break;
                }
                case 6: {
                    n5 = 60;
                    break;
                }
                case 7: {
                    n5 = 156;
                    break;
                }
                case 8: {
                    n5 = 196;
                    break;
                }
                case 9: {
                    n5 = 95;
                    break;
                }
                case 10: {
                    n5 = 115;
                    break;
                }
                case 11: {
                    n5 = 52;
                    break;
                }
                case 12: {
                    n5 = 254;
                    break;
                }
                case 13: {
                    n5 = 200;
                    break;
                }
                case 14: {
                    n5 = 4;
                    break;
                }
                case 15: {
                    n5 = 230;
                    break;
                }
                case 16: {
                    n5 = 255;
                    break;
                }
                case 17: {
                    n5 = 86;
                    break;
                }
                case 18: {
                    n5 = 22;
                    break;
                }
                case 19: {
                    n5 = 117;
                    break;
                }
                case 20: {
                    n5 = 242;
                    break;
                }
                case 21: {
                    n5 = 11;
                    break;
                }
                case 22: {
                    n5 = 194;
                    break;
                }
                case 23: {
                    n5 = 114;
                    break;
                }
                case 24: {
                    n5 = 53;
                    break;
                }
                case 25: {
                    n5 = 137;
                    break;
                }
                case 26: {
                    n5 = 66;
                    break;
                }
                case 27: {
                    n5 = 170;
                    break;
                }
                case 28: {
                    n5 = 147;
                    break;
                }
                case 29: {
                    n5 = 215;
                    break;
                }
                case 30: {
                    n5 = 110;
                    break;
                }
                case 31: {
                    n5 = 218;
                    break;
                }
                case 32: {
                    n5 = 102;
                    break;
                }
                case 33: {
                    n5 = 173;
                    break;
                }
                case 34: {
                    n5 = 41;
                    break;
                }
                case 35: {
                    n5 = 25;
                    break;
                }
                case 36: {
                    n5 = 205;
                    break;
                }
                case 37: {
                    n5 = 252;
                    break;
                }
                case 38: {
                    n5 = 79;
                    break;
                }
                case 39: {
                    n5 = 148;
                    break;
                }
                case 40: {
                    n5 = 23;
                    break;
                }
                case 41: {
                    n5 = 248;
                    break;
                }
                case 42: {
                    n5 = 7;
                    break;
                }
                case 43: {
                    n5 = 162;
                    break;
                }
                case 44: {
                    n5 = 122;
                    break;
                }
                case 45: {
                    n5 = 224;
                    break;
                }
                case 46: {
                    n5 = 35;
                    break;
                }
                case 47: {
                    n5 = 92;
                    break;
                }
                case 48: {
                    n5 = 21;
                    break;
                }
                case 49: {
                    n5 = 43;
                    break;
                }
                case 50: {
                    n5 = 152;
                    break;
                }
                case 51: {
                    n5 = 72;
                    break;
                }
                case 52: {
                    n5 = 128;
                    break;
                }
                case 53: {
                    n5 = 9;
                    break;
                }
                case 54: {
                    n5 = 109;
                    break;
                }
                case 55: {
                    n5 = 211;
                    break;
                }
                case 56: {
                    n5 = 187;
                    break;
                }
                case 57: {
                    n5 = 70;
                    break;
                }
                case 58: {
                    n5 = 166;
                    break;
                }
                case 59: {
                    n5 = 20;
                    break;
                }
                case 60: {
                    n5 = 201;
                    break;
                }
                case 61: {
                    n5 = 209;
                    break;
                }
                case 62: {
                    n5 = 1;
                    break;
                }
                case 63: {
                    n5 = 58;
                    break;
                }
                case 64: {
                    n5 = 203;
                    break;
                }
                case 65: {
                    n5 = 161;
                    break;
                }
                case 66: {
                    n5 = 98;
                    break;
                }
                case 67: {
                    n5 = 167;
                    break;
                }
                case 68: {
                    n5 = 116;
                    break;
                }
                case 69: {
                    n5 = 101;
                    break;
                }
                case 70: {
                    n5 = 139;
                    break;
                }
                case 71: {
                    n5 = 231;
                    break;
                }
                case 72: {
                    n5 = 229;
                    break;
                }
                case 73: {
                    n5 = 94;
                    break;
                }
                case 74: {
                    n5 = 164;
                    break;
                }
                case 75: {
                    n5 = 151;
                    break;
                }
                case 76: {
                    n5 = 191;
                    break;
                }
                case 77: {
                    n5 = 236;
                    break;
                }
                case 78: {
                    n5 = 193;
                    break;
                }
                case 79: {
                    n5 = 144;
                    break;
                }
                case 80: {
                    n5 = 142;
                    break;
                }
                case 81: {
                    n5 = 91;
                    break;
                }
                case 82: {
                    n5 = 61;
                    break;
                }
                case 83: {
                    n5 = 175;
                    break;
                }
                case 84: {
                    n5 = 99;
                    break;
                }
                case 85: {
                    n5 = 104;
                    break;
                }
                case 86: {
                    n5 = 24;
                    break;
                }
                case 87: {
                    n5 = 28;
                    break;
                }
                case 88: {
                    n5 = 85;
                    break;
                }
                case 89: {
                    n5 = 136;
                    break;
                }
                case 90: {
                    n5 = 107;
                    break;
                }
                case 91: {
                    n5 = 55;
                    break;
                }
                case 92: {
                    n5 = 16;
                    break;
                }
                case 93: {
                    n5 = 3;
                    break;
                }
                case 94: {
                    n5 = 29;
                    break;
                }
                case 95: {
                    n5 = 179;
                    break;
                }
                case 96: {
                    n5 = 222;
                    break;
                }
                case 97: {
                    n5 = 186;
                    break;
                }
                case 98: {
                    n5 = 227;
                    break;
                }
                case 99: {
                    n5 = 51;
                    break;
                }
                case 100: {
                    n5 = 37;
                    break;
                }
                case 101: {
                    n5 = 121;
                    break;
                }
                case 102: {
                    n5 = 0;
                    break;
                }
                case 103: {
                    n5 = 169;
                    break;
                }
                case 104: {
                    n5 = 134;
                    break;
                }
                case 105: {
                    n5 = 62;
                    break;
                }
                case 106: {
                    n5 = 65;
                    break;
                }
                case 107: {
                    n5 = 210;
                    break;
                }
                case 108: {
                    n5 = 80;
                    break;
                }
                case 109: {
                    n5 = 190;
                    break;
                }
                case 110: {
                    n5 = 247;
                    break;
                }
                case 111: {
                    n5 = 226;
                    break;
                }
                case 112: {
                    n5 = 6;
                    break;
                }
                case 113: {
                    n5 = 8;
                    break;
                }
                case 114: {
                    n5 = 49;
                    break;
                }
                case 115: {
                    n5 = 118;
                    break;
                }
                case 116: {
                    n5 = 40;
                    break;
                }
                case 117: {
                    n5 = 27;
                    break;
                }
                case 118: {
                    n5 = 50;
                    break;
                }
                case 119: {
                    n5 = 112;
                    break;
                }
                case 120: {
                    n5 = 219;
                    break;
                }
                case 121: {
                    n5 = 204;
                    break;
                }
                case 122: {
                    n5 = 32;
                    break;
                }
                case 123: {
                    n5 = 34;
                    break;
                }
                case 124: {
                    n5 = 84;
                    break;
                }
                case 125: {
                    n5 = 119;
                    break;
                }
                case 126: {
                    n5 = 251;
                    break;
                }
                case 127: {
                    n5 = 2;
                    break;
                }
                case 128: {
                    n5 = 244;
                    break;
                }
                case 129: {
                    n5 = 177;
                    break;
                }
                case 130: {
                    n5 = 73;
                    break;
                }
                case 131: {
                    n5 = 238;
                    break;
                }
                case 132: {
                    n5 = 195;
                    break;
                }
                case 133: {
                    n5 = 111;
                    break;
                }
                case 134: {
                    n5 = 155;
                    break;
                }
                case 135: {
                    n5 = 77;
                    break;
                }
                case 136: {
                    n5 = 46;
                    break;
                }
                case 137: {
                    n5 = 17;
                    break;
                }
                case 138: {
                    n5 = 221;
                    break;
                }
                case 139: {
                    n5 = 42;
                    break;
                }
                case 140: {
                    n5 = 83;
                    break;
                }
                case 141: {
                    n5 = 135;
                    break;
                }
                case 142: {
                    n5 = 81;
                    break;
                }
                case 143: {
                    n5 = 159;
                    break;
                }
                case 144: {
                    n5 = 75;
                    break;
                }
                case 145: {
                    n5 = 48;
                    break;
                }
                case 146: {
                    n5 = 59;
                    break;
                }
                case 147: {
                    n5 = 250;
                    break;
                }
                case 148: {
                    n5 = 249;
                    break;
                }
                case 149: {
                    n5 = 180;
                    break;
                }
                case 150: {
                    n5 = 174;
                    break;
                }
                case 151: {
                    n5 = 56;
                    break;
                }
                case 152: {
                    n5 = 127;
                    break;
                }
                case 153: {
                    n5 = 63;
                    break;
                }
                case 154: {
                    n5 = 149;
                    break;
                }
                case 155: {
                    n5 = 123;
                    break;
                }
                case 156: {
                    n5 = 36;
                    break;
                }
                case 157: {
                    n5 = 192;
                    break;
                }
                case 158: {
                    n5 = 213;
                    break;
                }
                case 159: {
                    n5 = 96;
                    break;
                }
                case 160: {
                    n5 = 202;
                    break;
                }
                case 161: {
                    n5 = 140;
                    break;
                }
                case 162: {
                    n5 = 216;
                    break;
                }
                case 163: {
                    n5 = 12;
                    break;
                }
                case 164: {
                    n5 = 88;
                    break;
                }
                case 165: {
                    n5 = 44;
                    break;
                }
                case 166: {
                    n5 = 232;
                    break;
                }
                case 167: {
                    n5 = 71;
                    break;
                }
                case 168: {
                    n5 = 146;
                    break;
                }
                case 169: {
                    n5 = 168;
                    break;
                }
                case 170: {
                    n5 = 207;
                    break;
                }
                case 171: {
                    n5 = 31;
                    break;
                }
                case 172: {
                    n5 = 189;
                    break;
                }
                case 173: {
                    n5 = 89;
                    break;
                }
                case 174: {
                    n5 = 157;
                    break;
                }
                case 175: {
                    n5 = 13;
                    break;
                }
                case 176: {
                    n5 = 241;
                    break;
                }
                case 177: {
                    n5 = 237;
                    break;
                }
                case 178: {
                    n5 = 184;
                    break;
                }
                case 179: {
                    n5 = 220;
                    break;
                }
                case 180: {
                    n5 = 18;
                    break;
                }
                case 181: {
                    n5 = 39;
                    break;
                }
                case 182: {
                    n5 = 5;
                    break;
                }
                case 183: {
                    n5 = 199;
                    break;
                }
                case 184: {
                    n5 = 124;
                    break;
                }
                case 185: {
                    n5 = 143;
                    break;
                }
                case 186: {
                    n5 = 235;
                    break;
                }
                case 187: {
                    n5 = 67;
                    break;
                }
                case 188: {
                    n5 = 160;
                    break;
                }
                case 189: {
                    n5 = 245;
                    break;
                }
                case 190: {
                    n5 = 172;
                    break;
                }
                case 191: {
                    n5 = 100;
                    break;
                }
                case 192: {
                    n5 = 125;
                    break;
                }
                case 193: {
                    n5 = 47;
                    break;
                }
                case 194: {
                    n5 = 93;
                    break;
                }
                case 195: {
                    n5 = 185;
                    break;
                }
                case 196: {
                    n5 = 38;
                    break;
                }
                case 197: {
                    n5 = 45;
                    break;
                }
                case 198: {
                    n5 = 26;
                    break;
                }
                case 199: {
                    n5 = 131;
                    break;
                }
                case 200: {
                    n5 = 253;
                    break;
                }
                case 201: {
                    n5 = 217;
                    break;
                }
                case 202: {
                    n5 = 10;
                    break;
                }
                case 203: {
                    n5 = 182;
                    break;
                }
                case 204: {
                    n5 = 208;
                    break;
                }
                case 205: {
                    n5 = 97;
                    break;
                }
                case 206: {
                    n5 = 141;
                    break;
                }
                case 207: {
                    n5 = 133;
                    break;
                }
                case 208: {
                    n5 = 57;
                    break;
                }
                case 209: {
                    n5 = 181;
                    break;
                }
                case 210: {
                    n5 = 171;
                    break;
                }
                case 211: {
                    n5 = 90;
                    break;
                }
                case 212: {
                    n5 = 176;
                    break;
                }
                case 213: {
                    n5 = 14;
                    break;
                }
                case 214: {
                    n5 = 240;
                    break;
                }
                case 215: {
                    n5 = 158;
                    break;
                }
                case 216: {
                    n5 = 30;
                    break;
                }
                case 217: {
                    n5 = 243;
                    break;
                }
                case 218: {
                    n5 = 214;
                    break;
                }
                case 219: {
                    n5 = 206;
                    break;
                }
                case 220: {
                    n5 = 223;
                    break;
                }
                case 221: {
                    n5 = 153;
                    break;
                }
                case 222: {
                    n5 = 64;
                    break;
                }
                case 223: {
                    n5 = 76;
                    break;
                }
                case 224: {
                    n5 = 233;
                    break;
                }
                case 225: {
                    n5 = 225;
                    break;
                }
                case 226: {
                    n5 = 108;
                    break;
                }
                case 227: {
                    n5 = 15;
                    break;
                }
                case 228: {
                    n5 = 188;
                    break;
                }
                case 229: {
                    n5 = 183;
                    break;
                }
                case 230: {
                    n5 = 212;
                    break;
                }
                case 231: {
                    n5 = 150;
                    break;
                }
                case 232: {
                    n5 = 126;
                    break;
                }
                case 233: {
                    n5 = 246;
                    break;
                }
                case 234: {
                    n5 = 19;
                    break;
                }
                case 235: {
                    n5 = 69;
                    break;
                }
                case 236: {
                    n5 = 197;
                    break;
                }
                case 237: {
                    n5 = 87;
                    break;
                }
                case 238: {
                    n5 = 54;
                    break;
                }
                case 239: {
                    n5 = 228;
                    break;
                }
                case 240: {
                    n5 = 130;
                    break;
                }
                case 241: {
                    n5 = 165;
                    break;
                }
                case 242: {
                    n5 = 113;
                    break;
                }
                case 243: {
                    n5 = 78;
                    break;
                }
                case 244: {
                    n5 = 239;
                    break;
                }
                case 245: {
                    n5 = 234;
                    break;
                }
                case 246: {
                    n5 = 178;
                    break;
                }
                case 247: {
                    n5 = 82;
                    break;
                }
                case 248: {
                    n5 = 33;
                    break;
                }
                case 249: {
                    n5 = 138;
                    break;
                }
                case 250: {
                    n5 = 68;
                    break;
                }
                case 251: {
                    n5 = 105;
                    break;
                }
                case 252: {
                    n5 = 163;
                    break;
                }
                case 253: {
                    n5 = 74;
                    break;
                }
                case 254: {
                    n5 = 132;
                    break;
                }
                default: {
                    n5 = 129;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            APDUSmartCard.e[n3] = new String(cArray).intern();
        }
        return e[n3];
    }
}

