/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11SecureRandom
extends SecureRandomSpi {
    private static final long serialVersionUID = -8939510236124553291L;
    private final Token token;
    private volatile SecureRandom mixRandom;
    private byte[] mixBuffer;
    private int buffered;
    private static final long MAX_IBUFFER_TIME = 100L;
    private static final int IBUFFER_SIZE = 32;
    private final transient byte[] iBuffer = new byte[32];
    private transient int ibuffered = 0;
    private transient long lastRead;

    P11SecureRandom(Token token) {
        this.token = token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void engineSetSeed(byte[] byArray) {
        block9: {
            if (byArray == null) {
                throw new NullPointerException("seed must not be null");
            }
            Session session = null;
            try {
                session = this.token.getOpSession();
                this.token.p11.C_SeedRandom(session.id(), byArray);
            }
            catch (PKCS11Exception pKCS11Exception) {
                SecureRandom secureRandom = this.mixRandom;
                if (secureRandom != null) {
                    secureRandom.setSeed(byArray);
                    break block9;
                }
                try {
                    this.mixBuffer = new byte[20];
                    secureRandom = SecureRandom.getInstance("SHA1PRNG");
                    secureRandom.setSeed(byArray);
                    this.mixRandom = secureRandom;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new ProviderException(noSuchAlgorithmException);
                }
            }
            finally {
                this.token.releaseSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void engineNextBytes(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return;
        }
        int n = byArray.length;
        if (n <= 32) {
            int n2 = 0;
            byte[] byArray2 = this.iBuffer;
            synchronized (this.iBuffer) {
                while (n > 0) {
                    long l = System.currentTimeMillis();
                    if (this.ibuffered == 0 || l - this.lastRead >= 100L) {
                        this.lastRead = l;
                        this.implNextBytes(this.iBuffer);
                        this.ibuffered = 32;
                    }
                    int n3 = 32 - this.ibuffered;
                    while (n > 0 && this.ibuffered > 0) {
                        byArray[n2++] = this.iBuffer[n3++];
                        --n;
                        --this.ibuffered;
                    }
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        } else {
            this.implNextBytes(byArray);
        }
    }

    protected byte[] engineGenerateSeed(int n) {
        byte[] byArray = new byte[n];
        this.engineNextBytes(byArray);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mix(byte[] byArray) {
        SecureRandom secureRandom = this.mixRandom;
        if (secureRandom == null) {
            return;
        }
        P11SecureRandom p11SecureRandom = this;
        synchronized (p11SecureRandom) {
            int n = 0;
            int n2 = byArray.length;
            while (n2-- > 0) {
                if (this.buffered == 0) {
                    secureRandom.nextBytes(this.mixBuffer);
                    this.buffered = this.mixBuffer.length;
                }
                int n3 = n++;
                byArray[n3] = (byte)(byArray[n3] ^ this.mixBuffer[this.mixBuffer.length - this.buffered]);
                --this.buffered;
            }
        }
    }

    private void implNextBytes(byte[] byArray) {
        Session session = null;
        try {
            session = this.token.getOpSession();
            this.token.p11.C_GenerateRandom(session.id(), byArray);
            this.mix(byArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("implNextBytes() failed", pKCS11Exception);
        }
        finally {
            this.token.releaseSession(session);
        }
    }
}

