/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.ocsp;

import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.OctetString;
import com.turktrust.asn1.Sequence;
import com.turktrust.x509.AlgorithmIdentifier;

public class CertID
extends Sequence {
    private AlgorithmIdentifier hashAlgorithm = new AlgorithmIdentifier("hashAlgorithm");
    private OctetString issuerNameHash = new OctetString("issuerNameHash");
    private OctetString issuerKeyHash = new OctetString("issuerKeyHash");
    private ASN1Integer serialNumber = new ASN1Integer("serialNumber");

    public CertID() {
        super("default_certId");
        this.setUpElements();
    }

    public CertID(String name) {
        super(name);
        this.setUpElements();
    }

    protected void setUpElements() {
        super.addElement(this.hashAlgorithm);
        super.addElement(this.issuerNameHash);
        super.addElement(this.issuerKeyHash);
        super.addElement(this.serialNumber);
    }

    public void setHashAlgorithm(AlgorithmIdentifier algId) {
        this.hashAlgorithm = algId;
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setIssuerNameHash(OctetString value) {
        this.issuerNameHash = value;
    }

    public OctetString getIssuerNameHash() {
        return this.issuerNameHash;
    }

    public void setIssuerKeyHash(OctetString value) {
        this.issuerKeyHash = value;
    }

    public OctetString getIssuerKeyHash() {
        return this.issuerKeyHash;
    }

    public void setSerialNumber(ASN1Integer value) {
        this.serialNumber = value;
    }

    public ASN1Integer getSerialNumber() {
        return this.serialNumber;
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }
}

