/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.ASN1Boolean;
import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.Enumerated;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.x509.Extension;
import java.math.BigInteger;

public class CRLReason
extends Extension {
    public static final String EXT_OBJ_ID = "2.5.29.21";
    private int reasonCode;

    public CRLReason(String name, boolean critical, int reasonCodeVal) {
        ObjectID extObjId = new ObjectID("CRLReasonObjectId");
        extObjId.setValue(EXT_OBJ_ID);
        this.setextnID(extObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(critical));
        this.setcritical(crit);
        this.reasonCode = reasonCodeVal;
        ASN1Integer reasonAsn = new ASN1Integer("reasonCode", Integer.toString(this.reasonCode));
        byte[] reasonBytes = reasonAsn.getEncoded();
        reasonBytes[0] = 10;
        OctetString reasonOcts = new OctetString("reasonOcts", reasonBytes);
        this.setextnValue(reasonOcts);
        this.commitElementUpdate();
    }

    public CRLReason() {
        ObjectID extObjId = new ObjectID("CRLReasonObjectId");
        extObjId.setValue(EXT_OBJ_ID);
        this.setextnID(extObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(false));
        this.setcritical(crit);
        this.commitElementUpdate();
    }

    public void decodeExtVal(byte[] extValBytes) {
        Enumerated renum = new Enumerated();
        try {
            renum.decode(extValBytes);
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.reasonCode = Integer.parseInt(((BigInteger)renum.getValue()).toString());
        OctetString octs = new OctetString("crlReasonVal", extValBytes);
        this.setextnValue(octs);
        this.commitElementUpdate();
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    public String getExtensionTitle() {
        return "CRL Reason";
    }

    public String getTurkishExtensionTitle() {
        return "Sertifika \u0130ptal Listesi Nedeni";
    }

    public String getExplanation() {
        switch (this.reasonCode) {
            case 0: {
                return "Unspecified";
            }
            case 1: {
                return "Key Compromise";
            }
            case 2: {
                return "CA Compromise";
            }
            case 3: {
                return "Affiliation Changed";
            }
            case 4: {
                return "Superseded";
            }
            case 5: {
                return "Cessation of Operation";
            }
            case 6: {
                return "Certificate Hold";
            }
            case 8: {
                return "Remove from CRL";
            }
            case 9: {
                return "Privilege Withdrawn";
            }
            case 10: {
                return "AA Compromise";
            }
        }
        return "";
    }

    public String getTurkishExplanation() {
        switch (this.reasonCode) {
            case 0: {
                return "Tan\u0131ms\u0131z";
            }
            case 1: {
                return "Anahtar G\u00fcvenlik Kayb\u0131";
            }
            case 2: {
                return "ESHS G\u00fcvenlik Kayb\u0131";
            }
            case 3: {
                return "Nitelik De\u011fi\u015fikli\u011fi";
            }
            case 4: {
                return "Yenileme";
            }
            case 5: {
                return "ESHS Faaliyetinin Durmas\u0131";
            }
            case 6: {
                return "Ask\u0131";
            }
            case 8: {
                return "CRL'den \u00c7\u0131karma";
            }
            case 9: {
                return "Yetki \u0130ptali";
            }
            case 10: {
                return "Yetkilendirme G\u00fcvenlik Kayb\u0131";
            }
        }
        return "";
    }
}

