/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.dataStructures;

import tubitak.akis.cif.akisExceptions.AkisRuntimeException;
import tubitak.akis.cif.dataStructures.FileDescriptor;

public class FDB {
    private FileDescriptor fd;
    private byte dataCodingByte = 0;
    private int recordLength = -1;
    private int recordNumber = -1;

    public FDB(FileDescriptor fileDescriptor) {
        if (fileDescriptor == FileDescriptor.FixedRecord || fileDescriptor == FileDescriptor.FixedCycRecord) {
            throw new AkisRuntimeException("Requires more parameters.");
        }
        this.fd = fileDescriptor;
    }

    public FDB(FileDescriptor fileDescriptor, int recordLength) {
        if (fileDescriptor != FileDescriptor.FixedRecord) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        this.fd = fileDescriptor;
        if (recordLength <= 0) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        this.recordLength = recordLength;
    }

    public FDB(FileDescriptor fileDescriptor, int recordLength, int recordNumber) {
        if (fileDescriptor != FileDescriptor.FixedRecord && fileDescriptor != FileDescriptor.FixedCycRecord) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        this.fd = fileDescriptor;
        if (recordLength <= 0) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        this.recordLength = recordLength;
        if (recordNumber <= 0) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        this.recordNumber = recordNumber;
    }

    public byte[] toByteArray() {
        byte[] bLen;
        int len = 1;
        if (this.recordLength > 0) {
            bLen = this.intToByteArray(this.recordLength);
            len = 2 + bLen.length;
            if (this.recordNumber > 0) {
                bLen = this.intToByteArray(this.recordNumber);
                len = 4 + bLen.length;
            }
        }
        byte[] arrData = new byte[len];
        arrData[0] = this.fd.getValue();
        if (this.recordLength > 0) {
            arrData[1] = this.dataCodingByte;
            bLen = this.intToByteArray(this.recordLength);
            System.arraycopy(bLen, 0, arrData, 2, bLen.length);
            if (this.recordNumber > 0) {
                bLen = this.intToByteArray(this.recordLength);
                if (bLen.length == 1) {
                    arrData[2] = 0;
                    arrData[3] = bLen[0];
                } else {
                    System.arraycopy(bLen, 0, arrData, 2, bLen.length);
                }
                bLen = this.intToByteArray(this.recordNumber);
                System.arraycopy(bLen, 0, arrData, 4, bLen.length);
            }
        }
        return arrData;
    }

    protected byte[] intToByteArray(int len) {
        byte[] data = len < 256 ? new byte[]{(byte)len} : new byte[]{(byte)(len >> 8), (byte)len};
        return data;
    }
}

