/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.dataStructures;

import tubitak.akis.cif.akisExceptions.AkisRuntimeException;
import tubitak.akis.cif.dataStructures.ARR;
import tubitak.akis.cif.dataStructures.KeyType;
import tubitak.akis.cif.dataStructures.SDOHeader;

public class SDOHeaderGezgin
extends SDOHeader {
    public byte[] effectiveDate;
    public byte[] expirationDate;
    public byte[] usageOID;

    public SDOHeaderGezgin() {
        this.effectiveDate = null;
        this.expirationDate = null;
        this.usageOID = null;
    }

    public SDOHeaderGezgin(byte id, byte[] name, int maxTryCount, int maxUsageCount, int nonRepFlag, int len, ARR access, byte[] berTLVInfo, byte[] info) {
        super(id, name, maxTryCount, maxUsageCount, nonRepFlag, len, access, berTLVInfo, info);
        this.effectiveDate = null;
        this.expirationDate = null;
        this.usageOID = null;
    }

    public SDOHeaderGezgin(byte id, byte[] name, byte[] effectiveDate, byte[] expirationDate, byte[] usageOID) {
        this.keyID = id;
        this.name = name;
        this.maxTryCount = -1;
        this.maxUsageCount = -1;
        this.nonRepFlag = -1;
        this.len = -1;
        this.access = null;
        this.berTLVInfo = null;
        this.info = null;
        this.effectiveDate = effectiveDate;
        this.expirationDate = expirationDate;
        this.usageOID = usageOID;
    }

    @Override
    public void CreateHeaderFromSDO(byte[] sdo) {
        KeyType keyType;
        int i = 5;
        if (sdo[1] == -112) {
            keyType = KeyType.PRIVATE_RSA;
        } else if (sdo[1] == -96) {
            keyType = KeyType.PUBLIC_RSA;
        } else if (sdo[1] == -111) {
            keyType = KeyType.PRIVATE_ECC;
        } else if (sdo[1] == -95) {
            keyType = KeyType.PUBLIC_ECC;
        } else if (sdo[1] == -110) {
            keyType = KeyType.PRIVATE_DH;
        } else {
            throw new AkisRuntimeException("Invalid parameter");
        }
        if (sdo[4] != -96) {
            throw new AkisRuntimeException("Invalid parameter");
        }
        this.keyID = sdo[2];
        i = 6;
        while (i < sdo.length) {
            switch (sdo[i]) {
                case -124: {
                    this.name = new byte[sdo[i + 1]];
                    System.arraycopy(sdo, i + 2, this.name, 0, sdo[i + 1]);
                    break;
                }
                case 37: {
                    if (keyType != KeyType.PUBLIC_ECC && keyType != KeyType.PUBLIC_RSA) break;
                    this.info = new byte[sdo[i + 1]];
                    System.arraycopy(sdo, i + 2, this.info, 0, sdo[i + 1]);
                    break;
                }
                case 36: {
                    if (keyType != KeyType.PUBLIC_ECC && keyType != KeyType.PUBLIC_RSA) break;
                    this.info = new byte[sdo[i + 1]];
                    System.arraycopy(sdo, i + 2, this.info, 0, sdo[i + 1]);
                    break;
                }
                case 6: {
                    if (keyType != KeyType.PUBLIC_ECC && keyType != KeyType.PUBLIC_RSA) break;
                    this.info = new byte[sdo[i + 1]];
                    System.arraycopy(sdo, i + 2, this.info, 0, sdo[i + 1]);
                    break;
                }
            }
            i = sdo[i + 1] + i + 2;
        }
    }
}

