/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.crypto.provider.sun;

import tr.gov.tubitak.uekae.esya.api.crypto.Cipher;
import tr.gov.tubitak.uekae.esya.api.crypto.Digester;
import tr.gov.tubitak.uekae.esya.api.crypto.KeyAgreement;
import tr.gov.tubitak.uekae.esya.api.crypto.KeyFactory;
import tr.gov.tubitak.uekae.esya.api.crypto.KeyPairGenerator;
import tr.gov.tubitak.uekae.esya.api.crypto.MAC;
import tr.gov.tubitak.uekae.esya.api.crypto.RandomGenerator;
import tr.gov.tubitak.uekae.esya.api.crypto.Signer;
import tr.gov.tubitak.uekae.esya.api.crypto.Verifier;
import tr.gov.tubitak.uekae.esya.api.crypto.Wrapper;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.Algorithm;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.AsymmetricAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.CipherAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.KeyAgreementAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.MACAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.WrapAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.CryptoProvider;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.sun.SUNCipher;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.sun.SUNDigester;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.sun.SUNKeyAgreement;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.sun.SUNKeyFactory;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.sun.SUNKeyPairGenerator;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.sun.SUNMAC;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.sun.SUNRandomGenerator;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.sun.SUNSigner;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.sun.SUNVerifier;
import tr.gov.tubitak.uekae.esya.api.crypto.provider.sun.SUNWrapper;

public class SUNCryptoProvider
implements CryptoProvider {
    public Cipher getEncryptor(CipherAlg aCipherAlg) throws CryptoException {
        return new SUNCipher(aCipherAlg, true);
    }

    public Cipher getDecryptor(CipherAlg aCipherAlg) throws CryptoException {
        return new SUNCipher(aCipherAlg, false);
    }

    public Digester getDigester(DigestAlg aDigestAlg) throws CryptoException {
        return new SUNDigester(aDigestAlg);
    }

    public Signer getSigner(SignatureAlg aSignatureAlg) throws CryptoException {
        return new SUNSigner(aSignatureAlg);
    }

    public Verifier getVerifier(SignatureAlg aSignatureAlg) throws CryptoException {
        return new SUNVerifier(aSignatureAlg);
    }

    public MAC getMAC(MACAlg aMACAlg) throws CryptoException {
        return new SUNMAC(aMACAlg);
    }

    public Wrapper getWrapper(WrapAlg aWrapAlg) throws CryptoException {
        return new SUNWrapper((Algorithm)aWrapAlg, true);
    }

    public Wrapper getUnwrapper(WrapAlg aWrapAlg) throws CryptoException {
        return new SUNWrapper((Algorithm)aWrapAlg, false);
    }

    public KeyAgreement getKeyAgreement(KeyAgreementAlg aKeyAgreementAlg) throws CryptoException {
        return new SUNKeyAgreement(aKeyAgreementAlg);
    }

    public KeyFactory getKeyFactory() throws CryptoException {
        return new SUNKeyFactory();
    }

    public KeyPairGenerator getKeyPairGenerator(AsymmetricAlg aAsymmetricAlg) throws CryptoException {
        return new SUNKeyPairGenerator(aAsymmetricAlg);
    }

    public RandomGenerator getRandomGenerator() {
        return new SUNRandomGenerator();
    }

    public boolean isFipsMode() {
        return false;
    }

    public void destroyProvider() {
    }
}

