/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1Real;
import com.objsys.asn1j.runtime.Asn1XmlEncoder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;

public class Asn1BigDecimal
extends Asn1Real {
    public transient BigDecimal value;
    private static final long serialVersionUID = 3406587116835849281L;

    public Asn1BigDecimal() {
        super(0.0);
        this.value = new BigDecimal(0);
    }

    public Asn1BigDecimal(double d2) {
        super(d2);
        this.value = new BigDecimal(d2);
    }

    public Asn1BigDecimal(BigDecimal bigDecimal) {
        super(bigDecimal.doubleValue());
        this.value = bigDecimal;
    }

    public void encode(Asn1XmlEncoder asn1XmlEncoder, String string, String string2) throws IOException, Asn1Exception {
        asn1XmlEncoder.encodeStartElement(string, string2, true);
        String string3 = this.value.toString();
        asn1XmlEncoder.copy(this.encodeBigDecimal());
        asn1XmlEncoder.encodeEndElement(string, string2);
    }

    public void encodeAttribute(Asn1XmlEncoder asn1XmlEncoder, String string) throws Asn1Exception, IOException {
        if (string == null) {
            return;
        }
        asn1XmlEncoder.copy(" " + string + "=\"" + this.encodeBigDecimal() + "\"");
    }

    public String encodeBigDecimal() {
        boolean bl = Asn1Exception.z;
        int n2 = this.value.scale();
        if (n2 < 0) {
            this.value.setScale(0);
        }
        if (n2 == 0) {
            return this.value.unscaledValue().toString();
        }
        int n3 = this.value.signum();
        String string = this.value.unscaledValue().abs().toString();
        int n4 = string.length() - n2;
        if (n4 == 0) {
            return (n3 < 0 ? "-0." : "0.") + string;
        }
        if (n4 > 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.insert(n4, '.');
            if (n3 < 0) {
                stringBuffer.insert(0, '-');
            }
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(3 + n2);
        stringBuffer.append(n3 < 0 ? "-0." : "0.");
        for (int i2 = 0; i2 < -n4; ++i2) {
            stringBuffer.append('0');
            if (!bl) continue;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public void decodeXML(String string, String string2) throws Asn1Exception {
        this.value = new BigDecimal(string.trim());
    }

    public boolean equals(double d2) {
        return this.value.doubleValue() == d2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Asn1BigDecimal)) {
            return false;
        }
        return this.value.doubleValue() == ((Asn1BigDecimal)object).value.doubleValue();
    }

    public String toString() {
        return this.value.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(1);
        objectOutputStream.writeObject(this.value);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readShort();
        this.value = (BigDecimal)objectInputStream.readObject();
    }
}

