/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1ConsVioException;
import com.objsys.asn1j.runtime.Asn1DecodeBuffer;
import com.objsys.asn1j.runtime.Asn1EncodeBuffer;
import com.objsys.asn1j.runtime.Asn1EndOfBufferException;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1JsonDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1JsonOutputStream;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerOutputStream;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import com.objsys.asn1j.runtime.Asn1XmlEncoder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;

public class Asn1BigInteger
extends Asn1Type {
    public static final Asn1Tag TAG = new Asn1Tag(0, 0, 2);
    static final BigInteger d = new BigInteger("256");
    static final BigInteger e = new BigInteger("-1");
    static final BigInteger f = new BigInteger("65536");
    static final BigInteger g = BigInteger.ZERO;
    static final int h = 100000;
    public transient BigInteger value;
    private static final long serialVersionUID = 3019513891173064889L;

    public Asn1BigInteger() {
        this.value = null;
    }

    public Asn1BigInteger(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new NullPointerException("Big integer value must not be null!");
        }
        this.value = bigInteger;
    }

    public Asn1BigInteger(String string) {
        int n2;
        String string2;
        String string3;
        block5: {
            block7: {
                boolean bl;
                block6: {
                    block4: {
                        bl = Asn1Exception.z;
                        string3 = "";
                        string2 = string;
                        if (string2.charAt(0) == '-') {
                            string2 = string2.substring(1);
                            string3 = "-";
                        }
                        if (!string2.startsWith("0x")) break block4;
                        n2 = 16;
                        string2 = string2.substring(2);
                        if (!bl) break block5;
                    }
                    if (!string2.startsWith("0b")) break block6;
                    n2 = 2;
                    string2 = string2.substring(2);
                    if (!bl) break block5;
                }
                if (!string2.startsWith("0o")) break block7;
                n2 = 8;
                string2 = string2.substring(2);
                if (!bl) break block5;
            }
            this.value = new BigInteger(string);
            return;
        }
        this.value = new BigInteger(string3 + string2, n2);
    }

    public Asn1BigInteger(String string, int n2) {
        this.value = new BigInteger(string, n2);
    }

    public static BigInteger decodeValue(Asn1DecodeBuffer asn1DecodeBuffer, int n2) throws Asn1Exception, IOException {
        BigInteger bigInteger = null;
        if (n2 > 100000) {
            throw new Asn1Exception("too big integer value (length is " + n2 + ")");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = asn1DecodeBuffer.readByte();
            if (n3 < 0) {
                throw new Asn1EndOfBufferException(asn1DecodeBuffer);
            }
            if (i2 == 0) {
                bigInteger = new BigInteger(n3 > 127 ? "-1" : "0");
            }
            bigInteger = bigInteger.multiply(d);
            bigInteger = bigInteger.add(new BigInteger(Integer.toString(n3)));
        }
        if (bigInteger == null) {
            bigInteger = g;
        }
        return bigInteger;
    }

    protected static int encodeValue(Asn1EncodeBuffer asn1EncodeBuffer, BigInteger bigInteger, boolean bl) {
        int n2;
        BigInteger bigInteger2 = bigInteger;
        int n3 = 0;
        do {
            BigInteger[] bigIntegerArray = bigInteger2.divideAndRemainder(d);
            bigInteger2 = bigIntegerArray[0];
            n2 = bigIntegerArray[1].intValue();
            if (bigInteger2.compareTo(g) == -1 && n2 != 0) {
                bigInteger2 = bigInteger2.add(e);
            }
            if (bl) {
                asn1EncodeBuffer.copy((byte)n2);
            }
            ++n3;
        } while (bigInteger2.compareTo(g) != 0 && bigInteger2.compareTo(e) != 0);
        if (bigInteger.compareTo(g) > 0 && (n2 & 0x80) == 128) {
            if (bl) {
                asn1EncodeBuffer.copy((byte)0);
            }
            ++n3;
        } else if (bigInteger.compareTo(g) < 0 && (n2 & 0x80) == 0) {
            if (bl) {
                asn1EncodeBuffer.copy((byte)-1);
            }
            ++n3;
        }
        return n3;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Asn1BigInteger) {
            if (this.value == null && ((Asn1BigInteger)object).value == null) {
                return true;
            }
            if (this.value == null) {
                return false;
            }
            if (((Asn1BigInteger)object).value == null) {
                return false;
            }
            return this.value.equals(((Asn1BigInteger)object).value);
        }
        if (object instanceof BigInteger) {
            if (this.value == null) {
                return false;
            }
            return this.value.equals((BigInteger)object);
        }
        if (object instanceof String) {
            if (this.value == null) {
                return false;
            }
            return this.equals(new Asn1BigInteger((String)object));
        }
        return false;
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n2) throws Asn1Exception, IOException {
        int n3 = bl ? Asn1BigInteger.matchTag(asn1BerDecodeBuffer, TAG) : n2;
        this.value = Asn1BigInteger.decodeValue(asn1BerDecodeBuffer, n3);
        asn1BerDecodeBuffer.setTypeCode((short)2);
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        int n2 = Asn1BigInteger.encodeValue(asn1BerEncodeBuffer, this.value, true);
        if (bl) {
            n2 += asn1BerEncodeBuffer.encodeTagAndLength(TAG, n2);
        }
        return n2;
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws Asn1Exception, IOException {
        int n2 = (int)asn1PerDecodeBuffer.decodeLength();
        asn1PerDecodeBuffer.byteAlign();
        asn1PerDecodeBuffer.getTraceHandler().newBitField("value", n2 * 8);
        this.value = Asn1BigInteger.decodeValue(asn1PerDecodeBuffer, n2);
        asn1PerDecodeBuffer.setTypeCode((short)2);
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, BigInteger bigInteger, BigInteger bigInteger2) throws Asn1Exception, IOException {
        block17: {
            block14: {
                block16: {
                    Object object;
                    int n2;
                    int n3;
                    block15: {
                        if (bigInteger == null) {
                            this.decode(asn1PerDecodeBuffer);
                            return;
                        }
                        BigInteger bigInteger3 = null;
                        n3 = 0;
                        boolean bl = asn1PerDecodeBuffer.isAligned();
                        if (bigInteger2 != null) {
                            bigInteger3 = bigInteger2.subtract(bigInteger).add(BigInteger.ONE);
                            if (bigInteger3.equals(BigInteger.ONE)) {
                                this.value = bigInteger;
                                return;
                            }
                            if (bl && bigInteger3.compareTo(f) <= 0) {
                                long l2 = bigInteger3.longValue();
                                long l3 = asn1PerDecodeBuffer.decodeConsWholeNumber(l2);
                                this.value = bigInteger.add(BigInteger.valueOf(l3));
                                return;
                            }
                            n3 = bigInteger3.subtract(BigInteger.ONE).bitLength();
                        }
                        if (bigInteger2 == null) break block14;
                        if (!asn1PerDecodeBuffer.isAligned()) break block15;
                        n2 = (n3 + 7) / 8;
                        long l4 = asn1PerDecodeBuffer.decodeLength(1L, n2);
                        if (l4 >= 16384L && n2 >= 65536) {
                            throw new Asn1Exception("fragmentation of INTEGER not supported");
                        }
                        asn1PerDecodeBuffer.byteAlign();
                        object = new byte[(int)l4];
                        asn1PerDecodeBuffer.decodeBitsToOctetArray((byte[])object, 0, (int)l4 * 8);
                        BigInteger bigInteger4 = new BigInteger(1, (byte[])object);
                        this.value = bigInteger4.add(bigInteger);
                        if (!Asn1Exception.z) break block16;
                    }
                    n2 = (n3 + 7) / 8;
                    int n4 = 8 - n3 % 8;
                    if (n4 == 8) {
                        n4 = 0;
                    }
                    byte[] byArray = new byte[n2];
                    asn1PerDecodeBuffer.decodeBitsToOctetArray(byArray, 0, n4, n3, "value");
                    object = new BigInteger(1, byArray);
                    this.value = ((BigInteger)object).add(bigInteger);
                }
                if (this.value.compareTo(bigInteger2) > 0) {
                    throw new Asn1ConsVioException("Asn1BigInteger.value", this.value.toString());
                }
                break block17;
            }
            long l5 = asn1PerDecodeBuffer.decodeLength();
            if (l5 >= 16384L) {
                throw new Asn1Exception("fragmented INTEGER not supported");
            }
            if (asn1PerDecodeBuffer.isAligned()) {
                asn1PerDecodeBuffer.byteAlign();
            }
            byte[] byArray = new byte[(int)l5];
            asn1PerDecodeBuffer.decodeBitsToOctetArray(byArray, 0, (int)l5 * 8);
            BigInteger bigInteger5 = new BigInteger(1, byArray);
            this.value = bigInteger5.add(bigInteger);
        }
        if (this.value.compareTo(bigInteger) < 0) {
            throw new Asn1ConsVioException("Asn1BigInteger.value", this.value.toString());
        }
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer) throws Asn1Exception, IOException {
        int n2;
        Asn1PerEncodeBuffer asn1PerEncodeBuffer2 = null;
        int n3 = Asn1BigInteger.encodeValue(asn1PerEncodeBuffer, this.value, false);
        asn1PerEncodeBuffer.encodeLength(n3);
        boolean bl = asn1PerEncodeBuffer.isAligned();
        if (!bl) {
            asn1PerEncodeBuffer2 = asn1PerEncodeBuffer;
            asn1PerEncodeBuffer = new Asn1PerEncodeBuffer(true, n3);
            n2 = 0;
        } else {
            asn1PerEncodeBuffer.getTraceHandler().newBitField("value", n3 * 8);
            n2 = asn1PerEncodeBuffer.getByteIndex() + 1;
        }
        Asn1BigInteger.encodeValue(asn1PerEncodeBuffer, this.value, true);
        asn1PerEncodeBuffer.reverseBytes(n2, n3);
        if (!bl) {
            byte[] byArray = asn1PerEncodeBuffer.getBuffer();
            asn1PerEncodeBuffer = asn1PerEncodeBuffer2;
            asn1PerEncodeBuffer.encodeBits(byArray, 0, n3 * 8);
        }
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, BigInteger bigInteger, BigInteger bigInteger2) throws Asn1Exception, IOException {
        block17: {
            int n2;
            byte[] byArray;
            int n3;
            block15: {
                int n4;
                int n5;
                BigInteger bigInteger3;
                boolean bl;
                block16: {
                    bl = Asn1Exception.z;
                    if (bigInteger == null) {
                        this.encode(asn1PerEncodeBuffer);
                        return;
                    }
                    bigInteger3 = this.value.subtract(bigInteger);
                    BigInteger bigInteger4 = null;
                    n5 = 0;
                    boolean bl2 = asn1PerEncodeBuffer.isAligned();
                    if (this.value.compareTo(bigInteger) < 0) {
                        throw new Asn1ConsVioException("Asn1BigInteger.value", this.value.toString());
                    }
                    if (bigInteger2 != null) {
                        bigInteger4 = bigInteger2.subtract(bigInteger).add(BigInteger.ONE);
                        if (this.value.compareTo(bigInteger2) > 0) {
                            throw new Asn1ConsVioException("Asn1BigInteger.value", this.value.toString());
                        }
                        if (bigInteger4.equals(BigInteger.ONE)) {
                            return;
                        }
                        if (bl2 && bigInteger4.compareTo(f) <= 0) {
                            long l2 = bigInteger3.longValue();
                            long l3 = bigInteger4.longValue();
                            asn1PerEncodeBuffer.encodeConsWholeNumber(l2, l3);
                            return;
                        }
                        n5 = bigInteger4.subtract(BigInteger.ONE).bitLength();
                    }
                    int n6 = n3 = (byArray = bigInteger3.toByteArray())[0] == 0 ? 1 : 0;
                    if (bigInteger2 == null) break block15;
                    if (!asn1PerEncodeBuffer.isAligned()) break block16;
                    n2 = (n5 + 7) / 8;
                    n4 = byArray.length - n3;
                    if (n2 >= 65536 && n4 >= 16384) {
                        throw new Asn1Exception("fragmentation of INTEGER not supported");
                    }
                    asn1PerEncodeBuffer.encodeLength(n4, 1L, n2);
                    asn1PerEncodeBuffer.byteAlign();
                    asn1PerEncodeBuffer.encodeBits(byArray, n3, n4 * 8);
                    if (!bl) break block17;
                }
                int n7 = (n4 = (n2 = bigInteger3.bitLength()) % 8) == 0 ? 0 : 8 - n4;
                int n8 = n5 - n2;
                asn1PerEncodeBuffer.mTraceHandler.newBitField("value", n5);
                if (n8 > 0) {
                    do {
                        if (n8 <= 8) {
                            asn1PerEncodeBuffer.encodeBits((byte)0, n8);
                            if (!bl) break;
                        }
                        asn1PerEncodeBuffer.encodeBits((byte)0, 8);
                        n8 -= 8;
                    } while (!bl);
                }
                asn1PerEncodeBuffer.encodeBits(byArray, n3, n7, n2, null);
                if (!bl) break block17;
            }
            if ((n2 = byArray.length - n3) >= 16384) {
                throw new Asn1Exception("fragmentation of INTEGER not supported");
            }
            asn1PerEncodeBuffer.encodeLength(n2);
            if (asn1PerEncodeBuffer.isAligned()) {
                asn1PerEncodeBuffer.byteAlign();
            }
            asn1PerEncodeBuffer.encodeBits(byArray, n3, n2 * 8);
        }
    }

    public void encode(Asn1XerEncoder asn1XerEncoder, String string) throws IOException, Asn1Exception {
        if (string == null) {
            string = "INTEGER";
        }
        asn1XerEncoder.encodeStartElement(string);
        asn1XerEncoder.copy(this.toString());
        asn1XerEncoder.encodeEndElement(string);
    }

    public void decodeXER(String string, String string2) throws Asn1Exception {
        this.value = new BigInteger(string);
    }

    public void encode(Asn1XmlEncoder asn1XmlEncoder, String string, String string2) throws IOException, Asn1Exception {
        if (string == null) {
            string = "INTEGER";
        }
        asn1XmlEncoder.encodeStartElement(string, string2, true);
        asn1XmlEncoder.copy(this.toString());
        asn1XmlEncoder.encodeEndElement(string, string2);
    }

    public void encodeAttribute(Asn1XmlEncoder asn1XmlEncoder, String string) throws Asn1Exception, IOException {
        if (string == null) {
            return;
        }
        asn1XmlEncoder.copy(" " + string + "=\"" + this.toString() + "\"");
    }

    public void decodeXML(String string, String string2) throws Asn1Exception {
        this.decodeXER(string, string2);
    }

    public void decode(Asn1JsonDecodeBuffer asn1JsonDecodeBuffer) throws IOException {
        this.value = new BigInteger(asn1JsonDecodeBuffer.readNumber());
    }

    public void encode(Asn1JsonOutputStream asn1JsonOutputStream) throws IOException {
        asn1JsonOutputStream.write(this.toString());
    }

    public String toString() {
        return this.value.toString();
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl) throws Asn1Exception, IOException {
        if (bl) {
            asn1BerOutputStream.encodeTag(TAG);
        }
        Asn1BerEncodeBuffer asn1BerEncodeBuffer = new Asn1BerEncodeBuffer();
        int n2 = Asn1BigInteger.encodeValue(asn1BerEncodeBuffer, this.value, true);
        asn1BerOutputStream.encodeLength(n2);
        asn1BerOutputStream.write(asn1BerEncodeBuffer.getMsgCopy());
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.b);
        asn1PerOutputStream.a(false);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream, BigInteger bigInteger, BigInteger bigInteger2) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.b, bigInteger, bigInteger2);
        asn1PerOutputStream.a(false);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(1);
        objectOutputStream.writeObject(this.value);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readShort();
        this.value = (BigInteger)objectInputStream.readObject();
    }
}

