/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Time;
import com.objsys.asn1j.runtime.IntHolder;
import java.io.IOException;
import java.util.Calendar;

public class Asn1UTCTime
extends Asn1Time {
    public static final Asn1Tag TAG = new Asn1Tag(0, 0, 23);

    public Asn1UTCTime() {
        super((short)23, false);
    }

    public Asn1UTCTime(boolean bl) {
        super((short)23, bl);
    }

    public Asn1UTCTime(String string) {
        super(string, (short)23, false);
        this.parseString(new String(this.value));
    }

    public Asn1UTCTime(String string, boolean bl) {
        super(string, (short)23, bl);
        this.parseString(new String(this.value));
    }

    protected void init() {
        super.init();
        this.minute = -1;
        this.hour = -1;
        this.utcFlag = true;
    }

    public boolean equals(String string) {
        if (string == null) {
            return false;
        }
        return this.getTime().equals(new Asn1UTCTime(string, this.derRules).getTime());
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n2) throws Asn1Exception, IOException {
        this.decode(asn1BerDecodeBuffer, bl, n2, TAG);
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        return this.encode(asn1BerEncodeBuffer, bl, TAG);
    }

    public void clear() {
        super.clear();
        this.minute = -1;
        this.hour = -1;
        this.utcFlag = true;
    }

    public void setYear(int n2) throws Asn1Exception {
        block4: {
            block5: {
                if (n2 < 0) {
                    throw new Asn1Exception("Invalid year value: " + n2);
                }
                if (n2 >= 100) break block4;
                if (n2 < 50) break block5;
                super.setYear(n2 + 1900);
                if (!Asn1Exception.z) break block4;
            }
            super.setYear(n2 + 2000);
        }
        super.setYear(n2);
    }

    public void setFraction(String string) throws Asn1Exception {
        this.secFraction = "";
        throw new Asn1Exception("Fraction is not supported for Asn1UTCTime.");
    }

    public String getFraction() throws Asn1Exception {
        return null;
    }

    public void setTime(Calendar calendar) throws Asn1Exception {
        block27: {
            block26: {
                boolean bl;
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    block20: {
                                        block19: {
                                            block18: {
                                                block17: {
                                                    block16: {
                                                        block15: {
                                                            block14: {
                                                                bl = Asn1Exception.z;
                                                                this.clear();
                                                                if (!calendar.isSet(1)) break block14;
                                                                this.year = calendar.get(1);
                                                                if (!bl) break block15;
                                                            }
                                                            throw new Asn1Exception("Invalid Calendar value: no year");
                                                        }
                                                        if (!calendar.isSet(2)) break block16;
                                                        this.month = calendar.get(2) + 1;
                                                        if (!bl) break block17;
                                                    }
                                                    throw new Asn1Exception("Invalid Calendar value: no month");
                                                }
                                                if (!calendar.isSet(5)) break block18;
                                                this.day = calendar.get(5);
                                                if (!bl) break block19;
                                            }
                                            throw new Asn1Exception("Invalid Calendar value: no day");
                                        }
                                        if (!calendar.isSet(11)) break block20;
                                        this.hour = calendar.get(11);
                                        if (!bl) break block21;
                                    }
                                    throw new Asn1Exception("Invalid Calendar value: no hours");
                                }
                                if (!calendar.isSet(12)) break block22;
                                this.minute = calendar.get(12);
                                if (!bl) break block23;
                            }
                            throw new Asn1Exception("Invalid Calendar value: no minutes");
                        }
                        if (!calendar.isSet(13)) break block24;
                        this.second = calendar.get(13);
                        if (!bl) break block25;
                    }
                    this.second = 0;
                }
                this.secFraction = "";
                if (!calendar.isSet(15)) break block26;
                int n2 = calendar.get(15);
                int n3 = calendar.get(16);
                this.diffHour = n2 / 3600000;
                this.diffMin = n2 % 3600000 / 60000;
                this.diffHour += n3 / 3600000;
                this.diffMin += n3 % 3600000 / 60000;
                boolean bl2 = this.utcFlag = n2 == 0 || this.derRules;
                if (!bl) break block27;
            }
            this.diffMin = 0;
            this.diffHour = 0;
            this.utcFlag = true;
        }
        this.compileString();
    }

    public void parseString(String string) throws Asn1Exception {
        boolean bl = Asn1Exception.z;
        if (string == null) {
            throw new Asn1Exception("Invalid parameter");
        }
        this.clear();
        IntHolder intHolder = new IntHolder(0);
        try {
            block45: {
                char c2;
                block49: {
                    block48: {
                        block47: {
                            block46: {
                                block44: {
                                    int n2;
                                    block43: {
                                        block42: {
                                            block41: {
                                                block40: {
                                                    block38: {
                                                        block39: {
                                                            this.year = Asn1UTCTime.parseInt(string, intHolder, 2);
                                                            this.month = Asn1UTCTime.parseInt(string, intHolder, 2);
                                                            this.day = Asn1UTCTime.parseInt(string, intHolder, 2);
                                                            if (this.year < 0) {
                                                                throw new Asn1Exception("Invalid year value: " + this.year);
                                                            }
                                                            if (this.year >= 100) break block38;
                                                            if (this.year <= 70) break block39;
                                                            this.year += 1900;
                                                            if (!bl) break block38;
                                                        }
                                                        this.year += 2000;
                                                    }
                                                    if (this.month < 1 || this.month > 12) {
                                                        throw new Asn1Exception("Invalid month value: " + this.month);
                                                    }
                                                    int n3 = f[this.month];
                                                    if (this.month == 2 && this.year % 4 == 0 && (this.year % 100 != 0 || this.year % 400 == 0)) {
                                                        ++n3;
                                                    }
                                                    if (this.day < 1 || this.day > n3) {
                                                        throw new Asn1Exception("Invalid day value: " + this.day);
                                                    }
                                                    n2 = 0;
                                                    if (!Character.isDigit(Asn1UTCTime.charAt(string, intHolder.value))) break block40;
                                                    this.hour = Asn1UTCTime.parseInt(string, intHolder, 2);
                                                    ++n2;
                                                    if (!bl) break block41;
                                                }
                                                throw new Asn1Exception("Hours expected");
                                            }
                                            if (!Character.isDigit(Asn1UTCTime.charAt(string, intHolder.value))) break block42;
                                            this.minute = Asn1UTCTime.parseInt(string, intHolder, 2);
                                            ++n2;
                                            if (!Character.isDigit(Asn1UTCTime.charAt(string, intHolder.value))) break block43;
                                            this.second = Asn1UTCTime.parseInt(string, intHolder, 2);
                                            ++n2;
                                            if (!bl) break block43;
                                        }
                                        throw new Asn1Exception("Minutes expected");
                                    }
                                    if (n2 >= 2 && (this.hour < 0 || this.hour > 23)) {
                                        throw new Asn1Exception("Invalid hour value: " + this.hour);
                                    }
                                    if (n2 >= 2 && (this.minute < 0 || this.minute > 59)) {
                                        throw new Asn1Exception("Invalid minute value: " + this.minute);
                                    }
                                    if (n2 == 3 && (this.second < 0 || this.second > 59)) {
                                        throw new Asn1Exception("Invalid second value: " + this.second);
                                    }
                                    char c3 = Asn1UTCTime.charAt(string, intHolder.value);
                                    if (Asn1UTCTime.charAt(string, intHolder.value) != 'Z') break block44;
                                    ++intHolder.value;
                                    this.utcFlag = true;
                                    if (intHolder.value != string.length()) {
                                        throw new Asn1Exception("Unexpected values at the end of string");
                                    }
                                    break block45;
                                }
                                if (this.derRules) {
                                    throw new Asn1Exception("Unexpected zone offset in DER/CER/PER time string");
                                }
                                this.utcFlag = false;
                                c2 = Asn1UTCTime.charAt(string, intHolder.value);
                                if (c2 != '-' && c2 != '+') break block45;
                                ++intHolder.value;
                                if (!Character.isDigit(Asn1UTCTime.charAt(string, intHolder.value))) break block46;
                                this.diffHour = Asn1UTCTime.parseInt(string, intHolder, 2);
                                if (!bl) break block47;
                            }
                            throw new Asn1Exception("Invalid diffhour");
                        }
                        if (!Character.isDigit(Asn1UTCTime.charAt(string, intHolder.value))) break block48;
                        this.diffMin = Asn1UTCTime.parseInt(string, intHolder, 2);
                        if (!bl) break block49;
                    }
                    throw new Asn1Exception("Invalid diffminute");
                }
                if (this.diffHour < 0 || this.diffHour > 12) {
                    throw new Asn1Exception("Invalid diffhour value: " + this.diffHour);
                }
                if (this.diffMin < 0 || this.diffMin > 59) {
                    throw new Asn1Exception("Invalid diffminute value: " + this.diffMin);
                }
                if (c2 == '-') {
                    this.diffHour = -this.diffHour;
                    this.diffMin = -this.diffMin;
                }
            }
            this.parsed = true;
            if (string != this.value) {
                this.compileString();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new Asn1Exception("Invalid date format");
        }
        catch (NumberFormatException numberFormatException) {
            throw new Asn1Exception("Invalid number format");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Asn1Exception("Invalid date format");
        }
    }

    protected boolean compileString() throws Asn1Exception {
        block16: {
            block15: {
                boolean bl;
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                bl = Asn1Exception.z;
                                this.value = "";
                                if (this.year < 0 || this.day <= 0 || this.month <= 0 || this.hour < 0 || this.minute < 0) {
                                    return false;
                                }
                                if (this.mStringBuffer != null) break block11;
                                this.mStringBuffer = new StringBuffer();
                                if (!bl) break block12;
                            }
                            this.mStringBuffer.setLength(0);
                        }
                        if (!this.derRules && !this.utcFlag || this.diffHour == 0 && this.diffMin == 0) break block13;
                        Calendar calendar = this.getTime();
                        calendar.add(12, -this.diffMin);
                        calendar.add(11, -this.diffHour);
                        this.putInteger(2, calendar.get(1));
                        this.putInteger(2, calendar.get(2) + 1);
                        this.putInteger(2, calendar.get(5));
                        this.putInteger(2, calendar.get(11));
                        this.putInteger(2, calendar.get(12));
                        if (!bl) break block14;
                    }
                    this.putInteger(2, this.year);
                    this.putInteger(2, this.month);
                    this.putInteger(2, this.day);
                    this.putInteger(2, this.hour);
                    this.putInteger(2, this.minute);
                }
                this.putInteger(2, this.second);
                if (!this.derRules && !this.utcFlag) break block15;
                this.mStringBuffer.append('Z');
                if (!bl) break block16;
            }
            if (this.diffHour != 0 || this.diffMin != 0) {
                this.mStringBuffer.append(this.diffHour > 0 ? (char)'+' : '-');
                this.putInteger(2, Math.abs(this.diffHour));
                this.putInteger(2, Math.abs(this.diffMin));
            }
        }
        this.value = this.mStringBuffer.toString();
        return true;
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl) throws Asn1Exception, IOException {
        super.encode(asn1BerOutputStream, bl, TAG);
    }
}

