/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.asn1;

import com.turktrust.asn1.BaseASN1Object;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.TagInfo;

public class IA5String
extends BaseASN1Object {
    private String value;

    public IA5String(String name) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(22);
        this.setTagNumber(22);
    }

    public IA5String(String name, Object value) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(22);
        this.setTagNumber(22);
        this.setValue(value);
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            this.value = (String)value;
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void decode(byte[] data) throws DecodeException {
        TagInfo tagInfo = this.getTagInfo(data, 0);
        if (this.tagClass != tagInfo.tagClass) {
            throw new DecodeException();
        }
        if (this.tagMethod != tagInfo.tagMethod) {
            throw new DecodeException();
        }
        if (this.tagNumber != tagInfo.tagNumber) {
            throw new DecodeException();
        }
        if (this.tagMethod != 1 && this.type != tagInfo.type) {
            throw new DecodeException();
        }
        if (tagInfo.contentIndex + tagInfo.contentLength != data.length) {
            throw new DecodeException();
        }
        if (this.tagMethod == 2) {
            this.setTagNumber(22);
        }
        this.value = new String(data, tagInfo.contentIndex, tagInfo.contentLength);
    }

    protected byte[] getContentEncoding() {
        if (this.value == null) {
            return null;
        }
        return this.value.getBytes();
    }

    public String toString() {
        if (this.value != null) {
            return this.value;
        }
        return new String(super.toString());
    }

    public static void main(String[] args) throws DecodeException {
        IA5String i = new IA5String("TestIA5String", "Test string");
        System.out.println(i.toString());
        byte[] a = i.getEncoded();
        for (int z = 0; z < a.length; ++z) {
            System.out.println(Integer.toString(a[z] & 0xFF, 16));
        }
    }
}

