/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.timestamp;

import com.turktrust.asn1.BitString;

public class PKIFailureInfo
extends BitString {
    public static final int BAD_ALGORITHM = 0;
    public static final int BAD_REQUEST = 2;
    public static final int BAD_DATA_FORMAT = 5;
    public static final int TIME_NOT_AVAILABLE = 14;
    public static final int UNACCEPTED_POLICY = 15;
    public static final int UNACCEPTED_EXTENSION = 16;
    public static final int ADDITIONAL_INFO_NOT_AVAILABLE = 17;
    public static final int SYSTEM_FAILURE = 25;
    private byte[] failureBytes = new byte[4];

    public PKIFailureInfo() {
        super("default_PKIFailureInfo");
    }

    public PKIFailureInfo(String name) {
        super(name);
    }

    public void setFailingReason(int value) {
        int div = value / 8;
        int mod = value % 8;
        byte mask = (byte)(-128 >> mod);
        this.failureBytes[div] = (byte)(this.failureBytes[div] | mask);
        super.setValue(this.failureBytes);
    }

    public int getFailingReason() {
        this.failureBytes = (byte[])super.getValue();
        if (this.failureBytes[0] == -128) {
            return 0;
        }
        if (this.failureBytes[0] == 32) {
            return 2;
        }
        if (this.failureBytes[0] == 4) {
            return 5;
        }
        if (this.failureBytes[1] == 2) {
            return 14;
        }
        if (this.failureBytes[1] == 1) {
            return 15;
        }
        if (this.failureBytes[2] == -128) {
            return 16;
        }
        if (this.failureBytes[2] == 64) {
            return 17;
        }
        if (this.failureBytes[3] == 64) {
            return 25;
        }
        return -1;
    }
}

