/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.ASN1Boolean;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.asn1.Sequence;
import com.turktrust.x509.Extension;
import java.math.BigInteger;

public class AuthorityKeyId
extends Extension {
    public static final String EXT_OBJ_ID = "2.5.29.35";
    private byte[] authKeyIdBytes;

    public AuthorityKeyId(String name, boolean critical, byte[] keyIdBytes) {
        super(name);
        this.authKeyIdBytes = keyIdBytes;
        ObjectID authObjId = new ObjectID("authKeyId");
        authObjId.setValue(EXT_OBJ_ID);
        this.setextnID(authObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(critical));
        this.setcritical(crit);
        OctetString octs = new OctetString("authKeyIdVal");
        octs.setValue(keyIdBytes);
        Sequence seqVal = new Sequence("authKeyIdSeq");
        octs.setOptional(true);
        octs.setTaggingMethod(1);
        octs.setTagClass((byte)-128);
        octs.setTagNumber(0);
        seqVal.addElement(octs);
        byte[] seqValBytes = seqVal.getEncoded();
        OctetString extOcts = new OctetString("extAuthKeyId");
        extOcts.setValue(seqValBytes);
        this.setextnValue(extOcts);
        this.commitElementUpdate();
    }

    public AuthorityKeyId() {
        super("defaultAKI");
        this.authKeyIdBytes = null;
        ObjectID authObjId = new ObjectID("authKeyId");
        authObjId.setValue(EXT_OBJ_ID);
        this.setextnID(authObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(false));
        this.setcritical(crit);
        this.commitElementUpdate();
    }

    public void decodeExtVal(byte[] extValBytes) {
        OctetString octs = new OctetString("authKeyIdVal");
        Sequence seqVal = new Sequence("authKeyIdSeq");
        octs.setOptional(true);
        octs.setTaggingMethod(1);
        octs.setTagClass((byte)-128);
        octs.setTagNumber(0);
        seqVal.addElement(octs);
        try {
            seqVal.decode(extValBytes);
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.authKeyIdBytes = (byte[])octs.getValue();
        OctetString extOcts = new OctetString("extAuthKeyId", extValBytes);
        this.setextnValue(extOcts);
        this.commitElementUpdate();
    }

    public String getExtensionTitle() {
        return "Authority Key Id";
    }

    public String getTurkishExtensionTitle() {
        return "ESHS Anahtar Tan\u0131mlay\u0131c\u0131s\u0131";
    }

    public String getExplanation() {
        BigInteger big = new BigInteger(1, this.authKeyIdBytes);
        String bigStr = big.toString(16);
        if (bigStr.length() % 2 != 0) {
            bigStr = "0" + bigStr;
        }
        String exp = "";
        for (int i = 0; i < bigStr.length() / 2; ++i) {
            exp = exp + bigStr.substring(i * 2, i * 2 + 2) + " ";
        }
        if (exp.equals("00 ")) {
            exp = "Hen\u00fcz anahtar olu\u015fturulmad\u0131\u011f\u0131 i\u00e7in de\u011fer g\u00f6sterilemiyor";
        }
        return exp;
    }

    public String getTurkishExplanation() {
        return this.getExplanation();
    }
}

