/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.Choice;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.IA5String;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.asn1.TagInfo;
import com.turktrust.asn1.UTF8String;
import com.turktrust.x509.Name;
import com.turktrust.x509.OtherName;
import java.util.StringTokenizer;
import java.util.Vector;

public class GeneralName
extends Choice {
    private OtherName otherName = new OtherName("otherName");
    private IA5String emailIA5 = new IA5String("email");
    private IA5String dnsIA5 = new IA5String("dns");
    private Name dirName = new Name("dir");
    private IA5String uriIA5 = new IA5String("uri");
    private OctetString ipOcts = new OctetString("ipOcts");
    private ObjectID regId = new ObjectID("regId");

    public GeneralName() {
        super("default_gn");
        this.setUpElements();
    }

    public GeneralName(String name) {
        super(name);
        this.setUpElements();
    }

    protected void setUpElements() {
        this.setForcedTagMethod(1);
        super.addElement(this.otherName);
        this.otherName.setTaggingMethod(1);
        this.otherName.setTagClass((byte)-128);
        this.otherName.setTagNumber(0);
        super.addElement(this.emailIA5);
        this.emailIA5.setTaggingMethod(1);
        this.emailIA5.setTagClass((byte)-128);
        this.emailIA5.setTagNumber(1);
        super.addElement(this.dnsIA5);
        this.dnsIA5.setTaggingMethod(1);
        this.dnsIA5.setTagClass((byte)-128);
        this.dnsIA5.setTagNumber(2);
        super.addElement(this.dirName);
        this.dirName.setTaggingMethod(2);
        this.dirName.setTagClass((byte)-128);
        this.dirName.setTagNumber(4);
        this.dirName.setTagToAllComponents((byte)-128, 2, 4);
        super.addElement(this.uriIA5);
        this.uriIA5.setTaggingMethod(1);
        this.uriIA5.setTagClass((byte)-128);
        this.uriIA5.setTagNumber(6);
        super.addElement(this.ipOcts);
        this.ipOcts.setTaggingMethod(1);
        this.ipOcts.setTagClass((byte)-128);
        this.ipOcts.setTagNumber(7);
        super.addElement(this.regId);
        this.regId.setTaggingMethod(1);
        this.regId.setTagClass((byte)-128);
        this.regId.setTagNumber(8);
    }

    public void setOtherName(OtherName oname) {
        this.otherName = oname;
        super.clearElements();
        this.setUpElements();
        super.setValue(this.otherName);
    }

    public void setRFC822Name(String emailAddressStr) {
        this.emailIA5.setValue(emailAddressStr);
        super.setValue(this.emailIA5);
    }

    public void setDNSName(String dnsNameStr) {
        this.dnsIA5.setValue(dnsNameStr);
        super.setValue(this.dnsIA5);
    }

    public void setDirectoryName(Name givenDirName) {
        this.dirName = givenDirName;
        super.clearElements();
        this.setUpElements();
        super.setValue(this.dirName);
        this.setTaggingMethod(2);
    }

    public Name getDirectoryName() {
        return this.dirName;
    }

    public void setURI(String uriStr) {
        this.uriIA5.setValue(uriStr);
        super.setValue(this.uriIA5);
    }

    public void setIPAddress(String ipStr) {
        StringTokenizer stok = new StringTokenizer(ipStr, ".");
        Vector<Byte> ipBytesVec = new Vector<Byte>();
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            int t = Integer.parseInt(token);
            if (t > 127) {
                t -= 256;
            }
            Byte b = new Byte((byte)t);
            ipBytesVec.addElement(b);
        }
        byte[] ipBytes = new byte[ipBytesVec.size()];
        for (int i = 0; i < ipBytes.length; ++i) {
            ipBytes[i] = (Byte)ipBytesVec.elementAt(i);
        }
        this.ipOcts.setValue(ipBytes);
        super.setValue(this.ipOcts);
    }

    public void setRegisteredId(ObjectID givenRegId) {
        this.regId = givenRegId;
        super.clearElements();
        this.setUpElements();
        super.setValue(this.regId);
    }

    public String getURI() {
        return (String)this.uriIA5.getValue();
    }

    public String getExplainedContent() {
        if (this.otherName.getNameValue().getValue() != null) {
            String onameStr = (String)this.otherName.getTypeId().getValue() + " = ";
            UTF8String utf = new UTF8String("utf");
            utf.setTaggingMethod(2);
            utf.setTagClass((byte)-128);
            utf.setTagNumber(0);
            try {
                utf.decode((byte[])this.otherName.getNameValue().getValue());
            }
            catch (Exception exc) {
                // empty catch block
            }
            onameStr = onameStr + (String)utf.getValue();
            return onameStr;
        }
        if (this.emailIA5.getValue() != null) {
            return "RFC822 Name = " + (String)this.emailIA5.getValue();
        }
        if (this.dnsIA5.getValue() != null) {
            return "DNS Name = " + (String)this.dnsIA5.getValue();
        }
        if (this.dirName.getValue() != null) {
            return "Directory Name CN = " + this.dirName.getCN();
        }
        if (this.uriIA5.getValue() != null) {
            return "URI = " + (String)this.uriIA5.getValue();
        }
        if (this.ipOcts.getValue() != null) {
            byte[] ipBytes = (byte[])this.ipOcts.getValue();
            String ipStr = "";
            for (int i = 0; i < ipBytes.length; ++i) {
                int b = ipBytes[i];
                if (b < 0) {
                    b += 256;
                }
                ipStr = ipStr + b;
                if (i >= ipBytes.length - 1) continue;
                ipStr = ipStr + ".";
            }
            return "IP Address = " + ipStr;
        }
        if (this.regId.getValue() != null) {
            return "Registered ID = " + (String)this.regId.getValue();
        }
        return "";
    }

    public String getTurkishExplainedContent() {
        if (this.otherName.getNameValue().getValue() != null) {
            String onameStr = (String)this.otherName.getTypeId().getValue() + " = ";
            UTF8String utf = new UTF8String("utf");
            utf.setTaggingMethod(2);
            utf.setTagClass((byte)-128);
            utf.setTagNumber(0);
            try {
                utf.decode((byte[])this.otherName.getNameValue().getValue());
            }
            catch (Exception exc) {
                // empty catch block
            }
            onameStr = onameStr + (String)utf.getValue();
            return onameStr;
        }
        if (this.emailIA5.getValue() != null) {
            return "E-posta Adresi = " + (String)this.emailIA5.getValue();
        }
        if (this.dnsIA5.getValue() != null) {
            return "DNS Ad\u0131 = " + (String)this.dnsIA5.getValue();
        }
        if (this.dirName.getValue() != null) {
            return "Dizin Ad\u0131 Bilinen \u0130smi = " + this.dirName.getCN();
        }
        if (this.uriIA5.getValue() != null) {
            return "URI = " + (String)this.uriIA5.getValue();
        }
        if (this.ipOcts.getValue() != null) {
            byte[] ipBytes = (byte[])this.ipOcts.getValue();
            String ipStr = "";
            for (int i = 0; i < ipBytes.length; ++i) {
                int b = ipBytes[i];
                if (b < 0) {
                    b += 256;
                }
                ipStr = ipStr + b;
                if (i >= ipBytes.length - 1) continue;
                ipStr = ipStr + ".";
            }
            return "IP Adresi = " + ipStr;
        }
        if (this.regId.getValue() != null) {
            return "Kay\u0131tl\u0131 Tan\u0131mlay\u0131c\u0131 Numara = " + (String)this.regId.getValue();
        }
        return "";
    }

    public void decode(byte[] data) throws DecodeException {
        if (data[0] == -95 && data[2] == -92) {
            byte[] shdata = new byte[data.length - 2];
            System.arraycopy(data, 2, shdata, 0, shdata.length);
            this.decode(shdata);
            return;
        }
        if (data[0] == -92) {
            super.setForcedTagMethod(2);
            TagInfo tinfo = super.getTagInfo(data, 0);
            if (tinfo.getContentIndex() + tinfo.getContentLength() != data.length) {
                this.dirName.setTaggingMethod(1);
                this.dirName.setTagToAllComponents((byte)-128, 1, 4);
                this.dirName.setForcedTagMethodToAllComponents(1);
                this.dirName.setForcedTagMethod(1);
                super.setForcedTagMethod(1);
            }
        }
        super.decode(data);
    }
}

