/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.Sequence;
import com.turktrust.asn1.SequenceOf;
import com.turktrust.x509.PolicyQualifierInfo;
import java.util.Vector;

public class PolicyInformation
extends Sequence {
    private ObjectID policy_OID = new ObjectID();
    private SequenceOf polQuals = new SequenceOf("polQuals", new PolicyQualifierInfo());

    public PolicyInformation() {
        super("defaultPI");
        this.setUpElements();
    }

    public PolicyInformation(String name, ObjectID policyOID, Vector polQualifiers) {
        super(name);
        this.setUpElements();
        this.policy_OID = policyOID;
        if (polQualifiers.size() > 0) {
            this.polQuals = new SequenceOf("seqOfPolQual", (PolicyQualifierInfo)polQualifiers.elementAt(0));
            this.polQuals.setValue(polQualifiers);
        }
        this.commitElementUpdate();
    }

    public ObjectID getPolicyOID() {
        return this.policy_OID;
    }

    public Vector getPolQualifiers() {
        return (Vector)this.polQuals.getValue();
    }

    private void setUpElements() {
        super.addElement(this.policy_OID);
        super.addElement(this.polQuals);
        this.polQuals.setOptional(true);
    }

    public String getExplanation() {
        String exp = "";
        ObjectID policyOID = (ObjectID)this.getElement(0);
        exp = exp + "Policy OID = " + (String)policyOID.getValue() + "\n";
        if (((Vector)this.getValue()).size() > 1) {
            SequenceOf seqQual = (SequenceOf)this.getElement(1);
            Vector qualVec = (Vector)seqQual.getValue();
            for (int i = 0; i < qualVec.size(); ++i) {
                PolicyQualifierInfo pqi = (PolicyQualifierInfo)qualVec.elementAt(i);
                exp = exp + pqi.getExplanation();
                if (i >= qualVec.size() - 1) continue;
                exp = exp + "\n";
            }
        }
        return exp;
    }

    public String getTurkishExplanation() {
        String exp = "";
        ObjectID policyOID = (ObjectID)this.getElement(0);
        exp = exp + "\u0130lke Numaras\u0131 = " + (String)policyOID.getValue();
        if (((Vector)this.getValue()).size() > 1) {
            exp = exp + "\n";
            SequenceOf seqQual = (SequenceOf)this.getElement(1);
            Vector qualVec = (Vector)seqQual.getValue();
            for (int i = 0; i < qualVec.size(); ++i) {
                PolicyQualifierInfo pqi = (PolicyQualifierInfo)qualVec.elementAt(i);
                exp = exp + pqi.getTurkishExplanation();
                if (i >= qualVec.size() - 1) continue;
                exp = exp + "\n";
            }
        }
        return exp;
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }
}

