/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.ASN1Boolean;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.asn1.Sequence;
import com.turktrust.asn1.SequenceOf;
import com.turktrust.x509.Extension;
import com.turktrust.x509.GeneralName;
import java.util.Vector;

public class SubjectAltName
extends Extension {
    public static final String EXT_OBJ_ID = "2.5.29.17";
    private Vector genNamesVec;

    public SubjectAltName(String name, boolean critical, Vector generalNameVec) {
        super(name);
        ObjectID altNameObjId = new ObjectID("altNameId");
        altNameObjId.setValue(EXT_OBJ_ID);
        this.setextnID(altNameObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(critical));
        this.setcritical(crit);
        this.genNamesVec = generalNameVec;
        Sequence seq = new Sequence("altNameSeq", generalNameVec);
        byte[] seqBytes = seq.getEncoded();
        OctetString extOcts = new OctetString("extAltName");
        extOcts.setValue(seqBytes);
        this.setextnValue(extOcts);
        this.commitElementUpdate();
    }

    public SubjectAltName(String name, ASN1Boolean crit, OctetString extValue) {
        super(name);
        ObjectID altNameObjId = new ObjectID("altNameId");
        altNameObjId.setValue(EXT_OBJ_ID);
        this.setextnID(altNameObjId);
        this.setcritical(crit);
        this.setextnValue(extValue);
        this.commitElementUpdate();
    }

    public SubjectAltName() {
        super("default_SAN");
        ObjectID altNameObjId = new ObjectID("altNameId");
        altNameObjId.setValue(EXT_OBJ_ID);
        this.setextnID(altNameObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(false));
        this.setcritical(crit);
        this.commitElementUpdate();
    }

    public Vector getGeneralNamesVector() {
        OctetString extOcts = this.getextnValue();
        byte[] seqBytes = (byte[])extOcts.getValue();
        GeneralName gn = new GeneralName("gn");
        SequenceOf seq = new SequenceOf("altNameSeq", gn);
        try {
            seq.decode(seqBytes);
        }
        catch (Exception exc) {
            return null;
        }
        return (Vector)seq.getValue();
    }

    public void decodeExtVal(byte[] extValBytes) {
        SequenceOf genNameSeq = new SequenceOf("genNameSeq", new GeneralName());
        genNameSeq.setForcedTagMethod(1);
        try {
            genNameSeq.decode(extValBytes);
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.genNamesVec = (Vector)genNameSeq.getValue();
        OctetString extOcts = new OctetString("extSAN", extValBytes);
        this.setextnValue(extOcts);
        this.commitElementUpdate();
    }

    public String getExtensionTitle() {
        return "Subject Alternative Name";
    }

    public String getTurkishExtensionTitle() {
        return "Sertifika Sahibi Alternatif \u0130smi";
    }

    public String getExplanation() {
        String exp = "";
        for (GeneralName gn : this.genNamesVec) {
            exp = exp + gn.getExplainedContent() + "\n";
        }
        return exp;
    }

    public String getTurkishExplanation() {
        String exp = "";
        for (GeneralName gn : this.genNamesVec) {
            exp = exp + gn.getTurkishExplainedContent() + "\n";
        }
        return exp;
    }
}

