/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.pades.pdfbox.validation.check;

import java.io.InputStream;
import java.util.Arrays;
import tr.gov.tubitak.uekae.esya.api.asn.pkixtsp.ETSTInfo;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.CMSSignatureI18n;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.BaseSignedData;
import tr.gov.tubitak.uekae.esya.api.common.util.StreamUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;
import tr.gov.tubitak.uekae.esya.api.pades.pdfbox.PAdESSignature;
import tr.gov.tubitak.uekae.esya.api.pades.pdfbox.validation.PadesChecker;
import tr.gov.tubitak.uekae.esya.api.pades.pdfbox.validation.ValidationResultDetailImpl;
import tr.gov.tubitak.uekae.esya.api.signature.Signable;
import tr.gov.tubitak.uekae.esya.api.signature.Signature;
import tr.gov.tubitak.uekae.esya.api.signature.ValidationResultDetail;
import tr.gov.tubitak.uekae.esya.api.signature.ValidationResultType;
import tr.gov.tubitak.uekae.esya.asn.x509.AlgorithmIdentifier;

public class TSDigestChecker
implements PadesChecker {
    public static int b;

    @Override
    public ValidationResultDetail check(PAdESSignature signature) {
        ValidationResultDetailImpl validationResultDetailImpl;
        Object object;
        if (!signature.isTimestamp()) {
            return null;
        }
        boolean bl = false;
        String string = CMSSignatureI18n.getMsg((Enum)E_KEYS.TS_MESSAGE_DIGEST_CHECKER_SUCCESSFUL, (String[])new String[0]);
        try {
            object = ((Signature)signature.getUnderlyingObject()).getContents();
            Signable signable = (Signable)object.get(0);
            BaseSignedData baseSignedData = (BaseSignedData)((Signature)signature.getUnderlyingObject()).getUnderlyingObject();
            ETSTInfo eTSTInfo = new ETSTInfo(baseSignedData.getSignedData().getEncapsulatedContentInfo().getContent());
            AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)eTSTInfo.getHashAlgorithm().getObject();
            DigestAlg digestAlg = DigestAlg.fromOID((int[])algorithmIdentifier.algorithm.value);
            InputStream inputStream = signable.getContent();
            byte[] byArray = StreamUtil.readAll((InputStream)inputStream);
            byte[] byArray2 = DigestUtil.digest((DigestAlg)digestAlg, (byte[])byArray);
            if (!Arrays.equals(byArray2, eTSTInfo.getHashedMessage())) {
                bl = true;
                string = CMSSignatureI18n.getMsg((Enum)E_KEYS.TS_MESSAGE_DIGEST_CHECKER_UNSUCCESSFUL, (String[])new String[0]);
            }
        }
        catch (Exception exception) {
            bl = true;
            string = CMSSignatureI18n.getMsg((Enum)E_KEYS.TS_MESSAGE_DIGEST_CHECKER_DIGEST_CALCULATION_ERROR, (String[])new String[0]);
            exception.printStackTrace();
        }
        object = CMSSignatureI18n.getMsg((Enum)E_KEYS.TIMESTAMP_MESSAGE_DIGEST_CHECKER, (String[])new String[0]);
        ValidationResultDetailImpl validationResultDetailImpl2 = validationResultDetailImpl;
        ValidationResultDetailImpl validationResultDetailImpl3 = validationResultDetailImpl;
        Class<?> clazz = this.getClass();
        Object object2 = object;
        String string2 = string;
        ValidationResultType validationResultType = bl ? ValidationResultType.INVALID : ValidationResultType.VALID;
        validationResultDetailImpl2(clazz, (String)object2, string2, validationResultType);
        return validationResultDetailImpl3;
    }
}

